/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
/*
***********************************************************************
     PARSER is the top level routine controlling the parsing of sent-
     ences.  PARSER interprets the context-free component of the gram-
     mar and tries to build, in node, a parse tree for the sentence.
     the basic algorithm is a top-down sequential parser for
     context-free grammars, augmented by a mechanism for checking for
     left recursion, and a special process mechanism for conjunctions.
     When analyzing English sentences, PARSER invokes the function
     restTest during the parsing process to interpret the restrictions.

          To obtain the first analysis of a sentence, PARSER should be
     called with PAR=FALSE and the appropriate information about the
     sentence in the struct SENTE.  If a parse is obtained, PARSER
     will return TRUE, if not, with FALSE .  To find out whether there
     there are any additional parses, PARSER can be called again with
     PAR=TRUE . Each time another parse is obtained, PARSER returns with
     TRUE (and can be called once more).  When PARSER finally determines
     that there are no more parses, it returns FALSE .
***********************************************************************
*/

/*
-----------------------------------------------------------------------

                       THE PARSE TREE (node array)

     The parse tree is an interconnected set of nodes.  Each node
     corresponds either to a definition which appears in the derivation
     of the sentence or to an atomic category.  Each node in the tree
     is represented by a set of fields in the node array.
     In our tree representation, only the first (leftmost) daughter
     node points to its parent;  second and subsequent daughter nodes
     point instead to the node immediately to their left. In describing
     the structure of the nodes, we therefore must differentiate
     between first-in-level nodes and other nodes.  Whether
     or not a node is a first-in-level is determined by bit FIL in
     word 4 of the node.
          The structure of the node also depends on whether the node
     was attached as a normal consequence of appearing in the
     definition of its parent, or was attached by the special process
     mechanism.  Nodes attached by the special process mechanism are
     indicated by bit SPNODE in the field NDABTS of the node being on.
          Throughout the program, the statement that a variable points
     to a node means that the variable contains the index in array node
     of the first word of the node.
          The actual allocation of the fields to bits bytes and words
     in the node array is described in the INCLUDE file.

        -NDUPLF- if first-in-level, a pointer to the node above this node
                 if not first-in-level, a pointer to the node to the left
                               of this node

        -NDOPES- if not a special process node then
              if a first-in-level node, a pointer to the option in the
                 definition of the parent of this node of which this
                 node is the first element
              if not a first-in-level node, a pointer to the element
                 in the definition of the parent of this node which
                 corresponds to this node
           if a special process node, a pointer to a word in list space
                 whose address field is a pointer to the head of the
                 definition corresponding to this node and
              whose special field is,
                 if a first-in-level node, a pointer to the option in
                    the definition of the parent of this node which is
                    currently being tried
                 if not a first-in-level node, a pointer to the element
                    in the definition of the parent node of this node
                    which corresponds to the node to be attached to the
                    right of this node if this node is successfully
                    completed (=0 if this is a special process node
                    which has been attached to the right of the last
                    regular node on this level)
           = 0 only for the root node

        -NDBALP- if this node corresponds to a BNF definition (the atomic
              bit in -NDSPFB- of this node is 0) a pointer to the node below
              this node
           if this node corresponds to an atomic category of a word
              (the atomic bit in -NDSPFB- = 1 and the Ltomic and Otomic
              bits in NDSPFB = 0), a pointer to the beginning of the
              attribute list of that category
           = 0 if this node corresponds to a literal or null (the
               ATOMIC bit and either the LTOMIC or OTOMIC bit in NDSPFB
               = 1)

        -NDRTPT-   a pointer to the node to the right of this node
                 = 0 if this is the rightmost daughter of its parent

        -NDWPNC-  contains the number of the sentence word which was
                  pending when the node was created;  for non-empty
                  nodes, this is the number of the first word subsumed
                  by the node

        -NDABTS-  contains individual bit flags;  we refer to these by
                 the names of the variables which contain the corres-
                 ponding bit masks (for the values of these masks,
                 see parameters in INCLUDE file.  these bits are:
                 FIL   = 1 if the node is a first-in-level
                 INDUM = 1 if the parent of this node is a dummy
                          (unnamed) node [this bit is used by the
                          routines ORIGHT, OLEFT, OUPONE, an ODOWN]
                 EABIT = 1 if there are node attributes which are to be
                          erased when the parser either descends below
                          or detaches this node
                 SAVFLG= 1 if this node has been copied to a save list
                 SPNODE= 1 if this node was attached by the special
                          process mechanism
                 SCPNOD=0 and SPNODE=1 if this node was attached as a
                          result of a SPWORD category appearing in a
                          word
                 SCPNOD=1 and SPNODE=1 if this node was attached as a
                          result of a SCOPEWORD category appearing in
                          a word

       -NDSPFB-  a copy of the special field of the head of the BNF
                   definition or atomic symbol corresponding to this node

       -NDWPCP-  contains the number of the sentence word which was
                 pending immediately after this node was completed;
                 for non-empty nodes, this is the number of the last
                 word subsumed by this node + 1.

       -NDORDC-
                  if this node corresponds to an atomic category (the
                  atomic bit in -NDSPFB- = 1 and the LTOMIC and OTOMIC
                  bits in -NDSPFB- = 0), the ordinal of the category
                  corresponding to this node in the category list
                  the word pending when this node was attached
             else 0

       -NDHDBA- a pointer to the head of the BNF definition or atomic
                symbol corresponding to this node

       -NDGCPS-
            in the transformation process as a work area to link
            copied subtrees together
----------------------------------------------------------------------
*/

#define TRUE 1
#define FALSE 0
#include <iostream.h>
#include <fstream.h>
#include <ctype.h>
#include <string.h>
#include "symtab.h"
#include "lispdefs.fcm"
#include "common.fcm"
#include "nodefs.fcm"
#include "returncodes.h"
extern void nodeInit(void);
extern int lookAtWord(int);
extern int gcons(int, int, int);
extern int recurs(int);
extern int dnrit(void);
extern int upone(void);
extern void freeListItem(int);
extern void fill(const char *);
extern void prntif(void);
extern void prnt(void);
extern void nodtrc(int, int);
extern void ptree(int);
extern char *subsum(int,char *);
extern int searchCatList(int, int);
extern void delna(int, int);
extern int getnod(void);
extern void freenode(int);
extern int restTest(int, int);
extern char *nodnam(int, char *);
extern void nodeAttInit();
extern void longJumpErr(int);
extern SymbTable sytab;

inline int MAX(int a,int b){ if (a>=b )return a; else return b;}
inline int MIN(int a,int b){ if (a>=b )return b; else return a;}
static int frznod, filsw, minwd, kateg, scpwrd;
static int iattrb, neww;
static int spdef,ndbits,par, arg;

#define SPWRDC "SPWORD"
#define SCOPWC "SCOPEWORD"
const char * msgAtToRef = "*** Attempt to reference undefined BNF definition\n    Parsing terminated";
const char * msgAtScpwUn = "*** Attribute of SCOPEWORD missing or undefined";

// JR: added strcasecmp, strncasecmp functions 11/2/01
#define MAX_SIZE 3000

/* Compare S1 and S2, ignoring case.  */
#ifdef LINUX_PARSER
int strcasecmp (const char *s1, const char *s2) {
  char buffer1[MAX_SIZE];
  char buffer2[MAX_SIZE];
  int i;

  int n = strlen(s1);
  for (i = 0; i <= n; i++)
    buffer1[i] = toupper(s1[i]);

  n = strlen(s2);
  for (i = 0; i <= n; i++)
    buffer2[i] = toupper(s2[i]);

  return strcmp(buffer1, buffer2);
}


/* Compare no more than N chars of S1 and S2, ignoring case.  */
int strncasecmp (const char *s1, const char *s2, int n) {
  char buffer1[MAX_SIZE];
  char buffer2[MAX_SIZE];
  int i;

  for (i = 0; i < n && s1[i] != '\0'; i++)
    buffer1[i] = toupper(s1[i]);
  buffer1[i] = '\0';

  for (i = 0; i < n && s2[i] != '\0'; i++)
    buffer2[i] = toupper(s2[i]);
  buffer2[i] = '\0';

  return strncmp(buffer1, buffer2, n);
}
#endif

//

// -----------------------------------------------------------------------

//                   Find last node attached

int findLastNodeAttached(){
	int ns, result;
	while(1){
	if(! frznod) {// if beneath a frozen node structure detach node
	if(NDFRZT(xr7)){
//   if node is freeze type and has been completed execute freeze restriction.
		if(NDWPCP(xr7)){
		ns=NDBALP(xr7);
		dlp=NDOPES(ns);
		if(arg = CSR(dlp)){
			freeze = TRUE;
			list = 0;
			if((result=restTest(arg, FALSE))<0)return result;
			freeze = FALSE;
			if(result) frznod=xr7;
//            if restriction succeeds make this a frozen
//            structure. detach node and its substructure.
			}//if arg
			}//if complete
		}//if freeze
		}//if

//                   Go down one level to rightmost node

//                         if we are about to descend through a recursive
// 				 node, record this on recursives list
	if(NDRECT(xr7)) recurs(3);
	NDWPCP(xr7)=0; // clear last word+1 field in node
//                         check for node attributes to be
//                         erased when this node is entered
	if(NDEABT(xr7)) delna(xr7,TRUE);
//                     try to descend. if cannot, are at last node attached
	if(!dnrit()) return 1; //goto 600
	if(trace) nodtrc(4,elemt); //If trace is on, print  :node
//                                go back to a--try to descend further
	}//while
}// end of func

// -----------------------------------------------------------------------

//                             Detach node

int detachNode(void){
	int sxr7,l;
//L600:
//                             if at root node, we are finished enumerating parses
	while(1){
		if(NDUPLF(xr7) == 0) return 0; //reached root node quit

//                             if trace is on, print - (node)
//L610:
	if(trace) nodtrc(5,elemt);
//                         if node is atomic, seek category in other word group
	if(NDATMT(xr7) && !NDOTMT(xr7)){// goto L620;

	elemt=CARADDR(NDOPES(xr7));
	if(NDFILT(xr7)) elemt=CARADDR(elemt);
	kateg=NDORDC(xr7);
	iattrb=NDBALP(xr7);
	neww=word;
	word=NDWPNC(xr7);
//cout<<"\n257 node="<<xr7<<" neww="<<neww<<" word="<<word<<endl;

	if(par) minwd=MIN(minwd,word);
//              if in a frozen substructure, ignore alternate categories
	if(!frznod){// goto L620;

//  try for an alternate catagory

	kateg=lookAtWord(kateg);

	if(kateg){// alternate category found,
		if(trace) nodtrc(1,elemt); // if trace on print = node
// 			 save pointer to category and neww
		NDORDC(xr7) = kateg;
		NDBALP(xr7) = iattrb;//store attribute list into down pointer
//		word = NDWPNC(xr7);
//cout<<"\ncrt="<<(NDWPNC(xr7))<<" coplet="<<(NDWPCP(xr7))<<endl;
word=neww;
		NDWPCP(xr7) = neww;
		maxwd = MAX(maxwd,word);
		furword = MAX(furword,word);
//cout<<"found alt catagory kateg="<<kateg<<" word="<<word<<" neww="<<neww
//<<" comp wd from node="<<(NDWPNC(xr7))<<endl;
		return 3;//      goto L300;
		}// if kateg

	}//if frznod
	}//if atomic

// 		 Detach node from tree
// L620:
//		If detached node is recursive, record on recursives list
	if(NDRECT(xr7)) recurs(4);
	sxr7=xr7;
	xr7=NDUPLF(xr7);
//         if FIL node--clear down pointer of node above
	if(NDFILT(sxr7)) NDBALP(xr7)=0;
	else NDRTPT(xr7)=0; //not FIL node--clear right ptr of node to left
//       check for node attributes to be erased when this node is detached
	if(NDEABT(sxr7)) delna(sxr7,FALSE);
//                 if frznod points to the node just erased, clear frznod
	if(sxr7 == frznod) frznod=0;
	int ndsc=NDSCPT(sxr7);
	int ndsp=NDSPNT(sxr7);
	int ndop=NDOPES(sxr7);
	filsw=NDFILT(sxr7);
	freenode(sxr7); // free space used by node

//              If special process node, except scope marker, has been
//              detached, try to rebuild level without special process node
	if(! ndsp) goto L650;
	dlp=CSR(ndop);
	freeListItem(ndop);
	if(ndsc) goto L658;
//                             if in a frozen substructure, ignore
//                             alternative without special process node
	if(frznod) goto L658;
	if(trace) nodtrc(4,elemt);
	spdef=0;
	return 4;// goto L320;
//			if a non-special process node has been detached,
//                      check if pending word has the SCOPEWORD category
L650:
	if(scpwrd){// goto L655;
//                                   if in a frozen substructure, don't
//                                   try alternative with SCOPEWORD
	if(!frznod){// goto L655;
	l=searchCatList(word,scpwrd);
	if(l) {//goto L655;
	l=CSR(l);
	if(l){// goto L653;
	elemt=CARADDR(l);
	dlp=gcons(0,ndop,elemt);
	ndbits=SPNODE|SCPNOD;
	if(elemt){// goto L653;
	//if(trace) nodtrc(1,elemt);
//                                attach node
	return 2;//      goto L200;

	}//if
	}//if
//L653:
	*coutP<<msgAtScpwUn <<endl;

//                   If FIL was detached, try its next division list
	}//if l
	}//if frznod
	}//if scop word

//L655:
	dlp=ndop;
L658:
	if(filsw) return 1;//goto L100;
//                           non FIL detached
	if(trace) nodtrc(4,elemt);//if trace is on print new current node
//                                find next node to detach
	if(findLastNodeAttached()<0)return -2;
	}//while
  //    goto L600;
}// func

extern int centerLastWord;
extern int centerFirstWord;
static int centerRepTerm;

int parser(int parin, int reparseFlag){
int lastAtomic=0;
	int ns,i, spword, l, prev;
	int sxr7,result;
	char txtarr[500];
	extern void interpRestart(void);
	interpRestart();
int indent=7;

	par=parin;
	nword=wordend;
	minwd=wordend;
//                          I. initialization
//                        If a parse has been obtained, detach last atomic node
	if(par){ // goto 500
	if(findLastNodeAttached()<0)return -2;
//	goto  L600;
	result=detachNode();
	if(result<=0)return result;
	if(result==1)goto L100;
	if(result==2)goto L200;
	if(result==3)goto L300;
	if(result==4)goto L320;
	}//if

	word=wordstart; // word in sentence
	furword=word;
//                                   4. pointer to next available node
	prev=0;
	frznod=0;  // frozen node pointer
	freeze=FALSE;
	filsw=FALSE;
	for(i=wordstart; i<= nword;i++) SENTE3(i)=0;

//                              Set up root node
	xr7=getnod();
	NDABTS(xr7)=FIL;
	NDWPNC(xr7)=wordstart;
	NDSPFB(xr7)=CSR(grroot);
	NDHDBA(xr7)=grroot;

	dlp=grroot; //  division list pointer
	elemt=grroot;
//cout<<"elemt-1 "<<STNAME(CAR(elemt))<<endl;// **debug**
	if(trace) nodtrc(0,elemt); //  initialize trace
	recurs(0); //  initialize RECUR
	nodeAttInit();

        spword=LOOKST((char *) SPWRDC);
        if(spword) spword=STADDR(spword);
        scpwrd=LOOKST((char *) SCOPWC);
        if(scpwrd) scpwrd=STADDR(scpwrd);
L100:
	 dlp=CDRADDR(dlp); //  Get next division list
//cerr<<"at 100 "<< dlp<<endl;
//      If no more division lists for this span, tear up tree
	if(!dlp){
		result=detachNode();
		if(result<=0)return result;
		if(result==1)goto L100;
		if(result==2)goto L200;
		if(result==3)goto L300;
		if(result==4)goto L320;
		}//if dlp==0
//                                 if in a frozen substructure, ignore
//                                 ignore other options, go tear up tree
	if(frznod){// goto L600;
		result=detachNode();
		if(result<=0)return result;
		if(result==1)goto L100;
		if(result==2)goto L200;
		if(result==3)goto L300;
		if(result==4)goto L320;
		}
	filsw=TRUE;
	ndbits=0;
	elemt=CARADDR(CARADDR(dlp));
//cerr<<"elemtat100 "<<elemt<<endl;
	if(!elemt){
		*coutP<<msgAtToRef<<endl;
		return -3;
		}

//                          if option has any restrictions execute them
	if(!(arg=CSR(dlp))) goto L200;
	if(trace) nodtrc(1,elemt); // if trace is on, print first element
	list=0;
	result = restTest(arg, FALSE);
	if(result == 2) goto L100; //edit restart definition
	if(result == 4){ //GENER restart definition
		if(trace) nodtrc(-1,elemt);
		goto L100;
		}
	if((result)<0 || result >1) return result;

//                              1. if restriction succeeds, attach node
  //180
//                              2. if it fails, print -(.) if trace
//                                  is on then try next division list
	if(result) goto L205;
	if(trace) nodtrc(2,elemt);
      goto L100;

// *                         III. attach node
// *                            if node to be attached is recursive,
// *                                  check recursives list
L200:
int dlyprt;
	dlyprt=trace;
//	if(trace) nodtrc(1,elemt);
goto L206;
L205:
	if(trace) dlyprt=0;
L206:
	 if((CSRINT(elemt) & RECBT) == 0) goto L210;
// *                                  1. if disqualified for recursion, go
// *                                     to B.1--back up or get next option
	if(recurs(1)) goto L220;
	if(dlyprt) {nodtrc(1,elemt);dlyprt=0;}
	if(trace) nodtrc(2,elemt);
      goto L219;
// *                               b. if element is atomic and not null,
// *                                  check against current word
L210:
	if((CSRINT(elemt) &(ATOMIC+OTOMIC)) != ATOMIC) goto L220;
	kateg=0;
	kateg=lookAtWord(kateg);
	if(dlyprt) {nodtrc(1,elemt);dlyprt=0;}
	if(kateg) goto L220;
//                                  1. if no match
//                                   print -(...) if trace is on
	if(trace) nodtrc(2,elemt);

//                        check if pending word has the SCOPEWORD category
	if(scpwrd == 0) goto L219;
	l=searchCatList(word,scpwrd);
	if(l == 0) goto L219;
	l=CSR(l);
	if(l){// goto L218;
	elemt=CARADDR(l);
	dlp=gcons(0,dlp,elemt);
	ndbits= (SPNODE | SCPNOD) ;

	if(elemt) {//goto 410
//	if(trace) nodtrc(1,elemt);
//                            Attach node
      goto L200;
	} 
}//if l
//L218:
	*coutP<<msgAtScpwUn <<endl;
//                           looking at first element try next option
L219:
	 if(filsw) goto L100;
//                              else back up
	if(trace) nodtrc(4,elemt);
//      goto 500
	if(findLastNodeAttached()<0)return -2;
//      goto L600;
	result=detachNode();
	if(result<=0)return result;
	if(result==1)goto L100;
	if(result==2)goto L200;
	if(result==3)goto L300;
	if(result==4)goto L320;

//                      Get free space in node array
L220:
	if(dlyprt) {nodtrc(1,elemt);dlyprt=0;}
	ns = getnod();
//                          D. build new node
	if(!filsw){
//               not first in level: set right ptr in current node to new node
		NDRTPT(xr7)=ns;
//                  if current node has in dummy flag set, flag new node too
		if(NDIDMT(xr7)) ndbits=ndbits|INDUM;
		}//if

	else {// first in level: set down pointer in current node to new node
		NDBALP(xr7)=ns;
		ndbits |= FIL; //  set first-in-level flag
//                         if current node is unnamed, set in dummy flag
		if(NDNONT(xr7)) ndbits=ndbits|INDUM;
		} //else filsw

	NDWPNC(ns)=word;
	NDABTS(ns)=ndbits;
	NDUPLF(ns)=xr7; // set up/left pointer of new node to current node
	NDOPES(ns)=dlp; //  store division list pointer
	NDSPFB(ns)=CSR(elemt); // store copy of grammer def head
//cerr<<"bits "<<CSR(elemt)<<endl;
	NDHDBA(ns)=elemt;
	xr7=ns; //  make new node current

	if(!(NDATMT(xr7))){
		dlp=elemt; // first division list
	      	goto L100;
		}

	 if(!NDOTMT(xr7)) {
//                     For non-null atomic nodes
// must check for not allowed pointer have to fail this node
// the node is complete will see if to go on
	maxwd=MAX(maxwd,word);
	word=neww; // advance word pointer
	furword=MAX(furword,word);
// 			 save pointer to category and neww
	NDWPCP(xr7)=neww;
	NDORDC(xr7)=kateg;
	NDBALP(xr7)=iattrb;//store attribute list into down pointer
	}

	else { 
		NDWPCP(xr7)=word;
		NDORDC(xr7)=0;
		}//else

//                    test for completeness of level
L300:
//  305
	if(!(NDUPLF(xr7))) {//At root node goto 370
	if(parseType==DOSE_TYPE){
		if(word>centerLastWord) centerLastWord = word;
		}
//                           have completed top level, check if
//                           all sentence words have been matched
//  370
		if(lastAtomic >  nword) {
			if(trace) nodtrc(3, elemt);
			return TRUE; // yes, return
			}

//                              no, detach last atomic attached
//  370
		if(findLastNodeAttached()<0)return -2;
L876:		result=detachNode();
		if(result<=0)return result;
		if(result==1)goto L100;
		if(result==2)goto L200;
		if(result==3)goto L300;
		if(result==4)goto L320;
		}//if at root node

//			put pointer to completed element in dlp
	dlp=NDOPES(xr7);
	if(NDSPNT(xr7)) dlp=CSRADDR(dlp);
	if(NDFILT(xr7)) dlp=CARADDR(dlp);

//			check if pending word has SPWORD category
	spdef=0;
	if(word<=nword){ // goto 500
	if(spword == 0) goto L320;
	if(NDOTMT(xr7) || NDNONT(xr7)) goto L320;
	l=searchCatList(word,spword);
	if(!l) goto L320;
	l=CSR(l);
	if(l == 0){
	*coutP<<"*** Attribute of SPWORD missing or undefined"<<endl;
	goto L320;
	}
	spdef=CARADDR(l);
	ndbits=SPNODE;
	elemt=spdef;
	dlp=gcons(0,dlp,elemt);
	filsw=FALSE;
	if(elemt) goto L340;
	spdef=0;
	}// if word processed not last one

//			execute wellf
L320:
	if(NDSCPT(xr7)) goto L340;
	if(!(arg=CSR(dlp))) goto L340; //no wellfs on scope nodes
	list=0;
	if((result=restTest(arg,TRUE))<0)return result;

//    if wellf fails, find last atomic attached and detach it up tree
//L330:
	if(! result){ // goto 500
	if(findLastNodeAttached()<0)return -2;
//	goto L600;
	result=detachNode();
	if(result<=0)return result;
	if(result==1)goto L100;
	if(result==2)goto L200;
	if(result==3)goto L300;
	if(result==4)goto L320;
	}

L340:
	if(trace) nodtrc(3,elemt); //if trace is on, print +(node) **
	if(linz<0) return -1;
//                       if completion bit is set, print completion message
	if(NDCMPT(xr7)){
		prntif();
		sxr7=xr7;
		for(int i=0;i<3;i++){
			if(i) { if(!upone()) break; fill(" in "); }
{
			fill(nodnam(xr7, txtarr));
}
			}//for
		xr7=sxr7;
		fill(" has been completed subsuming  ");
		fill(subsum(xr7,txtarr));
		prnt();
		}// if comp
{
		if(strcmp(nodnam(xr7, txtarr),"CENTER")== 0){
				int mwp=NDWPCP(xr7);
				if(mwp>centerLastWord){
					centerLastWord=mwp;
					centerFirstWord=NDWPNC(xr7);
					}
			}//if at CENTER
if(NDSPFB(xr7) & ATOMIC){
lastAtomic=word;
}
}

//                         If more elements in current defn.
	if(!spdef) {
	if(!(NDSCPT(xr7))) dlp=CDRADDR(dlp);

	if(!dlp){
// 				 else go up one level and repeat IV.
		upone();
//                               If node just completed is recursive
//                               record completion on recurs list
		if(NDRECT(xr7))recurs(2);
// 				 Record pending word in node
		NDWPCP(xr7) = word;
		NDORDC(xr7) = 0;
		goto L300;
}
//                       get next element of division list
	elemt=CARADDR(dlp);
	if(!elemt) {*coutP<<msgAtToRef<<endl; 
		return FALSE;}
	filsw=FALSE;
	ndbits=0;
	}
//                                 if trace on, print element
//	 if(trace) nodtrc(1,elemt);
	if(trace)dlyprt=1;
//                                 attach node
      goto L200;

}// end of parser

/*
***********************************************************************
     Function lookAtWord is called by the parser when it reaches
     an atomic node, to check for a match with the pending sentence
     word.  It is also called by the parser when it is about to detach
     an atomic node, to check whether the matched category appears a
     second time on the category list (as might occur if the current
     word were a homograph) .

          On the call to seek an initial match with the sentence word,
     KATEG=0, the values of NEWW and IATTRB are ignored.  If no match
     can be made to the pending word, LAW returns with KATEG still
     equal to 0.  If the atomic node is not a literal and it matches a
     category of the pending word, lookAtWord returns with KATEG = the
     position of the matched category on the category list (e.g., 3 if
     it is the third category on the list) and IATTRB pointing to the
     beginning of the attribute list for that category.  If the atomic
     node is a literal, and matches the pending word, lookAtWord returns
     with KATEG=1, IATTRB=0.  In either case, if a match is made, NEWW
     contains the number of the word following the last word matched by
     the node (i.e., the pending word after the atomic node is completed).

          On subsequent calls to lookAtWord, when the current atomic node
     is about to be detached, KATEG, IATTRB, and NEWW should contain on
     entry the values returned by lookAtWord on the preceding call. If the
     node to be matched is a literal, lookAtWord returns failure (KATEG=0).
     If the node is not a literal, lookAtWord continues searching the
     category list, starting from the position where the previous
     matching category appeared.  If a second occurrance of this catagory
     is found, lookAtWord  returns KATEG, IATTRB, and NEWW just as for
     the initial match.  If the category does not appear again, lookAtWord
     returns with KATEG=0.
***********************************************************************
*/

int lookAtWord(int kategin){
	int lform=0,k,l;

if(word>nword)return 0;

	if((CSR(elemt)&LTOMIC)) {//element to be matched is a literal,
	if(kategin) return 0;// second try fail for literal
	int litptr=CARADDR(elemt);
	char *tspt=STNAME(litptr), *strt;
	strt=tspt;
	int wd=word, ssct=1;
	while(*tspt !='\0'){
		if(*tspt == '!' || *tspt == '_'){
			if(strncasecmp(SENTWD(wd++),strt,tspt-strt))return 0;
			ssct++;
			strt=tspt+1;
			}
		tspt++;
		}//while

	if(ssct < SENTE6(word))return 0;//not same length
	if(ssct ==1)if(strcasecmp(SENTWD(word),strt))return 0;
	else if(strncasecmp(SENTWD(wd),strt,tspt-strt))return 0;
	neww=word+ssct;
//cout<<"\n779 neww="<<neww<<endl;
	iattrb=0;
	SENTE3(word)=0;
	return 1; //  Return 1 as success signal
	} //if literal

	k=1;
	l=SENTE2(word);
	if(!kategin){// first search
//               we are looking for first span, start at beginning of list
	neww=word+SENTE6(word);
//cout<<"\n779 neww="<<neww<<endl;
	}//if
	else {// check for alternate category


//                                D. set L to point to element of
//                                   category list following one just used
		l = SENTE2(word); k = 1;
//                           Search for an alternate category
		while(k<=kategin){
			if(l==0) {
				*coutP<<"***** Invalid KATEG="<<kategin
				<<" passed to LookAtWord at word "
				<<SENTWD(word)<<endl;
				return 0;
				}//if
			if(!ATOMP(CAR(l))) lform=l;
			l=CDRADDR(l); k++;
			}//while
		}//else alternate search start

	if(!l) return 0;

//               search for matching category on category list
	for(int katsh=k;katsh<=255;katsh++){
//                        if at end of list, return failure
		int kar=CAR(l);
		if(!ATOMP(kar)) lform=l;
//   skip over list head ++ check this
		else {
//                       if element matches category sought, return success
		if(kar == elemt) {
//                    hit -- return pointer to attribute list in iattrb
			iattrb=CSR(l);
			SENTE3(word)=CSR(lform);
//cout<<"\nSENTE3 at word="<<word<<" val is="<<(SENTE3(word))<<endl;
//void plist(int,int,int);// **debug
//plist(SENTE2(word),FALSE,PRUNIT);cout<<endl;// **debug
//plist(SENTE3(word),FALSE,PRUNIT);cout<<endl;// **debug
      			return katsh;

			} // kar
		}//else
//                              Get next list element
	l=CDRADDR(l);
	if(!l) return 0;
	} // for on kateg 

//                                C. If too many categories, print message
   *coutP<<"*** More than 255 elements in category list of word "
	<<SENTWD(word)<<endl;
      return 0;
}

#if 0
// *
// * This function is called after a successful parse and there are
// * homographs in the Sentence. It will search the catagory list for
// * the word in the call after the catagory used in the parse. Since
// * a catagory can only appear once for a word in a group this
// * operation is equivalent to looking for this catagory in another
// * group.
// *
      FUNCTION GETNEXTCAT(WRDSH)
      INCLUDE 'common.fcm'
      CHARACTER*(WORDLEN) SENTWD
      INCLUDE 'nodefs.fcm'
// *
      l=SENTE2(WRDSH)
      KATEG=SENTE4(WRDSH)
// *     print*,'word= ',WRDSH,' ',stname(sente1(WRDSH))
      DO K=1,KATEG
      if(l.EQ.0) THEN
      ENDIF
// *     print 8888,k,l,cdr(l),csr(l),car(l),csr(car(l))
// *8888 format('k=',i4,' l=',i4,' cdr-csr-car',3i5,' csrofcar',o8)
      IF(.NOT. ATOMP(CAR(L))) THEN
        LFORM=L
      ELSE
        CATW=CAR(L)
      ENDIF
      L=CDR(L)
      ENDDO
// *
// * check if there is another catagory of the same type in
// * another word group below the one used.
// *
      DO K=KATEG+1,255
      if(L.EQ.0) THEN
// * There are no other groups after the group which was used in the
// * parse or there is no catagory of the same type in a lower group
// * as used in the parse.
        RETURN 0;
      ENDIF
      if(.NOT. ATOMP(CAR(L))) THEN
        LFORM=L
      ELSE
        if(CATW.EQ.CAR(L))THEN
          GETNEXTCAT=K
          RETURN
        ENDIF
      ENDIF
      L=CDR(L)
      ENDDO
      RETURN
      END
#endif
