/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <string.h>
#include <fstream.h>
#include <signal.h>
#include <setjmp.h>
#include "common.fcm"
#include "lispdefs.fcm"
#include "nodefs.fcm"
// #include "timings.h" JR: removed timing code 11/02/01 
#include "returncodes.h"
#if 0
      INTEGER SENTESAV(6)
      COMMON/SEGTABS/SEGED,SEGST
      INTEGER*2 SEGED(100),SEGST(100)
#endif
#define TRUE 1
#define FALSE 0
#define PARPROCSTAT_IN_SENTREAD 1
#define PARPROCSTAT_IN_PARSER 2
#define PARPROCSTAT_IN_TREEOUT 3
#define PARPROCSTAT_IN_DRAWTREE 4

struct doseInst{short sentNumInDoc; short wordsInStr;
        char medPos; char rightOrLeft; char isOF;
	char startWordInDoc; char endWordInDoc; char startWord; char endWord;};
extern int inctrt; // **debug
extern int scanwd(int,int);
extern int scanwd_dose(int, struct doseInst*);
extern void errmgp(int,int,int,int);
extern void ptree(int);
extern int printSent(int,int,int,int);
extern void plist(int,int,int);
extern void freesg(int);
extern int parser(int, int);
extern void treeDraw(int, int), outpud(int, int, int, int);
extern int treeToList(int);
extern int rdpars(void);
extern void nodeInit(void);
extern int xform(char, int);
extern void exitr(int, const char *);
extern void wordDefsEnd(void);
extern void prntif(void);
extern void prnt(void);
extern void setFillUnit(int);
extern void resetFillUnit(void);
extern void setrtmargin(int,int);
extern int nodesInTree(void), nodesRequested(void);
jmp_buf longjumpbuf; // oogles return
//struct itimerval value;  JR: removed timing code 11/02/01 
//struct itimerval *valuep=&value;  JR: removed timing code 11/02/01 
//struct timeval it_interval;  JR: removed timing code 11/02/01 
//struct timeval it_value;  JR: removed timing code 11/02/01 

// timings testtimes;  JR: removed timing code 11/02/01 
int centerLastWord;
int centerFirstWord;
extern void timer(int);
void (*handlerp)(int);
static int longjpret;

void readSegmentData(int){
*coutP<<"In segment read"<<endl;
return;
}

// ---------------------------------------------------------------------

void sentskip(int num_skipsent){
	for(int i=0; i<num_skipsent; i++){
int		scret=scanwd(wdin,TRUE);
		*coutP<<"Skipping sentence SID="<<sentid<<endl;
		isenfp++;   // update sentence file position pointer
		} //for
	return;
} //func end

// ---------------------------------------------------------------------

void parscn(int numSentParse){
	int scret,parstat, ltree, reparseSwitch, cutoffPos;
	float fltime,flsystime;
// parlim=10;
	int startWord, endWord;
	int parsingStatus=0;
	if(numSentParse<0)numSentParse=totalNumSent-isenfp;
	else if(numSentParse>totalNumSent-isenfp)
		numSentParse=totalNumSent-isenfp;

ofstream doseout;
if(parseType == DOSE_TYPE){
	doseout.open("$$dose-parsed$$",ios::out|ios::trunc);
	if(!doseout){
		*coutP<<"failed to open"<<endl;
		}
	}//if dose parse

struct doseInst doseParams;
	while(numSentParse-- > 0){ // loop over sentences
	freesg(0); // get rid of data of previous sentence
	nodeInit(); // return nodes to pool

//                            call SCANWD

	parsingStatus = PARPROCSTAT_IN_SENTREAD;
	int totwords;//number of tokens in sentence

	if(parseType == DOSE_TYPE) {//dose string parse
//doseParams.sentidTxt= sentid;
		scret = scanwd_dose(wdin, &doseParams);
		totwords = doseParams.wordsInStr;//number of tokens in sentence
		isenfp++; //  update sentence file position pointer
		if(scret==-1)break;//end of file
if(scret==2){//empty string send back a failure return
doseout<<doseParams.sentNumInDoc<<"  "<<(int)doseParams.medPos<<"  "
<<' '<<(int)doseParams.isOF<<" 0 0"<<endl;
continue;
}
	totwords = doseParams.wordsInStr;//number of tokens in sentence
	nwordSent = doseParams.wordsInStr;
	startWord = doseParams.startWord; endWord=doseParams.endWord;
		if(scret==0)continue;// skip dose string
		wordDefsEnd(); // note end of sentence word definitions
		}//if dose parse

	else {//regular parse
		scret = scanwd(wdin,FALSE);
		isenfp++; //update sentence file position pointer
//          if lexical error, print message, get next sentence
		if(scret==0) {errmgp(2,0,0,0); continue; }
		wordDefsEnd(); //note end of sentence word definitions
		startWord = 1;

		if(scret<0){ // the first undefined word is -scret

// With an undefined word we try to parse the sentence up to
// the undefined word. However if the last word is the undefined one
// we cannot proceed since the sentence terminator is undefined. This
// can come about if ther is a error in the dictionary

		errmgp(11,-scret-1,0,0);
		if(-scret==nwordSent){
		*coutP<<"The sentence terminator is not defined. This is "
                    <<"likely due to a dictionary error\n"
                    <<"Parsing run will be terminated"<<endl;
		exitr(10, "Bad dictionary");
			}
		if(scret == -1) continue;//skip sent first word bad
// move the sentence terminator to the first undefined word
		cutoffPos = -scret;
		sentTable[nwordSent+1] = sentTable[cutoffPos];//save undef word
		sentTable[cutoffPos]=sentTable[nwordSent];//move sent term
		endWord = cutoffPos;
		}// undef words

	else { //good lookup
		if(nwordSent==1){ // empty sentence
			*coutP<<"SID="<<sentid<<endl;
			*coutP<<"No parses possible - empty sentence"<<endl;
			continue;// next sentence
			}//if
		endWord=nwordSent;
		}//else good lookup
		}//else regular parse


//      nosegs=0;

//                            Parse sentence

      rarsw=FALSE;
      repsw=FALSE;
	linz=linlim;
	parsno=0;
//      maxwd=prevwd+1;
	int par=FALSE;

	int moreParse=0;
	do { //loop for multiple parses
	//if(verbos) timeit(0);
//      lexerr=FALSE;
#if 0
      if(nosegs != 0) go to 613
      if(segsw == TRUE) go to 721
      segbeg=1;
      segend = totword-1;
      seglen = segend-segbeg+2;
#endif
	wordstart = startWord; wordend = endWord;
	printSent(startWord,endWord,0,PRUNIT);//print sentence

// if(restiming)testtimes.timeRestrInit();  JR: removed timing code 11/02/01 
int parSwtch=1;
int oogles=0, ljret, maxtmflg=0;
	if((ljret = setjmp(longjumpbuf)) != 0){ // longjump return

/*
This is the return point from a long jump. This will occur under the
following conditions:
	1. Max time was set and a max time occurred
	2. Parser ran out of list space
	3. Parser ran out of node space. This is almost impossible.
           For conditions 1, 2 and 3: if the first time then a
           reparse is tried in the same way as if there had been a
           parsing failure of the usual type.

There should be no long jumps errors on a reparse since the parser 
is redoing what it was done before only less this second time, ie the
parsing termination condition is one that it had reached on the first try.
*/

switch(ljret){

	case LJR_MAXPRINTLINES:
//lines in print file exceeds limit. The action taken is to lerminate
//the run since somthing is out of control and will not likely go
//away by going to a new sentence.
	exitr(11, "Too many lines in output file");

	case LJR_MAXNODES:
		errmgp(6,0,0,0); // print node limit exceeded message
	case LJR_OUTNODESPACE:
		*coutP<<"\nCurrent parse tree"<<endl;
		ptree(PRUNIT);
		parstat=FALSE;
		parSwtch=-1; break;//next sentence

	case LJR_ARRAYOVERFLOW:
	case LJR_STACKREQOVER:
		*coutP<<" array overflow return"<<endl;
		parstat=FALSE;
		parSwtch=-1; break;//do next sentence

	case LJR_TRANSSTACKOVER:
		*coutP<<" transformation stack overflow return"<<endl;
		parstat=FALSE;
		parSwtch=-1; break;//do next sentence

	case LJR_MAXTIME: //max time return
		*coutP<<"Max time for sentence"<<endl;
		errmgp(12,0,0,0); // print time limit exceeded message 
//if file selected print sentence
if(maxtimefl){
	printSent(wordstart,wordend,0,maxtimefl); // print sent 
	}
if(maxtmflg!=0)break;//second max time go to next sentence
maxtmflg=1;//mark a maxtime
		parstat = FALSE;
		parSwtch=2;//set for center retry
		break;

	case LJR_OUTLISTSPACE://out of list space
		*coutP<<"oogles return"<<endl;
/*
One can arrive here on the first parse try.
It is not possible to be here on a center reparse because one would have
gotten to the stopping point on the first try before an oogle.
*/
		oogles++; parstat = FALSE;
	if(verbos){
	  // fltime = testtimes.timeSentEnd();  JR: removed timing code 11/02/01 
	  // flsystime = testtimes.timeSysSentEnd();  JR: removed timing code 11/02/01 
	  // *coutP<<"            CPU time = "<<fltime<<" sec"<<endl;
		}

	// if(restiming)testtimes.timeRestrPrint();  JR: removed timing code 11/02/01 

		if(parsingStatus == PARPROCSTAT_IN_TREEOUT){
			*coutP<<"oogles in outputting tree"<<endl;
			parstat = FALSE;
			parSwtch= -1;//next sentence
			break;
			}
if(oogles ==1){parSwtch=2; parstat=FALSE; break;}//set for reparse-center

default:
	exitr(9, "error in longjump");
	}//switch end

	if(parSwtch<0)break;//next sentence

		}//if long jump and not init

inctrt=0; // **debug

switch(parSwtch){
case 1:

//                      call PARSER for the first try

	if(maxtime>0){//set the max time counter
	        // (valuep->it_value).tv_sec=maxtime;  JR: removed timing code 11/02/01 
	        // signal(SIGVTALRM,&timer);  JR: removed timing code 11/02/01 
		// int timret=setitimer(ITIMER_VIRTUAL,valuep,NULL);  JR: removed timing code 11/02/01 
		}//if max timer request

	        // if(verbos)testtimes.timeSentStart();  JR: removed timing code 11/02/01 
		reparseSwitch = 0;
		parsingStatus = PARPROCSTAT_IN_PARSER;
		globsws[0]=0; globsws[1]=0; globsws[2]=0; globsws[3]=0;
		centerLastWord=0;
		centerFirstWord=0;
		parstat = parser(par, reparseSwitch);//call parser
		if(verbos){
		  // fltime = testtimes.timeSentEnd();  JR: removed timing code 11/02/01 
		  // flsystime = testtimes.timeSysSentEnd();  JR: removed timing code 11/02/01 
		}

	if(parseType != DOSE_TYPE){
		if(parstat == TRUE){
			parsno++;
			*coutP<<"\nSuccessful parse No. "<<parsno<<endl;
			par=TRUE;
			moreParse=1; break;
			}
		}//if not DOSE parse
	
//If this is a dose run then a failure with a non-zero last word at root
// is a success and the result is returned but with a shortened string

if(parseType == DOSE_TYPE){
doseout<<doseParams.sentNumInDoc<<"  "<<(int)doseParams.medPos
<<' '<<(int)doseParams.isOF<<" "
<<doseParams.startWordInDoc+startWord-1;
if(parstat == TRUE){
doseout<<"  "<<doseParams.startWordInDoc+endWord-1<<endl;

if(!doseout){//bad output operation
*coutP<<"output failed for "
<<doseParams.sentNumInDoc<<"  "<<doseParams.startWordInDoc+startWord-1
<<" "<<doseParams.startWordInDoc+endWord-1<<endl;
}

parsno++;
moreParse=1; break;
}//if success

if(centerLastWord>0){// a non-zero last word
*coutP<<"the dose string parsed was: ";
for(int i=1; i<centerLastWord; i++)*coutP<<' '<<(SENTWD(i));
*coutP<<endl;

doseout<<" "<<doseParams.startWordInDoc+centerLastWord-2<<endl;
//moreParse=1;
//break;
//for now we reparse the short string  to get the tree
}//if non-zero last word

else {
doseout<<" "<<doseParams.startWordInDoc+endWord-1
<<" "<<doseParams.startWordInDoc+endWord-1<<endl;
break;//total failure on dose parse
}
}//if dose type

case 2:
//     The parse failed; return the list and node space used in the parse
//  and rerun the sentence to get parse to longest center.
if(!centerLastWord){
//if this was an oogles back up to a last comma and try again, but only do once
if(oogles==1){
int io;
for(io=wordend; io>0 ;io--){
if(strcmp(SENTWD(io), ",")==0)break;
}//for
if(io==0){ centerLastWord=io;
}//if oogles ==1
	else *coutP<<"Center never reached- no reparse"<<endl;
}//if
}//center not reached
else {//center reached on first try do a reparse
                // if(verbos)testtimes.timeSentStart();  JR: removed timing code 11/02/01 
		par=0;
		freesg(1);
		nodeInit();
		char *savwd;
	if(parseType == DOSE_TYPE) wordend = centerLastWord-1;
	else{//regular parse
		wordend = centerLastWord;
		savwd = SENTWD(wordend);
		sentTable[wordend]=sentTable[nwordSent];
		}//else

		centerLastWord=0;
		centerFirstWord=0;
		reparseSwitch=1;
		parsingStatus = PARPROCSTAT_IN_PARSER;
		globsws[0]=0; globsws[1]=0; globsws[2]=0; globsws[3]=0;
		parstat=parser(par, reparseSwitch);//reparse
		// if(verbos)fltime = testtimes.timeSentEnd();  JR: removed timing code 11/02/01 
		if(parstat != TRUE)exitr(20, "Failure on CENTER reparse-system error");
		*coutP<<"\nSuccessful parse on CENTER-reparse"<<endl;
		printSent(wordstart,wordend-1,0,PRUNIT);//print sub-sentence
		if(parseType != DOSE_TYPE) {
			SENTWD(wordend) = savwd;
			if(scret<0)sentTable[-scret]=sentTable[nwordSent+1] ;
			}
		printSent(1,nwordSent,0,2);//print original sentence
		sentTable[wordend]=sentTable[nwordSent];
		wordend--;
parsno++;
		break;

}//else center reached on first parse

}//end of switch


{
	if(parstat < 0){
//                        flush line buffer and print error messages
	prntif();
	if(linz < 0) errmgp(5,0,0,0); // print message if line limit was exceeded
	*coutP<<"Current parse tree"<<endl;
	ptree(PRUNIT);
	break; // get next sentence
	}//if error
}


	if(parstat>1){ 
// we are here because the parsing process was interrupted.
// this is due to:
//   1. A termination request was made which requires
//      a notation that a reparse has been done, 
		parsno = 1;
//reparse results in a shortened sentence. Need to mark wordend
//with the last word subsumed by the CENTER node.
		wordend = word-1;
		NDWPCP(1) = word;
		}
#if 0
  613 continue
      segnumst=segnumed+1;
      segnumed=segnumst+segspan-1;
      segbeg=segst[segnumst];
      segend=seged[segnumed];
      seglen=segend-segbeg+2;

      if(segnumed != nosegs) {
        sentesav[1]=SENTE1(segend+1);
        sentesav[2]=SENTE2(segend+1);
// *       sentesav(3)=SENTE3(segend+1)
	sentesav[4]=SENTE4(segend+1);
	sentesav[5]=SENTE5(segend+1);
	sentesav[6]=SENTE6(segend+1);

// *     SENTE1(segend+1)=SENTE1(totword)
      if(segend+1!=totword) SENTE1(segend+1)=getst('#',0);
      SENTE2(segend+1)=SENTE2(totword);
// *     SENTE3(segend+1)=SENTE3(totword);
      SENTE4(segend+1)=SENTE4(totword);
      SENTE5(segend+1)=SENTE5(totword);
      SENTE6(segend+1)=SENTE6(totword);
      }
      if(nosegs.gt.1) {
      if(sidl.gt.0)sentid(sidl+1:sidl+1)=char(segnumst+ichar('A')-1);
      }
	if(segbeg==1) segpvw=0;
	else segpvw=segend[segnumst-1];
      errmgp(9,segbeg,segend,segpvw) ;// print segment being parsed
// *     CALL FREEPARTSG(BNDAFWD)
	wordstart=segbeg;
	wordend=segbeg+seglen-1;
      parser(segbeg,seglen, reparseSwitch);

      if(segnumed.ne.nosegs) then
        SENTE1(segend+1)=sentesav[1];
        SENTE2(segend+1)=sentesav[2];
// *       SENTE3(segend+1)=sentesav(3);
        SENTE4(segend+1)=sentesav[4];
        SENTE5(segend+1)=sentesav[5];
        SENTE6(segend+1)=sentesav[6];
      endif
  617 continue
  622
#endif
int listSpaceAvailable(void);
	if(verbos) {
//           if requested, print elapsed time and cell count
		*coutP<<"            CPU time = "<<fltime<<" sec"
		<<"\n            Sys time = "<<flsystime<<" sec"
		<<"\n            Nodes in tree  = "<<nodesInTree()
		<<"\n            Nodes attached = "<<nodesRequested()
		<<"\n            Number of tokens = "<<nwordSent
		<<"\n            List Space Reamaining = "<<listSpaceAvailable()<<endl;
		}
	// if(restiming)testtimes.timeRestrPrint();  JR: removed timing code 11/02/01 

//                     Output results of parse
//                    if no parses, print last word analyzed
	if(!parsno){
	errmgp(1,0,0,0);
//  720 CALL ERRMGP(3,MAXWD,segend+1,segbeg)
//720
	errmgp(3,maxwd,wordend,furword);
	break;// break from parsno while loop
	}
#if 0
//     sentence has failed to parse, see if any semicolons and try to
//     parse the subunit      

  721 if(nosegs!=0) go to 740
      if(segsw==FALSE) go to 740
      sidl=trmlen(sentid)
      nosegs=getsegs(segst,seged,totword);
      if(nosegs>0) go to 722
      nosegs=1;

  722 segspan=1;
      segnumed=0;

	continue;
  740 continue
#endif
//                             2. if no more parses, get next input line
#if 0
  750 IF(.NOT.PAR) GO TO 800
      segspan=1;
// *        last parse was a success if segparse adjust seg pointer
// *        arrays
      if(nosegs>0) {then
      if(segnumst.ne.segnumed) then
      seged[segnumst]=seged[segnumed];
      i=segnumst;
      do 751 j=segnumed+1,nosegs
      i=i+1
      segst[i]=segst[j];
  751 seged[i]=seged[j];
      nosegs=i;
      segnumed=segnumst;
      segspan=1;
      end if
      }
#endif
//                                 apply transformations
//      if(xon){ 
//        if(xform('T') <0) Go to 9999
//      }
//                                 print tree if requested
      if(treesw) {
		parsingStatus = PARPROCSTAT_IN_DRAWTREE;
		outpud(parsno, wordstart, wordend, PRUNIT);
		}
      if(drawsw) {
		parsingStatus = PARPROCSTAT_IN_DRAWTREE;
		treeDraw(wordstart, wordend);
		}

// 	check if transformation succeeded
// 	if transformation fails try for another parse

//                          Write tree if requested
	if(treout>0) {
		parsingStatus = PARPROCSTAT_IN_TREEOUT;
        	prntif();
		printSent(1,wordend,2,treflo); // print sent on treflo

//    check if word forms requested

		if(treout==TRENWF) ltree=treeToList(FALSE);
        	else ltree=treeToList(TRUE);

        	plist(ltree,FALSE,treflo);
		} // if treout
//                    Process parse tree
//                             scan parse tree:  to generate MINWORD lists
//      scantr();

//                  call PARSER again to try to find more parses
	}while(parsno<parlim && moreParse !=0);

#if 0
  800 if(nosegs) then
        if(parsno) {
//       last parse was a success
          if(segnumed == nosegs) go to 802
          segspan=1;
		}
        else {

//       last parse was a failure

          if(segnumed < nosegs) {
            segnumed=segnumst-1;
            segspan++;
		}
          else {
            if(segnumst==1) go to 802
            segnumed=segnumst-2 ;
            segspan++;
          }
        }
        go to 600
      end if
// *                                  3. else get for next input line
#endif
	}// while(numSentParse>0)
/*
// if this is a dose run close and delete the stream for reading the files
if(parseType == DOSE_TYPE){
doseout.close();
}
*/
	return;
	}
#if 0
 9997 continue
      SENTE1(segend+1)=sentesav[1];
      SENTE2(segend+1)=sentesav[2];
// *     SENTE3(segend+1)=sentesav(3)
      SENTE4(segend+1)=sentesav[4];
      SENTE5(segend+1)=sentesav[5];
      SENTE6(segend+1)=sentesav[6];

      if(parstat.gt.0) then
        if(parstat == 1) then
          if(segnumed >= nosegs) go to 617
          segnumed=segnumst-1;
        elseif(parstat == 2) then
          if(segnumst==1) go to 617
          segnumed=segnumst-2;
          segspan++;
        endif
      go to 600

//   error return
      elseif(parstat.lt.0) then
        if(parstat==-1) then
//                      print message if line limit was exceeded
          errmgp(5,0,0,0);
        elseif(parstat==-2) then
//                      print message if node limit was exceeded
          errmgp(6,0,0,0);
        endif
      endif

	*coutP<<"\nCurrent parse tree"<<endl;
	ptree();
	if(parsno==0) GO TO 720
	par=FALSE;
	LEXERR=TRUE
      GO TO 622

 9998 LEXERR=TRUE;
      GO TO 617

 9999 RETURN
      END
#endif

// ------------------------------------------------------------------------

void treeTransCtl(int num_trees){
	int ltree,trresult,readTreeRet;

	linz=linlim;
	for(;;){
	freesg(0);
	nodeInit();
	if((readTreeRet=rdpars())<=0){// tree reading error
int ftrfg=0;
if(ftrfg){
ltree=treeToList(TRUE);
plist(ltree,FALSE,treflo);
treeDraw(1,5);
exitr(0, "debug");
}
//	treeSkip(); // skip to next tree
break;
		}
	wordDefsEnd(); // note end of sentence word definitions
//int      countfre=freect;
		printSent(wordstart,wordend,0,2); // print sent
	int ljret;

	if((ljret = setjmp(longjumpbuf)) != 0){ // set long jump return
	if(ljret == LJR_MAXNODES){
		errmgp(6,0,0,0); // print message if node limit was exceeded
		continue;
		}//if
	if(ljret == LJR_OUTNODESPACE){
	*coutP<<"No more nodes"<<endl;
		continue;
		}
	if(ljret == LJR_TRANSSTACKOVER){
		*coutP<<"\ntransformation stack overflow return"<<endl;
		continue;
		}
*coutP<<" oogles or overflow return"<<endl;
		continue;
		}//long jump error
		trresult=xform('T',1);
		if(trresult<0) {
			*coutP<<"\nbad xform"<<endl;
			continue;
			}
		prntif();
		if(linz <0) {
        		errmgp(7,0,0,0);
        		exitr(22, " Line Limit");
			}

// if success write the list representation of the tree

		if(trresult){
			if(treout>0){
				if(treout==trenwf) ltree=treeToList(FALSE);
				else ltree=treeToList(TRUE);

// print sent on treflo with leading * and blank
				printSent(wordstart,wordend,2,treflo);
				setrtmargin(treflo,72);
				plist(ltree,FALSE,treflo);
        			}//if
        		}//if
        	}//for on trees
	resetFillUnit();
	return ;
}//func end

void clearInterpBufs(void);
void longJumpErr(int ljerrflg){
longjpret=ljerrflg;
	clearInterpBufs(); //return buffers acquired in interp
	longjmp(longjumpbuf,longjpret);
}

// ---------------------------------------------------------------------
void timer(int sigtype){
longJumpErr(LJR_MAXTIME);
return ;
}
