/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
/*
***********************************************************************
     GETNOD allocates space for a node of the parse tree.  NS is set to
     the index of the structure of the allocated block.  All words in
     the block are set to 0.  If no space is available a long jump is
     made to the parser control routine.
     GETNOD also  does a long jump if the number oof nodes which has
     been allocated during the parse/transformation is exceeded.
     (if NODZ is negative after being decremented).

     The space which has been freed by detaching nodes from the parse
     tree is used first.  The variable PREV points to the most recently
     freed node;  NDHDBA(.) of that node (i.e., NDHDBA(PREV) ) points
     to the next available block , and so forth, forming a linked
     list, until NDHDBA(.) of the last block contains 0.
***********************************************************************
*/

#include <setjmp.h>
#include <iostream.h>
#include <fstream.h>
static const int NODEARRSIZE=20000;
#include "nodefs.fcm"
#include "common.fcm"
#include "lispdefs.fcm"
#include "returncodes.h"

extern void longJumpErr(int);
extern void exitr(const char *);

static int prev,nodeOutPtr=0;
static int nodesInRet, nodz, nintre;
struct ndctlstr {struct nodestruc *arrBase; int
xr7; int outPtr; int inRet; int nodz; int nintre; int prev;};

//structures to save current and previous node space control values
struct ndctlstr nodeControlCurr;
struct ndctlstr nodeControlPrev;
static int treeflag=0, nodeSpaceFlag=0;;

int whichNodeSpace(){
	return nodeSpaceFlag;
}

void nodeInit(){
	nodeOutPtr = 0;
	nodesInRet = 0;
	nodz = nodlim;
	nintre = 0;
	prev = 0;
	nodeSpaceFlag=0;
	return;
}

/* this function gets node space from the heap to build a tree from an
outputted previous tree
*/

#define PREVTREENODESPACESIZE 1000
void getPrevNodeSpace() {
	node = new struct nodestruc[PREVTREENODESPACESIZE];
	nodeInit();
	treeflag=1;
	return;
}

static void saveCurrTreeParams(){
	nodeControlCurr.arrBase = node;
	nodeControlCurr.xr7= xr7;
	nodeControlCurr.outPtr = nodeOutPtr;
	nodeControlCurr.inRet = nodesInRet;
	nodeControlCurr.nodz = nodz;
	nodeControlCurr.nintre = nintre;
	nodeControlCurr.prev = prev;
	return;
}

static void restoreCurrTreeParams(){
	node = nodeControlCurr.arrBase;
	xr7 = nodeControlCurr.xr7;
	nodeOutPtr = nodeControlCurr.outPtr;
	nodesInRet = nodeControlPrev.inRet;
	nodz = nodeControlPrev.nodz;
	nintre = nodeControlPrev.nintre;
	prev = nodeControlPrev.prev;
	nodeSpaceFlag=0;
	return;
}

static void savePrevTreeParams(){
	nodeControlPrev.arrBase = node;
	nodeControlPrev.xr7= xr7;
	nodeControlPrev.outPtr = nodeOutPtr;
	nodeControlPrev.inRet = nodesInRet;
	nodeControlPrev.nodz = nodz;
	nodeControlPrev.nintre = nintre;
	nodeControlPrev.prev = prev;
	return;
}

static void restorePrevTreeParams(){
	node = nodeControlPrev.arrBase;
	xr7 = nodeControlPrev.xr7;
	nodeOutPtr = nodeControlPrev.outPtr;
	nodesInRet = nodeControlPrev.inRet;
	nodz = nodeControlPrev.nodz;
	nintre = nodeControlPrev.nintre;
	prev = nodeControlPrev.prev;
	nodeSpaceFlag=1;
	return;
}

/* This routine saves the current node space parameters and switiches
to the previous node space ones. If this is the first call ie there is
no previous tree node space it get this space and initializes it.
*/
void switchPrevTreeParams(){
	if(nodeSpaceFlag == 1)return;// in previous tree node space
	saveCurrTreeParams();
	if(nodeControlPrev.arrBase == 0){//first call no previous
		getPrevNodeSpace();
		nodeSpaceFlag=1;
		}
	else restorePrevTreeParams();
	return;
}

void switchCurrTreeParams(){
	if(nodeSpaceFlag == 0)return;
	savePrevTreeParams();
	restoreCurrTreeParams();
	return;
}

void restoreNodeSpace(){
	delete node;
	restoreCurrTreeParams();
	treeflag=0;
	return;
}

void clearNDGCPS(void){
	for(int i=0; i<=nodeOutPtr;i++) NDGCPS(i)=0;
	return;
}

int nodesInTree(void){
	return nintre;
}

int nodesRequested(void){
	return nodlim-nodz;
}

int getnod(void){
	int ns;
	if(--nodz<0) {// max nodes requested limit exceeded
		longJumpErr(LJR_MAXNODES);
		}
	nintre++;
#if 0
	if(nodeOutPtr < (NODEARRSIZE-1)) { ns = ++nodeOutPtr;}
	else {
		ns=prev;
if(ns==0){
cerr<<"no more nodes"<<endl;
		longJumpErr(OUTNODESPACE);
		}
		prev=NDHDBA(prev);
		nodesInRet-- ;
		}
#endif
// #if 0

	if((ns=prev) != 0){
		prev=NDHDBA(prev);
		nodesInRet-- ;
		}//if
	else {
		if((ns=++nodeOutPtr) > (NODEARRSIZE-1)) 
		longJumpErr(LJR_OUTNODESPACE);
		} //else

// #endif
//    set all the items in the node to zero
	NDUPLF(ns)=0;
	NDOPES(ns)=0;
	NDBALP(ns)=0;
	NDRTPT(ns)=0;
	NDWPNC(ns)=0;
	NDWPCP(ns)=0;
	NDABTS(ns)=0;
	NDHDBA(ns)=0;
	NDGCPS(ns)=0;
	NDNODEATRIBLISTPOINTER(ns)=0;
	NDNODEATRIBREFPOINTER(ns)=0;
	NDNODEATRIBHOUSPOINTER(ns)=0;
	NDWKSP(ns)=0;
	return ns;
}
     
// ************************************************************************
//    FREENODE adds to the available space list the node is pointed to by NS.
// ************************************************************************

int outctxx=0;// **debug
void freenode(int ns){
/*
if(ns==72)cout<<ns<<" coming in"<<endl;// **debug**
if(ns==314){// **debug**
outctxx++;// **debug**
void printNA(int, const char*);// **debug**
char chbf[50];// **debug**
if(outctxx==242){// **debug**
printNA(60, chbf);// **debug**
}// **debug**
int scantree(int);// **debug
int there=scantree(ns);// **debug**
}// **debug**
*/

/*
{// **debug
struct NAstr *ppp= NDNODEATRIBLISTPOINTER(ns);// **debug
if(ppp!=0){// **debug
cout<<"\nin freenode: node="<<ns<<" ret with attrib ptr="<<ppp<<endl;// **debug
}// **debug
}// **debug
void printValNA(int);// **debug
{// **debug
struct NArefstr *ppp=NDNODEATRIBREFPOINTER(ns);// **debug
if(ppp!=0){// **debug
cout<<"\nin freenode: node="<<ns<<" ret with refer ptr="<<((void *) ppp)<<endl;// **debug
printValNA(ns);// **debug
}// **debug
}// **debug
{// **debug
struct NArefstr *ppp=NDNODEATRIBHOUSPOINTER(ns);// **debug
if(ppp!=0){// **debug
cout<<"\nin freenode: node="<<ns<<" ret with house ptr="<<((void *) ppp)<<endl;// **debug
printValNA(ns);// **debug
}// **debug
}// **debug
*/

void freeNAblocks(int);
freeNAblocks(ns);
	
	NDHDBA(ns)=prev;
	prev=ns;
	NDSPFB(ns)=0;
	nintre--;
	nodesInRet++ ;
	return;
	}

/*
************************************************************************
     MRKFRE and FRETRE function together to free all nodes in a parse
     subtree.  MRKFRE marks node frtp and all nodes below frtp in the
     parse tree for freeing.  Each Node is marked by zeroing NDSPFB oF
     the node;  in addition, all nodes to be freed are chained, with
     links in NDUPLF of the node and variable TOFREE pointing to the
     head of the chain.  MRKFRE scans the tree in a bottom-up, right-
     to-left sequence.  FRETRE frees all nodes marked by MRKFRE.
*********************************************************************
*/

extern int upone(), dnrit(), left1();
void fretre(int frtp){

	int tofree=frtp;
	while(tofree){
		int n=tofree;
		tofree=NDUPLF(tofree);
		freenode(n);
		}//while
	return;
}

//---------------------------------------------------------------------

void mrkfre(int ixr7){
	int tofree=0;
	int lxr7;
	xr7=ixr7;
	while(1){
	while(dnrit());
//                         if at starting node, done
		while(1){
			if(xr7 == ixr7) { //finally free root node
				NDSPFB(ixr7)=0;
{// **debug
struct NAstr *pp1=NDNODEATRIBLISTPOINTER(ixr7);// **debug
if(pp1!=0){// **debug
*coutP<<"\nin mrkfre: node="<<ixr7<<" ret with attrib ptr="<<((void *) pp1)<<endl;// **debug
}// **debug
struct NArefstr *pp2=NDNODEATRIBREFPOINTER(ixr7);// **debug
if(pp2!=0){// **debug
*coutP<<"\nin mrkfre: node="<<lxr7<<" ret with refer ptr="<<((void *) pp2)<<endl;// **debug
}// **debug
struct NArefstr *pp3=NDNODEATRIBHOUSPOINTER(ixr7);// **debug
if(pp3!=0){// **debug
*coutP<<"\nin mrkfre: node="<<ixr7<<" ret with house ptr="<<((void *) pp3)<<endl;// **debug
}// **debug
}// **debug
				NDUPLF(ixr7)=tofree;
				return;
				}
			lxr7=xr7;
			if(left1()) break;
			upone();
			NDSPFB(lxr7)=0;
//cout<<"mrkfre: freeing "<<lxr7<<endl;// **debug

/*
{
struct NAstr *pp1=NDNODEATRIBLISTPOINTER(lxr7);
if(pp1!=0){
cout<<"\nin mrkfre: node="<<lxr7<<" ret with attrib ptr="<<((void *) pp1)<<endl;
}
struct NArefstr *pp2=NDNODEATRIBREFPOINTER(lxr7);
if(pp2!=0){
cout<<"\nin mrkfre: node="<<lxr7<<" ret with refer ptr="<<((void *) pp2)<<endl;
}
struct NArefstr *pp3=NDNODEATRIBHOUSPOINTER(lxr7);
if(pp3!=0){
cout<<"\nin mrkfre: node="<<lxr7<<" ret with house ptr="<<((void *) pp3)<<endl;
}
}
*/
			NDUPLF(lxr7)=tofree;
			tofree=lxr7;
			}//while
			NDSPFB(lxr7)=0;
//cout<<"mrkfre: freeing "<<lxr7<<endl;// **debug
/*
{
struct NAstr *pp1=NDNODEATRIBLISTPOINTER(lxr7);
if(pp1!=0){
cout<<"\nin mrkfre: node="<<lxr7<<" ret with attrib ptr="<<((void *) pp1)<<endl;
}
NArefstr *pp2=NDNODEATRIBREFPOINTER(lxr7);
if(pp2!=0){
cout<<"\nin mrkfre: node="<<lxr7<<" ret with refer ptr="<<((void *) pp2)<<endl;
}
NArefstr *pp3=NDNODEATRIBHOUSPOINTER(lxr7);
if(pp3!=0){
cout<<"\nin mrkfre: node="<<lxr7<<" ret with house ptr="<<((void *) pp3)<<endl;
}
}
*/
		NDUPLF(lxr7)=tofree;
		tofree=lxr7;
		}//while
}

//--------------------------------------------------------------

int scantree(int nodeofint){
char* nodnam(int, char*);
	char nambuf[50];
	int upxr7=0, s;
int sx=xr7;
	char * nameP, *namubvP;
	while(1) {
if(xr7==nodeofint){
		nameP=nodnam(xr7, nambuf); //get name of present node
		namubvP=nodnam(upxr7, nambuf); //get name of present node
//cerr<<"nodnam nameP " <<nameP<<endl;// **debug
*coutP<<"XXX node "<<xr7<<" found. Node above is "<<upxr7<<endl;
*coutP<<"name is "<<nameP<<" above is "<<namubvP<<endl;
xr7=sx;
return upxr7;
}

int down(void), oright(void), oupone(void);
	upxr7=xr7;
	if(down()) continue;

	do {
		if(s = oright()) break;
		} while(s=oupone());

	if(!s) break;
	} // while
	xr7=sx;
return 0;
}// func end
