/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
/*
 ***********************************************************************
      Assigns a node attribute
    
         nodass   = Node being assigned attribute
         attrb  = attribute being assigned
         valu    = value being assigned
         nodhous = node where restriction doing assignment was housed
         ilist  = 0 if valu points to a node (or if valu = 0, indicating
                  no value, or valu= -1, indicating erasure).
                  1 if valu points to a list element.
         wflag  = TRUE if wellformedness restriction
 -----------------------------------------------------------------------

Node attribute information is stored in chained blocks of memory which are
gotten from the heap with the -new- request.
Each node has three pointers which contain the address of the last block
allocated. The first set of blocks have the actual NA information.

         1. The NA name
         2. Its value if any may be a node or a list
         3. A flag to tell which type the value is if any
         4. The node on which the the restric/trans was housed which
            assigned this node attribute.
         5, A flag which indicated whether this NA came from a disqualify
            or a wellformedness restriction. NA from transformations
            are marked as being wellformedness ones.

The second set of chained blocks gives information about those NAs which
have this node as its value. The infomation recorded in this set of blocks
is the node where the NA is and its name.

The third set of blocks contains information on those NAs which were
assigned by restric/transf housed on this node. This information is needed
in the back-up process in parsing. If transformations is done in a separate
run there is no information for those NAs assigned by previous tree
building and transformation runs.

Each block contains a pointer to the previous block and the number of
entries in the block as well as the maximum number of entries allowed in
the block.

If the value of a NA is -1 this means the NA with this name is erased. Thus
a query as to the existance of this NA will be answered negatively. However
the NA is still there. A backup which deletes NAs belonging to a none could
delete the "erased node" and thus make the NA with the same name as that
of the "erased node" availible.
This situation is brought into being by the ERASE operator during
parsing. During transformation the ERASE operator actually deletes the
NA since the is no backing up operation which could "unerase" an erasure.
*/
    
//         * This information is used by DELNA in deleting node attributes
//       during parser back-up.

//        ** This value is assigned by the erase node attribute operation.
//       Erasure cannot be effected by removing the node attribute, since
// *      IT WILL BE NECESSARY TO UNDO THE ERASURE DURING PARSER BACK-UP.
// *      INSTEAD, A SECOND BLOCK WITH THE SAME NODE AND ATTRIBUTE
// *      POINTERS AND VALUE -1 IS ADDED TO THE LIST.
// * ***********************************************************************


extern char* restrnamP;
static const int NAblksiz=8;
static const int NArefblksiz=8;
struct NAitemstr {int attrb; int value; char valtype; char DorW; int nodeHous;};
struct NAstr {char count; char max; struct NAstr *extension;
	struct NAitemstr NAitem[NAblksiz];};
struct NArefitstr {int node; int attrb;};
struct NArefstr {char count; char max; struct NArefstr *extension;
	struct NArefitstr NArefit[NArefblksiz];};
struct NAsetstr{int attrb; int value; short valtype; int hous;};
#include <iostream.h>
#include <fstream.h>
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#include "symtab.h"
#define TRUE 1
#define FALSE 0

void printNA(int, const char *);// **debug*
void printValNA(int);// **debug**
extern SymbTable sytab;
extern int getnod(void);
extern int nodattf(int, int, int, int, int, int);
static struct NAitemstr * nodeAttAssigned(int nodref, int attrb);
extern char *nodnam(int, char *);
void delNAlist(int);
int getNAfornode(int, struct NAsetstr *, int);
static int samecnt=0;// **debug

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int whchsen; // **debug
int asgnat(int nodass,int attrb, int valu, int ilist, int nodhous,int wflag){
#if 0
if(nodhous==108){// **debug
cout<<"in asgnat: nodass="<<nodass<<" attrb="<<STNAME(CAR(attrb))<<" valu="<<valu<<" Hous="<<nodhous<<endl;// **debug
void printHousNA(int, const char *);// **debug
printHousNA(nodhous, "before asgnat");// **debug
}
}// **debug
if(whchsen==0 && nodass==94){ // **debug
*coutP<<"in asgnat: nodass="<<nodass<<" attrb="<<STNAME(CAR(attrb))<<" valu="<<valu<<endl;// **debug
}
	struct NAitemstr *allAss =  nodeAttAssigned(nodass, attrb);//
**debug
//if one is already there see if the new assignment is the same as the old
	if(allAss){// **debug
		if((allAss->valtype == ilist) && (allAss->value ==valu))//*debug
{
char bbuf[40];// **debug
*coutP<<"identical attribute being assigned for node, "<< nodnam(nodass,bbuf)<<endl;// **debug
samecnt++;// **debug
return TRUE;//new NA same as old
}
		}
#endif
	return nodattf(nodass, attrb, valu, ilist, nodhous, wflag);
}
      
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//        entry for erasing a Node

int removeNA(int, int, int, int, int, int);
int removeNAref(int, int, int, int);
int eraseNodeAtt(int nd, int attrb, int nodhous, int wflag){
	if(extyp==RDPAR){
		if(removeNA(nd, attrb, 0, 1, 1, 0)>0){
			return TRUE;
			}
		else return FALSE;
		}//if

	return  nodattf(nd, attrb, -1, 0, nodhous, wflag);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void addToNodeRefList(int nodref, int ndNA, int attrb, int type){
	struct NArefstr *napt, *napts, **addp;
	if(type)addp = &(NDNODEATRIBREFPOINTER(nodref));
	else addp = &(NDNODEATRIBHOUSPOINTER(nodref));

	if((napt= *addp) ==0){// no blocks
		napt= *addp = new struct NArefstr;
		napt->count = 0;
		napt->max = NArefblksiz;
		napt->extension = 0;
		}//if

	else { //  blocks exist
		if(napt->count >= napt->max){ //is it full
			napts = *addp =  new struct NArefstr;
			napts->count = 0;
			napts->max = NArefblksiz;
			napts->extension = napt;
			napt = napts;
			}//if
		}//else

		int nps = (napt->count);
		(napt->NArefit[nps]).node = ndNA;
		(napt->NArefit[nps]).attrb = attrb;
		(napt->count)++;

	return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void printDuplicateWarning(int ndass, int attrb, int value, int valtyp, int hous){
char nambuf[20];
*coutP<<"\nA duplicate node attribute "<<(STNAME(CAR(attrb)))
<<" is being assigned on node="<<nodnam(ndass,nambuf)<<'('<<ndass<<')'<<endl;
*coutP<<"by the restriction "<<restrnamP;
if(value == -1)*coutP<<". Both are erasures";
else {//not an erase
*coutP<<". Both have same value ";
if(!valtyp){
if(!value)*coutP<<"which is zero"<<endl;
else *coutP<<"a node="<< nodnam(value,nambuf)<<endl;
}
else *coutP<<"a list"<<endl;
}//else
if(hous!=0)
*coutP<<"The previous one was assigned by a restriction housed on node "<<
nodnam(hous,nambuf)<<endl;
return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int nodattf(int ndass, int attrb, int value, int valtype, int nodhous, int wflag){
	int  cnt;
	int oval, otyp;
	struct NAstr *napt, *napts;
/*
{// **debug
if(ndass==52){// **debug**
if(restrnamP!=0)
cout<<"in restr "<<restrnamP<<endl;
cout<<"\n*DB*before assigning on node="<<ndass<<" att="<<attrb<<" val="<<value<<" valtype="<<valtype<<endl;// **debug**
printNA(ndass, "At assign: ");// **debug**
}// **debug
}// **debug
*/
	if((napt=NDNODEATRIBLISTPOINTER(ndass)) == 0){
		napt=NDNODEATRIBLISTPOINTER(ndass) = new struct NAstr;
		napt->count = 0;
		napt->max=NAblksiz;
		napt->extension = 0;
		}//if
	else { //blocks exist
//	check if NA is already there
	while(napt){//loop over blocks
		cnt=napt->count;
		for(cnt--; cnt>=0; cnt--){
			if(attrb != (napt->NAitem[cnt]).attrb)continue;
//		there is an item with same attribute
			oval=(napt->NAitem[cnt]).value;
			if(oval == -1){
				if(value != -1){napt=0; break;}//not a dup
				}

			else{
			if(value == -1){napt=0; break;}
				otyp=(napt->NAitem[cnt]).valtype;
//first determine if this is an exact duplicate or a change in value
		if((value==oval) && (valtype==otyp)){
//an exact duplicate, print warning and return
//			int ohous=(napt->NAitem[cnt]).nodeHous;
//			printDuplicateWarning(ndass, attrb, value, valtype, ohous);
			return TRUE;
			}//if

//		a change in value
				(napt->NAitem[cnt]).value = value;
				(napt->NAitem[cnt]).valtype = valtype;
				(napt->NAitem[cnt]).nodeHous = nodhous;

//if a node value adjust the reference information
		if(oval && value && !otyp && !valtype){
			removeNAref(oval,ndass,attrb,0);
			addToNodeRefList(value,ndass,attrb,1);
			}//if
				return TRUE;

				}//else
			}//for
			if(napt==0)break;
			napt = napt->extension;
		}// while
// add NA to node
	napt=NDNODEATRIBLISTPOINTER(ndass);
		if(napt->count >= napt->max){ //block is full; get another
			napts = NDNODEATRIBLISTPOINTER(ndass) =  new struct NAstr;
			napts->count = 0;
			napts->max=NAblksiz;
			napts->extension = napt; //back pointer
			napt = napts;
			}//if
		}//else

		int nps = napt->count++;
		(napt->NAitem[nps]).attrb = attrb;
		(napt->NAitem[nps]).value = value;
		(napt->NAitem[nps]).valtype = valtype;
		(napt->NAitem[nps]).DorW = wflag;
		(napt->NAitem[nps]).nodeHous = nodhous;

// now we need to add this node to the list of references on any
//referenced by the NA if the value is a node
		if((valtype == 0)&&value)  addToNodeRefList(value, ndass, attrb, 1);
		if(nodhous != 0) addToNodeRefList(nodhous, ndass, attrb, 0);
extern int copyListToNAlist(int);
if(valtype ==1 && value!=-1){
int nodNA=ndass;// **debug
//jval= copyListToNAlist(jval);
}
	if(nodhous) NDABTS(nodhous) |= EABIT;

/*
{// **debug
if(ndass==52){// **debug**
cout<<"\n*DB*after assigning on node="<<ndass<<" val="<<value<<" valtype="<<valtype<<endl;// **debug**
printNA(ndass, "At assign: ");// **debug**
}// **debug**
}// **debug
*/

	return TRUE;
}
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

static struct NAitemstr * nodeAttAssigned(int nodref, int attrb){
	struct NAstr *napt;
	int ndNA;
	if((napt=NDNODEATRIBLISTPOINTER(nodref))==0)return FALSE;
	while(napt){//loop through the blocks
		int nctb = napt->count;
		for(int nct=nctb-1;nct>=0;nct--){
			if((napt->NAitem[nct]).attrb == attrb){
				if((napt->NAitem[nct]).value == -1) return FALSE;
				return &(napt->NAitem[nct]);
				}//if
			}//for
		napt = napt->extension;
		}//while
	return FALSE;

}

#if 0
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int NAlistCnt(){

	int lpp, cnt=0, lkk;
	lpp=nodatl;
	while((lpp=NAFLBL(lpp))){

		if(NANDLS(lpp) != 1) continue;
		if((lkk=NAVALA(lpp)) <= 0)continue;
		while(lkk){
		if(ATOMP(lkk) !=0)cnt++;
		else cnt += 2;
		lkk=CDR(lkk);
		}
		}//while
	return cnt;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

extern int retar[],retnxx;
int NAinOutList(){

	int lpp, cnt=0, iu, lkk, as,unc=0;
	lpp=nodatl;
	while((lpp=NAFLBL(lpp))){

		if(NANDLS(lpp) != 1) continue;
		if((lkk=NAVALA(lpp)) <= 0)continue;
		while(lkk){
		if(ATOMP(lkk) !=0){
			cnt++;
			for(iu=0;iu<retnxx;iu++){
				if(retar[iu]==lkk){
					retar[iu]= -retar[iu];
					break;}
				}//for
			if(iu==retnxx)
			*coutP<<"in NA set not on NAout list "<<lkk<<endl;
			}//if
		else {
			cnt += 2;
			for(iu=0;iu<retnxx;iu++){
				if(retar[iu]==lkk){
					retar[iu]= -retar[iu];
					break;}
				}//for
			if(iu==retnxx)
			*coutP<<"in NA set not on NAout list "<<lkk<<endl;
			as=CAR(lkk);
			for(iu=0;iu<retnxx;iu++){
				if(retar[iu]==as){
					retar[iu]= -retar[iu];
					break;}
				}
			if(iu==retnxx)
			*coutP<<"in NA set not on NAout list "<<as<<endl;
			}//else
		lkk=CDR(lkk);
		}//while
		}//while
int nnc=0;
for(iu=0;iu<retnxx;iu++) if(retar[iu]!=0)nnc++;
*coutP<<"in NA list "<<cnt<<"   In out list "<<nnc<<endl;
*coutP<<"In out list not in NA list"<<endl;
nnc=0;
for(iu=0;iu<retnxx;iu++){
if(retar[iu]==0)continue;
if(retar[iu]<0)
retar[iu]= -retar[iu];
else {
if( (++nnc %13)==0)*coutP<<endl;
*coutP<< retar[iu]<<' ';
}
if(nnc>200)break;
}//for
*coutP<<endl;
	return cnt;
}
#endif

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
/*
*********************************************************************
     Retrieves a Node attribute

     Input arguments:
        nodref = Node whose attribute is being referenced
        attrb  = attribute being referenced

     Output arguments:
        valu  = value associated with the attribute
              = -1 if the attribute is not assigned to this node
        ilist = 0 if valu points to a node in the parse tree
              = 1 if valu points to a list element
***********************************************************************
*/

int nodeat(int nodref, int attrb, int* valu, int* ilist){
	struct NAstr *napt;
//printNA(nodref, "At retrieve: ");// **debug**

	napt = NDNODEATRIBLISTPOINTER(nodref);
	while(napt != 0){
		int ncti = napt->count; 
		for(int nct=ncti-1;nct>=0;nct--){
			if((napt->NAitem[nct]).attrb != attrb)continue;
			if((napt->NAitem[nct]).value == -1){
				*valu=-1; *ilist=0;
				return FALSE;
				}
			*valu = (napt->NAitem[nct]).value;
			*ilist = (napt->NAitem[nct]).valtype;
			return TRUE;
			}//for
			napt= napt->extension;

		} // while
	*valu=-1; *ilist=0;
	return FALSE;
} //func

       
extern void frenod(int);
/*
if replval = zero
removeNA deletes all node attributes on a given node which has a given attrb
else it replaces the value of that NA with repval
*/
int removeNA(int ndrmv, int attrb, int val, int DorW, int remref, int replval){
	struct NAstr *napt, *napts, *naprev=0;
	int attNA, numDel=0;
	if((napt=NDNODEATRIBLISTPOINTER(ndrmv))==0)return -1;
	while(napt){//loop through the blocks
		int nctb = napt->count;
		for(int nct=nctb-1;nct>=0;nct--){
			if((attNA=(napt->NAitem[nct]).attrb) == 0){
continue;
}
			if((napt->NAitem[nct]).attrb != attrb)continue;
if(val != 0 && (napt->NAitem[nct].valtype==0)){
if(val != napt->NAitem[nct].value)continue;
}
			if((napt->NAitem[nct]).DorW != -1){
				if((napt->NAitem[nct]).DorW != DorW)continue;
				}
if(replval != 0 && (napt->NAitem[nct].valtype == 0)){
	int oval = (napt->NAitem[nct]).value;
	(napt->NAitem[nct]).value = replval;
	addToNodeRefList(replval, ndrmv, attrb, 1);
	removeNAref(oval, ndrmv, attNA, 0);
	numDel++;
	continue;
}
//if caller requested reference deletion and the NA value was != 0 and
// was a node then remove the reference
	if(remref){
	if((napt->NAitem[nct]).value){// NA has a value
	if((napt->NAitem[nct]).valtype == 0) //value is a node
		removeNAref((napt->NAitem[nct]).value, ndrmv, attNA, 0);
	}//if
	}//if
			(napt->NAitem[nct]).attrb = 0;
			numDel++;
			nctb--;
			}//for

		napts = napt->extension;
		if(nctb == 0){//this block is empty
			if(NDNODEATRIBLISTPOINTER(ndrmv) == napt) //first block
				NDNODEATRIBLISTPOINTER(ndrmv) = napts;
			else naprev->extension = napts;

			delete napt;
			napt=0;
			}//if empty block

		else {//block not empty close up if deletions
			if(nctb<napt->count){//close up
				int nctx = napt->count;
				int ia, ib;
				for(ia=0,ib=0;ia<nctx;ia++){
					if((napt->NAitem[ia]).attrb == 0)continue;
					napt->NAitem[ib++] = napt->NAitem[ia];
					}//for
				napt->count = nctb;
				}//if
			}//else
		naprev = napt;
		napt = napts;
		}//while
	return numDel;
}
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int removeNAref(int ndref, int ndrmv, int attrb, int replNode){
	struct NArefstr *napt, *napts, *naprev=0;
	int attNA, numDel=0;
	if((napt=NDNODEATRIBREFPOINTER(ndref))==0)return -1;
	while(napt){//loop through the blocks
		int nctb = napt->count;
		for(int nct=nctb-1;nct>=0;nct--){
			if((napt->NArefit[nct]).node == 0)continue;
			if((napt->NArefit[nct]).node != ndrmv)continue;
			if((napt->NArefit[nct]).attrb != attrb)continue;
if(replNode != 0){
			(napt->NArefit[nct]).node = replNode;
			return 1;
}
			(napt->NArefit[nct]).node = 0;
			numDel++;
			nctb--;
			}//for

		napts = napt->extension;
		if(nctb == 0){//this block is empty
			if(NDNODEATRIBREFPOINTER(ndref) == napt) //first block
				NDNODEATRIBREFPOINTER(ndref) = napts;
			else naprev->extension = napts;

			delete napt;
			napt=0;
			}//if empty block

		else {// block not empty close up if deletions
			if(nctb<napt->count){//close up
				int nctx = napt->count;
				int ia, ib;
				for(ia=0,ib=0;ia<nctx;ia++){
					if((napt->NArefit[ia]).node == 0)continue;
					napt->NArefit[ib++] = napt->NArefit[ia];
					}//for
				napt->count = nctb;
				}//if
			}//else
		naprev = napt;
		napt = napts;
		}//while
	return numDel;
}

//--------------------------------------------------------------------------

void printHousNA(int ndref, const char* text){
	struct NArefstr *napt, *napts, *naprev;
	int ndNA;
*coutP<<text<<" NA's housed on "<<ndref<<endl;
	if((napt=NDNODEATRIBHOUSPOINTER(ndref))==0){
*coutP<<"no NA's housed on "<<ndref<<endl;
return;
}
	while(napt){//loop through the blocks
		int nctb = napt->count;
		for(int nct=nctb-1;nct>=0;nct--){
	*coutP<<"node="<<(napt->NArefit[nct]).node
<<" attrb="<<(napt->NArefit[nct]).attrb<<endl;
			}//for

			napt = napt->extension;
		}//while
	return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

/*
***********************************************************************
     DELNA deletes all attributes assigned by restrictions on a given
     node
        ndr = Node where restriction doing assignment was housed
        wflag = TRUE for wellformedness restrictions
     It is invoked by the PARSER backup.
***********************************************************************
*/
void delna(int ndref, int wflag){
	struct NArefstr *napt, *napts, *housp, *naprev=0;
// go through the list of NA which were assigned by restrictions on
// the node ndref and delete them if the type matched wflag

/*
if((strcmp(sentid,"ASTHMA1-59  001.01E.01.04")==0)&& (ndref==172)){// **debug
extern int outctxx;// **debug**
cout<<"outctxx="<<outctxx<<" wflag="<<wflag<<endl;// **debug**
printNA(94,"before delna");// **debug**
extern void printHousNA(int, const char *);// **debug
printHousNA(ndref, "before delna");// **debug
}// **debug

if((strcmp(sentid,"ASTHMA1-59  001.01E.01.04")==0)&& ndref==172){// **debug
cout<<"\nin delna: deleting node="<<ndref<<endl;// **debug
}// **debug
*/
	int ndNA;
	housp=NDNODEATRIBHOUSPOINTER(ndref);
	if((napt=housp)==0)return;//no NA housed
	while(napt){//loop through the blocks
		int nctb = napt->count;//count in block
		for(int nct=nctb-1;nct>=0;nct--){
			ndNA = (napt->NArefit[nct]).node;//where NA is
			if(removeNA(ndNA, (napt->NArefit[nct]).attrb, 0, wflag, 1, 0)>0){
				(napt->NArefit[nct]).node = 0;
				nctb--;
				}//if
			}//for

		napts = napt->extension;
		if(nctb == 0){//this block is empty
			if(NDNODEATRIBHOUSPOINTER(ndref) == napt) //first block
				NDNODEATRIBHOUSPOINTER(ndref) = napts;
			else naprev->extension = napts;
			
			delete napt;
			napt=0;
			}//if empty block

		else {// block not empty close up if deletions
			if(nctb<napt->count){//close up
				napt->count = nctb;
				int ia, ib;
				for(ia=0,ib=0;ia<nctb;ia++){
					if((napt->NArefit[ia]).node == 0)continue;
					napt->NArefit[ib++] = napt->NArefit[ia];
					}//for
				}//if
			}//else
			naprev = napt;
			napt = napts;
		}//while
	housp=NDNODEATRIBHOUSPOINTER(ndref);
	if(!housp)NDABTS(ndref) &= (~EABIT);

//if(ndref==165)printNA(60,"after delna");// **debug**
	return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

/*
		Update Node Attributes

After the tree has been adjusted it may be the case that a subtree has
been deleted. Thus it is necessary to delete all the NA's that are on
deleted nodes and those NA's which have a deleted node as value.
*/

/*
This function deletes (ie puts back on the heap) those
memory blocks which contain the NA information.
*/
void remvNAforDelNode(int nodedel){
// nodedel = the node being deleted
	struct NAstr *napt, *naprev;
	struct NArefstr *naptr, *naptsr, *naprevr;

//delete blocks which have the NA's for this node
	napt = NDNODEATRIBLISTPOINTER(nodedel);
	NDNODEATRIBLISTPOINTER(nodedel) = 0;
	while(napt){
		naprev = napt->extension;
		delete(napt);
		napt = naprev;
		}//while

//delete blocks which have the node which housed the
//restriction/transformation which assigned this node
	naptr = NDNODEATRIBHOUSPOINTER(nodedel);
	NDNODEATRIBHOUSPOINTER(nodedel) = 0;
	while(naptr){
		naprevr = naptr->extension;
		delete(naptr);
		naptr = naprevr;
		}//while

//delete blocks which has the nodes whose NA's have
//this node as its value
	naptr = NDNODEATRIBREFPOINTER(nodedel);
	NDNODEATRIBREFPOINTER(nodedel) = 0;
	while(naptr){
		naprevr = naptr->extension;
		delete(naptr);
		naptr = naprevr;
		}//while
	return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void printNAwarning(int dln, int ndwval, int attdl) {
char nbuf[50];
#if 0
cout<<"\n** in "<<restrnamP<<" The value(node) "<<nodnam(dln,nbuf)<<" of a NA on "
<<"node "<<nodnam(ndwval,nbuf)<<"\nwith attrb "<<STNAME(CAR(attdl))
<<" is being deleted and value node has not been copied"<<endl;
cout<<"This would result in a NA whose value (node) does not exist. "
<< "The NA is being deleted"<<endl;
#endif
if(attdl==0){*coutP<< "in warning: bad attdl"<<endl; return;}
if(ndwval==0){ *coutP<<"in warning: bad ndwval"<<endl; return;}
char * atnm = STNAME(CAR(attdl));
*coutP<<"\n** in "<<restrnamP<<" The value(node) "<<nodnam(dln,nbuf)<<'('<<dln
<<") of a NA on "
<<"node "<<nodnam(ndwval,nbuf)<<'('<<ndwval<<") with attrb "<<atnm
<<"\nis being deleted and value node has not been copied.";
*coutP<<"This would result in a NA whose value (node) does not exist. "
<< "The NA is being deleted"<<endl;
return;
}// func end

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

struct NArefsetstr{ int node; int attrb;};
int getsetvalnode(int, struct NArefsetstr*, int);

int fixupNodeAttributes(int delList){
/*
{
cout<<"start of fixup"<<endl;
for(int dln=delList; dln!=0; dln=NDUPLF(dln)){//loop through deleted nodes
cout<<"        - - - - - - - - - - - - - - - - -"<<endl;// ===debug===
char nnbb[30];// ===debug===
cout<<"\nNA's on node being deleted "<<dln<<"="<<nodnam(dln,nnbb)<<endl; //===debug===
printNA(dln, "Before removal of NA:");//  ===debug===
cout<<"list of nodes which have as value this node="<<dln<<endl;// ===debug===
printValNA(dln);// ===debug===
cout<<"copied value of deleted node="<<NDGCPS(dln)<<endl;// ===debug===
}//for
}
*/

/*
 we delete those NA's which have as value deleted
 we check whether the node the NA is on is deleted. In that case the
 NA will get deleted when the the deleted node is processed.
*/
/*
 adjust values of NA on non-deleted nodes which point to a node which
 is either deleted or deleted and copied
*/

//int ndnodes[100], ndnct=0;;// **debug
/*
First we look at all the nodes which have as value a node that is being
deleted. If the deleted node has been copied change the value to the copied
node. However if the deleted node has been copied more than once, then
output a message and fail the sentence.
*/
	struct NArefsetstr valar[50];
	struct NAsetstr naar[50];
	for(int dln=delList; dln!=0; dln=NDUPLF(dln)){//loop over deleted nodes
		int copiedNode=NDGCPS(dln);
		int nrefs;
// get list of node which have the deleted node as value
		if((nrefs=getsetvalnode(dln, valar, 50))== 0)continue;//no values
		for(int i=0; i<nrefs; i++){//loop over the value list
			int NAnode = valar[i].node;
			if(NDSPFB(NAnode) != 0){ //node with NA not deleted
			int rret = removeNA(NAnode, valar[i].attrb, dln,
				TRUE, FALSE, copiedNode);
if(rret <= 0)*coutP<<"nodeAtt: No remove NA's for node "<<NAnode<<endl;
//ndnodes[ndnct++]=NAnode;//  **debug
			}//if
			}//for
		}//for over deleted set


	for(int dln=delList; dln!=0; dln=NDUPLF(dln)){//loop over deleted nodes
//		int copiedNode = NDGCPS(dln);
//get list of NA's for this deleted node 
		int nnas;
		if((nnas=getNAfornode(dln, naar, 50))== 0)continue;
		for(int i=0; i<nnas; i++){//loop through set of NA's 
			int ndwval = naar[i].value;//node having NA with this node as value
			if(naar[i].valtype|| !ndwval) continue;//skip if no value or not a node
	 		if(NDSPFB(ndwval) == 0) continue;//value deleted
//	if ND node and value node are both deleted skip
//	 		int ndCopyVal = NDGCPS(ndwval);
//	 		if(ndCopyVal && copiedNode == 0) continue;

			int attdl = naar[i].attrb;//node node attribute
//if(!copiedNode)printNAwarning(dln, ndwval, attdl);
//int rret = removeNAref(ndwval, dln, attdl, copiedNode);
				int rret = removeNAref(ndwval, dln, attdl, 0);
if(rret == 0)*coutP<<"nodeAtt: No remove NA's for node "<<ndwval<<endl;
				continue;
//	 		if(ndCopyVal == 0 && copiedNode == 0) continue;
//	 		if(ndCopyVal != 0) removeNAref(ndwval, dln, attdl, copiedNode);
// **delete**			removeNA(dln, attdl, TRUE, FALSE, ndCopyVal);
//printNA(ndd, "Before removal of NA:");//  ===debug===

//printNA(ndd, "List of NAs after removal of NA of del value nodes: ");//  ===debug===
//if(nrv==0){
//cout<<"list of values not match NA list for value node="<<dln<<" for NA node="
//<<ndd<<" attrb="<<valar[i].attrb<<endl;
//}

//printNA(ndwval, "List of NAs after removal of NA of del value nodes: ");//  ===debug===
//if(nrv==0){
//cout<<"list of values not match NA list for value node="<<dl<<" for NA node="
//<<ndd<<" attrb="<<valar[i].attrb<<endl;
//}

			}//for over NA list for deletes node
		}//for over deleted node set
// else move NA buffers to the copied node.

	for(int dln=delList; dln!=0; dln=NDUPLF(dln)){//loop over deleted nodes
/*
if(NDGCPS(dln) != 0){ //node copied move NA lists
	NDNODEATRIBLISTPOINTER(NDGCPS(dln)) = NDNODEATRIBLISTPOINTER(dln);
	NDNODEATRIBLISTPOINTER(dln)=0;
	NDNODEATRIBREFPOINTER(NDGCPS(dln)) = NDNODEATRIBREFPOINTER(dln);
	NDNODEATRIBREFPOINTER(dln)=0;
printNA(NDGCPS(dl), "List of NAs of copied nodes: ");//  ===debug===
cout<<"after fixuplist of nodes having value this node="<<dl<<endl;// ===debug===
printValNA(dl);// ===debug===
	}//if
*/
// If node not copied return buffers
		void freeNAblocks(int);
		freeNAblocks(dln);
//		}//else
	}//for
/*
{
cout<<"after of fixup"<<endl;// **debug
char nnbb[30];// ===debug===
for(int dln=delList; dln!=0; dln=NDUPLF(dln)){//loop through deleted nodes
int copn=NDGCPS(dln);// **debug
if(!copn) continue;// **debug
cout<<"        - - - - - - - - - - - - - - - - -"<<endl;// ===debug===
cout<<"\nNA's on copied node "<<copn<<"="<<nodnam(copn,nnbb)<<endl; //===debug===
printNA(copn, "Before removal of NA:");//  ===debug===
cout<<"list of nodes which have as value this node="<<copn<<endl;// ===debug===
printValNA(copn);// ===debug===
}
for(int j=0;j<ndnct;j++){// **debug
int ndn=ndnodes[j];
cout<<"\nNA's on not deleted node "<<ndn<<"="<<nodnam(ndn,nnbb)<<endl; //===debug===
printNA(ndn, "Before removal of NA:");//  ===debug===
cout<<"list of nodes which have as value this node="<<ndn<<endl;// ===debug===
printValNA(ndn);// ===debug===
}//for
}
*/

	return 1;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int gotopointedto(int nodeval,int attrb){
	int max = 30;
	int ret = 0;
	struct NArefsetstr *array = new struct NArefsetstr[max];
	int numnod = getsetvalnode(nodeval, array, max);
	for(int i=numnod-1; i>= 0; i--){
		if(array[i].attrb == attrb){
			xr7=array[i].node; list=0;
			ret = 1;
			for(int j= i-1; j >= 0; j--) if(array[j].attrb == attrb)ret = -1;
			break;
			}//if
		}//for
	delete array;
	return ret;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void nodeAttInit(){
return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

//frees the blocks which contains the NA info on the Tree.
//The tree is traversed and all the allocated blocks free'd

void freeNAblocks(int nodearg){
	struct NAstr *napt, *npts;
	struct NArefstr *npt, *nptr;

	napt = NDNODEATRIBLISTPOINTER(nodearg);
	while(napt){
		npts = napt->extension;
		delete napt;
		napt = npts;
		}//while
	NDNODEATRIBLISTPOINTER(nodearg) = 0;

	npt = NDNODEATRIBREFPOINTER(nodearg);
	while(npt){
		nptr = npt->extension;
		delete npt;
		npt = nptr;
		}//while
	NDNODEATRIBREFPOINTER(nodearg) = 0;
	return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

/*
 This function returns in a simple structure the parameters of all the
 NA's on the node in the call parameter nodref. The values are returned
 in a structure provided by the caller. The return value is the number
 of NA's returned. If this number is negative then the buffer was too small
 to hold all the values.
*/

int getNAfornode(int nodref, struct NAsetstr *array, int max){
	struct NAstr *napt;
	int cnt=0;

	napt = NDNODEATRIBLISTPOINTER(nodref);
	while(napt != 0){
		int nct = napt->count; 
		for(nct--; nct>=0; nct--){
			if(cnt>= max){
				*coutP<<"buffer too small"<<endl;
				return -cnt;
				}
			array[cnt].attrb = (napt->NAitem[nct]).attrb;
			array[cnt].value = (napt->NAitem[nct]).value;
			array[cnt].hous = (napt->NAitem[nct]).nodeHous;
			array[cnt++].valtype = (napt->NAitem[nct]).valtype;
			}//for
		napt=napt->extension;
			}
	return cnt;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int getsetvalnode(int nodref, struct NArefsetstr *array, int max){
	struct NArefstr *napt;
	int cnt=0;

	napt = NDNODEATRIBREFPOINTER(nodref);
	while(napt != 0){
		int nct = napt->count; 
		for(nct--;nct>=0;nct--){
			array[cnt].node = (napt->NArefit[nct]).node;
			array[cnt++].attrb = (napt->NArefit[nct]).attrb;
			}//for
		napt=napt->extension;
			}
	return cnt;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int isNAfornode(int nodref){
	int retv;
	if(NDNODEATRIBLISTPOINTER(nodref) != 0){
		retv=1;
	if(NDNODEATRIBREFPOINTER(nodref) !=0)retv=3;
	}
	else{
	if(NDNODEATRIBREFPOINTER(nodref) !=0)retv=2;
	else retv=0;
	}
	return retv;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void prtnodsub(int, int);
void printValNA(int nodref){
int cnt;
char nb[30];
struct NArefsetstr array[30];
int max;
cnt=getsetvalnode(nodref, array, 30);
if(cnt==0){
*coutP<<"\n**DB* Node "<<nodref<<"  "<<nodnam(nodref,nb)<<" not a value of any NA"<<endl;
return;
}
*coutP<<"\n**DB* Node "<<nodref<<"  "<<nodnam(nodref,nb)<<" is value of:"<<endl;
for(int i=0;i<cnt;i++){
int nv=array[i].node;
int anam=array[i].attrb;
int avp;
if(ATOMP(anam)) avp=CAR(anam);
else avp=CAR(CAR(anam));
*coutP<<"**DB* NA node="<<nv<<" ";
prtnodsub(nv,0);
*coutP<<" attrib "<<anam<<" "<<STNAME(avp)<<endl;
}
return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void printNA(int nodref, const char* txt){
char nb[30];
if(NDSPFB(nodref)==0){
*coutP<<"\n**DB* node "<<nodref<<" is notin use"<<endl;
return;}
*coutP<<"\n**DB* "<<txt<<" NA's for node "<<nodref<<"  "<<nodnam(nodref,nb)<<endl;
struct NAsetstr array[30];
int max;
int cnt=getNAfornode(nodref, array, 30);
if(cnt==0){ *coutP<<"**DB* No NA's for this node"<<endl; return; }

for(int i=0;i<cnt;i++){
int anam=array[i].attrb;
int atn=CAR(anam);
int val=array[i].value;
int valtyp=array[i].valtype;
int hous=array[i].hous;
*coutP<<"**DB* Attrib "<<anam<<" "<<STNAME(atn)<<", value="<<val;
if(val==0){*coutP<<endl;continue;}
if(val==-1){*coutP<<" ereased NA"<<endl;continue;}
if(valtyp==0){
if(NDSPFB(val)==0){
*coutP<<"the value node="<<val<<" appears to have been deleted"<<endl;
}
else {
*coutP<<" val node=";
prtnodsub(val,valtyp);
*coutP<<endl;
printValNA(val);
}
}
else {
//value is a list
void plist(int,int,int);
*coutP<<' ';
plist(val,0,2);
}
if(hous!=0){
char nambf[30];
extern char *nodnam(int,char*);
*coutP<<" Hous="<<hous<<" "<<nodnam(hous,nambf);
}
*coutP<<endl;
}
return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

struct cpnstr{int orig; int copy;};
void copyNAs(struct cpnstr * cpnodes, int cpnct){
	int org,cpy, nact;
	struct NAsetstr NAlist[50];
	struct NArefsetstr NArefs[20];
	for(int i=0;i<cpnct;i++){
		org = cpnodes[i].orig;
		cpy = cpnodes[i].copy;
	// get list of NAs for this node
		nact=getNAfornode(org, NAlist, 50);
		if(nact == 0)continue;
		for(int j=0; j<nact; j++){
			int val=NAlist[j].value;
			int valtyp = NAlist[j].valtype;
			if(valtyp==0 && val>0){ //an NA with a node for a value
			for(int k=0;k<cpnct;k++){//is the value a copied node
			if(cpnodes[k].orig == val){val=cpnodes[k].copy;break;}
			}//for
			}//if
//char ccc[20];// **debug**
//cout<<"node="<<org<<" "<<nodnam(org,ccc)<<" copied to="<<cpy<<endl;// **debug
//if(cpy==52)cout<<"rest="<<restrnamP<<" in copyNA assgn to 52 due to copy from "
//<<org<<" att= "<<NAlist[j].attrb<<" val="<<val<<endl;
			asgnat(cpy,NAlist[j].attrb,val,valtyp,0,1);
			}//for on NA's on node
/*

	int nrefs=getsetvalnode(org,NArefs,20);
for(int j=0;j<nrefs;j++){
int refnd=NArefs[j].node;
int k;
for(k=0;k<cpnct;k++){
if(refnd==cpnodes[k].orig)break;
}//for
if(k<cpnct)continue;//on list dont do
//if(refnd==52)cout<<"rest="<<restrnamP<<" in copyNA ref assign to 52 due to copy from "<<org<<" att="<<NAlist[j].attrb<<" val="<<cpy<<endl;// **debug
nodattf(refnd, NArefs[j].attrb, cpy, 0, 0, 1);
}//for
*/
		}//for in copy nodes
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

char * subsum(int, char*);

void prtnodsub(int ndd, int typ){
	char txtarr[400];
	if(typ==0){
char txtarr[300];
*coutP<<nodnam(ndd, txtarr); // **fix this

//          prints words subsumed unless node is empty
		if(NDWPNC(ndd) == 0) return;
		if(NDWPCP(ndd) == 0) {*coutP<<" incomplete";return;}
		if(NDWPNC(ndd) == NDWPCP(ndd)) return;
		*coutP<<" wd sub="<<subsum(ndd,txtarr);
		return;
		}

//              list -- print the list
	//plist(ndd,FALSE,PRUNIT);
	return;
}
// ---------------------------------------------------------

int ckref(int strtxr7){
extern int oright(void), down(void), oupone(void);
	char nambuf[50];
	int nancrt=0, s, nt, ret=0;
	char * nameP;
	int xr7sav=xr7;
	int listsv=list;
	xr7=strtxr7;
	list=0;
	while(1) {

if(NDSPFB(xr7)==0){
*coutP<<"node="<<xr7<<" "<<nodnam(xr7,nambuf)<<" appears to have been deleted"<<endl;
ret=1;
}
else {
struct NAsetstr NAlist[20];
struct NArefsetstr NArefs[20];
int nnas=getNAfornode(xr7, NAlist, 20);
//check for dups

for(int i=0; i<nnas; i++){
int at=NAlist[i].attrb;
for(int k=i+1; k<nnas; k++){
if(at==NAlist[k].attrb){
if((NAlist[k].value != -1) && (NAlist[i].value != -1)){
char *atn=STNAME(CAR(at));
*coutP<<"node="<<xr7<<" "<<nodnam(xr7,nambuf)<<" NA with att="<<at<<" "
<<atn<<" is dup-ed";
if(NAlist[i].value != NAlist[k].value){
*coutP<<" but have different values ";
*coutP<<NAlist[i].value;
if(NDSPFB(NAlist[i].value) == 0)*coutP<<"(deleted)";
*coutP<<" "<< NAlist[k].value;
if(NDSPFB(NAlist[k].value) == 0)*coutP<<"(deleted)";
}
*coutP<<endl;
ret=1;
}
}
}
}

for(int i=0; i<nnas; i++){
if(NAlist[i].value==0)continue;
if(NAlist[i].value==-1)continue;
if(NAlist[i].valtype != 0)continue;
int j;
if(NDSPFB(NAlist[i].value)==0){
*coutP<<"on node="<<xr7<<" "<<nodnam(xr7,nambuf)<<" the value node="<<NAlist[i].value<<" appears to have been deleted"<<endl;
ret=1;
continue;
}
int nrefs=getsetvalnode(NAlist[i].value,NArefs,20);
for(j=0;j<nrefs;j++){
if(NArefs[j].node != xr7)continue;
if(NArefs[j].attrb == NAlist[i].attrb)break;
}//for
if(nrefs==0 || j>=nrefs){//not found
char *atn=STNAME(CAR(NAlist[i].attrb));
*coutP<<"On node="<<xr7<<" "<<nodnam(xr7,nambuf)<<" NA="<<atn<<
" with node value="<<NAlist[i].value<<" "<<nodnam(NAlist[i].value,nambuf)<<
" has no reference"<<endl;
ret=1;
}//if
	}//for over NAs

int nrefs=getsetvalnode(xr7,NArefs,20);
//check for dups
for(int i=0; i<nrefs; i++){
int at=NArefs[i].attrb;
int nn=NArefs[i].node;
for(int k=i+1; k<nrefs; k++){
if((at==NArefs[k].attrb) && (nn==NArefs[k].node)){
char *atn=STNAME(CAR(at));
*coutP<<"on node="<<xr7<<" "<<nodnam(xr7,nambuf)<<" ref with attrb="<<at<<" "
<<atn<<" and node="<<nn<<" is duplicated"<<endl;
printValNA(xr7);
ret=1;
}//if
}//for
}// for

for(int j=0;j<nrefs;j++){
if(NDSPFB(NArefs[j].node)==0){
*coutP<<"on node="<<xr7<<" "<<nodnam(xr7,nambuf)<<" Referenced node="<<NArefs[j].node<<" appears deleted"<<endl;
ret=1;
continue;
}
int nnas=getNAfornode(NArefs[j].node, NAlist, 20);
int i;
for(i=0;i<nnas;i++){
if(NAlist[i].value != xr7) continue;
if(NArefs[j].attrb != NAlist[i].attrb) continue;
if(NAlist[i].valtype ==0) break;
}//for NAs
if(nnas==0 || i>=nnas){//not found
char *atn=STNAME(CAR(NArefs[j].attrb));
*coutP<<"On node="<<xr7<<" "<<nodnam(xr7,nambuf)<<" NA="<<atn<<
" is a reference to node="<<NArefs[j].node<<" "<<nodnam(NArefs[j].node,nambuf)<<
" that node has no corresponding NA"<<endl;
ret=1;
}
}//for over refs
}//else node not deleted
	if(down()) continue;

	do {
		if(xr7 == strtxr7){s=0;break;}
		if(s = oright()) break;
		} while((xr7!= strtxr7) && (s=oupone()));

	if(!s) break;
	} // while

	xr7=xr7sav;
	list=listsv;
return ret;
}// func end
