/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
//      SUBROUTINE RIGHT
// ***********************************************************************
// *     This program contains the basic routines for moving about
// *     the parse tree.  Its entry points are:
// *          RIGHT -- go to Node right of current Node
// *          LEFT1 -- go to Node left of current Node
// *          UPONE -- go to Node above current Node
// *          DOWN  -- Go to leftmost Node on level below current Node
// *          DNRIT -- go to rightmost Node on level below current Node

// *     On entry, xr7 points to the current Node.
// *     On exit, return=TRUE,  if the operation could be performed,
// *     xr7 then points to the new current Node.
// *     return=FALSE, if the operation could not be performed,
// *     xr7 is unchanged
// ************************************************************************
#define TRUE 1
#define FALSE 0

#include <fstream.h>
#include "common.fcm"
#include "lispdefs.fcm"
#include "nodefs.fcm"

int right() {
	if(NDRTPT(xr7)==0) return FALSE;
	xr7=NDRTPT(xr7); return TRUE;
}

int left1() {
	if(NDFILT(xr7)) return FALSE ;
	xr7=NDUPLF(xr7); return TRUE ;
}
int upone(){

	int nxr7;
	nxr7=xr7;
	while(!NDFILT(xr7)) xr7=NDUPLF(xr7);
	if((xr7=NDUPLF(xr7))) return TRUE;
	xr7=nxr7; return FALSE;
}

// - - - - - - - - - - - - - - - - - - - - - - - 
int down(){
//int downentry=xr7;// **debug

	if(NDATMT(xr7)) return FALSE;//GO TO 2
	if(! NDBALP(xr7)) return FALSE;//GO TO 2
	xr7=NDBALP(xr7);
	return TRUE;
}
// - - - - - - - - - - - - - - - - - - - - - - - 

int dnrit(){

	if(NDATMT(xr7)) return FALSE;//GO TO 2
	if(NDBALP(xr7)==0) return FALSE;// GO TO 2
	xr7=NDBALP(xr7);

	while(NDRTPT(xr7)) xr7=NDRTPT(xr7);
	return TRUE;
}

// ***********************************************************************
// *     THIS SUBPROGRAM CONTAINS THE CODE FOR THE RESTRICTION OPERATORS
// *     RIGHT, LEFT, UPONE, AND DOwn.  in contrast with the functions
// *     RIGHT, LEFT1, UPONE, and DOWN appearing
// *     in this file, these operators automatically pass
// *     through dummy Nodes, IN OTHER WORDS, THE OPERATORS APPEAR TO
// *     move right, left, up, and down in a tree in which elements
// *     inside parentheses in a BNF definition are on the same
// *     level as the elements outside the parentheses.  THE OPERATORS
// *     can handle an arbitrary depth of dummy Nodes, i.e., an arbitrarily
// *     deep nesting of parentheses in a BNF definition.

// *          THE ENTRY POINTS ARE
// *          ORIGHT -- operator right
// *          OLEFT -- operator left
// *          OUPONE -- operator upone
// *          ODOWN -- operator down

// *     On entry, (xr7,list) point to the current position
// *     On exit, return=TRUE if operation was successful,
// *     xr7 points to the new current Node, list=0.
// *     Return FALSE, If list!=0 on entry (not looking at
// *     Node) or operation could not be performed,
// *     xr7 and list are unchanged.
// ***********************************************************************

int oright(){
	int nxr7;
	if (list) return FALSE; //GO TO 81
	nxr7=xr7;
// 10
	do {

	if (right()) {//GO TO 12
// *             If Node to right is a dummy, descend to a named Node
	if(!NDNONT(xr7)) return TRUE;// GO TO 30

		do{
			if(! down()){xr7=nxr7;return FALSE;}// GO TO 80
			}while(NDNONT(xr7));
		return TRUE;
} // if right

// *   If cannot go right and are below dummy,try to go right on level above
// 12
		if(!(NDIDMT(xr7))) {xr7=nxr7; return FALSE;} //GO TO 80
		}while(upone());// GO TO 90

	xr7=nxr7;return FALSE;
      //GO TO 90
}
// - - - - - - - -- - - - - - - - - - - - - - -  - - - - 
int oleft(){
	if (list) return FALSE ;//GO TO 81
	int nxr7 = xr7;

 //20 
	do {
		if(left1()) { // GO TO 22
// *       If Node to left is dummy, descend to named Node
 //21
		do{
			if(!(NDNONT(xr7))) return TRUE;
			}while(dnrit());

	nxr7=xr7; return FALSE;//GO TO 80
      //GO TO 21
			} // if left1

// *  If cannot go left and are below dummy, try to go left on level above

// 22 
 		if(!NDIDMT(xr7)){nxr7=xr7;return FALSE;}// GO TO 80
		} while(upone()) ; //GO TO 90
	xr7=nxr7; return FALSE;
//      GO TO 90
}

int odown(){
	int nxr7;
	if (list) return FALSE;//GO TO 81
	nxr7=xr7;
 //30 
	do{
		if(! down()){xr7=nxr7;return FALSE;}// GO TO 80
		}while(NDNONT(xr7));
	return TRUE;
}

int oupone() {
	int nxr7;
	if(list) return FALSE;//GO TO 81
	nxr7=xr7;
// 40   CONTINUE
	do {
		if(! upone()) {xr7=nxr7; return FALSE;}//GO TO 80
	} while(NDNONT(xr7)); // GO TO 40
	return TRUE;
}
#if 0
// *             FAILURE EXIT
   80 xr7=nxr7;
   81 PASS=.FALSE.
      return FALSE;
// *             SYSTEM ERROR EXIT
   90 PRINT *,'***** Node flagged in DUMMY has no parent'
     GO TO 80
#endif
