/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <string.h>
#include <fstream.h>
#include "common.fcm"
#include "lispdefs.fcm"
#include "symtab.h"

extern int gcons(int,int,int);
extern SymbTable sytab;

// ************************************************************************
// *     SYMBOL creates a symbol head for the symbol named -nm- (unless
// *     such a head already exists) and returns a pointer to this head.
// ************************************************************************
int symbol(char *nm){
	int ist;
	if(strcmp(nm,"NIL")==0) return 0;
        ist=GETST(nm,0);
        if(!(STADDR(ist))) SETSTADDR(ist,gcons(0,HEAD,ist));
        return STADDR(ist);
}


// ************************************************************************
// *     LITRAL creates a literal head for the symbol named -NM- (unless
// *     such a head already exists) and returns a pointer to this head.
// ************************************************************************
// *
int litral(char *nm){
	int ist;
        ist=GETST(nm,0);
	if(!STREFC(ist))SETSTREFC(ist,gcons(0,(HEAD+ATOMIC+LTOMIC),ist));
	return STREFC(ist);
}

// ************************************************************************
// *     NSYMBL creates a numeric head for the number -NUM-, and returns
// *     a pointer to this head.
// ************************************************************************

int nsymbl(int num){ return gcons(num,(HEAD+CNSTBT),0) ;}
