/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "symtab.h"
#include "operdefs.h"

#define DEFINITION_RECTYPE 1
#define RESTRIC_RECTYPE 2
#define ADDRESS_RECTYPE 3
#define ROUTINE_RECTYPE 4
#define LIST_RECTYPE 5
#define WD_DEF_RECTYP 6
#define WD_DEF_SUBPART 7
#define WD_DEF_CANON_RECTYP 8
#define WD_CANON_DEF_RECTYP 9

extern SymbTable sytab;

#include "lispdefs.fcm"
#include "common.fcm"
#include "gencom.fcm"
#define FALSE 0
#define TRUE 1
#define NUMOPS 92
#define DEFLIM 20
#define LXLEN 15 

char numric[10]= {'0','1','2','3','4','5','6','7','8','9'};
#define ISGWTH 1
#define INTWTH 3
#define IFDWTH 15
#define GLOBAL 16
//     xref controls printing of symbol and literal cross reference table
//     house controls printing of housing directory

#define RNAME( x )  (recDatP + (x) )->rnameP
#define FRSTIG( x ) (recDatP + (x) )->frstigP
#define LASTIG( x ) (recDatP + (x) )->lastigP
struct recDatst { char * rnameP ; unsigned short frstigP; unsigned short lastigP;};
static struct recDatst *recDatP;
static char rectps[1500];
static int *rst_unt_st;
static char* recold; //debug
static int undef[100];
static int* undefP=&undef[0];
#define LXLEN 15
const char * lxsym[LXLEN]={"GENERATOR","ENDMARK","SPECIAL","NAME","INTEGER",
  "TEXT","ADDRESS","ATOM","ATTRIBUTE","DEF","NODE","NTH","REG","LINO", "TYPE"};
int lxadr[LXLEN];

const char * nilnm = "NIL";
const char * namtyp[16]={"DEF", "LEX","G/O","ADD","ATT", "REG","TYP",
	 "   ", "   ", "   ", "   ", "   ", "   ", "   ", "INT","   "};
struct opertbs {const char *opnamp; unsigned char opid;};
static struct opertbs goname[]= {
	{"AND",ANDOPER},
	{"OR",OROPER},
	{"IMPLY",IMPLYOPER},
	{"NOT",NOTOPER},
	{"EXEC",EXECOPER},
	{"CANDO",CANDOOPER},
	{"ITER",ITEROPER},
	{"ITERT",ITERTOPER},
	{"ITERF",ITERFOPER},
	{"ITERFT",ITERFTOPER},
	{"EDIT",EDITOPER},
	{"COMMONAT",COMMONATOPER},
	{"EXECUTE",EXECUTEOPER},
	{"STACK",STACKOPER},
	{"PRESENT",PRESENTOPER},
	{"UPONE",UPONEOPER},
	{"DOWN",DOWNOPER},
	{"VALUE",VALUEOPER},
	{"LEFT",LEFTOPER},
	{"RIGHT",RIGHTOPER},
	{"UPTRN",UPTRNOPER},
	{"DNTRN",DNTRNOPER},
	{"NELEM",NELEMOPER},
	{"WORDL",WORDLOPER},
	{"FRSTL",FRSTLOPER},
	{"LASTL",LASTLOPER},
	{"PREVL",PREVLOPER},
	{"NEXTL",NEXTLOPER},
	{"TRUE",TRUEOPER},
	{"IDENTICAL",IDENTICALOPER},
	{"IS",ISOPER},
	{"ATTRB",ATTRBOPER},
	{"TEXTX",TEXTXOPER},
	{"EMPTY",EMPTYOPER},
	{"NWORD",NWORDOPER},
	{"MINWD",MINWDOPER},
	{"PARSE",PARSEOPER},
	{"RARE",RAREOPER},
	{"SEGMENT",SEGMENTOPER},
	{"REP",REPOPER},
	{"NODENAME",NODENAMEOPER},
	{"HEAD",HEADOPER},
	{"SUCCESSORS",SUCCESSORSOPER},
	{"PREFIX",PREFIXOPER},
	{"LOOKATSYMBOL",LOOKATSYMBOLOPER},
	{"LOOKATLIST",LOOKATLISTOPER},
	{"TESTFORNIL",TESTFORNILOPER},
	{"MEMBER",MEMBEROPER},
	{"STORE",STOREOPER},
	{"LOOK",LOOKOPER},
	{"ASSIGN",ASSIGNOPER},
	{"HASATT",HASATTOPER},
	{"ERASE",ERASEOPER},
	{"GENER",GENEROPER},
	{"WRITE",WRITEOPER},
	{"REPARSE",REPARSEOPER},
	{"CREATE",CREATEOPER},
	{"COPY",COPYOPER},
	{"CLASS",CLASSOPER},
	{"BUILDDOWN",BUILDDOWNOPER},
	{"BUILDRIGHT",BUILDRIGHTOPER},
	{"BUILDUP",BUILDUPOPER},
	{"BUILDWORD",BUILDWORDOPER},
	{"REPLACE",REPLACEOPER},
	{"INSERTBEFORE",INSERTBEFOREOPER},
	{"INSERTAFTER",INSERTAFTEROPER},
	{"TRANSFORM",TRANSFORMOPER},
	{"DEACTIVATE",DEACTIVATEOPER},
	{"GENSYM",GENSYMOPER},
	{"SEARCHWORD",SEARCHWORDOPER},
	{"INTERSECTOP",INTERSECTOPER},
	{"INTERSECTCHK",INTERSECTCHKOPER},
	{"UNIONOP",UNIONOPER},
	{"COMPLEMENTOP",COMPLEMENTOPER},
	{"SETLOGSW",SETLOGSWOPER},
	{"CLEARLOGSW",CLEARLOGSWOPER},
	{"CLEARLOGSWALL",CLEARLOGSWALLOPER},
	{"TESTLOGSW",TESTLOGSWOPER},
	{"TOGLOGSW",TOGLOGSWOPER},
	{"SETGLOBSW",SETGLOBSWOPER},
	{"CLEARGLOBSW",CLEARGLOBSWOPER},
	{"TESTGLOBSW",TESTGLOBSWOPER},
	{"EQUIVMATCH",EQUIVMATCHOPER},
	{"REPARSESW",REPARSESWOPER},
	{"CREATE-IDIOM",CREATEIDIOMOPER},
	{"EVERY-NODE",EVERYNODEOPER},
	{"GETPREVTREEE",GETPREVTREEOPER},
	{"SWITCHPREVTREEE",SWITCHPREVTREEOPER},
	{"SWITCHCURTREE",SWITCHCURTREEOPER},
	{"COPYPREVTREE",COPYPREVTREEOPER},
	{"INSERTAFTERPREVTREE",INSERTAFTERPREVTREEOPER},
	{"GOTONODEPOINTEDTO",GOTONODEPOINTEDTOOPER}
};

// ----------------------------------------------------------------------

extern void CLOSE(int);
extern void REWIND(int);
extern unsigned int getfld(int);
extern void plist(int, int, int);
extern int gcons(int,int,int);
extern int grammar_read(int, unsigned int *, int, int *, char *, int *, int *);
extern int readst(int);
extern int load(int);
extern void iniget(unsigned int *, int);


void creatHeads(){
int i,type,addr,idexs,ist;
char * sname;
int jop=0;
// 		 Create heads for symbols of certain types
// 				 Loop through symbol table
//ist=STLNTH ;
	sytab.alphInit();
	while((idexs=sytab.getNextAlpha())!= 0){
//                              Create HEAD
	type=STTYPE(idexs);
	if(type == 0 || type == SPTYPE)continue; // Skip if no type 
	sname=STNAME(idexs);
	addr=STADDR(idexs);
//if(addr)cerr<<"in lked addr was not zero in lked "<<sname<<endl;

	switch(type){

        case ADTYPE: 
// 		restriction and routine names	
// 		address symbols are not in main symbol table

		if(addr)CSRINT(addr)=HEAD;
//else cerr<<"adtype no add "<<sname<<endl;//**debug**
		break;

        case DTYPE: 
//           for symbols of type definition, and typelist copy bits indicating
//           lists of which  symbol is a member to special field of head
		if(addr)CSRINT(addr)=HEAD |
			(sytab.retstopoth(idexs)&(STGBIT+MINFLG+RECBT));
		break;

        case TPTYPE: 
//                          create type list -ATOM- if not present in grammar
	if(!strcmp(sname,"ATOM")) {
		if(addr == 0){
			 addr = gcons(0,(HEAD | ATOMIC),0);
			 SETSTADDR(idexs,addr);
			}
		else CSRINT(addr)=(HEAD|ATOMIC);
		}
	else if(addr)CSRINT(addr)=HEAD;
		break;
//				3. For symbols of types ATOMIC, OPERATOR
//				 REGISTER, CONSTANT, LITERAL, create HEAD

	case 16:
	case ATTYPE:
		if(addr == 0){
			addr = gcons(0,HEAD,0);
			sytab.setstadd(idexs,addr);
			}
		else CSRINT(addr)=HEAD;
		break;

        case LTYPE: 
		if(addr == 0){
			addr = gcons(0,(HEAD | ATOMIC),0);
			sytab.setstadd(idexs,addr);
			}
		else CSRINT(addr)=(HEAD | ATOMIC);

//                         flag symbols beginning NULL... as null atomics

		if(strncmp(sname, "NULL",4)==0) {CSRINT(addr)=(HEAD|ATOMIC|OTOMIC); break;}

//                          for atomic symbols, look up name on LXLIST and 
//                          replace entry in LXLIST with pointer to head
		for(int i=0;i<LXLEN;i++){ 
			if(!strcmp(lxsym[i] ,sname)){ lxadr[i]=addr;  break;}
			}
		break;

        case GTYPE: 
		if(addr == 0) {
			addr = gcons(0,HEAD,0);
			sytab.setstadd(idexs,addr);
			}
		else CSRINT(addr)=HEAD;
//                              For operators, look name up on goname
		for(int i=0;i<NUMOPS;i++){
			if(!strcmp(sname ,goname[i].opnamp)){
//                                         save number in STTYPE
				sytab.setstopnm(idexs,goname[i].opid) ;
				break;
				} //if
			} // for
		break;

//                                 for registers, set flag bit
	case RGTYPE:
		if(addr == 0){
			addr=gcons(0,(HEAD | REGBIT),0);
			sytab.setstadd(idexs,addr);}
		else CSRINT(addr)=(HEAD|REGBIT);
	break;

        case  INTYPE:
//                             Store flag BITSS in special of head
		if(addr == 0) {
			addr = gcons(0,(HEAD|CNSTBT),0);
			sytab.setstadd(idexs,addr);
			}
		else CSRINT(addr)=(HEAD|CNSTBT);

//                        For constants, store value in successor field of HEAD
		CDRINT(addr)=sytab.retstnum(idexs);
		break;

	default: 
              *coutP<< "***** symbol " << sname <<" of invalid type"<< endl;
	continue;//go to end of while
	} // switch end


//                     Insert pointer to name in address field of head
	if(addr)CARINT(addr)=idexs;

// *                       E. For reference table, write out type of symbol
//  468 if(XREF)WRITE (UNIT=REFFIL,FMT=470) NAME,NAMTYP(ITYPE)
//  470 FORMAT('S',A20,'T',A3)
//  430
	}// while
	return;
}

//    - - - - - - - - - - - -- - - - - - - - - - - - - - - - - -  -

void houserr(const char * txt, int idx, int iddf, char * rcn){
  *coutP<< txt << STNAME(idx)<<" of def "<<(STNAME(iddf))<<
", specified in housing of  " << rcn <<" not found"<<endl;
return;
}

//    - - - - - - - - - - - -- - - - - - - - - - - - - - - - - -  -

void houserr2(char *par, char * rcn,int idx){
      *coutP<<"*** Housing list for "<<par<<rcn
            <<" references undefined def "
            << STNAME(idx)<< "--ignored"<<endl;
     }

//    - - - - - - - - - - - -- - - - - - - - - - - - - - - - - -  -

void putPointList(int irad){
	int i,rst;
	rst=gcons(0,0,0);
	if(!CSR(irad)) CSR(irad)=rst; // Create new list
	else{ //   Add to old list in srt
		i=CSR(irad);
		while(CDRADDR(i)) i=CDRADDR(i);
    		CDRADDR(i)=rst;
		}//else
	*rst_unt_st++ = rst;
	return;
}

//    - - - - - - - - - - - -- - - - - - - - - - - - - - - - - -  -

//                           process housing lists
int prochousing(char *rcdnam){

int lstptr,sign,type,idexs,idexsFile,ignore;
int knt=0, opt, ielem;
int idad,houseType, houseTypeFile, inddef,irad,j,i,ii,num;
int deflst[DEFLIM], dadlst[DEFLIM];
int numdef=0;

//  L602
// the grammar will start one past the current position
	ignore = getfld(ISGWTH);
//  L603
// extract the INDEF portion of the housing. For a list of the nodes or Types
	do {
		type=getfld(INTWTH) ;
		if(type) ignore=getfld(IFDWTH);
		ignore = getfld(INTWTH);
		idexsFile = getfld(IFDWTH);
		idexs = sytab.getTransStIdx(idexsFile);
		knt++;
//					 check that def is defined
	int syt;
		if( (syt=STADDR(idexs)) == 0) {
			houserr2((char *) "",rcdnam, idexs);
			continue;
			}// if

		deflst[numdef]=idexs;
		dadlst[numdef++]=syt;
		if(type) {
//                         If housing on dummy, search for dummy def
			i=FALSE;
			opt=CDRADDR(STADDR(idexs));
			do{
				ielem=CARADDR(opt);

				do{
					if(CARINT(ielem) <= SOS){i=TRUE;
					dadlst[numdef-1]=CAR(ielem);break;}
					} while(ielem=CDRADDR(ielem));

					if(i) break;
					} while(opt=CDRADDR(opt));

				if(!i) {numdef--; houserr2((char *) "()",rcdnam, idexs);}
			} // if type
		} while(sign=getfld(ISGWTH)); // end of indef part


//                         Save indicator for option/elem list
	ignore=getfld(2*INTWTH);
	houseTypeFile=getfld(IFDWTH);
	knt++;
//cerr <<"in lked houseTypeFile "<<houseTypeFile<<endl;
	if(houseTypeFile > 5){
int htt=houseTypeFile;
		houseType = sytab.getTransStIdx(houseTypeFile);
//cerr<<"house type > 5 "<<rcdnam<<" "<<htt<<" "<<STNAME(houseType)<<" "<<hex<<STTYPE(houseType)<<dec<<endl;
houseType=sytab.retsthostp(houseType);
//cerr<<houseType<<endl;
	}
	if(houseType) sign=getfld(ISGWTH);
	do {
//                         If 0 (no option/elem list) skip list read in [C.]
		if(houseType){// goto L620;
			ignore=getfld(2*INTWTH);
			idexsFile = getfld(IFDWTH);
			knt++;
		if(!(idexs = sytab.getTransStIdx(idexsFile))){
			*coutP<<" *** Invalid symbol table pointer= "<<idexs
			<<" in record "<<rcdnam<<" word "<< knt<<endl;
			continue;
			}//if on error
			}// if houseType !=0

//              Loop over defs, inserting pointers to restrictions on SRT
	for(int def=0; def < numdef; def++){
//                                  Set idad=address of head of def
	inddef=deflst[def];
	idad=dadlst[def];
//                                  If type LIST, get first element
	lstptr=0;
	if(STTYPE(inddef) == TPTYPE) {
		lstptr=CDRADDR(idad);
		}//if TPTYPE
	do {
		if(lstptr){
		inddef=sytab.getTransStIdx((CAR(lstptr)-SOS)) ;
		if(!STADDR(inddef)) {houserr2((char *) "", rcdnam, inddef);continue;}
		idad=STADDR(inddef);
		}//if tlist
//L630:

	switch (houseType) {
		case 0:    //    simple housing on the node
		while(idad=CDRADDR(idad)) {
			if(*rcdnam==(char )'W') {
//                     (A) For W restrs, put on last element of all options
				irad=CARADDR(idad);
				while(CDRADDR(irad) != 0) irad=CDRADDR(irad);
				}//if
			else irad=idad; // For D restrs, put on all options
			putPointList(irad);
			if(*rcdnam<(char)'W' && *rcdnam >= 'O') break;
//                      (C) Get next option
			} //while
		break;

		case 1:
		case 3:
//  option list for both RE and AFTER types
		if(STTYPE(idexs)==15) {// an integer
//                                   Seek numbered option (houseType=1,3)
			num=sytab.retstnum(idexs);
			i=idad;
			for(int ii=0;ii<num;ii++){
				i=CDRADDR(i);
		if (!i) {houserr((char *) " *** Option  ",idexs,inddef,rcdnam);break;}
				}//for
			if(!i) break;

			j=CAR(i);
			}//if ==15
		else { //    Seek named option
			i=idad;
			do {
			i=CDRADDR(i);
	if (!i) {houserr((char *) " *** Option  ",idexs,inddef,rcdnam); break;}
			j=CAR(i);}
			while(CARINT(j) != idexsFile+SOL
				&& CARINT(j) != idexsFile+SOS);//goto L635;
			if(!i) break;
			}//else
//                         House_type=1, put on option RE opt
	irad=i;
	if(houseType == 3) {//goto L720;
//                         House_type=3, put on last elem AFTER
		irad=j;
		while(CDRADDR(irad)) irad=CDRADDR(irad);
		}//if houseType==3
	putPointList(irad); //  Put pointer to restric. in grammar
	break;

	case 4: // Element list, houseType 4, after node
		opt=CDRADDR(idad);
//		 check that there is only one option
		while(opt){
			irad=CARADDR(opt);
			while(irad){ //   Seek named element
				int carrad = CARINT(irad);
				if(carrad == idexsFile+SOS)break;// goto L720;
				if(carrad == idexsFile+SOL)break;// goto L720;
				irad=CDR(irad);
				}// while irad
			if(irad) break;
			opt=CDRADDR(opt);
			}// while opt
			if(!opt){
				houserr((char *) " *** Element ",idexs,inddef,rcdnam);
				continue;
				}
 // Put pointer to restric. in grammar
			putPointList(irad);
			break;

	case 2: //    Seek numbered element
		opt=CDRADDR(idad);
		irad=CARADDR(opt);
		num=sytab.retstnum(idexs)-1;
		for(i=0;i<num;i++){
		irad=CDRADDR(irad);
	if(!irad) {houserr((char *) " *** Element ",idexs,inddef,rcdnam);continue;}
			}// for
		putPointList(irad); // Put pointer to restric. in grammar
		break;
		}// end switch

//                          If processing a type list, get next entry
	if(!lstptr) break;
	} while (lstptr=CDRADDR(lstptr));//goto L622;
	}// for indefs

//                                 Look at next list entry
//                       If not at end of list, loop back case 1,3
	} while(sign=getfld(ISGWTH));

//  there are two words remaining which are constructed
//  be pointers to the housing. These are discarded
	ignore=getfld(2*INTWTH);
	ignore=getfld(IFDWTH);
	knt++;
	ignore=getfld(1+2*INTWTH);
	ignore=getfld(IFDWTH);
	knt++;
//                       Compute effective starting location of record
	return ig-knt;
}

void printHouse(void){
#if 0
char * namee,nameo,named;
//      INDENT=38
// *                               A. Loop through symbol table
// *                                  1. Loop thorugh hash table
	sytab.alphaInit();
	while((idexs=sytab.getNextAlpha()>0){
// *                                  2. Link through symbol table list for
// *                                     this hash value, looking for defs
//  820
	if(STTYPE(idexs) != DTYPE) continue;
// *                                  3. Save def name a<nd address
	named=STNAME(idexs);
	icc='0';
	idad=STADDR(idexs);
// *                                     (A) Skip def if undefined
      if(idad == 0) contine;

 L825:
	 idummy=0;
// *                               B. Loop over options
      iopt=0;
      locopt=idad;
 L830:
      while(locopt=CDR(locopt){
//      if(locopt == 0) goto 860
	 iopt++;
// *                                  1. Reset element name, count, posn
      namee=(char *)"NULL";
      ielem=0;
// *                                  2. Get option name
// *                                     (A) If only one option, set
// *                                         option name = blank
      nameo=(char *)"NULL";
      if(CDRADDR(CDRADDR(idad)) ){
// *                                     (B) Get head pointed to by first
// *                                         element of option
        i=CARADDR(CARADDR(locopt));
        if(!(CSRINT(i) & NONAM))
// *                                     (C) If named head, take its name
// *                                         as name of option
          nameo=STNAME(CARINT(i));
}
        else nameo=&numric[iopt];
// *                                  3. If restrictions are housed on
// *                                     option, go link them
}
	irad=locopt;
	if(CSR(irad)) goto L870;
// *                               C. Loop over elements
 L841:
	ielem=1;
	locelm=CARADDR(locopt);
// *                                  1. If no restrictions housed on this
// *                                     element, get next element
 L842:
	 if(CSR(locelm) == 0) goto L855;
// *                                  2. GET ELEMENT NAME
// *                                     (A) DOES ELEMENT POINT TO NAMED HD
      i=CARADDR(locelm);
      if((CSRINT(i) & NONAM) == 0) namee=STNAME(CAR(i));
// *                                     (B) YES -- TAKE NAME OF HEAD AS
// *                                         NAME OF ELEMENT
	else namee=&numric[ielem]; //  No -- use element number
// *                                  3. List restrictions
	irad=locelm
// *                               E. Link up restrictions
// *                                  1. Print DEF, OPT, ELEMENT names
 L870:
// COL(WUTIX(PRUNIT))=1
      fill(icc);
	for(i=0;i<3;i++){ fill (namez[i]); fill ('  '); }
      icc=' ';
      named=' ';
// *                                  2. Get pointer to list of restrs
  875 link=CSR(irad);
// *                                  3. List restrictions
	while(link){
 L880:
	j=CAR(link);
      if(j){
        plist(j,FALSE,prunit);
        fill(", ");
      }
	link=CDR(link);
}
	prnt();
// *                                4. Go back for next element/option
      if(ielem == 0) goto L841;
// *                                   Get next element
 L855: 
	if(!idummy){
	i=CAR(locelm);
	if((CSRINT(i) & NONAM)) idummy=i;
}
	ielem++;
	locelm=CDR(locelm);
	if(locelm ) goto 842;
//                                      (A) IF NO MORE, GET NEXT OPTION
	}//while goto L830;
//                                D. If no more options, and no restrs were
//                                   housed in this def, print def name alone
  L860 :
	if(NAMED .NE. ' '){
//      COL(WUTIX(PRUNIT))=1
        fill (icc);
        fill (named);
        prnt();
      }
      if(idummy == 0) goto L815;
//                                   1. IF A DUMMY DEF WAS FOUND, REPEAT
//                                      SEARCH PROCEDURE FOR DUMMY
      named=NAMDUM(STNAME(idexs));
      icc='0';
      idad=idummy;
      goto L825;
}
}
return;
#endif
}

//    - - - - - - - - - - - -- - - - - - - - - - - - - - - - - -  -

static void restricFillAdd( int * array, int count){
	int  nstFile, idxadd, str, symidx;
	for(int itm=0; itm<count; itm++){
	str = array[itm];
	for(int iw = str; iw<array[itm+1]; iw++){
	if(CSRINT(iw) & HEAD){
	nstFile=(CARINT(iw)-SOS);
	if((symidx = -sytab.getTransStIdx(nstFile))>0){//an address
//  if the symbol appears in the CAR of the head, It is the name of the 
//  substatement ie $XXX. If a global do not erase the defining address.
	array[itm]= symidx; // mark for erasure
	if(sytab.isAddSymGlob(symidx)) array[itm] = 0;// no erase-global
	CARADDR(iw) = 0;	
	}//address head
 	continue;
	}//if head

	if(CARINT(iw) < SOL) {
	if((nstFile=(CARINT(iw)-SOS))>0){//a symbol
	if((symidx = -sytab.getTransStIdx(nstFile))>0){// address symbol
//  It is possible for an address symbol to be undefined at this point.
//  This is only possible for a global symbol. A list of those places in
//  the grammar is developed along with the address symbol table pointer
//  to be resolved when the entire grammer is read in.

	CARADDR(iw) = CDR(sytab.retstaddSym(symidx));
	if(CARADDR(iw)==0){
	cerr<< sytab.retstnameSym(symidx)<<" is undefined at "<<recold<<endl;
		*(undefP++)=iw;
		CARINT(iw)=symidx;
		}//if
	}//if address symbol
	}//if a symbol
	}//not a literal

	if(CSRINT(iw) >= SOL) continue;//a literal
	if((nstFile = (CSRINT(iw)-SOS))<0) continue;//not a symbol
	if((symidx = -sytab.getTransStIdx(nstFile))<0)continue;//not address
	CSRADDR(iw) = CDR(sytab.retstaddSym(symidx));	
	if(CSRADDR(iw)==0){
		CSRINT(iw)=symidx;
		*(undefP++)=-iw;
		}//if
	}//for iw
	}//for itm

// now we need to clear the address of the heads for each of the
// address symbols that were defined in this restriction, except
// those which are marked as GLOBAL ie made zero
//the first entry will be the main the rest are address symbols
	for (int itm=1; itm<count; itm++) {
            if((symidx=array[itm])) sytab.setstaddSym(symidx,0);
            }// for
	return ;
}

//    - - - - - - - - - - - -- - - - - - - - - - - - - - - - - -  -

//         Scan record for symbol and literal references
static void scanRecSymLit(int fw, int lw, int irec) {
      int  addr, nst, nstFile;
      char lors;
      for (int iw=fw; iw<=lw; iw++) {
//              Do special first, then address field
          for (int k=0;k<2;k++) {

              if (k == 0) {
                 if (ATOMP(iw)) continue;
                 addr=CSRINT(iw);
                 }
              else addr=CARINT(iw);

// cerr<< "k addr iw "<<k<<" "<<addr<<" "<<iw<<"\n";
              if (addr < SOS) continue ;//not a symb or lit
              if (addr < SOL) {
//                              Process symbol reference
                 nstFile=addr-SOS;
                 nst = sytab.getTransStIdx(nstFile);
                 if (nst<0) {
                    if (rectps[irec] != 1) {CARINT(iw)=0;}
                    else {
                       nst = -nst;
                       addr = sytab.retstaddSym(nst); 
                       if (addr == 0) {
                          *coutP<<"*** Undefined symbol "
                                << sytab.retstnameSym(nst)
                                <<" referenced in "<< RNAME(irec)<<endl;
                          }
                       }//else
                    }//if
//           cerr<<"error in lked-proc sym ref "<<nstFile<<" "<<nst<<endl;
//           cerr<<"should not be here "<<sytab.retstnameSym(-nst)<<endl;
                 else {
                    addr=STADDR(nst);
                    if (addr == 0) {
                       *coutP<<"*** Undefined symbol "<<(STNAME(nst))
                             <<" referenced in "<< RNAME(irec)<<endl;
                       }
                    }
                 }

              else { //   3. Process literal reference
                 nstFile=addr-SOL;
                 nst=sytab.getTransStIdx(nstFile);
                 addr=STREFC(nst);
                 if (!addr) {
//                       (A) Create literal head if this is first reference

                    addr=gcons(0,(HEAD+ATOMIC+LTOMIC),nst);
                    SETSTREFC(nst,addr);
                    } // address =0
// Nhan *coutP<<"3. Process literal reference "<<nstFile<<" "<<nst<<" addr "<<addr<<endl;
                 lors='L';
                 } // if literal
//                                 Store address into list element
              if (nst > 0){
                 if (k) CARADDR(iw)=addr;
                 else CSRADDR(iw)=addr;
                 }

//                                   5. write record for reference table
//      IF(XREF) WRITE (UNIT=REFFIL,FMT=552)LORS,STNAME(NST),RNAME(KREC)
//  552 FORMAT(A1,A,1X,A)
              } // for k
       } // for iw
}

// - - - - - - -- - - - - - - - - - - - - - - - - - - - - - - 

static void badIntErrMsg(int lochd, char * rcdnam){

        if(lochd < 0 ) *coutP<<" *** invalid interpret field in record ";
        else *coutP <<" *** no head in record ";
	*coutP<< rcdnam <<endl; 
	return;
}

// - - - - - - -- - - - - - - - - - - - - - - - - - - - - - - 

static int dgbf;// **debug
void lked(int grmobf){
int i,iw, idexs,fw,lw,ignore,lochd,nrec,irec,nst,addr;
int locrec,ist;
int addRestrCount = 0 ;
const int OBJECTLIM=3500; // Nhan No change
unsigned int object[OBJECTLIM]; // ** make new
int objlen,tost,grunt;
int resaddr[200]; // ** mkae new
char rcdnam[40];
int addSymRecBeg[160]; // ** mkae new
int rstt,redd; // **debug
char *recnamTextBeg = new char[900*16]; // Nhan 900
char *recnamP = recnamTextBeg ;

undefP=&undef[0];
recDatP = new struct recDatst[900]; // Nhan 900

//      Initialize list space pointers

	int  lrsrvd=0;
	int  mat=0;
	int  anythp=0;
//      CALL LARGO(0)
	for(int i=0;i<LXLEN;i++) lxadr[i]=0;

// 		     Create head for symbol -NIL- in word 0 of list space
	ignore=gcons(0,HEAD,sytab.getst((char *) nilnm,0));
	nrec=-1;
//                            read in grammar
	*coutP<<"Grammar read-in begins."<<endl;
//				If we hit EOF done reading.
	int canindex;
	int fdl=0;
while(grammar_read(grmobf,object, OBJECTLIM, &objlen, rcdnam, &tost, &canindex)>=0){
//cerr << "recred read "<<nrec<<"  "<<rcdnam<<endl;
     if(tost == WD_CANON_DEF_RECTYP){
	void storeCanonData_dose(unsigned int*, int, int);
	storeCanonData_dose(object, objlen, canindex);
	continue;
	}//if

//			If WD record, grammar done
	if(tost > 5) break;
// records of GLOBALs and ATTRIBUTEs are skipped as they are only
// relevant to the compilation process
	if(strcmp(rcdnam,"GLOBAL")==0
		|| strcmp(rcdnam,"ATTRIBUTE")==0) continue;

	iniget(object,objlen);
if(strcmp(rcdnam,"$RARE")==0)tost=ROUTINE_RECTYPE; // ** debug
//                                  Save record name (unless address)
	if (tost == ADDRESS_RECTYPE){//an address symbol
	   addSymRecBeg[addRestrCount++] = ig+1 ;
rstt=ig+1; // **debug
	   if((lochd=load(ig)) <= 0){ badIntErrMsg(lochd,rcdnam);continue;}
redd=ig; // **debug
	   idexs = -sytab.getTransStIdx((CAR(lochd)-SOS)) ;
	   if(sytab.retstaddSym(idexs)){
		*coutP <<" *** Duplicate definition for "
		<< rcdnam<<" in "<<RNAME(nrec-1)
		<<" (last definition used)"<<endl;
		}
	   sytab.setstaddSym(idexs,lochd);
#if 0
cerr<<"Usual way "<<rcdnam<<" "<<" "<<ig+1<<" "<<lochd<<endl;
for(int ii=rstt;ii<=redd;ii++){
cerr<<ii<<" " <<CDR(ii)<<" " <<CSR(ii)<<" " <<CAR(ii)<<" ";
if((CAR(ii)-SOS)>0&CAR(ii)<SOL){
idexs= sytab.getTransStIdx((CAR(ii)-SOS)) ;
if(idexs>0)cerr<< STNAME(idexs);
else  cerr<<sytab.retstnameSym(-idexs);
}
else cerr<<"no car";
if((CSR(ii)-SOS)>0&CSR(ii)<SOL){
idexs=sytab.getTransStIdx((CSR(ii)-SOS)) ;
if(idexs>0)cerr<<" "<<STNAME(idexs);
else  cerr<<" "<<sytab.retstnameSym(-idexs);
}
cerr<<endl; }
cerr<<endl;
#endif
	continue;
		}//if address symbol
// not an address field
	if (nrec>=0) LASTIG(nrec)=ig;
	RNAME(++nrec)=recnamP;
	rectps[nrec]=tost;
	strcpy(recnamP,rcdnam);
	recnamP += strlen(rcdnam)+1;

// were we previously reading a restriction/routine with addresses
// then process the restric/routine address symbols
	if(addRestrCount){
	  addSymRecBeg[addRestrCount] = ig+1;
	  restricFillAdd(addSymRecBeg, addRestrCount);
	  addRestrCount = 0;
	  }//if count
recold=rcdnam;//** debug

	if(tost != RESTRIC_RECTYPE){
	  FRSTIG(nrec)=ig+1;
	  if(tost==ROUTINE_RECTYPE)
		addSymRecBeg[addRestrCount++] = ig+1 ;
	  if((lochd=load(ig)) <= 0){
	        badIntErrMsg(lochd,rcdnam);continue; }
          } //if not restric

	else { // a restriction record
#if 0
int rst=ig+1;
lochd=load(ig);
int red=ig;
cerr<<"ALL of file way "<<rcdnam<<" "<<ig+1<<" "<<lochd<<endl;
for(int ii=rst;ii<=red;ii++){
cerr<<ii<<" " <<CDR(ii)<<" " <<CSR(ii)<<" " <<CAR(ii)<<" ";
if((CAR(ii)-SOS)>0&CAR(ii)<SOL){
idexs=sytab.getTransStIdx((CAR(ii)-SOS)) ;
if(idexs>0)cerr<<STNAME(idexs);
else  cerr<<sytab.retstnameSym(-idexs);
}
else cerr<<"no car";
if((CSR(ii)-SOS)>0&CSR(ii)<SOL){
idexs=sytab.getTransStIdx((CSR(ii)-SOS)) ;
if(idexs>0)cerr<<" "<<STNAME(idexs);
else  cerr<<" "<<sytab.retstnameSym(-idexs);
}
cerr<<endl; } 
iniget(object,objlen);
cerr<<endl; 
#endif
//                     Process housing lists

		rst_unt_st = resaddr;
	 	locrec = prochousing(rcdnam);

		FRSTIG(nrec) = ig+1;
		addSymRecBeg[addRestrCount++] = ig+1 ;

//                   Load record into list space
rstt=ig+1; // **debug
	if((lochd=load(locrec)) <= 0){badIntErrMsg(lochd,rcdnam);continue;}
redd=ig; // **debug

// * The item which follows the head word is part of the housing.
// * This word should be returned to the pool. The following word to
// * the discarded item should be linked to the head item.

	int retitm=CDR(lochd);
	CDR(lochd)=CDR(retitm);
		}// else for restric

if(maxwd)maxwd=0;

#if 0
if(tost==ROUTINE_RECTYPE || tost==RESTRIC_RECTYPE ){
if(dgbf){
cerr<<"Usual way "<<rcdnam<<" "<<locrec<<" "<<ig+1<<" "<<lochd<<endl;
for(int ii=rstt;ii<=redd;ii++){
cerr<<ii<<" " <<CDR(ii)<<" " <<CSR(ii)<<" " <<CAR(ii)<<" ";
if((CAR(ii)-SOS)>0&CAR(ii)<SOL){
idexs=sytab.getTransStIdx((CAR(ii)-SOS)) ;
if(idexs>0)cerr<<STNAME(idexs);
else  cerr<<sytab.retstnameSym(-idexs);
}
else cerr<<"no car";
if((CSR(ii)-SOS)>0&CSR(ii)<SOL){
idexs=sytab.getTransStIdx((CSR(ii)-SOS)) ;
if(idexs>0)cerr<<" "<<STNAME(idexs);
else  cerr<<" "<<sytab.retstnameSym(-idexs);
}
cerr<<endl; }
cerr<<endl;
dgbf=0;
}
}
#endif
//                  D. Record address of head of record
	idexs=sytab.getTransStIdx((CAR(lochd)-SOS)) ;
//cout<<"lked "<<idexs<<" "<<STNAME(idexs)<<" "<<lochd<<endl;


	if(STADDR(idexs)){

// 	If symbol is already defined, store new value in CDR of
// 	old head and issue warning (except for BNF definitions.

	if((STTYPE(idexs) != DTYPE) && CDR(STADDR(idexs))){
		*coutP <<" *** duplicate definition for "
		<<(STNAME(idexs))<<" (last definition used)"<<endl;
*coutP<<" type is "<<(STTYPE(idexs))<<" "<<idexs<<" "<<CAR(lochd)-SOS<<endl;
		}//if

		CDR(STADDR(idexs))=CDR(lochd);
		}//if

	else SETSTADDR(idexs,lochd);
//                3. If list, save address on lrsrvd (list of lists)

	if (tost == LIST_RECTYPE) lrsrvd=gcons(lrsrvd,0,lochd+1);

//                       For restriction records:
	if (tost != RESTRIC_RECTYPE )continue; // next record

//                 1. IN PROCESSING THE HOUSING LIST, section Iv created
//                    CREATED A SERIES OF LIST ELEMENTS, IN WORDS IGSTRT
//                    THROUGH IGEND, WHICH SHOULD POINT TO THE RESTRICTION.
//                    FILL THESE WORDS IN WITH ADDRESS OF RESTR.
	int * pp=resaddr;
	while (pp < rst_unt_st) CAR(*(pp++)) = lochd;

// *                                  2. Flag restriction as global
// xxxx         int rr = sytab.settyp(idexs,GLOBAL);
} // while for end of file
	LASTIG(nrec++)=ig;
	if (addRestrCount){
	   addSymRecBeg[addRestrCount] = ig+1;
	   restricFillAdd(addSymRecBeg, addRestrCount);
	   }//if

// - - - - - - -- - - - - - - - - - - - - - - - - - - - - - - 

*coutP <<"\n Grammar read-in complete.\n\n"<<nrec<<" records passed."<<endl;

//                         Store symbol and literal addresses in grammar
//                                 Loop over Major records

int dflg=0;
int * uup=undef;
int ux ;
while(uup<undefP){
	ux=*(uup++);
	if(ux>0)CARADDR(ux)=CDR(sytab.retstaddSym(CARINT(ux))); 
//else CSRADDR(-ux)=CDR(sytab.retstaddSym(CSRINT(-ux))); 
	else {
		int ase=sytab.retstaddSym(CSRINT(-ux)); 
		CSRADDR(-ux)=CDR(ase);
		}//else
	}//while
	creatHeads();
	for (irec=0;irec<nrec;irec++) {
	    int fw=FRSTIG(irec); int lw=LASTIG(irec);
//                . Scan record for symbol and literal references
// if ((fw<0) || (lw<0)) *coutP <<"-- FRSTIG and LASTIG before scanRecSymLit "<<fw<<" "<<lw<<" "<<irec<<" or "<<RNAME(irec)<<endl;
//            if (lw<0) lw = -lw; // Nhan
//            if (fw<0) fw = -fw; // Nhan
 	    scanRecSymLit(fw, lw, irec);
	    }// for irec

  *coutP << "\nGrammar occupies "<<ig<<" list-space items"<<endl ;
//      nasfw=ig+2;

//                             Print housing directory
	if (house) printHouse(); 

#if 0
	irec=0;
	for(int i=1;i<=STLNTH;i++){
	if(sytab.retstname(i) != (char*)NULL){
	irec++;
	if(sytab.retsttype(i) == 0) sytab.setsttype(i,IGTYPE);
      }
      }
	cout <<irec<<" of "<<stlnth <<" SYMBOL TABLE entries used \f";
for(int ijk=1;ijk<nrec-1;ijk++){
int ij=FRSTIG(ijk);
cerr<<'\n'<<RNAME(ijk)<<" "<< ij<<" "<<FRSTIG(ijk+1)<< endl;
//for(ij;ij<=FRSTIG(ijk+1);ij++){
//cerr<<ij<<" " <<CDR(ij)<<" " <<CSR(ij)<<" " <<CAR(ij)<<"  "
//<<hex<<CSR(ij)<<dec<<endl;}
}
#endif
	delete recnamTextBeg ;
	delete recDatP ;
	return;
}
