/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#define LIST_SPACE_SIZE 500000
#include <iostream.h>
#include <fstream.h>
#include <setjmp.h>
#include "lispdefs.fcm"
#include "common.fcm"
#include "symtab.h"
#include "returncodes.h"

extern void exitr(const char *);
extern SymbTable sytab;
extern void longJumpErr(int);
extern fstream* getstptr(int lun);

static int grptr=0, endOfPermList=0, freeListPointer=0, endOfWords=0;
static int listSpaceSize = LIST_SPACE_SIZE-2;
static int listAvail, listMax;

void listSpaceInit(){
	grptr=0, endOfPermList=0, freeListPointer=0, endOfWords=0;
	listSpaceSize = LIST_SPACE_SIZE-2;
	listAvail = listSpaceSize;
	listMax=0;
	ig=grptr;
	return;
}

struct{struct listSpaceStu *listBase; int grptr; int freeList;}listControl;
void switchListSpace(){
	listControl.listBase = listbaseP;
	listControl.freeList = freeListPointer;
	listControl.grptr = grptr;
	listSpaceSize = 20000-2;
	listbaseP = new struct listSpaceStu[20000];
	grptr=0;
	ig=grptr;
}

void restoreListSpace(){
	delete listbaseP;
	listbaseP = listControl.listBase;
	grptr=listControl.grptr;
	freeListPointer = listControl.freeList;
	listSpaceSize = LIST_SPACE_SIZE-2;
}

int gcons(int dd,int ss,int aa){
int tm;
	if(grptr>listSpaceSize){
		if(freeListPointer == 0){
		        *coutP<<"\n***** gcons overflow " <<grptr<<endl;
			longJumpErr(LJR_OUTLISTSPACE);
			}
		tm=freeListPointer;
		freeListPointer=CARADDR(freeListPointer);
		}
	else {
		tm = ++grptr;
		ig=grptr;
		}
	CDRINT(tm)=dd;
	CSRINT(tm)=ss;
	CARINT(tm)=aa;
	listAvail--;
	listMax++;
	return tm;
}

int gcons(struct listSpaceStu dd, int ss, int aa){
	return 0;
	}
int gcons(struct listSpaceStu dd, int ss, struct listSpaceStu aa){
	return 0;
	}

void permListComp(){
// all the permanent symbols have been read in or generated  as well
// as all the grammar items. This point on the list space is marked
// so that it may be released by freesg at the end of a sentence.
	endOfPermList = grptr;
	return;
}

void wordDefsEnd(){
// all the word definitions have been formed .
// This point on the list space is marked
// so that it may be released by freesg at the start of a retry.
	endOfWords = grptr;
	return;
}

/*
***********************************************************************
     FREESG is invoked at the start of processing of each sentence
     (just prior to the dictionary scan) or before doing a reparse when
     the initial parse failed.  The list space is divided into three
     sections. The first contains the grammar and its associated symbol
     and literal heads and various symbols generated which are needed for
     the processing of every sentence. The end of the area is given by the
     variable -endOfPermList-. The next part of the list space is occupied
     by the word definitions for the sentence being processed. The end of
     this area is marked by the symbol -endOfWords-. The rest of the list
     space is occupied by generated grammar(EDIT etc) and other list
     elements in grammar space which are created by the processing of the
     sentence (or tree). 

     Before doing a reparse the list space above endOfWords is free'd. The
     word definitions must be kept. Before processing a new sentence the
     list space above -endOfPermList- is free'd. FREESG erases pointers in
     the symbol table to SYMBOL or LITERAL heads which have just been
     freed, and frees symbol table entries which have neither a
     symbol head, a LITERAL head, or a TYPE.

     The sentence word text space is also freed.
***********************************************************************
*/

void freesg(int type){
	if(type==0){
		grptr = endOfPermList;
		sytab.freeTempSymbols(grptr);
		}
	else grptr=endOfWords;
	ig=grptr;
	freeListPointer = 0;
	return ;
}
//   - - - - - - - - - - -  - - - - - - - - - - - - - - - -  -
// * add a list space item to the free list;
void freeListItem(int a){
	CAR(a) = freeListPointer;
	freeListPointer=a;
	listAvail++;
	return;
}

void freeList(int a){
	do{
		CAR(a) = freeListPointer;
		freeListPointer=a;
		listAvail++;
		}while(a=CDR(a));
	return;
}
int listSpaceMaxUsed(void){
	return listMax;
}

int listSpaceAvailable(void){
	return listAvail;
}
