/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
/*
   Subroutine INTERP interprets the lists of operators which
   constitute restrictions and transformations.  The principal input
   variables are:

      arg       pointer to beginning of operator list
      xr7       pointer to node at which RESTR/TRANSF starts
      tr        TRUE if an operator trace is to be generated

   INTERP returns TRUE if the restriction/transformation succeeded.

        The bulk of the routine consists of functions which perform
   the operations associated with the various operators. These are
   nvoked by the main loop, which sequences through the operators
   and produces the operator trace.

   The principal variables used by the interpreter are:
      xr7    )- These two variables together indicate the present
      list   )   position of the restriction in the parse tree /
                 attribute list / sentence (what the restriction is
                 looking at), as follows:
                    If list=0, xr7 points to a node in the parse tree
                    If list=1, xr7 points to a list element
                    If list=2, xr7 points to a sentence word
      opptr     Pointer to list element containing operator presently
                being executed
      rptr      Pointer to argument of operator (used by RECURSIVE
                operators)

   The code is written with the assumption that no operator alters
   the value of opptr or rptr.  In addition, the specifica-
   tions of some logical operators require that they restore the
   original values of xr7 and list.  To satisfy these needs in a
   uniform fashion, every recursive operator (and some other
   operators) saves the initial values of xr7, list, opptr, RETADR,
   and rptr in a structure  named STACK, as follows:
                STACK[N].opptr = opptr
                STACK[N].rptr = rptr
                STACK[N].list = list
                STACK[N].xr7 = xr7
   for some integer N.  The variable IS points to the top entry
   in STACK.

        When the parse tree is transformed, subroutine XFIXUP updates
   STACK, setting pointers to nodes to 0 where nodes have been deleted
   and changing pointers where nodes have been moved. XFIXUP assumes
   that if STACK[N*5+4)=0 and STACK(N*5+5) != 0, STACK(N*5+5) point
   to a node and should be updated.  Although STACK may be used by
   operators to save information other than that listed above, one
   must be careful to add to STACK in groups of 5, and to leave the
   last word of the group = 0 unless it contains a pointer to a node.
   The remarks in this paragraph also apply to SAVED, the stack for
   the non-deterministic programming mechanism described below.
********************************************************************
*/

void printNA(int,const char *);// **debug
static int restcnt=0, stkent=0, copycnt,wrtcnt=0; // **debug
static int totalc=1000;
static const int NLOGSW=100;//number of local switches
static const int NLOGOP=13;
static const int NUMOPS=92;
#define TRUE 1
#define FALSE 0
static const int ROUTINEINDENT=4;

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <setjmp.h>
#include "symtab.h"
#include "returncodes.h"
#include "operdefs.h"
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
// #include "timings.h" JR 11/5 removed timing code

// extern timings testtimes; JR 11/5 removed timing code
extern void longJumpErr(int);
extern SymbTable sytab;
extern int getnod(void);
extern void mrkfre(int);
extern void fretre(int);
extern int eraseNodeAtt(int,int,int,int);
extern int wrtitr(int,int);
extern char * subsum(int, char *);
extern void xfmtre(int,int,int,int,int);
extern int xfixup(int);
extern void prtloc(void),prnt(void),prntif(void);
extern void plist(int, int, int), plistnn(int, int, int);
extern void fill(const char*);
extern int s7(int),nodeat(int,int,int*,int*),symbolCreate(char *);
extern int left1(void),oright(void),uptrn(int),dntrn(int),attrb(int);
extern int right(void),down(void),upone(void);
extern int oleft(void),oupone(void),odown(void);
extern int isit(int),empty(void),search(int,int),nodtst(int);
extern int equivmatch(int, int *, int *, int, int, int *);
extern int append(int,int),gcons(int,int,int), length(int);
extern char * nodnam(int, char *);
extern void setIndent(int);
extern void getreg(int, int *, int *);
extern void setreg(int, int, int),newlocalreg(const int, const int, const int);
extern int asgnat(int, int, int, int, int, int);
extern void exitr(int, const char *);
extern void freenode(int);
extern void xdo(void);
extern int execuErrm(int, int);
extern int xfwdsQue(char *,int,int,int);
extern void xfwdsInit(void);
extern void regrestore(int);
extern void regsavedel(int);
extern void regsaveclear(void);
extern void clearInterpBufs();
extern void regInit(void);
extern int regsave(void);
extern void reg_local_push(void), reg_local_pop(void);

extern int stackXform(int);
extern void deactXform();
static int deact;
static int environSavIdx;
extern int olddlp;
static int tr;
extern void fixupStacks(void);

static int stckStart;
static const int RECURSTACKSIZE=200;
struct stackstr {int opptr; int rptr; int xr7; short list; char restroper;
	char callInOper;} stack[RECURSTACKSIZE];

static const int UNSTACKINFOSIZE=50;
struct {
	stackstr *recurSav;
	stackstr *stackPtr;
	int *stackSav;
	int *nodeListPtr;
	int opptr; int rptr;
	int recurLenth;
	short regSaveId;
	short rouDepth; // routine depth at this point
	short numOfNodes;
	short stackCnt;
		} unstackInfo[UNSTACKINFOSIZE];

struct { int node ; int environIdx; } unstackNodes[100];
static int is, getcontxt, nodHousRest;
static stackstr *stackPtr;
static int opptr,rptr,ix0;
static int stackingCount,routineDepth;
static int trctop,routin;

static const int STACKREQUESTSIZE=100;
static int stkstk[STACKREQUESTSIZE];
static int ixfwds, ixfrst, frstxf, lastxf, newnod;
static int newdlp, lastOptGen;
char * restrnamP;

static void push(int oper){
	if(is >= RECURSTACKSIZE) {
		cout<<"recursive loop in "<<restrnamP<<endl;
		longJumpErr(LJR_RECURSIVELOOP);
		}
	stackPtr->opptr=opptr;
	stackPtr->rptr=rptr;
	stackPtr->xr7=xr7;
	stackPtr->list=list;
	stackPtr->restroper=oper;
	stackPtr->callInOper=0;
	stackPtr++; is++;
	rptr=CSRADDR(opptr);
}

inline void pushmod(int calln){(stackPtr-1)->callInOper=calln;}
static char logsws[NLOGSW];

inline void restore(){xr7=(stackPtr-1)->xr7; list=(stackPtr-1)->list;}
inline void savepos(){(stackPtr-1)->xr7=xr7; (stackPtr-1)->list=list;}

extern int AndStackOper(int, int), OrStackOper(int, int),
ImplyStackOper(int,int), NotStackOper(int, int), ExecStackOper(int,int),
CandoStackOper(int, int), IterStackOper(int, int), ItertStackOper(int, int),
IterfStackOper(int, int), IterftStackOper(int, int), EditStackOper(int, int),
CommonatStackOper(int, int), ExecuteStackOper(int,int);

extern int AndOper(void), OrOper(void), ImplyOper(void), NotOper(void),
ExecOper(void), CandoOper(void), IterOper(void), ItertOper(void), IterfOper(void),
IterftOper(void), EditOper(void), CommonatOper(void), ExecuteOper(void),
StackOper(void), PresentOper(void), UponeOper(void), DownOper(void),
ValueOper(void), LeftOper(void), RightOper(void), UptrnOper(void),
DntrnOper(void), NelemOper(void), WordlOper(void), FrstlOper(void),
LastlOper(void), PrevlOper(void), NextlOper(void), TrueOper(void),
IdenticalOper(void), IsOper(void), AttrbOper(void), TextxOper(void),
EmptyOper(void), NwordOper(void), MinwdOper(void), ParseOper(void),
RareOper(void), SegmentOper(void), RepOper(void), NodnameOper(void),
HeadOper(void), SuccessorsOper(void), PrefixOper(void), LookatsymbolOper(void),
LookatlistOper(void), TestfornilOper(void), MemberOper(void), StoreOper(void),
LookOper(void), AssignOper(void), HasattOper(void), EraseOper(void),
GenerOper(void), WriteOper(void), CreateOper(void), CopyOper(void),
ReparseOper(void), ClassOper(void), BuilddownOper(void), BuildrightOper(void),
BuildupOper(void), BuildwordOper(void),ReplaceOper(void), InsertbeforeOper(void),
InsertafterOper(void), TransformOper(void), BuildwordOper(void),
DeactivateOper(void), GensymOper(void), NewdefOper(void),
IntersectOper(void), IntersectchkOper(void), UnionOper(void),
ComplementOper(void), ClearlogswOper(void), ClearlogswallOper(void),
SetlogswOper(void), TestlogswOper(void), ToglogswOper(void),
SetglobswOper(void), ClearglobswOper(void), TestglobswOper(void),
EquivmatchOper(void), ReparseswOper(void), CreateidiomOper(void),
EverynodeOper(void), GetprevtreeOper(void), SwitchprevtreeOper(void),
SwitchcurtreeOper(void), CopyfromprevtreeOper(void),
InsertafterprevtreeOper(void),
GotonodepointedtoOper(void);

static int (*calltab[NUMOPS])(void);
static int (*calltabstack[13])(int,int);
static const char *msgUnGenOpt= "*** Unable to generate option from specified structure";
static const char * msgTranTermF = "Execution of transformation terminated, deleted node";

// JR: added 11/2/01
/* Compare S1 and S2, ignoring case.  */
extern int strcasecmp (const char *s1, const char *s2); 

/*
#if 0
*calltab[]=NewdefOper   // Type 68
#endif
};
*/

/*
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

 The following need to be saved in a push-down manner:
 1. The registers, both global and local. This is done by a call to
    the register file. It will return a number, which is the inform-
    ation which is needed to restore the saved set.
 2. The stacking requests which were already queued at this point.
 3. The recursive stack info. 
*/

void saveEnvironment(int stcats, int stc){
		
// Save the register set of this environment.
	unstackInfo[environSavIdx].regSaveId=regsave();
	unstackInfo[environSavIdx].rouDepth=routineDepth;
	unstackInfo[environSavIdx].opptr=opptr;
	unstackInfo[environSavIdx].rptr=rptr;
	unstackInfo[environSavIdx].numOfNodes = stc-stcats;

	unstackInfo[environSavIdx].stackCnt=stcats;
	if(stcats) {
// save the set of nodes which are on the request stack and are associated
// with routine which are not yet complete when current routine completed
int *stp;
	unstackInfo[environSavIdx].stackSav=stp=new int[stcats];
//cout<<"in interp:rest="<<restrnamP<<" getting stackSav="<<stp<<" for index="<<environSavIdx<<endl;// **debug
	for(int i=0;i<stcats;i++) *stp++ = stkstk[i];
	}
	else unstackInfo[environSavIdx].stackSav=0;

	unstackInfo[environSavIdx].recurLenth=is;
	unstackInfo[environSavIdx].stackPtr = stackPtr;
	if(is>0){
		stackstr *stdd = new stackstr[is];
		unstackInfo[environSavIdx].recurSav = stdd;
//cout<<"in interp:rest "<<restrnamP<<" getting recurSav="<<(void *)stdd<<" for index="<<environSavIdx<<endl;// **debug
		for(int ij=0;ij<is;ij++) *stdd++ = stack[ij];
		}
	else unstackInfo[environSavIdx].recurSav = 0;

// Save the set of nodes in the STACKing request array which was added
// during the execution of the last routine and the index of the save
// information of the current environment.

	int *npt = unstackInfo[environSavIdx].nodeListPtr = new int[stc-stcats];
//cout<<"in interp:rest="<<restrnamP<<" getting nodeListPtr="<<(void *)npt<<" for index="<<environSavIdx<<endl;// **debug
	for(int i=stcats; i<stc; i++){*npt++ = stkstk[i];}
	environSavIdx++;

	if(tr) {
		prntif();
		for(int i=stcats;i<stc;i++){
			fill(" (****** Stacking ");
			char txtbf[1000];
			fill(nodnam(stkstk[i], txtbf)); fill("=");
	 		fill(subsum(stkstk[i],txtbf)); fill(" ");
			fill("******)");
			prntif();
			}//for
		} //if
}
void deleteStackingSaves(int delIdx){
		regsavedel(unstackInfo[delIdx].regSaveId); //del save area
/*
cout<<"\nin interp-delsav:rest="<<restrnamP<<" at index "<<delIdx<<// **debug
" deleting stackSav="<<(void*) unstackInfo[delIdx].stackSav // **debug
<<" recurSav="<<(void*) unstackInfo[delIdx].recurSav // **debug
<<" nodeListPtr="<<(void*) unstackInfo[delIdx].nodeListPtr<<endl ;
*/
		if(unstackInfo[delIdx].stackSav)
			delete unstackInfo[delIdx].stackSav;
		if(unstackInfo[delIdx].recurSav)
			delete unstackInfo[delIdx].recurSav;
		if(unstackInfo[delIdx].nodeListPtr)
			delete unstackInfo[delIdx].nodeListPtr;
}

//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

//    Control transfers here to execute the list of operators pointed
//    to by -opptr-.  We first check if the list is undefined.

static int looper(void){
	int op, passlp, opstp;

	while(1){
int oppast=opptr; // **debug
	if(opptr){

//   next we check if we have been passed a pointer to the head of a
//   list.  if so, we advance the pointer to the next element.

//L205:
#if 0
	if(!ATOMP(opptr)){
		opptr=CDRADDR(opptr);
		if(opptr){
			op=CARADDR(opptr);
			if(!ATOMP(op)) opptr=0;
			}// if
		}// if

	else {
#endif
//    then we extract and check the operator number
//L210:
		opstp = CARADDR(opptr);
		if(!ATOMP(opstp)){opptr=0;}
//	} //else
		}// if

//L201:
	if(!opptr){
		prntif();
		fill("- undefined operator list referenced in restriction ");
		fill(restrnamP); fill(" -- success assumed"); prnt();
		return -4;
		}//if
//cerr<<"op name "<<sytab.retstname(CAR(op))<<"  num "<<CAR(op)<<endl;
//cerr<<sytab.retsttypeent(CAR(op))<<"  num "<<CAR(op)<<endl;
	int opidx=sytab.retstopnm(CAR(opstp));
	if(!opidx || ((opidx > NUMOPS)&&(opidx!=EVERYNODEOPER))) {
		exitr(15, "Bad Op code in INTERP");
		}

//    if trace is on, print the operator and its argument
	if(tr) {
//    Don't print operator name for EXECUTE operator
        	if(opidx != EXECUTEOPER) plistnn(CARADDR(opptr),FALSE,PRUNIT);
		if(CSRADDR(opptr)) {
//      print ( if argument is present
			fill("(");
//      Print argument except for logical operators
          		if((opidx > NLOGOP)&& (opidx!=EVERYNODEOPER))
				plistnn(CSRADDR(opptr),FALSE,PRUNIT);
			}//if
		}// if tr

//    Now we transfer to the section of code for this operator
	if(!xr7 && !list ) {

//    If xr7=0, and list=0 we are at a node which was deleted by a
//    transformational operation.  The only operators which are
//    permitted at this point are logical operators, TRUE, and LOOK.
	if(opidx > NLOGOP && opidx != TRUEOPER && opidx != LOOKOPER){//goto L9200
 prntif();
		fill("*** transformation "); fill(restrnamP);
		fill(" executed operator at deleted node");
		prnt();
		*coutP<<msgTranTermF<<endl;
		return -4;
		}
	}
//cerr<<(char *) " calling op "<< opidx<<" is stack ptr "<<is<<endl;// **debug**
	passlp = (*calltab[opidx-1])();
//cerr<<" returning opidx "<< opidx<<" is stack ptr "<<is<<endl;
//   we return here after an operator is completed, to set pass flag

if(opidx<14){
//   we return here after a recursive operator, to restore
//   OPPTR, and RPTR from stack and to set pass flag
	--stackPtr; is--;
	opptr=stackPtr->opptr;
	rptr=stackPtr->rptr;
}//if recur
// ---------------------------------------------------------------------

//   If the trace is on  a ) is printed if the operator had an argument,
//   and a + or - is printed to indicate success or failure.

// L250:
	if(tr) {
		if(CSRADDR(opptr)) fill(")");
        	if(passlp) fill("+ ");
        	else fill("- ");
		}//if tr

//   if the last operator succeeded and there are more operators on
//   the list, loop back to execute the next one.
//   otherwise return to the operator which invoked this list

	if(opidx ==EXECUTEOPER && getcontxt) {
		saveEnvironment(stckStart,getcontxt);
		getcontxt=0;
		}

	if(passlp!=TRUE) return passlp ;
	opptr=CDRADDR(opptr);
	if(!opptr) return TRUE;//goto L210
	} // while 
}//end looper

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

void interpInit(void){
routin=symbolCreate((char *) "ROUTINE");
calltab[ANDOPER-1]=AndOper;
calltabstack[ANDOPER-1]=AndStackOper;
calltab[OROPER-1]=OrOper;
calltabstack[OROPER-1]=OrStackOper;
calltab[IMPLYOPER-1]=ImplyOper;
calltabstack[IMPLYOPER-1]=ImplyStackOper;
calltab[NOTOPER-1]=NotOper;
calltabstack[NOTOPER-1]=NotStackOper;
calltab[EXECOPER-1]=ExecOper;
calltabstack[EXECOPER-1]=ExecStackOper;
calltab[CANDOOPER-1]=CandoOper;
calltabstack[CANDOOPER-1]=CandoStackOper;
calltab[ITEROPER-1]=IterOper;
calltabstack[ITEROPER-1]=IterStackOper;
calltab[ITERTOPER-1]=ItertOper;
calltabstack[ITERTOPER-1]=ItertStackOper;
calltab[ITERFOPER-1]=IterfOper;
calltabstack[ITERFOPER-1]=IterfStackOper;
calltab[ITERFTOPER-1]=IterftOper;
calltabstack[ITERFTOPER-1]=IterftStackOper;
calltab[EDITOPER-1]=EditOper;
calltab[COMMONATOPER-1]=CommonatOper;
calltabstack[COMMONATOPER-1]=CommonatStackOper;
calltab[EXECUTEOPER-1]=ExecuteOper;
calltabstack[EXECUTEOPER-1]=ExecuteStackOper;
calltab[STACKOPER-1]=StackOper;
calltab[PRESENTOPER-1]=PresentOper;
calltab[UPONEOPER-1]=UponeOper;
calltab[DOWNOPER-1]=DownOper;
calltab[VALUEOPER-1]=ValueOper;
calltab[LEFTOPER-1]=LeftOper;
calltab[RIGHTOPER-1]=RightOper;
calltab[UPTRNOPER-1]=UptrnOper;
calltab[DNTRNOPER-1]=DntrnOper;
calltab[NELEMOPER-1]=NelemOper;
calltab[WORDLOPER-1]=WordlOper;
calltab[FRSTLOPER-1]=FrstlOper;
calltab[LASTLOPER-1]=LastlOper;
calltab[PREVLOPER-1]=PrevlOper;
calltab[NEXTLOPER-1]=NextlOper;
calltab[TRUEOPER-1]=TrueOper;
calltab[IDENTICALOPER-1]=IdenticalOper;
calltab[ISOPER-1]=IsOper;
calltab[ATTRBOPER-1]=AttrbOper;
calltab[TEXTXOPER-1]=TextxOper;
calltab[EMPTYOPER-1]=EmptyOper;
calltab[NWORDOPER-1]=NwordOper;
calltab[MINWDOPER-1]=MinwdOper;
calltab[PARSEOPER-1]=ParseOper;
calltab[RAREOPER-1]=RareOper;
calltab[SEGMENTOPER-1]=SegmentOper;
calltab[REPOPER-1]=RepOper;
calltab[NODENAMEOPER-1]=NodnameOper;
calltab[HEADOPER-1]=HeadOper;
calltab[SUCCESSORSOPER-1]=SuccessorsOper;
calltab[PREFIXOPER-1]=PrefixOper;
calltab[LOOKATSYMBOLOPER-1]=LookatsymbolOper;
calltab[LOOKATLISTOPER-1]=LookatlistOper;
calltab[TESTFORNILOPER-1]=TestfornilOper;
calltab[MEMBEROPER-1]=MemberOper;
calltab[STOREOPER-1]=StoreOper;
calltab[LOOKOPER-1]=LookOper;
calltab[ASSIGNOPER-1]=AssignOper;
calltab[HASATTOPER-1]=HasattOper;
calltab[ERASEOPER-1]=EraseOper;
calltab[GENEROPER-1]=GenerOper;
calltab[WRITEOPER-1]=WriteOper;
calltab[REPARSEOPER-1]=ReparseOper;
calltab[CREATEOPER-1]=CreateOper;
calltab[COPYOPER-1]=CopyOper;
calltab[CLASSOPER-1]=ClassOper;
calltab[BUILDDOWNOPER-1]=BuilddownOper;
calltab[BUILDRIGHTOPER-1]=BuildrightOper;
calltab[BUILDUPOPER-1]=BuildupOper;
calltab[BUILDWORDOPER-1]=BuildupOper;
calltab[REPLACEOPER-1]=ReplaceOper;
calltab[INSERTBEFOREOPER-1]=InsertbeforeOper;
calltab[INSERTAFTEROPER-1]=InsertafterOper;
calltab[TRANSFORMOPER-1]=TransformOper;
calltab[BUILDWORDOPER-1]=BuildwordOper;
calltab[DEACTIVATEOPER-1]=DeactivateOper;
calltab[GENSYMOPER-1]=GensymOper;
calltab[INTERSECTOPER-1]=IntersectOper;
calltab[INTERSECTCHKOPER-1]=IntersectchkOper;
calltab[UNIONOPER-1]=UnionOper;
calltab[COMPLEMENTOPER-1]=ComplementOper;
calltab[SETLOGSWOPER-1]=SetlogswOper;
calltab[CLEARLOGSWOPER-1]=ClearlogswOper;
calltab[CLEARLOGSWALLOPER-1]=ClearlogswallOper;
calltab[TESTLOGSWOPER-1]=TestlogswOper;
calltab[TOGLOGSWOPER-1]=ToglogswOper;
calltab[SETGLOBSWOPER-1]=SetglobswOper;
calltab[CLEARGLOBSWOPER-1]=ClearglobswOper;
calltab[TESTGLOBSWOPER-1]=TestglobswOper;
calltab[EQUIVMATCHOPER-1]=EquivmatchOper;
calltab[REPARSESWOPER-1]=ReparseswOper;
calltab[CREATEIDIOMOPER-1]=CreateidiomOper;
calltab[EVERYNODEOPER-1]=EverynodeOper;
calltab[GETPREVTREEOPER-1]=GetprevtreeOper;
calltab[SWITCHPREVTREEOPER-1]=SwitchprevtreeOper;
calltab[SWITCHCURTREEOPER-1]=SwitchcurtreeOper;
calltab[COPYPREVTREEOPER-1]=CopyfromprevtreeOper;
calltab[INSERTAFTERPREVTREEOPER-1]=InsertafterprevtreeOper;
calltab[GOTONODEPOINTEDTOOPER-1]=GotonodepointedtoOper;
}//end func interpinit

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

int flag1,flag2, flag3, flag4;// **debug**
int interp(int nodrest, int argres, char * resnamP, int traceFlag){

/*
 Possible returns are:
	0 = Failed restriction
	1 = Restriction/transformation succeeded
	2 = Terminate from a successful EDIT
	4 = Terminate from a successful GENER
	-1 = Too many nodes
	-2 = Too many lines
	-3 = Too much list space used
	-4 = Undefined operator list
	-5 = An array overflow message in output
*/
/*
if((&cout)->fail()){
cerr<<"iofail in interp"<<endl;
}
*/
	int arg=argres;
	tr=traceFlag;
	trctop=traceFlag;
	restrnamP=resnamP;
	nodHousRest=nodrest;
restcnt++;// **debug
	int isvxr7=xr7;
	list=0;
	is=0;
	stackPtr=stack;
	stackingCount=0;
	regInit();
	routineDepth=0;
	newdlp=0;
	lastOptGen=0;
	frstxf=0;
	int newnod=0;
	xfwdsInit();
	ixfwds=0;
	environSavIdx = 0;
	for(int i=0;i<NLOGSW;i++) logsws[i]=0;
	if(ix0=LOOKST((char *) "X0") ) ix0=STADDR(ix0);

	opptr=argres;
/*
----------------------------------------------------------------------
      N O N - D E T E R M I N I S T I C   P R O G R A M M I N G
                      M E C H A N I S M

   The INTERPRETER includes a special operator, STACK, which causes
   a portion of a restriction to be executed repeatedly starting from
   different points in the parse tree.  This operator is designed to be
   used inside routines (operator lists invoked by the EXECUTE operator)
   to simulate the effect of multiply-valued routines, as may occur in
   grammars with conjunction.
        Suppose that when the STACK operator is executed, the restriction
   is looking at node N and is inside a ROUTINE R (if inside several
   nested routines, let R be the most deeply nested, i.e., the one most
   recently entered;  if not inside a routine, the STACK operation has no
   effect).  Execution continues normally until the restriction is finished.
   If the restriction fails, a failure indication is returned to the parser.
   If the restriction succeeds, execution is resumed immediately after
   ROUTINE R, with all registers having the values the had then, but with
   the restriction looking at node N.  If several STACK operators were
   executed, the restriction will be repeatedly backed up and restarted.
   Only if all these executions terminate in success will a success
   indication be returned to the parser.
        Information is passed from STACK to EXECUTE through the stack STKSTK.
   Information is passed from EXECUTE to the restart procedure in the stacks
   NDSTK and SAVED.  The pointer to the top of NDSTK is INDSTK, the pointer
   to the top of SAVED is ISAVED.
        Each entry in NDSTK, NDSTK(I,J), J=1,3, represents one
   restart point.  NDSTK(I,1) points to the node at which execution
   of the restriction or transformation is to be resumed.
   The contents of the main push-down stack, STACK, at the end of
   ROUTINE R are saved in the NDSTK(I,3) entries of SAVED,
   beginning with entry NDSTK(I,2)+1.  In addition to the information
   normally present, the top group of 5 entries on STACK will
   contain the saved values of the variables ISTKST, LCLREG, GBLREG,
   and XDEPTH.  Following the copy of STACK on SAVED are copies of
   REGSTK and STKSTK.  These are organized into groups of 5 elements
   on SAVED, with the fifth element pointing to a node of the parse
   tree if and only if the fourth element = 0 . This organization is
   necessary so that node pointers in SAVED can be properly updated
   by XFIXUP after a transformation.
********************************************************************
*/
flag1=0;// **debug
flag2=0;// **debug
flag3=0;// **debug
/*
if(strcmp("WCONJ9",restrnamP)==0){// **debug
cout<<" we are here at "<<restrnamP<<endl;// **debug
//void treeDraw(int,int);// **debug
printNA(159,"start of WCONJ9");
//treeDraw(1,20);// **debug
//flag2=1;// **debug
}// **debug
*/
/*
{// **debug
extern int ckref(int);// **debug
int ckret=ckref(1);// **debug
if(ckret!=0)cout<<"**Fail ckret failed at start of restric="<<restrnamP<<endl;
else if(flag3)cout<<"**Succeed ckret passed at start of restric="<<restrnamP<<endl;
}// **debug
*/

int	passflg=looper();
	stackstr *unstackPtr;
	while(passflg==TRUE && environSavIdx >0){
// The parse so far has been successful. if no stacking return success.
//cout<<"unstacking***"<<endl;
	int environCurIdx = environSavIdx-1 ;
	int *unsnpt = unstackInfo[environCurIdx].nodeListPtr ;
	int unsnodct = unstackInfo[environCurIdx].numOfNodes;
	xr7 = *(unsnpt+ --unsnodct);
	list=0;
// restore the registers for the branch
	regrestore(unstackInfo[environCurIdx].regSaveId);
	routineDepth=unstackInfo[environCurIdx].rouDepth;
	opptr=unstackInfo[environCurIdx].opptr;
	rptr=unstackInfo[environCurIdx].rptr;

	stackingCount = unstackInfo[environCurIdx].stackCnt;
	int *stp = unstackInfo[environCurIdx].stackSav;
	for(int i=0;i<stackingCount;i++) stkstk[i] = *stp++;

	is = unstackInfo[environCurIdx].recurLenth;
	stackPtr = unstackInfo[environCurIdx].stackPtr;
	stackstr *stdd = unstackInfo[environCurIdx].recurSav;
	for(int ik=0; ik<is; ik++) stack[ik] = *stdd++;

	if((unstackInfo[environCurIdx].numOfNodes=unsnodct) ==0){
		deleteStackingSaves(environCurIdx);
	 	environSavIdx--;
}
{
char nambuf[50];
	if(trctop){
        prntif();
//        skipln();
        fill(" Restriction restarted due to stacking at node ");
char subtext[100];
        fill(nodnam(xr7, subtext));
        fill(" which subsumes "); fill(subsum(xr7,subtext));
        prnt();
	}
}
	//tr=trctop && (fultrc || routineDepth==0);
	tr=trctop ;
	opptr=CDRADDR(opptr);
//if(opptr!=0){ cout<<"doing remainder if ops before backing up"<<endl; }
	if(opptr!=0)passflg=looper();
	while(is>0){
		int restroper = (stackPtr-1)->restroper;
		int callInOper = (stackPtr-1)->callInOper;
//cout<<resnamP<<" recur depth greater than zero.  is= "<<is
//<<" oper = "<<restroper<<" call "<<callInOper<<endl; // ***debug
		passflg = (*calltabstack[restroper-1])(passflg,callInOper);
		is--;stackPtr--;
		opptr = stackPtr->opptr;
		rptr = stackPtr->rptr;
		if(tr) {
			if(CSRADDR(opptr)) fill(" )");
        		if(passflg) fill("+ ");
        		else fill("- ");
			}//if tr
		opptr=CDRADDR(opptr);
		if(opptr)passflg=looper();
		}// while on recursive stack

		}// while on environ set

	if(tr) prntif();
	if(newdlp != 0) {passflg=4; dlp=gcons(newdlp,0,0);}
	if(passflg!=TRUE && environSavIdx>0) clearInterpBufs();
	xr7 = isvxr7;
//if(tr) cout<<"exiting interp "<<resnamP<<endl;// ***debug
	if(passflg == -4)return TRUE; // ** hack remove
/*
{// **debug
extern int ckref(int);// **debug
int ckret=ckref(1);// **debug
if(ckret!=0)cout<<"**Fail ckret failed at end of restric="<<restrnamP<<endl;
else if(flag3)cout<<"**Succeed ckret passed at end of restric="<<restrnamP<<endl;
}// **debug
*/
	return passflg;
} // end of interp

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

void clearInterpBufs(){
	for(int i=0; i<environSavIdx; i++){
		if(unstackInfo[i].numOfNodes>0)
			deleteStackingSaves(i);
		}//for
	regsaveclear();
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

/*
      L O G I C A L   AND   C O N T R O L   O P E R A T O R S

	AND [(Y1[F1], Y2[F2], ..., Yn[Fn])]
		1. for i=1 to n repeat steps 2 to 4; return TRUE
		2. execute Yi
		3. if Yi fails, return FALSE
		4. if Fi=NIL, go to starting position
*/

int AndStackOper(int retin,int entPoint){  
	int rptmp, ret;
	if(retin != TRUE) return retin;
	if(!(rptmp = CDRADDR(rptr))) return TRUE;
	if(!CSRADDR(rptr)) { restore(); }
	rptr = rptmp;
	for (;;){
		opptr = CARADDR(rptr);
		if((ret = looper())!=TRUE) return ret;
		if(!(rptmp = CDRADDR(rptr))) return TRUE;
		if(!CSRADDR(rptr)) { restore(); }
		rptr = rptmp;
		}//for
}

int AndOper(){  
	int rptmp, ret;
	push(ANDOPER);
	while (1){
		opptr=CAR(rptr);


		if((ret=looper())!=TRUE) return ret;
		if(!(rptmp=CDRADDR(rptr))) return TRUE;
		if(!CSRADDR(rptr)) { restore(); }
		rptr=rptmp;
		}//while 
	return TRUE; // JR fixed undefined return value
}

/*
   OR [(Y1, Y2, ..., YN)]
                1. For i=1 to N repeat steps 2 to 4; return FALSE
                2. Execute Yi
                3. If Yi succeeds, return TRUE
                4. Go to starting position
*/

int OrStackOper(int retin,int entPoint){
	int ret;
	if(retin!=FALSE) return retin;
	if(!CDRADDR(rptr)) return FALSE;
restore();
	rptr=CDRADDR(rptr);

	while(1){
		opptr=CAR(rptr);
	if((ret=looper())!=FALSE) return ret;
	if(!CDRADDR(rptr)) return FALSE;
restore();
	rptr=CDRADDR(rptr);
	}// while
}

int OrOper(){
	int ret;
	push(OROPER);
	while(1){
		opptr=CAR(rptr);


	if((ret=looper())!=FALSE) return ret;
	if(!CDRADDR(rptr)) return FALSE;
restore();
	rptr=CDRADDR(rptr);
	}// while 
	return TRUE; // JR fixed undefined return value
}

/*
	 IMPLY [(Y1[F],Y2)]
 		1. Execute Y1
 		2. If Y1 fails go to starting position and return TRUE
 		3. If F=NIL go to starting position
 		4. Execute Y2
		5. if Y2 succeeds, return TRUE; if Y2 fails, return FALSE

	 IMPLY [(Y1[F],Y2,Y3)]
 		1. Execute Y1
 		2. If Y1 fails go to starting position and go to 6
 		3. If F=NIL go to starting position
		4. Execute Y2
		5. If Y2 succeeds, return TRUE; If Y2 fails, return FALSE
		6. Execute Y3
		7. If Y3 succeeds, return TRUE; if Y3 fails, return FALSE
*/

int ImplyStackOper(int retin,int entPoint){
	if(entPoint>0)return retin;
	if(retin != TRUE){ //exec Y1 
restore();
	if(retin != FALSE)return retin;
//       If Y3 is not present, return TRUE
	if(!CDRADDR(CDRADDR(rptr))) return TRUE;

//       Execute Y3
        opptr=CARADDR(CDRADDR(CDRADDR(rptr)));
}
	else {
		if(!CSRADDR(rptr)) restore();

//       Execute Y2
		opptr=CARADDR(CDRADDR(rptr));
		}
	pushmod(1);
	return looper(); // do Y2 or Y3 as appropriate
}

int ImplyOper(){
	int ret;

	push(IMPLYOPER);
	opptr=CARADDR(rptr);


	if((ret = looper()) != TRUE){//exec Y1 
restore();
		if(ret != FALSE)return ret;

//       If Y3 is not present, return TRUE
		if(!CDRADDR(CDRADDR(rptr))) return TRUE;

//		Execute Y3
        	opptr=CARADDR(CDRADDR(CDRADDR(rptr)));
		}
	else {
		if(!CSRADDR(rptr)) restore();

//       Execute Y2
		opptr=CARADDR(CDRADDR(rptr));
		}


	pushmod(1);
	return looper();
}

/*
   NOT [Y]
                1. Execute Y
                2. If Y fails, go to starting position and return TRUE;
                   If Y succeeds, exit -
*/

int NotStackOper(int retin, int entPoint){
restore();
	if(retin==FALSE) return TRUE;
	else return retin;
}

int NotOper(){
	int ret;

	push(NOTOPER);
	opptr = rptr;


	if((ret=looper())==TRUE) return FALSE;
restore();
	if(ret==FALSE) return TRUE;
	else return ret;
}

/*
	EXEC [Y]
		1. Execute Y
		2. If Y succeeds, return TRUE; If Y fails, return FALSE
*/

int ExecStackOper(int retin, int entPoint){
	return retin;
	}

int ExecOper(){

	int arglst;
	push(EXECOPER);
	opptr = rptr;
	if((CSRINT(rptr)&(HEAD|REGBIT)) == (HEAD|REGBIT)) {
		getreg(rptr,&opptr,&arglst);
        	if(arglst != 1)return TRUE;
		}
	if(ATOMP(opptr))opptr = CDR(opptr);

	return looper();
}

/*
   CANDO [Y]
                1. Execute Y
                2. Go to starting position
                3. If Y succeeded, return TRUE; 
 		       If Y failed, return FALSE

*/

int CandoStackOper(int retin, int entPoint){
	restore();
	return retin;
	}

int CandoOper(){
	int passflg;

	push(CANDOOPER);
	opptr = rptr;
	if(ATOMP(opptr))opptr = CDR(opptr);


	passflg=looper();
	restore();
	return passflg;
}

/*
   ITER [(Y)]
	1. Execute Y
 	2. If Y fails, return FALSE
	3. Execute Y
	4. If Y fails, go to position prior to last execution
	   of Y and return TRUE;  If Y succeeds, go to step 3

  ITER [(Y1,Y2)]
	1. Execute Y1
	2. If Y1 fails, return FALSE
	3. Execute Y2
	4. If Y2 succeeds, return TRUE
	5. Go to position prior to last execution of Y2 and go to step 1
*/

int IterStackOper(int retin, int entPoint){
	int ret;
	switch(entPoint){
	case 0:
	case 1:
	if(entPoint == 0)
		if(retin != TRUE) return retin;
	else
		if(retin != TRUE) {restore(); return retin;}

	while(1){
		pushmod(0);
		opptr=CARADDR(rptr);
		savepos();
		pushmod(1);
		if((ret = looper()) != TRUE){
			restore();
			if(ret==FALSE) return TRUE;
			else return ret;
			}
		}//while

	case 2:
	case 3:
	if(entPoint==2){
	if(retin != TRUE) return retin;
	savepos();
	opptr = CARADDR(CDRADDR(rptr));
		pushmod(3);
	if((ret = looper()) != FALSE) return ret;
	}
	else {
	if(retin != FALSE) return retin;
		}
	restore();

	while(1){
		opptr=CARADDR(rptr);
		pushmod(2);
		if((ret = looper()) != TRUE) return ret;
		savepos();
		opptr=CARADDR(CDRADDR(rptr));
		pushmod(3);
		if((ret = looper()) != FALSE) return ret;
		restore();
		}//while
	}// end of switch
	return TRUE; // JR fixed undefined return value
}

int IterOper(){
	int ret;

	push(ITEROPER);
	if(!CDRADDR(rptr)){// goto L370;
// one argument
	opptr = CARADDR(rptr);


	if((ret = looper()) != TRUE) return ret;
//364
	while(1){
		opptr = CARADDR(rptr);
		savepos();

		pushmod(1);
		if((ret = looper()) != TRUE){
			restore();
			if(ret == FALSE)return TRUE;
			else return ret;
			}
		}//while
	} //if one argument

//370 
// two arguments
	while(1){
		opptr = CARADDR(rptr);

		pushmod(2);
		if((ret = looper()) != TRUE) return ret;
		savepos();

//375
		opptr = CARADDR(CDRADDR(rptr));

		pushmod(3);
		if((ret = looper()) != FALSE) return ret;
		restore();
		}//while
	return TRUE; // JR fixed undefined return value
}

/*
   ITERT [(Y1,Y2)]
	1. Execute Y2
	2. If Y2 succeeds, return TRUE
	3. Go to position prior to last execution of Y2
	4. Execute Y1
	5. If Y1 fails, return FALSE ; else go to step 1
*/

int ItertStackOper(int retin, int entPoint){
	int ret;
	ret=retin;
	if(entPoint==0){
		if(ret != FALSE) return ret;
		if((ret = looper()) != FALSE) return ret;
restore();
		opptr = CARADDR(rptr);
		pushmod(1);
		ret = looper();
		}
	if(ret != TRUE) return ret;

	while (1){
		pushmod(0);
		savepos();
		opptr = CARADDR(CDRADDR(rptr));
		if((ret = looper()) != FALSE) return ret;
restore();
		opptr = CARADDR(rptr);
		pushmod(1);
		if((ret = looper()) != TRUE) return ret;
		} // while
	return TRUE; // JR fixed undefined return value
}
int ItertOper(){
	int ret;

	push(ITERTOPER);
//      GO TO 375
	while (1){
		savepos();
		opptr = CARADDR(CDRADDR(rptr));

		if((ret = looper()) != FALSE) return ret;
restore();
		opptr = CARADDR(rptr);

		pushmod(1);
		if((ret = looper()) != TRUE) return ret;
		pushmod(0); 
		} // while
	return TRUE; // JR fixed undefined return value
}

/*
   ITERF [(Y1,Y2)]
	1. Execute Y1
	2. If Y1 fails, return FALSE
	3. Execute Y2
	4. If Y2 succeeds, go to step 1
	5. Go to position prior to last execution of Y2 and return TRUE
*/

int IterfStackOper(int retin, int entPoint){
	int ret = retin;
	if(entPoint==0){
		if(ret != TRUE) return retin;
		savepos();
		opptr = CAR(CDRADDR(rptr));
		pushmod(1);
		ret = looper() ;
		}
	if(ret != TRUE) {
restore();
		if(ret==FALSE) return TRUE;
		else return ret;
		}

	do{
		opptr = CARADDR(rptr);
		pushmod(0);
		if((ret = looper()) != TRUE) return ret;
		savepos();
		opptr = CAR(CDRADDR(rptr));
		pushmod(1);
		} while((ret = looper()) == TRUE) ;

restore();
                if(ret==FALSE) return TRUE;
	return TRUE; // JR fixed undefined return value
}


int IterfOper(){
	int ret;
	push(ITERFOPER);

//391
	do{
		opptr = CARADDR(rptr);

		pushmod(0);
		if((ret = looper()) != TRUE) return ret;
		savepos();

//395
		opptr = CAR(CDRADDR(rptr));

		pushmod(1);
		} while((ret = looper()) == TRUE) ;

restore();
	if(ret==FALSE) return TRUE;
	else return ret;
}

/*
   ITERFT [(Y1,Y2)]
	1. Execute Y2
	2. If Y2 fails, go to position prior to last execution of
	   Y2 and return TRUE
	3. Execute Y1
	4. If Y1 fails, return FALSE
	5. Go to step 1
*/

int IterftStackOper(int retin, int entPoint){
	int ret;
	if(entPoint==0){
		if(retin != TRUE) {
			restore();
			if(retin == FALSE) return TRUE;
			else return retin;
			}
		opptr = CARADDR(rptr);
		pushmod(1);
		if((ret = looper()) != TRUE) return ret;
		}
	else if(retin != TRUE) return ret;

	while(1){
		pushmod(0);
		opptr = CARADDR(CDRADDR(rptr));
		savepos();
		if((ret = looper()) != TRUE) {//
			restore();
			if(ret == FALSE) return TRUE;
			else return ret;
			}
		opptr = CARADDR(rptr);
		pushmod(1);
		if((ret = looper()) != TRUE) return ret;
		} //while
	return TRUE; // JR fixed undefined return value

}

int IterftOper(){
	int ret;

	push(ITERFTOPER);

//GO TO 395
//395
	while(1){
	opptr = CARADDR(CDRADDR(rptr));
	savepos();

	if((ret = looper()) != TRUE) {//
restore();
	if(ret == FALSE) return TRUE;
	else return ret;
	}
	opptr = CARADDR(rptr);

	pushmod(1);
	if((ret = looper()) != TRUE) return ret;
	pushmod(0);
	} //while
	return TRUE; // JR fixed undefined return value
}

/*
   EDIT [Y]
	This operator should appear only in a disqualify
	restriction housed on the first option of a
	definition. Only the the first restriction housed on
	the first option may contain EDIT operators, since if
	the first option was selected by the EDIT the first
	restriction will be eliminated from the edited
	definition.If the current definition has N options,
	EDIT will generate a new option list L as follows:

	1. For I=1 to N repeat steps 2 to 4;  go to step 5
	2. Look at the first element of the i th option
	3. Execute Y
	4. If Y succeeds, add the I th option to the end of L
	5. Go to starting position
	6. If L is empty, place the first (current) option L and return FALSE
	7. Replace the original option list by L and return 2

        If this operator is executed more than once in a sequence of
	restrictions on one option, the option list edited by the operator
	will be the list produced by the previous execution of the operator
*/

int EditOper(){

//cout<<"doing a EDIT "<<dlp; // **debug
	int newlst, newopt,iopt, last=0, opcnt=0;
	push(EDITOPER);
	newlst=0;
	iopt=dlp;	
//412
	do { xr7=CAR(iopt);
	list=1;
	opcnt++;
	opptr=rptr;
	if(tr) {
        	prnt();
        	fill("Option ") ;
        	fill(STNAME(CAR(CAR(xr7)))) ;
        	fill(":  ") ;
		}

	if(looper()) {
        newopt=gcons(0,CSR(iopt),CAR(iopt));

// The first option was selected for the new definition. Eliminate the
// first restriction from this option in the original definition.

	if(opcnt==1)CSR(newopt)=CDRADDR(CSR(newopt));
        if(!newlst) newlst=newopt;
        else CDRADDR(last)=newopt;
        last=newopt;
	}
	}while(iopt=CDRADDR(iopt));// if(iopt) goto L412;
restore();
	if(newlst) {
		dlp=gcons(newlst,0,0);
		elemt=CARADDR(CARADDR(dlp));
		if(tr)fill(") +");
		return 2;
		}
	dlp=gcons(0,CSR(dlp),CAR(dlp));
//	if(dlp <= 0)go to 9999
	return FALSE;
}

/*
   COMMONAT [(Y1,Y2)]
	 1. execute Y1
	 2. if Y1 fails, return FALSE
	 3. execute ATTRB [NIL]
	 4. if attrb fails, return FALSE
	 5. Let A = current list
	 6. Go to starting position
	 7. Execute Y2
	 8. If Y2 fails, return FALSE
	 9. execute ATTRB [NIL]
	10. If ATTRB fails, return FALSE
	11. If list A and the current list have a common element,
	    return TRUE;  else return FALSE
*/

int CommonatStackOper(int retin, int entPoint){
	return TRUE;
}
int CommonatOper(){
	int ret;

	push(COMMONATOPER);
	opptr = CARADDR(rptr);

	if((ret = looper())!=TRUE) return ret;
	if(!attrb(0)) return FALSE;
int     iqxr7 = xr7;
restore();
	opptr = CARADDR(CDRADDR(rptr));

	if((ret = looper())!=TRUE) return ret;
	if(!attrb(0))return FALSE;
	return (s7(iqxr7)!=0);
	} // end of func
/*
   EXECUTE [(Y[(Z1 Z2 ...)])]
                The basic function of this operator is to execute
                routine Y with argument Z1 Z2 ....  (There may be
                zero or more arguments).  It returns + if Y succeeds
                and returns - if Y fails.

                  A routine should have the form
                    (Routine parameters local-variables code)
                where:
                     parameters is a list of zero or more local
                variables Vi, each of which is a register. The number
                of arquments must exactly match the number of parameters.

                    There is a special operator trace format for this
                    operator. THe routine name and argument are printed
                    when the routine is invoked, and if the routine
                    succeeds and the new current position is a node, The
                    name of the node and the words it subsumes are printed
                    Unless fultrc=TRUE, the operator trace is suspended
                    inside the routine

                    If the routine terminates successfully, then
                      for each call to STACK made inside this routine
                      (but not inside routines called by this
                      ROUTINE), AN ENTRY IS MADE, WHEN THE ROUTINE IS
                      COMPLETED, IN THE STACK OF RESTART POINTS FOR
                      THE NON-DETERMINISTIC PROGRAMMING MECHANISM.

                      EACH CALL TO STACK ADDS AN ENTRY TO THE STKSTK
                      STACK, CONTAINING THE POSITION WHICH WAS
                      CURRENT WHEN THE STACK OPERATOR WAS EXECUTED
                      (ONLY THE VALUE OF xr7 IS SAVED; SINCE STACK
                      WILL FAIL UNLESS LOOKING AT A Node, LIST=0).
                      BEFORE THE ROUTINE IS INVOKED, EXECUTE SAVES
                      THE POINTER TO THE TOP OF STKSTK, ISTKST.  IF
                      THE ROUTINE IS SUCCESSFUL AND ENTRIES HAVE BEEN
                      ADDED TO STKSTK, CORRESPONDING ENTRIES ARE MADE
                      IN THE NON-DETERMINISTIC MECHANISM STACK,
                      NDSTK.  THE FORMAT OF ENTRIES IN NDSTK IS GIVEN
                      ABOVE.  THE NEW ENTRIES IN STKSTK ARE THEN
                      REMOVED.
*/

int ExecuteStackOper(int retin, int entPoint){
	return TRUE;
}
int ExecuteOper(){
int 	stackingCountAtStart=stackingCount;

	push(EXECUTEOPER);
//                           Save pointer to top of STKSTK and local
//                           register pointer on stack.
	int y=CARADDR(rptr);
	rptr=CSRADDR(rptr);
	routineDepth++;
//        If trace is on, print routine name and argument list
	if(tr) {
        	plistnn(y,FALSE,PRUNIT);
        	if(rptr) plistnn(rptr,FALSE,PRUNIT);
		tr = tr && fultrc;
		if(tr){
        		fill(":  ");
			prntif();
			setIndent(routineDepth*ROUTINEINDENT);
        		tr = 1;
			}//if
		}//if tr

//	Check validity of structure of of routine Y, and 
// 	and extract parameter list, local variable list, and code

int params,param, argxr7,arglst,locals,passfl;
int r;// r is the routine pointer
	if((r = CDRADDR(y))) {
		if(CARADDR(r) != routin) r=0;
		else {// name is ROUTINE
			if((r = CDRADDR(r))){
				params = CAR(r);//parameter list
				if((r = CDRADDR(r))){
					locals = CARADDR(r);
					opptr = CDRADDR(r);
					}//if
				}// if
			}//else
		}//if
	if(!r)return execuErrm(1, CAR(y));

// We first collect the arguments of the call. Some of these arguments may
// be local registers and must be extracted from the current set of local
// registers. They must be stored in local variables with the name given
// in the parameter set of the called routine. But before they are stored
// the local register context must be switched.

//		Assign values to routine parameters

	struct { int xr7; int list;} routarg[8];
	int num_of_args = 0;
	while(rptr){
		if(!rptr) return execuErrm(2, CAR(y));
		int arg=CAR(rptr);

//	Get arguments in the call 
		if(ATOMP(arg)){  // Evaluate argument
//                       If argument is a register, get its value
        		if((CSRINT(arg)&REGBIT)) getreg(arg,&argxr7,&arglst);

//                      If argument is a symbol other than a register
//                      (presumably the name of a list), get its value
        		else { argxr7=CDRADDR(arg); arglst=1; }

			}//if

//               If argument is a list, use the list itself
		else { argxr7 = arg; arglst=1; }

		routarg[num_of_args].xr7 = argxr7;
		routarg[num_of_args++].list = arglst;

		rptr=CDRADDR(rptr);// next argument in call
		}//while

	int i_arg=0;
	reg_local_push();//change local context
	while(params){
		if(i_arg == num_of_args) return execuErrm(2, CAR(y));
		param=CARADDR(params);

	// parameters must be registers
		if((CSRINT(param)&(HEAD|REGBIT)) != (HEAD|REGBIT))
			return execuErrm(1, CAR(y));

// the arguments in the call are converted to local registers
        	newlocalreg(param,routarg[i_arg].xr7, routarg[i_arg].list);
		i_arg++;

		params=CDRADDR(params);//get next param in called routine
		}// while

	if(i_arg != num_of_args)return execuErrm(3, CAR(y));//too many in call
/*
//		Assign values to routine parameters
	while(params){
		if(!rptr) return execuErrm(2, CAR(y));
		int arg=CAR(rptr);
		param=CARADDR(params);

	// parameters must be registers
		if((CSRINT(param)&(HEAD|REGBIT)) != (HEAD|REGBIT))
			return execuErrm(1, CAR(y));
// the arguments in the call are converted to local registers
		if(ATOMP(arg)){  // Evaluate argument
//                        If argument is a register, get its value
        		if((CSRINT(arg)&REGBIT)) getreg(arg,&argxr7,&arglst);

//                       If argument is a symbol other than a register
//                       (presumably the name of a list), get its value
        		else { argxr7=CDRADDR(arg); arglst=1; }

			reg_local_push();
        		newlocalreg(param,argxr7,arglst);
			}//if

//		If argument is a list, use the list itself
		else {
			reg_local_push();
			newlocalreg(param,arg,1);
			}

		rptr=CDRADDR(rptr);// next argument in call
		params=CDRADDR(params);//get next param in called routine
		}// while

//L520:
	if(rptr) return execuErrm(3, CAR(y));
*/

// 			Create local variables
//525
	while(locals){
		int v=CAR(locals);

		if((CSR(v)&(HEAD|REGBIT)) != (HEAD|REGBIT))
			return execuErrm(1, CAR(y));// goto L580;
		newlocalreg(v,0,0);
		locals=CDR(locals);
		}// while goto 525

// Exexute the routine
	//if(routineDepth==1) testtimes.timeRoutineStart(); JR removed timing code
	passfl=looper();
//                -- Return here after executing routine --
	if(tr) {
		if(passfl!=TRUE) prtloc(); // If trace is on, print node reached
		if(fultrc){
			prntif();
			setIndent((routineDepth-1)*ROUTINEINDENT);
			}
		}
	reg_local_pop();
	if(!(--routineDepth)) tr=trctop; // restore trace flag if routines done
	if(restiming){
	  //if(!routineDepth) testtimes.timeRoutineEnd(); JR removed timing code
		}

//540
	if(passfl != TRUE) {
	stackingCount=stackingCountAtStart;
	return passfl;
	}
//                        If STACK not called inside this routine return,
	if(stackingCountAtStart==stackingCount) return TRUE;

//  Save the set of nodes in the STACKing request array which was
//  added during the execution of the last routine
//  and the index of the save information of the current environment.

	stckStart = stackingCountAtStart;
	getcontxt = stackingCount;
	stackingCount = stackingCountAtStart;
// *				SAVE STACK, REGSTK AND STKSTK ON SAVED
// *				(NOTE THAT SAVED IS STRUCTURED IN GROUPS
// *				OF 5 ENTRIES, WITH THE FOURTH ENTRY = 0
// *				IF THE FIFTH ENTRY POINTS TO A Node
// *				[JUST AS STACK IS STRUCTURED] SO THAT
// *				XFIXUP CAN UPDATE DAVED PROPERLY AFTER
// *				A TRANSFORMATION)
//      is--;
	return TRUE;
	}

int execuErrm(int type, int sti){
//L580:
	prntif();
	switch(type){
	case 1:
	*coutP<< "\nError in structure of routine "<<STNAME(sti)<<endl;//,PNAME(Y)
	break;
//L582:
	case 2:
        *coutP<<"\nToo few arguments in call on routine "<<STNAME(sti)<<endl;//,PNAME(Y)
	break;
//L583:
	case 3:
      *coutP<<"\nToo many arguments in call on routine "<<STNAME(sti)<<endl;//, PNAME(Y)
	break;
	}
	exitr(16, "quitting");
	return 0;
}

/*
   STACK
		If not looking at a node, exit -;  if looking at a
                node, SAVE CURRENT POSITION ON STKSTK AND return TRUE.
                This operator should only be executed inside of a
                ROUTINE.  When the ROUTINE is finished, EXECUTE will
                convert the entry on STKSTK TO AN ENTRY ON NDSTK.
                THIS WILL EVENTUALLY CAUSE THE NON-DETERMINISTIC
                PROGRAMMING MECHANISM TO RESUME EXECUTION AT THE END
                OF THE ROUTINE WHILE LOOKING AT THE POSITION CURRENT
                WHEN THE STACK OPERATOR WAS EXECUTED.
*/

int StackOper(){
stkent++;
	if(list) return FALSE;
	if(stackingCount >= STACKREQUESTSIZE) {
		*coutP<<"  ***Stack request array overflow***"<<endl;
		longJumpErr(LJR_STACKREQOVER);
		}
	stkstk[stackingCount++] = xr7;
	return TRUE; // JR: added 12/5
#if 0
char nbf[35]; // **debug
cout<<"\nrequest stacking in "<<restrnamP<<" for node "<<nodnam(xr7,nbf)
<<" routine depth "<<routineDepth<<endl;// **debug
	return TRUE;
#endif
}

//       T R E E   M O T I O N   O P E R A T O R S

// *   PRESENT
// *		no-operation, included for operator trace,returns TRUE
   
int PresentOper(){
	if(tr) fill(" ELEMENT");
	return TRUE;
}

// *   UPONE
// *		1. If not looking at a node, return FALSE
// *		2. If at root node, return FALSE
// *		3. Go to node above current node and return TRUE

int UponeOper(){
//610 
	return oupone(); //GO TO 250
}

/*
   DOWN
		1. if not looking at a node, return FALSE
		2. If there are no nodes below current node, return FALSE
		3. Go to leftmost node below current node and return TRUE
*/
int DownOper(){

	return odown();
}

// *   VALUE
// *                Synonymous with down, included for operator trace

int ValueOper(){
	return odown();// GO TO 250
}

// *   LEFT
// *                1. If not looking at a node, return FALSE
// *                2. If at first-in-level node, return FALSE
// *                3. Go to node to left of current node, return TRUE

int LeftOper(){
	if(list) return FALSE;
	return oleft();
}

// *   RIGHT
// *                1. If not looking at a node, return FALSE
// *                2. If at rightmost node in a level, return FALSE
// *                3. Go to node to right of current node, return TRUE

int RightOper(){

	if(list) return FALSE;
	return oright();
}

// *   UPTRN [(A1,A2,A3)]
// *                1. If not looking at a node, return FALSE
// *                2. If at the root node, return FALSE
// *                3. Go to node above current node
// *                4. If current node IS on A1, return TRUE
// *                5. If current node is on A3, return FALSE
// *                6. If current node is not on string list or is on
// *                   A2, go to step 2;  else return FALSE

int UptrnOper(){

	if(list) return FALSE;
	return uptrn(CSR(opptr));// GO TO 250
}
//	if(CSRINT(opptr));// GO TO 250 what is this
//}

/*
   DNTRN [(A1,A2,A3)]
                If not looking at a node, return FALSE, else
                perform a breadth-first, left to right search of the
                subtree below the current node, excluding any nodes
                which are below nodes in the subtree which are on A3,
                or are on the string list but not on A2. If A node is
                found which is on A1, go to that node and return TRUE.
                otherwise go to starting position and return FALSE.
*/

int DntrnOper(){

	if(list) return FALSE;
	return dntrn(CSRADDR(opptr));// GO TO 250
}

// *   NELEM [N]
// *		go to the nth non-special process daughter node:
// *		1. execute down operator;  if it fails, exit -
// *		2. if not at a special process node, set N=N-1
// *		3. if N=0, return TRUE
// *		4. execute RIGHT operator;   if it fails, return FALSE,
// *		   if it succeeds, go to step 2

// *   NELEM [(N[A])]
// *		go to the Nth daughter node named A
// *		1. execute DOWN operator; if it fails, return FALSE
// *		2. if name of current node is on A, set N=N-1
// *		3. if N=0, return TRUE
// *		4. execute RIGHT operator; if it fails, return FALSE;
// *		   if it succeeds, go to step 2

int NelemOper(){

	int n,lswth, ln, pass, arg;
//680
	arg=CSRADDR(opptr);
	lswth=NUMBRP(arg);
	if(!lswth){
// *            second form of argument list
        	n=CDRADDR(CAR(arg)); ln=CSRADDR(arg);
	}
	else n = CDRADDR(arg);
	pass = odown();
//685
	while(pass){
	if(lswth) { if(!NDSPNT(xr7)) n--;}
	else {if(nodtst(ln)) n--;}
	if(!n) return TRUE;//GO TO 250
	pass= oright();
	}// GO TO 685
	return FALSE;
}

// *      S E N T E N C E   M O T I O N   O P E R A T O R S

// *   WORDL
// *                1. if all sentence words have been matched by nodes
// *                   in the parse tree, return FALSE
// *                2. go to the pending sentence word and return TRUE

int WordlOper(){

//700
	if(word>nword) return FALSE;
	xr7=word;
	list=2;
	return TRUE;
}

// *   FRSTL
// *                1. if not looking at a node, return FALSE
// *                2. go to the sentence word which was pending when
// *                   the current node was created and return TRUE

int FrstlOper(){

//710
	if(list) return FALSE;
	xr7=NDWPNC(xr7);
	list = 2;
	return TRUE;
}

// *   LASTL
// *                1. if not looking at a node, return FALSE
// *                2. if current node is incomplete, go to pending word
// *                   and return TRUE
// *                3. go to word which was pending when the current node
// *                   was completed and return TRUE

int LastlOper(){

//720
	if(list) return FALSE;
	list=2;
	if((xr7=NDWPCP(xr7))==0) xr7=word;
	return TRUE;
}

/*
   PREVL
                1. if not looking at a sentence word, return FALSE
                2. if looking at the first sentence word, return FALSE
                3. go to the previous sentence word and return TRUE
*/

int PrevlOper(){
//730
	if(list != 2) return FALSE;
	if(xr7 == wordstart) return FALSE;
	while((SENTE6(--xr7)==0)); 
	return TRUE;
}
/*
   NEXTL
                1. if not looking at a sentence word, return FALSE
                2. if looking at the last sentence word, return FALSE
                3. go to the following sentence word and return TRUE
                   for this operator an idiom is treated as a
                   single unit of motion
*/

int NextlOper(){

//740
	if(list != 2) return FALSE;
	if(xr7+SENTE6(xr7) > wordend)return FALSE;
	xr7 += SENTE6(xr7);
	return TRUE;
}

// *      T E S T   O P E R A T O R S

// *   TRUE
// *                1. return TRUE

int TrueOper(){
//  800 GO TO 271

	return TRUE;
}

// *   IDENTICAL [X]
// *            1. If register X has not been assigned a value,
// *                return FALSE
// *            2. If the value of X is identical to the current
// *                position, return TRUE, else return FALSE
//805
int IdenticalOper(){

	int ilist, ixr7;
	getreg(CSR(opptr),&ixr7,&ilist);
	if(ixr7 == xr7 && ilist == list)return TRUE;
	return FALSE;
}
/*
   IS [A]
                1. If looking at a node and the node is a member of
                   A, return TRUE
                2. If looking at a list element and the element is a
                   member of A
                3. If looking at a word,
                    If A is a list, search the category list of the
                      current word for a category which is a member
                       return TRUE
                    if A is a register and points to the current
                       word, return TRUE
                4. Else return FALSE
*/

//810
int IsOper(){

      return (isit(CSR(opptr))!=0);
}

/*
   ATTRB [A]
                1. If looking at a node:
                    If node is not atomic or has no attribute list,
                       return FALSE; else look at attribute list and
                       go to step 4
                2. If looking at a list element:
                    if element has no attribute list, return FALSE;
                       else look at attibute list and go to step 4
                3. If looking at a sentence word:
                    If word has no category list then return FALSE;
                       else look at category list and go to step 4
                4. If  A=NIL or A=(ANYTHING), return TRUE
                5. Search the current list for an element which is a member
                   of A; if one is found, look at that element and return
                   TRUE, else go to starting position and return FALSE
*/

//820
int AttrbOper(){

	return (attrb(CSR(opptr))!=0);// GO TO 250
}

/*
   TEXTX [(L1,L2,L3,...)]
                1. if looking at a node,
			node must be atomic and subsume one
                           word or idiom, else return FALSE
                   if the word or idiom pending when this node was
                     created=L1 (or L1_L2_L3 etc), then return TRUE, else
                2. if looking at a list element,
                     if this element has an attribute=L1, then look at
			 that attribute and return TRUE, else return FALSE
                3. if looking at a sentence word,
                    if the word=L1 or if an idiom and = L1_L2_..
                    then return TRUE, else return FALSE
*/
int TextxOper(){

int arg,i,texlen,iw,l;
	arg=CSR(opptr);
	texlen=length(arg);
	if(list == 1){ // a list
		if(texlen != 1) return FALSE;
		i=search(CSR(xr7),arg);
		if(!i) return FALSE;
		xr7=i;
		return TRUE;
		}
	if(!list){ // a node
        	if(!NDATMT(xr7)) return FALSE;//not atomic
        	iw=NDWPNC(xr7);
        	l=NDWPCP(xr7);
        	if(l-iw != texlen) return FALSE;
        	i=iw;
		}

	else i=xr7; // sentence word

	if(SENTE6(i) != texlen) return FALSE;
	for(int ii=1;ii<=texlen;ii++){
		if(strcasecmp(SENTE1(i), STNAME(CAR(CAR(arg)))))return FALSE;
		i++;
 		arg=CDR(arg);
		}
	return TRUE;
}

/*
   EMPTY
              1. If not looking at a node, return FALSE.
              2. If the current node is complete and subsumes no
                 words, return TRUE.
              3. If the current node is incomplete and the pending
                 word is the word which was pending when the node
                 was attached, return TRUE.
              4. Else return FALSE.
*/

int EmptyOper() {

	if(list) return FALSE;
	return empty();// GO TO 250
}

// *   NWORD [N]
// *                1. If there are at least N words in the sentence
// *                   following the pending word, return TRUE; 
// *                   otherwise return FALSE.

// *       it is necessary to determine the number of words
// *       remaining in the sentence where an idiom counts
// *       as one word

int NwordOper(){

	int nwrm,ii;
	nwrm=0;
	ii=word;
	do {ii += SENTE6(ii);
	nwrm++;
	}while(ii < nword); 
	return (CDR(CSR(opptr)) < nwrm) ;// GO TO 250
}

/*
   MINWD
                If the pending word is the MINWORD,
		return TRUE; else return FALSE
*/

int MinwdOper(){
	int pass;
return 0;
#if 0
	pass= (word == minwd);
	if(parlim != 1) TOSAVE=1
	return pass;//GO TO 250
#endif
}

// *   PARSE
// *                If a parse has already been obtained, return TRUE,
// *                else return FALSE

//870
int ParseOper(){

return FALSE;
#if 0
	if(parlim !=1 && !par) tosave=1;
	return par;// GO TO 250
#endif
}

// *   RARE
// *                If the rare switch is on, return TRUE; else return FALSE
int RareOper(){

	return rarsw;
}

int SegmentOper(){

return FALSE;//fix
#if 0
// *   SEGMENT
// *          If the segment switch is on, return TRUE;  else return FALSE

//885
	return SEGSW;// GO TO 250
#endif
}

// *   REP
// *          If the REP switch is on, return TRUE;  else return FALSE

//890
int RepOper(){

return TRUE;
#if 0
	return REPSW;// GO TO 250
#endif
}

// *			L I S T  O P E R A T O R S

// *                 Error messages for list operators

static const char *msgNotList= "   Not at a LIST element **";
static const char * msgAtSymLit="** At a Symbol/Literal/NIL **";

/*
   NODENAME
                1. If not looking at a node, return FALSE.
                2. Look at the symbol or literal head which is
                   the name of the current node and return TRUE.
*/

int NodnameOper(){

	if(!list) return FALSE;
	xr7=NDHDBA(xr7);
	list=1;
	return TRUE;
}

/*
   HEAD
            1. If not looking at a list element, return FALSE
            2. If looking at a symbol, literal, or NIL, return FALSE
            3. Look at head of current list element and return TRUE
*/

int HeadOper(){

	if(list != 1){ if(tr) fill(msgNotList); return FALSE; }
	if(ATOMP(xr7)) { if(tr) fill(msgAtSymLit); return FALSE; }
	xr7=CAR(xr7);
	return TRUE;
}

// *   SUCCESSORS
// *                1. If not looking at a list element, return FALSE
// *                2. If looking at a symbol, literal, or NIL, return FALSE
// *                3. Look at successors of current list element and
// *                   return TRUE

int SuccessorsOper() {

	if(list != 1){ if(tr) fill(msgNotList); return FALSE; }
	if(ATOMP(xr7)) { if(tr) fill(msgAtSymLit); return FALSE; }
	xr7=CDR(xr7);
	return TRUE;
}

/*
   PREFIX[(X1)]
   PREFIX[(X1[X2])]
		1. If not looking at a list element, return FALSE
		2. If the value of X1 is not a list element, return FALSE
		3. If X2 is present and the value of X2 is not
		   a list element, return FALSE
		4. Create a new list element whose
                   successors = current list element
                   attribute-list = value of X2 (or NIL if X2 is absent)
                   head = value of X1
                   Look at this new list element and return TRUE
*/

int PrefixOper() {

	int ixr71,ixr72,ilist, arg;
	if(list != 1){
		if(tr) fill(msgNotList);
		return FALSE;
		}
	arg=CSR(opptr);
	getreg(CAR(arg),&ixr71,&ilist);
	if(ilist != 1) return FALSE;
	ixr72=0;
	if(CSR(arg) != 0) {
		getreg(CSR(arg),&ixr72,&ilist);
		if(ilist != 1) return FALSE;
		}
	xr7=gcons(xr7,ixr72,ixr71);
//xx      if(xr7 <= 0) go to 9999
	return TRUE;
}

// *   LOOKATSYMBOL [S]
// *                Look at the symbol S and return TRUE

int LookatsymbolOper(){

	list=1;
	xr7=CSR(opptr);
	return TRUE;
}

// *   LOOKATLIST [S]
// *               Look at the value of s [a list] and return TRUE

int LookatlistOper(){
	list =1;
	xr7=CDR(CSR(opptr));
	return TRUE;
}

// *   TESTFORNIL
// *            If looking at NIL return TRUE , else return FALSE

int TestfornilOper(){

	if(list != 1) {//GO TO 990
		if(tr) fill(msgNotList);
		return FALSE;
	}
	return (xr7 == 0);// GO TO 250
}

/*
   MEMBER [A]
                1. If not looking at a list element, return FALSE
                2. If looking at a symbol, literal, or NIL, FALSE
                3. Examine the current list element and its
                   successors for an element whose head is on
                   list A;  If such an element is found, look
                   at it and return TRUE, else return FALSE
                   [SPECIAL CASE-- If the argument is a register
                   whose value is a symbol S, examine the current
                   list element and its successors for an element
                   whose head = S]
*/

int MemberOper(){

int ixr7,ilist, arg;
	if(list != 1){ if(tr) fill(msgNotList); return FALSE; }
	if(ATOMP(xr7)) { if(tr) fill(msgAtSymLit); return FALSE; }
	arg=CSR(opptr);
	if((CSR(arg)&(HEAD|REGBIT)) == (HEAD|REGBIT)){// GO TO 975

//		Argument is a register, get its value
	getreg(arg,&ixr7,&ilist);
	if(ilist != 1) return FALSE;
	arg=ixr7;
	if(ATOMP(ixr7)){ //GO TO 973

//           Value of register is an atom (symbol/literal)
	ixr7=search(xr7,arg);
	if(!ixr7)return FALSE;
	xr7=ixr7;
	return TRUE;
	}
// 		 value of register is a list
//973
	return (s7(arg)!=0);// GO TO 250
	}
// *		argument is not a register
// *            if argument is a symbol, gets its value, which should
// *            be a list
//975
	if(ATOMP(arg)) arg=CDR(arg);
	return (s7(arg)!=0);// GO TO 250
}


// *      R E G I S T E R   AND   A T T R I B U T E   O P E R A T O R S


// *   STORE [X]

// *	Store the current position in register X and return TRUE

//1000
int StoreOper() {
	setreg(CSR(opptr),xr7,list);
	if(tr)prtloc();
	return TRUE;
}


// *   LOOK [X]
// *	1. If register X has not been assigned a value,return FALSE
// *	2. Look at whatever is stored in X and return TRUE

int LookOper(){
	int ixr7, ilist;
	getreg(CSR(opptr),&ixr7,&ilist);
	if(!ixr7 && !ilist) return FALSE;
	xr7=ixr7; list=ilist;
	if(tr) prtloc();
	return TRUE;
}

/*
   ASSIGN [S]
		1. If not looking at a node, return FALSE
		2. if register X0 has not been assigned a value,
		   assign to the current node the node attribute S
		   with value NIL and return TRUE
		3. if register X0 has been assigned a value which is
                   is a sentence word, return FALSE
		4. if the value of register X0 is some node N, assign
			the current node the node attribute S with value
		   N, set register X0 to empty (unassigned), return TRUE
*/

int AssignOper(){
	int ilist,ival;
	if(list) return FALSE;//looking at a list or sent word
	ival=0;
	ilist=0;
	if(ix0) {
		getreg(ix0,&ival,&ilist);
		if(ival && ilist == 2) return FALSE;
		}
//1025
/*
if(xr7==ival && ilist==0){// **debug**
cout<<"\nin interp asgnat xr7="<<xr7<<" has same node value"<<endl;// **debug**
}// **debug**
*/
/*
int ffl=0;// **debug
if(strcmp(restrnamP,"T-RN-WH")==0){// **debug**
if(strcmp(STNAME(CAR(CSRADDR(opptr))),"FILLED-PT")==0){// **debug
char npb[40];// **debug
char *xcd=nodnam(xr7,npb);
if(strcmp(xcd,"NON-EMPTY")==0){// **debug

cout<<"\nDB:in interp assign xr7="<<xr7<<" value="<<ival<<" hous="<<nodHousRest<<endl;// **debug**
}// **debug**
ffl=1;// **debug
}// **debug**
}// **debug**
*/
	asgnat(xr7,CSR(opptr),ival,ilist,nodHousRest,well);// **debug
/*
if(ffl){// **debug
cout<<"print na stuff"<<endl;// **debug
printNA(xr7,"after asgnat");// **debug
}// **debug
*/
/*
if(strcmp(restrnamP,"T-MOD")==0)lag1 && restcnt>10){// **debug**
if(nodHousRest==171){// **debug**
void printHousNA(int,char *);// **debug**
printHousNA(171,"in interp at asgnat");// **debug**
printNA(101,"in interp at asgnat");// **debug**
int vv=1;// **debug**
}// **debug**
}// **debug**
*/
	if(ival) setreg(ix0,0,0);
//      ASNSW=TRUE;
	return TRUE;
}

/*
   HASATT [S]
	1. If not looking at a node, return FALSE
	2. If current node does not have node attribute S, return FALSE.
	3. If attribute S has value n (not NIL), look at
	   node N, return TRUE
*/

int HasattOper(){

	int ilist, ixr7;
	if(list) return FALSE;
	if(!nodeat(xr7,CSR(opptr),&ixr7,&ilist))return FALSE;
	if(ixr7 == 0 && ilist == 0) return TRUE;
	xr7=ixr7;
	list=ilist;
	if(tr) prtloc();
	return TRUE;
}

/*
   ERASE [S]
	1. If not looking at a node, return FALSE
	2. If current node does not have node attribute return FALSE
	3. Erase the node attribute S on the current node
*/

int EraseOper(){

int ixr7,ival,ilist;
	if(list) return FALSE;
	nodeat(xr7,CSR(opptr),&ixr7,&ilist);
	if(ixr7<0) return FALSE;
	eraseNodeAtt(xr7,CSR(opptr),nodHousRest,well);
//      ASNSW=TRUE;
	return TRUE;
}
/*
      D E F I N I T I O N - G E N E R A T I N G   O P E R A T O R


   GENER [(X1,X2)]
	GENER should appear only in a disqualify restriction.
	1. If X1 or X2 does not contain a node, return FALSE
	2. If X1 is not on the same level of the parse tree as X2,
	   or not equal to or to the left of X2, return FALSE
	3. Create an element list containing pointers to the definitions
	   of the nodes between X1 and X2, inclusive, but excluding any
	   special process nodes; each element will also contain a pointer
	   to the wellformedness restrictions on the corresponding node.
                4. If the list generated in step 3 is vacuous, return FALSE
                5. Add to the beginning of the restriction list of last
                   element of the created list the wellformedness restrictions
                   housed in the first element of the original option
                6. If this is the first call on GENER in this restriction,
                   replace the original option and any subsequent options by
                   an option consisting of the newly created element list
                   (with no disqualify restrictions);  return TRUE
                7. Otherwise (GENER has elready been executed) add an
                   option consisting of the newly created element list (with
                   no disqualify restrictions) and return TRUE.
*/

int GenerOper(){
int ixr71,ixr72,list1,list2,elist, elem, lx, iwellf, ioldw,sxr7;
int xr7sv,listsv,passflg;
//cout<<"doing a GENER "<<dlp; // **debug
	rptr=CSR(opptr);
	getreg(CAR(rptr),&ixr71,&list1);
	if(!ixr71 || list1) return FALSE;//GO TO 282
	getreg(CAR(CDR(rptr)),&ixr72,&list2);
	if(!ixr72 || list2) return FALSE;//GO TO 282

	xr7sv=xr7; listsv=list;
	elist=0;
//                     start at right and go left
	xr7=ixr72;
	list=0;
// 		If rightmost node is below dummy node, check that
// 		it is the rightmost node below the dummy (if not,
// 		ignore call). Go up to the dummy node and start
//		duplicating nodes on level containing the dummy

	if(NDIDMT(xr7)){// GO TO 1105
	if(right()) {//GO TO 1130
		*coutP<<msgUnGenOpt<<endl;
		xr7=xr7sv; list=listsv;
		return TRUE;//GO TO 281
		}

	passflg=oupone();
	}
// 			skip special process nodes
	while(1){
	if(!NDSPNT(xr7)) {
        	elem=NDOPES(xr7);
        	if(NDFILT(xr7)) elem=CAR(elem);
        	iwellf=CSR(elem);

// 		Add list of generated options to a copy
// 		of list of wellfs from original definition

		if(!elist){
			ioldw=CSR(CAR(olddlp));
			iwellf=append(ioldw,iwellf);
        		}
		elist=gcons(elist,iwellf,CAR(elem));
		}//if
//                        Test if at leftmost node
	if(xr7 == ixr71) break;//goto 1120
//                        If at dummy node, check if named node below is
//                        specified first node for generated option
	if(NDNONT(xr7)){//GO TO 1118
	sxr7=xr7;
	if(odown()) {//GO TO 1118
		if(xr7 == ixr71){ //GO TO 1119
// *                   if it is, verify that this node is the leftmost
// *                   node below the dummy node (otherwise, ignore call)
			if(left1()) {//GO TO 1130
				*coutP<<msgUnGenOpt<<endl;
				xr7=xr7sv; list=listsv;
				return TRUE;//GO TO 281
				}//if on left1
			} //if
		xr7=sxr7;
		} // if
	}//if

	if(!(left1())) {
		xr7=xr7sv; list=listsv;
		return TRUE;//GO TO 282
		}
	} // while

	if(!elist) return FALSE;//list is emptyGO TO 282
	lx=gcons(0,0,elist);
	if(!newdlp) {
//     First call on GENER fors restriction, replace old option(s) by new ones
	  	newdlp=lx;
		elemt=CAR(elist);
		}//if

//     second or subsequent call on GENER, append option to option list
	else CDR(lastOptGen)=lx;

	lastOptGen=lx;
{
char nambuf[50];
	if(tr) {
		xr7=xr7sv;
		prntif();
		fill("GENER executed at node "); fill(nodnam(xr7,nambuf));
		oupone();
		fill(" node above is " ); fill(nodnam(xr7,nambuf));
		oupone();
		fill(" node two above is " ); fill(nodnam(xr7,nambuf));
		plist(newdlp,FALSE,PRUNIT);
		}//if tr
}
	xr7=xr7sv; list=listsv;
	return TRUE;//GO TO 281
}

// *           O U T P U T   O P E R A T O R S

// *   WRITE [(M N)]
// *                write to output file and return TRUE
// *                M= file type

// *                N=1, write first 20 char. of last comment
// *                N=2, write name of current node/list element/word
// *                N=3, write words subsumed by current node
// *                N=4, write END-OF-LINE
// *                N=5, write parse tree
// *                N=6, write source statement as comment
// *                N=7, write parse tree with word forms
// *                N is ATOMIC a literal, write literal

int WriteOper(){

wrtcnt++;//** debug
	int arg=CSR(opptr);
	int fout=CAR(CAR(arg));
	fout=sytab.retsthostp(fout);
	wrtitr(fout,CAR(CDR(arg)));
	return TRUE;
}

// *   REPARSE[N]
int ReparseOper() {
	return 3;
#if 0

 1160 int arg=CSR(opptr);
      PARSTAT=CDR(arg)
      if(tr)fill(")")
      if(tr)fill(" + ")
      prntif()
//      RETURN1
#endif
}

/*
      T R A N S F O R M A T I O N A L   O P E R A T O R S

   A set of 7 operators are provided for transforming the parse tree.
   these operators make it possible to assemble an arbitrary tree
   structure and then place it below or to the right of some node in
   the tree.  the operators are divided into three groups. Two
   operators create new nodes:
      CREATE  -- creates a node with a given name
      COPY    -- creates a copy of a subtree of the parse tree
      CLASS   -- locate word of specified category and create node

   Three operators assemble the created nodes into a transformed
   structure:
      BUILDDOWN -- adds last created node below current node in
                   transformed structure
      BUILDRIGHT-- adds last created node to right of current node in
                   transformed structure
      BUILDUP   -- moves pointer to current node in transformed
                   structure up one level

   Three operators insert the transformed structure into the parse
   tree:

      REPLACE      -- replace current node in parse tree
                      with transformed structure
      INSERTBEFORE -- insert transformed structure to left of current
                      node in parse tree
      INSERTAFTER  -- insert transformed structure to right of
                      current node in parse tree
*/
//		Error messages for transformational operators

 static const char *msgNoCreatNod = "(** No created node **)";
 static const char *msgDnRtFl = "** DOWN/RIGHT pointer already filled **";


//   CREATE [S]
//                Create a node named S and return TRUE
int CreateOper(){
	int ns;

//1200
	int arg=CSR(opptr);
	xdo();
	ns=getnod(); 
	NDWPNC(ns)=ixfwds;
	NDABTS(ns)=0;
	NDSPFB(ns)=CSR(arg);
	NDHDBA(ns)=arg;
	newnod=ns;
	xr7=ns;
	list=0;
	if(NDLTMT(ns)) {
//                  if node is literal add word to xfwds

		ixfwds=xfwdsQue(STNAME(CAR(arg)),0,0,1);
		}
	NDWPCP(ns)=ixfwds;
	NDORDC(ns)=0;
	return TRUE;
}
/*
   COPY
		If not looking at a node, return FALSE; else create a copy
		of the current node and if, the argument is not null,
		all nodes below it and return TRUE
*/

const int COPYLEN=1000;
struct NAsetstr {int attrb; int value; short valtype; int hous;};
struct cpnstr{int orig; int copy;};

int CopyOper(){
	int arg,lxr7,sxr7,ns,n,i,flag=1,passflg;
	struct cpnstr *cpnodes =  new struct cpnstr [COPYLEN];
int cpnct=0;
/* debug
if(tr){ // **debug
copycnt++; // **debug
if(copycnt> 9){ // **debug
cout<<"copy count "<<copycnt<<endl; // **debug
}} // **debug
*/
	if(list) return FALSE;
	arg=CSR(opptr);
	xdo();
	lxr7=0;
	sxr7=xr7;
//                   copy current node
void subtreeDraw(int);// **debug
/*
if(flag1){// **debug
char a1tx[40];// **debug
cout<<"\nin interp:subtree is being copied at node="<<xr7<<" "<<nodnam(xr7,a1tx)<<endl;
int a1=NDRTPT(xr7);// **debug
if(a1)cout<<"node to right="<<a1<<" "<<nodnam(a1,a1tx)<<endl;// **debug
a1=NDUPLF(xr7);// **debug
if(NDFILT(xr7))cout<<"node above="<<a1<<" "<<nodnam(a1,a1tx)<<endl; // **debug
else cout<<"node to left="<<a1<<" "<<nodnam(a1,a1tx)<<endl; // **debug
subtreeDraw(xr7);// **debug
}// **debug
*/

/*
if(arg){//a subtree is being copied
int ssx=xr7;
//if(NDFILT(xr7)) subtreeDraw(xr7);// **debug
xr7=ssx;
cout<<endl;
}
*/
int ggg=0;// **debug
int newroot;// **debug
	while(flag){
		ns=getnod();
/*
if(flag1){// **debug
if(ggg==0){ggg=1; newroot=ns;}// *8debug
char bbf[40];
if(arg)cout<<"copy: xr7="<<xr7<<" "<<nodnam(xr7,bbf)<<"  ns="<<ns<<" ixfwds "<<ixfwds<<endl;// **debug
}// **debug
*/
		NDOPES(ns)=NDOPES(xr7);
		NDABTS(ns)=NDABTS(xr7);
		NDWPNC(ns)=ixfwds;
		NDSPFB(ns)=NDSPFB(xr7);
		NDHDBA(ns)=NDHDBA(xr7);

if(cpnct>=COPYLEN){
*coutP<<"Array overflow copy length="<<COPYLEN<<endl;
void exit(char*);
exitr(17, "array overflow");
}
	cpnodes[cpnct].orig = xr7;
	cpnodes[cpnct++].copy = ns;
//		for non-null atomic nodes, copy attribute
//		pointer and add subsumed words to xfwds

		if(NDATMT(xr7) && (!NDOTMT(xr7))){
			NDBALP(ns) = NDBALP(xr7);
        		for(i=NDWPNC(xr7); i<NDWPCP(xr7); i++){
			ixfwds=xfwdsQue(SENTE1(i),SENTE2(i),SENTE3(i),SENTE6(i));
//if(arg)cout<<"copy:ixfwds="<<ixfwds<<" sent word="<<i<<endl;// **debug**
				}//for
			}//if


//               link up with previously copied nodes

		if(lxr7 != 0) {
			NDUPLF(ns)=lxr7;
//if(arg)cout<<"copy:lxr7="<<lxr7<<endl;// **debug**
        		if(!NDFILT(ns)) NDRTPT(lxr7)=ns;
        		else NDBALP(lxr7)=ns;
			} //if

		lxr7=ns;
		n=xr7;
		while(NDGCPS(n)) n=NDGCPS(n);
		NDGCPS(n)=ns;
/*
if(flag1){// **debug
cout<<"\ncopy from="<<xr7<<" ";// **debug**
cout<<" to="<<ns<<endl;// **debug**
}
//void prtnodsub(int,int);// **debug**
//prtnodsub(xr7,0);// **debug**
*/

		if(arg == 0) break;//only copy one node

//                   find next node in tree to be copied (depth-first,
//                   left-to-right preorder scan)
//                          go down
	if(down()) continue;

	while(1){ //cannnot go down 
		NDWPCP(lxr7)=ixfwds;
		NDORDC(lxr7)=0;
//		if at starting node, done
		if(xr7 == sxr7) {flag=0;break;}//goto L1275

//			try to go right
		if(right()) break;//goto L1215;
//                  If can't, go up (and move lxr7, pointer to
//                  last created node, up one level)

		passflg = upone();
		while(!NDFILT(lxr7)) lxr7=NDUPLF(lxr7);
		lxr7=NDUPLF(lxr7);

//                     try to go right again
		}//while 1

	} // while flag

// copy the node attributes
extern void copyNAs(struct cpnstr *, int);
{// **debug
if(flag1){// **debug
int idf=52;// **debug
if(idf)printNA(idf,"before copy");// **debug
}// **debug
}// **debug

copyNAs(cpnodes, cpnct);

{// **debug
if(flag1){// **debug
int idf=52;// **debug
if(idf)printNA(idf,"before copy");// **debug
}// **debug
}// **debug
/*
{// **debug
if(flag1){// **debug
cout<<"NAs of copied nodes"<<endl;// **debug
for(int i=0;i<cpnct;i++){// **debug
int orgx = cpnodes[i].orig;// **debug
int cpyx = cpnodes[i].copy;// **debug
printNA(orgx,"orignal");// **debug
printNA(cpyx,"copy");// **debug
}// **debug
}// **debug
}// **debug
*/

/*
struct NAsetstr cpnst, NAlist[50];
extern int getNAfornode(int, struct NAsetstr*, int);
int org,cpy, nact;
for(int i=0;i<cpnct;i++){
org = cpnodes[i].orig;
cpy = cpnodes[i].copy;
// get list of NAs for this node
int nact=getNAfornode(org, NAlist, 50);
if(nact == 0)continue;
for(int j=nact-1; j>=0; j--){
int val=NAlist[j].value;
int valtyp = NAlist[j].valtype;
if(valtyp==0 && val>0){ //an NA with a node for a value
for(int k=0;k<cpnct;k++){//is the value a copied node
if(cpnodes[k].orig == val){val=cpnodes[k].copy;break;}
}//for
}//if
//char ccc[20];// **debug**
//cout<<"node="<<org<<" "<<nodnam(org,ccc)<<" copied to="<<cpy<<endl;// **debug
asgnat(cpy,NAlist[j].attrb,val,valtyp,0,1);
}//for on NA's on node
}//for in copy nodes
*/
	newnod=lxr7;
	xr7=lxr7;
	NDABTS(lxr7) &= (~INDUM);
/*
if(flag1){// **debug
cout<<"copied tree at "<<lxr7<<endl;// **debug
subtreeDraw(newroot);// **debug
cout<<"end of copy"<<endl;// **debug
}// **debug
*/
	delete cpnodes;
	return TRUE;
}

/*
   CLASS [S]
	When invoked, the parser should be looking at the categories
	list for a group of words.  (A group consists of a prototype
	word and its derivative words;  The categories list has as
	elements The category lists of the words in the group.)
	This operator finds the first word, W, in
	the group with a category S1, and an attribute list S2.
	S2 may point to a list or be a register which points to
	a list.  This list may contain one sub-attribute level.
	The operator creates a node named S1 subsuming word W
	(and with word W's attribute list for category S1),
	and returns TRUE.  If no word in the group has category
	S, and attributes S1 and S2 return FALSE.
*/


int ClassOper(){
	int ns, n, s_att, s_cat, ilist, kat, forms, att, wdform;
	int flag,lforms,subatt;
	if(list) return FALSE;
	n=xr7;
//			extract arguments to operator
	s_cat=CSR(opptr);
	s_att=0;
	if(!ATOMP(s_cat)){
        	s_att=CSR(s_cat);
        	s_cat=CAR(s_cat);
        	if(CSR(s_att)&(HEAD|REGBIT)){
// 		if no register defined return FALSE
			getreg(s_att,&s_att,&ilist);
//		if not list return FALSE
			if(ilist !=1) return FALSE;
//                        if reg is null only catagory defined
			}//if
		}//if

// 		 forms = lists of word forms and their catagory lists
	lforms=SENTE3(NDWPNC(xr7));
	if(!(forms=lforms)) return FALSE;

//		search for word with specified category and
// 		attribute. No more word forms to examine, return FALSE

	do{ //loop on forms
// 		kat = list containing word form and its categories
		kat=CAR(forms);
//             wdform = word form (list of literals)
		wdform=CAR(kat);
//                        search for category
	while(1){ // loop on cat's
		flag=0;

		if(!(kat=search(CDR(kat),s_cat))){flag=1;break;}
// 				if found, see if attributes requested
//                                 not found, advance to next word form
// 				if attribute was specified, check
//                                for it, else done

		att=s_att;
// 				if attribute not present in defn,
// 				continue searching this category list
// 				for a homograph- maybe

	while(att){
		att=search(CSR(kat),CAR(att));
		if(!att){flag=1; break;}
//                                 check if a sub-attribute is requested
		subatt=CSR(att);
//                            if not check for next attribute in request

		while(subatt){
//                          check if attribute has sub-attribute
//                          in defn. if more cat search
		if(search(CSR(att),CAR(subatt))==0) {flag=1;break;}//goto L1287;
//                              get next sub-attribute in request
			subatt=CDR(subatt);
			}//while for subattGO TO 1284
// at this point:
//    1. the subatt matched -  test next att
//    2. matched failed- a break do the next cat
//    3. no subatt request - check next att

		if(flag) break;
		att=CDR(att);
	} // while for att

// at this point:
// 1. no att - a find
// 2. an att, no subs or all subs ok for all atts complete loop - a find
// 3. an att, no sub an att break, look for more kat (check this)?
// 4. an att, sub failed look for next kat match - homograph
	if(!flag) break;   //flag clear - a find
} // while for kat

// at this point:
// 1. kat loop complete - no find go to next form - continue
// 2. no find - continue
	if(flag)continue;

// 		word found with specified category and
// 		attribute(s);  create new node

	xdo();
	ns=getnod();
	newnod=ns;
	NDSPFB(ns)=CSR(s_cat);
	NDHDBA(ns)=s_cat;
	NDBALP(ns)=CSR(kat);
	NDWPNC(ns)=ixfwds;
	NDABTS(ns)=0;
	ixfwds=xfwdsQue(STNAME(CAR(CAR(wdform))),CAR(forms),lforms,1);

	while(wdform=CDR(wdform)) {
	ixfwds=xfwdsQue(STNAME(CAR(CAR(wdform))),0,0,1);
//	wdform=CDR(wdform);
		} // GO TO 1295

//	ixfwds=xfwdsQue(STNAME(CAR(forms)),lforms,0,0);
//	xfwds[ixfrst][1]=CAR(forms);
//	xfwds[ixfrst][2]=lforms;
	NDWPCP(ns)=ixfwds;
	NDORDC(ns)=0;
	while(NDGCPS(n)) n=NDGCPS(n);
	NDGCPS(n)=ns;
	xr7=ns;
	list=0;
	return TRUE;

	}while(forms=CDR(forms)); //GO TO 1285
	return FALSE;//loop complete no find
}

/*
   BUILDDOWN

	1. if there does not exist a created node not yet incorported
	   into the transformed structure, return FALSE.
	2. If there is no extant transformed structure, make the created
           node the current transformed structure and return TRUE
	3. If the current node in the transformed structure is atomic
	   or has some node below it, return FALSE
	4. Place the created node below the current node in the transformed
	   structure, make the new node the current node in the transformed
	   structure, and return TRUE
*/

int BuilddownOper(){

	if(!newnod) {
		if(tr) fill(msgNoCreatNod);
		return FALSE;
	}

	if(frstxf){
		if(NDATMT(lastxf)) {
			if(tr) fill("(** Cannot add node below atomic **)");
			return FALSE;
			}

		if(NDBALP(lastxf)){
			if(tr) fill(msgDnRtFl);
			return FALSE;}
		NDBALP(lastxf)=newnod;
		NDUPLF(newnod)=lastxf;
		NDABTS(newnod)=(NDABTS(newnod)|FIL);
			}
	else frstxf=newnod;

	lastxf=newnod;
	newnod=0;
	return TRUE;
}

/*
   BUILDRIGHT
	1. if there is no extant transformed structure, return FALSE
	2. if the current node in the transformed structure has
           some node to the right of it, return FALSE
	3. if there exists a created node not yet incorporated into
           a transformed structure, place it to the right of the current
	   node in the transformed structure make the new node the current
	   node in the transformed structure and return TRUE
	4. return FALSE
*/

int BuildrightOper(){

	if(!frstxf) return FALSE;
	if(NDRTPT(lastxf)){
			if(tr) fill(msgDnRtFl);
			return FALSE;}
	if(!newnod) {
		if(tr) fill(msgNoCreatNod);
		return FALSE;
		}
	NDRTPT(lastxf)=newnod;
	NDUPLF(newnod)=lastxf;
	NDABTS(newnod)=(NDABTS(newnod)&(~FIL));
	lastxf=newnod;
	newnod=0;
	return TRUE;
}

/*
   BUILDUP
	1. If no extant transformed structure,return FALSE
	2. If there is a node in the transformed structure
	   one level above the current node in transformed
	   structure, make it the current node and
	   return TRUE, else return FALSE
*/

int BuildupOper(){

	if(!frstxf) return FALSE;
	int lpc=lastxf;
	while(1){
		if(!NDUPLF(lpc)) return FALSE;
		if(NDFILT(lpc)) break;
		lpc=NDUPLF(lpc);
		}//

	lastxf=NDUPLF(lpc);
	NDWPCP(lastxf)=ixfwds;
	NDORDC(lastxf)=0;
	return TRUE;
}

/*
   BUILDWORD [(S[A])]
	1. If there is no extant transformed structure, return FALSE
	2. The last node added to the transformed structure must be an
	   which is not a literal, is not a null atom, and is not associated
	   with any sentence word. If these conditions are not met,
	   return FALSE.
	3. Add word S, with attribute list A, to the sentence. Associate
	   this word with the last created node, and return TRUE.
*/

//1360
int BuildwordOper() {

	int arg;
	if(!frstxf) return FALSE;
	if(!NDATMT(lastxf)) return FALSE;
	if(NDLTMT(lastxf) || NDOTMT(lastxf)) return FALSE;
	if(NDWPNC(lastxf) != NDWPCP(lastxf)) return FALSE;
	arg=CSR(opptr);
	ixfwds=xfwdsQue(STNAME(CAR(CAR(arg))),0,CDR(arg),1);
	NDWPCP(lastxf)=ixfwds;
	NDORDC(lastxf)=0;
	NDBALP(lastxf)=CSR(arg);
	return TRUE;
}

/*
   REPLACE
	1. If not looking at a node, return FALSE
	2. If a transformed structure has just been built, replace
	   the current node (and the nodes below it, if any) by the
	   transformed structure and return TRUE
	3. If no transformed structure has been built (since the last
	   last REPLACE, INSERTBEFORE, or INSERTAFTER), delete the
	   current node.  Furthermore, delete any node all of whose
	   immediate descendants have been deleted. If this leads to
	   the deletion of the root node, return FALSE; else return TRUE.
*/

int ReplaceOper(){
static int replcnt=0;// **debug
	int lxr7,rxr7,sxr7,filsw;
char nbuf[30];// **debug
void treeDraw(int,int);// **debug
void subtreeDraw(int);// **debug
extern int ckref(int);// **debug
/*
if(ckret){// **debug
cout<<"in interp-before replace: rest="<<restrnamP<<"  NAref check failed"<<endl;// **debug
}// **debug
*/

if(flag1){// **debug
int ppr=52;// **debug
//printNA(ppr,"before replace");// **debug
treeDraw(1,20);// **debug
*coutP<<"\nreplacing subtree at node="<<xr7<<" "<<nodnam(xr7,nbuf)<<endl;// **debug
subtreeDraw(xr7);// **debug
if(frstxf){// **debug
*coutP<<"transformed structure at node="<<frstxf<<endl;
subtreeDraw(frstxf);// **debug
}
else *coutP<<"deletion only"<<endl;
}// **debug

	if(list) return FALSE;//no at a node
	if(!frstxf) {//no trans structure
	xdo();
//       jump if node has left or right coelement
		while(NDFILT(xr7) && !(NDRTPT(xr7))){
			if(!upone()) return FALSE;
			}//while
		}//if

	filsw=NDFILT(xr7);
	rxr7=NDRTPT(xr7);
	lxr7=NDUPLF(xr7);
//	(cannot pass xr7 directly to fretre because fretre changes xr7)
	sxr7=xr7;
/*
{// **debug
void printValNA(int);// **debug
int px2= 40;// **debug
if(flag3){// **debug
int px1=244;// **debug
if(NDSPFB(px1)){// **debug
cout<<"\nin replace:before xfmtre"<<endl;// **debug
printValNA(px1);// **debug
}// **debug
}// **debug
}// **debug
*/
//cout<<"in interp-copy:mrkfre "<<xr7<<endl;// **debug
	mrkfre(sxr7);
	xfmtre(lxr7,rxr7,filsw,frstxf,lastxf);
if(flag3){// **debug
int px3=52;// **debug
if(NDSPFB(px3)){// **debug
printNA(px3,"before fixup");// **debug
void printValNA(int);// **debug
printValNA(px3);// **debug
}// **debug
}// **debug

	if(xfixup(sxr7)<0) return FALSE;
/*
{// **debug
if(flag3){// **debug
int px3=244;
if(NDSPFB(px3)){// **debug
printNA(px3,"after fixup");// **debug
cout<<"\nin replace:after xfixup rest="<<restrnamP<<endl;// **debug
void printValNA(int);// **debug
//printValNA(px3);// **debug
}// **debug
}// **debug
}// **debug
*/

/*
if(flag1){// **debug
if(frstxf) {// **debug
cout<<"\nreplaced subtree at node="<<frstxf<<" "<<nodnam(frstxf,nbuf)<<endl;// **debug
//subtreeDraw(frstxf);// **debug
}// **debug
else cout<<"a deletion"<<endl;// **debug
}// **debug
*/

	frstxf=lastxf=ixfwds=0;
	fretre(sxr7);// return blocks of deleted tree
#if 0
if(tr){// **debug
extern void ptree(int);// **debug
cout<<"interp: replace "<<nwordSent<<endl;// **debug
extern int printSent(int,int,int,int);// **debug
printSent(1,nwordSent,0,PRUNIT);// debug
ptree(PRUNIT);// **debug
}// **debug
#endif
/*
if(flag1){// **debug
cout<<"\nafter replace oper"<<endl;// **debug
treeDraw(1,5);// **debug
}// **debug
int ckrety=ckref(1);// **debug
if(ckrety){
cout<<"in interp-after replace: rest="<<restrnamP<<"  NAref check failed"<<endl;// **debug
}// **debug
*/
	return TRUE;
}

/*
   INSERTBEFORE
	1. If no transformational structure was built, return FALSE
	2. If not looking at a node, return FALSE
        3. Insert the transformed structure to the left of the
	   current node and return TRUE
*/

//1420
int InsertbeforeOper() {

	int rxr7,lxr7,filsw;
	if(!frstxf) return FALSE;
	if(list) return FALSE;
	filsw=NDFILT(xr7);
	NDABTS(xr7)=(NDABTS(xr7)&(~FIL));
	rxr7=xr7;
	lxr7=NDUPLF(xr7);
	xfmtre(lxr7,rxr7,filsw,frstxf,lastxf);
	frstxf=0; lastxf=0; ixfwds=0;
	xfixup(0);
#if 0
if(tr){// **debug
extern void ptree(int);// **debug
cout<<"interp: insertbefore "<<nwordSent<<endl;// **debug
extern int printSent(int,int,int,int);// **debug
printSent(1,nwordSent,0,PRUNIT);// debug
ptree(PRUNIT);// **debug
}// **debug
#endif
	return TRUE;
}

/*
   INSERTAFTER
	1. If no transformational structure was built, return FALSE
	2. If not looking at a node, return FALSE
	3. Insert the transformed structure to the right of the
	   current node and return TRUE
*/

int InsertafterOper() {

	int rxr7,lxr7,filsw;
	if(!frstxf) return FALSE;
	if(list) return FALSE;
	filsw=FALSE;
	lxr7=xr7;
	rxr7=NDRTPT(xr7);
{
void printValNA(int);// **debug
if(flag1){// **debug
*coutP<<"\nin insertafter:before xfixup rest="<<restrnamP<<endl;// **debug
int px3=52;// **debug
if(NDSPFB(px3)){// **debug
printNA(px3,"before insertafter");// **debug
}// **debug
px3=73;// **debug
printValNA(px3);// **debug
px3=262;// **debug
printValNA(px3);// **debug

}// **debug
}

	xfmtre(lxr7,rxr7,filsw,frstxf,lastxf);
	frstxf=0; lastxf=0; ixfwds=0;
	xfixup(0);
{
void printValNA(int);// **debug
if(flag1){// **debug
*coutP<<"\nin insertafter:after xfixup rest="<<restrnamP<<endl;// **debug
int px3=52;// **debug
if(NDSPFB(px3)){// **debug
void printValNA(int, const char*);// **debug
printNA(px3,"afterinsertafter");// **debug
void printValNA(int);// **debug
}// **debug
px3=73;// **debug
printValNA(px3);// **debug
px3=262;// **debug
printValNA(px3);// **debug
}// **debug
}
#if 0
if(tr){// **debug
extern void ptree(int);// **debug
cout<<"interp: insertafter "<<nwordSent<<endl;// **debug
extern int printSent(int,int,int,int);// **debug
printSent(1,nwordSent,0,PRUNIT);// debug
ptree(PRUNIT);// **debug
}// **debug
#endif
	return TRUE;
}

/*
   TRANSFORM
	If not looking at a node, return FALSE;  else put current node
 	on top of stack of nodes whose transformations are to be executed
*/

int TransformOper() {

	if(list) return FALSE;
	if(!stackXform(xr7)) return -2;
	return TRUE;
}

/*
   DEACTIVATE
	1. if deactivate was already called by transformation, return FALSE .
	2. remove from stack of transformations node that was current
	   current before transformation was executed.  return TRUE .
*/

int DeactivateOper(){

	if(!deact){
		deactXform();
		deact = TRUE;
		return TRUE;
		}
	prntif();
      *coutP<<"\n*** DEACTIVATE called twice while executing transformation "
      <<restrnamP<<endl;
	return FALSE;
}

// *   GENSYM
// *                generate a new symbol of the form NDDD, where DDD is
// *                A 3-DIGIT NUMBER.  DDD=0 FOR THE FIRST CALL ON
// *                GENSYM, and is incremented by 1 for each successive
// *                call. Look at the head for this symbol.

// *      CONVERT NUMBER TO CHARACTER STRING, AND CHANGE LEADING 0 TO N
// *      (WE ADD 1000 TO FORCE GENERATION OF LEADING ZEROES IN CASE
// *      NGENSM<100)

	static int ngensym=0;
int GensymOper(){
	char gsyt[5];
static char *gsy= (char *) "N000";
	strcpy(gsyt,gsy);
	int np=3, ngg= ngensym;
	while(ngg){
	*(gsyt+np) += ngg%10;
	ngg /= 10;np--;
	}

	xr7=symbolCreate(gsyt);
	list=1;
	ngensym++;
	return TRUE;
}
#if 0
int NewdefOper(){
// *  Get a new definition for the word which is pointed to by the
// *  atomic node. Argument is a register which points to a list of
// *  literals which is the word to be looked up.
      plist(newdef,FALSE,PRUNIT);
      exitr(0, "wdlookup")
      if(list) return FALSE;
      if(!ATOMP(xr7)) return FALSE;
      getreg(CSR(opptr),ixr7,ilist);
      if(ixr7==0 && ilist==0) return FALSE;
      if(ilist!=1) return FALSE;
      lookupwd=NDWPNC(xr7);
	return TRUE;
}
#endif
/*
  INTERSECTOP[(X1 X2 X3)]
  INTERSECTOP[(X1 X2)]
     This operator forms the intersection of the two lists pointed
     to by X1 and X2 and the result (which may be NIL and stored in
     a list poined to by X3, if X3 given, else the intersection is
     pointed to only.
     In case of a find the attribute list of X1 is used for X3
     All of the items in X1 with a match go to X3.
     If the register does not point to a list return FALSE
     If either list is NIL set result to NIL, return TRUE.
     Take the intersection and return TRUE.
*/

int IntersectOper(void){
int ixr71,ixr72,ixr73,fel,list1,list2,prev,intlst,soptr,jxr72;
	soptr=CSR(opptr);
	getreg(CAR(soptr),&ixr71,&list1);
	getreg(CAR(CDR(soptr)),&ixr72,&list2);
	if(list1!=1 || list2 != 1) return FALSE;
	intlst=0;
	if(ixr71 && ixr72) {
// *     if(ixr73 && list3 != 1) return FALSE;
	prev=0;
	while(ixr71){
//1811
	jxr72=ixr72;
	fel=CAR(ixr71);
	while(jxr72){
//1812
	if(fel == CAR(jxr72)){
        ixr73=gcons(0,CSR(ixr71),fel);
        if(prev) CDR(prev)=ixr73;
        else intlst=ixr73;
        prev=ixr73;
		break;}
	else jxr72=CDR(jxr72);
	} // inner while
	ixr71=CDR(ixr71);
	}// while
}// if

	prev=CDR(CDR(soptr));
	if(prev) setreg(CAR(prev),intlst,1);
	xr7=intlst;
	list=1;
	return TRUE;
}// fun end

/*
  INTERSECTCHK[(X1 X2)]
     This operator checks if the intersection of the two lists pointed
     to by X1 and X2 is empty.
     If the register does not point to a list retuen FALSE
     If either list is NIL set result to NIL, return TRUE
     Take the intersection and retuen FALSE if NIL else return TRUE.
*/

int IntersectchkOper(void){
int ixr71,ixr72,fel,list1,list2,soptr,jxr72;
	soptr=CSR(opptr);
	getreg(CAR(soptr),&ixr71,&list1);
	getreg(CAR(CDR(soptr)),&ixr72,&list2);
	if(list1!=1 || list2 != 1) return FALSE;
	if(!ixr71 || !ixr72)return FALSE;
	while(ixr71){
		fel=CAR(ixr71);
		jxr72=ixr72;
		while(jxr72){
			if(fel == CAR(jxr72))return TRUE;
			jxr72=CDR(jxr72);
			}//while
		ixr71=CDR(ixr71);
		}//while
	return FALSE;
	}

// *  UNIONOP[(X1 X2 X3)]
// *	Takes the union of the lists pointed to by X1 and X2
// *	and placed into X3
// *	If the register does not point to a list return FALSE
// *	Take the union and return TRUE.
     
int UnionOper(void){
int ixr71,ixr72,ixr73,fel,list1,list2,prev,intlst,soptr,jxr71;
	soptr=CSR(opptr);
	getreg(CAR(soptr),&ixr71,&list1);
	getreg(CAR(CDR(soptr)),&ixr72,&list2);
	if(list1!=1 || list2 != 1) return FALSE;
// *   getreg (CAR(CDR(CDR(soptr))),ixr73,list3)
	prev=0;
	if(!ixr71 || !ixr72) {
		if(ixr72)ixr71=ixr72;
		ixr72=0;
		}//if
// one is empty
	jxr71=ixr71;
	while(jxr71){
		ixr73=gcons(0,CSR(jxr71),CAR(jxr71));
		if(prev) CDR(prev)=ixr73;
		else intlst=ixr73;
		prev=ixr73;
		jxr71=CDR(jxr71);
		}//while
	if(ixr72){
		while(ixr72){
			fel=CAR(ixr72);
			jxr71=ixr71;
			while(jxr71){
				if(fel == CAR(jxr71))break;
				jxr71 = CDR(jxr71);
				}
			if(!jxr71){
				ixr73=gcons(0,CSR(ixr72),fel);
				CDR(prev)=ixr73;
				prev=ixr73;
				}
			ixr72=CDR(ixr72);
			}//while
		}//if
	prev=CDR(CDR(soptr));
	if(prev) setreg(CAR(prev),intlst,1);
	xr7=intlst;
	list=1;
	return TRUE;
}

// *  COMPLEMENTOP[(X1 X2 X3)]
int ComplementOper(void){
int ixr71,ixr72,ixr73,fel,list1,list2,prev,intlst,jxr72;
	int soptr=CSR(opptr);
	getreg(CAR(soptr),&ixr71,&list1);
	getreg(CAR(CDR(soptr)),&ixr72,&list2);
	if(list1 != 1 || list2 != 1) return FALSE;
	if(!ixr71) {xr7=0; return FALSE;}
	if(!ixr72) return FALSE;
	prev=0;
	while(ixr71){
		fel = CAR(ixr71);
		jxr72 = ixr72;
		while(jxr72){
			if(fel == CAR(jxr72))break;
			jxr72=CDR(jxr72);
			}
		if(jxr72){
			ixr73=gcons(0,CSR(ixr71),fel);
			if(prev)CDR(prev)=ixr73;
			else intlst=ixr73;
			prev=ixr73;
			}
		ixr71=CDR(ixr71);
		}//while
	prev=CDR(CDR(soptr));
	if(prev) setreg(CAR(prev),intlst,1);
	xr7=intlst;
	list=1;
	return TRUE;
}

//         L O G I C A L   S W I T C H S

//      SETLOGSW[N]

int SetlogswOper(){
	logsws[CDR(CSR(opptr))-1]=1;
	return TRUE; }

//      CLEARLOGSW[N]

int ClearlogswOper(){
	logsws[CDRINT(CSRADDR(opptr))-1]=0;
	return TRUE; }

//      CLEARLOGSWALL

int ClearlogswallOper(){
	for(int i=0; i<NLOGSW; i++) logsws[i]=0;
	return TRUE;}

// *    TESTLOGSW[N]

int TestlogswOper(){
	if(logsws[CDRINT(CSRADDR(opptr))-1]==0)return FALSE;
        else return TRUE;}

//      TOGLOGSW[N]

int ToglogswOper(){
	if(logsws[CDRINT(CSRADDR(opptr))-1]==0)
		logsws[CDRINT(CSRADDR(opptr))-1]=1;
	else logsws[CDRINT(CSRADDR(opptr))-1]=0;
        return TRUE;}

// *    SETGLOBSW[N]

int SetglobswOper(void){
	globsws[CDRINT(CSRADDR(opptr))-1]=1;
	return TRUE;
}

// *    CLEARGLOBSW[N]

int ClearglobswOper(void){
	globsws[CDRINT(CSRADDR(opptr))-1]=0;
	return TRUE;
}
int TestglobswOper(void){
	return globsws[CDRINT(CSRADDR(opptr))-1];

}

// *   REPARSESW[N]

int ReparseswOper() {
	int reparseSwitch=0; // GET RID
	return reparseSwitch;
}

// * EQUIVMATCH

int EquivmatchOper(){
	int linkset, numLists;
	int ixr7,ilist, attlists[10],newattlists[10], regname[10];
	int soptr=CSR(opptr);
	if((CSRINT(CAR(soptr))&(HEAD|REGBIT)) == (HEAD|REGBIT)){
	getreg(CAR(soptr),&linkset,&ilist);//get pointer to linkset
	if(ilist !=1){
	*coutP<<"register of wrong type must be a list"<<endl;
	return FALSE;
	}
	}//if for reg
	else linkset = CDR(CAR(soptr));

	int k=0;
	soptr = CDR(soptr);
	int attp=CAR(soptr);
	soptr = CDR(soptr);
	int strp = CAR(soptr);
	for(; attp; attp=CDR(attp), strp=CDR(strp)){
if(!strp){
*coutP<<"lists must be of same length";
return FALSE;
}
		getreg(CAR(attp),&ixr7,&ilist);
if(ilist !=1){*coutP<<"register must point to a list "; return FALSE;}
		attlists[k]=ixr7;
		getreg(CAR(strp),&ixr7,&ilist);
		//newattlists[k++]=CAR(strp);
		regname[k]=CAR(strp);
		newattlists[k++]=ixr7;
		}//for
if(strp){ *coutP<<"lists must be of same length"; return FALSE;}
	numLists=k;

// check for a rejection list in argument list
int rejlst=0;
if(soptr=CDR(soptr)){
rejlst=CAR(soptr);
	if((CSRINT(CAR(soptr))&(HEAD|REGBIT)) == (HEAD|REGBIT)){
	getreg(CAR(soptr),&rejlst,&ilist);//get pointer to linkset
	if(ilist !=1){*coutP<<"register must point to a list "; return FALSE;}
	}//if for reg
	else rejlst = CDR(CAR(soptr));
}//if


	int newAttval[10];
	int equmret = equivmatch(linkset, attlists, newattlists, numLists, rejlst, regname);
	if(equmret == FALSE)return FALSE;
//for(int i=0; i<numLists; i++) setreg(newattlists[i],newAttval[i],1);

	return TRUE;
}

// * CREATEIDIOM

int CreateidiomOper(){
	int ixr7, fw, lw, dxr7, dlist;
	int sdf;
	if(list) return FALSE;
	ixr7=xr7;
	if(!down()) return FALSE;
	int lxr7=xr7;//start of group of nodes to be grouped
	getreg(CSR(opptr),&dxr7,&dlist); // node to take definition
	if(dxr7 == 0) return FALSE;
	if(dlist != 0) return FALSE;
	if(!NDATMT(xr7)) return FALSE;
	while(right()) if(!NDATMT(xr7)) return FALSE;
	fw = NDWPNC(ixr7); lw = NDWPCP(ixr7);
	NDWPNC(dxr7) = fw;  NDWPCP(dxr7) = lw;
	SENTE6(fw) = lw-fw;
	SENTE3(fw) = SENTE3(NDWPNC(dxr7));
	SENTE2(fw) = SENTE2(NDWPNC(dxr7));
	for(int i=fw+1; i<lw; i++) {
		SENTE3(i)=0;
		SENTE2(i)=0;
		SENTE6(i)=0;
		}
	NDBALP(NDUPLF(ixr7)) = dxr7;
	NDABTS(dxr7) |= FIL;
	NDRTPT(dxr7) = 0;
	NDUPLF(dxr7) = NDUPLF(ixr7);
	int rxr7, rr;
	do {
		xr7 = lxr7;
		rr = right();
		rxr7=xr7;
		if(lxr7 != dxr7)freenode(lxr7); 
		lxr7 = rxr7;
		}while(rr);
	xr7 = dxr7;
	freenode(ixr7);
	return TRUE;
}

//  EVERYNODE

int EverynodeOper(){
	int arglst;
	rptr=CSRADDR(opptr);
	opptr = rptr;
	if(ATOMP(opptr))opptr = CDR(opptr);
	int opptrstart=opptr;
	int s;
	xr7=1; list=0;
	while(1) {
		opptr=opptrstart;
		int ret = looper();
		if(down()) continue;
		do {
			if(s = oright()) break;
			} while(s=oupone());

		if(!s) break;
		} // while
	return TRUE;
}

/*
GETPREVTREE

This operator reads in a previous tree from the input file. If a prev-
ious tree has already been read in that tree is deleted and the tree 
previous to that one is read in and built.

To acomplish this some storage is gotten from the heap for the tree space
and space for the lists is needed. When this operator completes any of the
operations which are requested will be done on this previous tree. The only
operations which are allowed are navigation through the tree and a special
operation which is similar to the COPY operation. This is explained later.

It leaves the previous tree environment as the active environment
*/

int GetprevtreeOper() {
	extern int getPrevTree();
	getPrevTree();
	return TRUE;
}

/*
This operator will switch the working environment to the previous tree
which has been read by the GETPREVTREEOPER. If no previous tree has been
read in the operator will fail.
*/

extern int swToPrevTree(void);
extern int swToCurrTree(void);

int SwitchprevtreeOper() {
	swToPrevTree();
	return TRUE;
}

/*
This operator will switch the working environment to the current tree
from a previous tree environment. The previous tree environment will
be retained.
*/


int SwitchcurtreeOper() {
	swToCurrTree();
	return TRUE;
}

int ClearprevtreeOper() {
	return TRUE;
}

/*
This operator make a copy of the subtree starting at the node pointed to
by xr7 of the tree in the previous tree space. The subtree is copied to
the current tree space. The words which are subsumed by the various nodes
are in the previous tree text space. however the lists which correspond to
the definitions are in the current tree space. The words from the previous
tree which are subsumed by the subtree being copied must be moved to the
text space of the current tree.
*/


int copiedTreeRoot;
// It is expected that we are in the previous tree space
// when entering this operator

// xr7 is in the previous tree space
// lxr7 is in the current tree space

int CopyfromprevtreeOper() {
	int lxr7,sxr7,ns,i,flag=1,passflg;
	struct cpnstr *cpnodes =  new struct cpnstr [COPYLEN];
	if(list) return FALSE;
	sxr7=xr7;
	lxr7=0;
	int cpycnt=0;
	int ixfwdstmp=ixfwds;

	while(flag){

		int NDOPEStmp=NDOPES(xr7);
		int NDABTStmp=NDABTS(xr7);
		int NDSPFBtmp=NDSPFB(xr7);
		int NDHDBAtmp=NDHDBA(xr7);
		cpnodes[cpycnt].orig = xr7;

//		for non-null atomic nodes, copy attribute
//		pointer and add subsumed words to xfwds

int NDBALPtmp;
		if(NDATMT(xr7) && (!NDOTMT(xr7))){
			NDBALPtmp = NDBALP(xr7);
        		for(i=NDWPNC(xr7); i<NDWPCP(xr7); i++){
			ixfwdstmp=xfwdsQue(SENTE1(i),SENTE2(i),SENTE3(i),SENTE6(i));
				}//for
			}//if
		else int NDBALPtmp=0;

 //switch to current space and build the copied node
		swToCurrTree();
		ns = getnod();
if(lxr7==0) copiedTreeRoot=ns;
		NDOPES(ns) = NDOPEStmp;
		NDABTS(ns) = NDABTStmp;
		NDSPFB(ns) = NDSPFBtmp;
		NDHDBA(ns) = NDHDBAtmp;
		NDWPNC(ns) = ixfwds;
		NDBALP(ns) = NDBALPtmp ;
		ixfwds = ixfwdstmp;
		cpnodes[cpycnt++].copy = ns;

//                  link up with previously copied nodes

		if(lxr7 != 0) {
			NDUPLF(ns)=lxr7;
        		if(!NDFILT(ns)) NDRTPT(lxr7)=ns;
        		else NDBALP(lxr7)=ns;
			} //if

		lxr7=ns;

		swToPrevTree();

//              find next node in tree to be copied (depth-first,
//              left-to-right preorder scan)

//				go down
	if(down()) continue;
	swToCurrTree();
	while(1){ //cannnot go down 
		NDWPCP(lxr7)=ixfwds;
		NDORDC(lxr7)=0;
		swToPrevTree();
//                    if at starting node, done
		if(xr7 == sxr7) {flag=0;break;}

//                           try to go right
		if(right()) break;

//                   If can't, go up (and move lxr7, pointer to
//                   last created node, up one level)

		passflg = upone();
		swToCurrTree();
		while(!NDFILT(lxr7)) lxr7=NDUPLF(lxr7);
		lxr7=NDUPLF(lxr7);
//                           try to go right again
		}//while 1

	} // while flag

	swToCurrTree();
	NDABTS(lxr7) &= (~INDUM);

/* This form of subtree copying has an added constraint which
is not present in the general COPY operator. This comes about
because of the possibility of NA's on the nodes of this subtree
may have values which are nodes which are not in the subtree.
These NA's must be deleted. The information about the housing
in not meaningful and is discarded by the write out read in. */

swToPrevTree();
struct NAsetstr *NAlist = new struct NAsetstr [40];
for(int ind=0; ind<cpycnt; ind++){
int nd;
if(NDNODEATRIBLISTPOINTER((nd=cpnodes[ind].orig)) == 0) continue;//no NA's
// get list of NA's on node
int getNAfornode(int, struct NAsetstr *, int);
int numNAs = getNAfornode(nd, NAlist, 40);
for(int k=0; k<numNAs; k++){//loop over NAs on node
if (NAlist[k].valtype != 0) continue; // not a node value put on new

// check if value in subtree
int val= NAlist[k].value;
int m;
for(m =0; m<cpycnt; m++){
if(cpnodes[m].orig == val) NAlist[k].value = cpnodes[m].copy;
break;
}//for
if(m == cpycnt) NAlist[k].attrb=0;//value not in subtree;
}//for

	swToCurrTree();
for(int kk = 0; kk<numNAs; kk++){
if(NAlist[kk].attrb == 0) continue; // a deleted NA not in tree
int nnode = cpnodes[ind].copy;
asgnat(nnode, NAlist[kk].attrb, NAlist[kk].value, 0, 0, 0);
}//for
	swToCurrTree();
}//for

	delete cpnodes;
	return TRUE;
}

/*
REPLACEPREVTREE
   This operator replaces the tree below the node pointed to by xr7
   with the tree copied from a previous tree.
	1. If there is no previous copied tree rerurn FALSE
	2. If not pointing to a node return FALSE
	3. If not in current tree space return FALSE
*/

int ReplaceprevtreeOper(){
	int sxr7;
	if(copiedTreeRoot==0) return FALSE;
//(Cannot pass xr7 directly to fretre because fretre changes xr7)
	sxr7=xr7;
	int leftn=copiedTreeRoot;
	int rightn=copiedTreeRoot;
	int nodeLeft = NDUPLF(xr7);
	int nodeRight =  NDRTPT(xr7);
	int nodefil = NDFILT(xr7);
	mrkfre(sxr7);
	xfmtre(nodeLeft, nodeRight, nodefil, leftn, rightn);
	ixfwds=0;
	copiedTreeRoot = 0;
	if(xfixup(sxr7)<0) return FALSE;
	fretre(sxr7);// return blocks of deleted tree
	return TRUE;
}

/*
INSERTAFTERPREVTREE
*/

int InsertafterprevtreeOper(){
	if(copiedTreeRoot==0) return FALSE;
	int leftn = copiedTreeRoot;
	int rightn = copiedTreeRoot;
	int nodeLeft = NDUPLF(xr7);
	int nodeRight =  NDRTPT(xr7);
	int nodefil = 0;
	xfmtre(nodeLeft, nodeRight, nodefil, leftn, rightn);
	ixfwds=0;
	copiedTreeRoot = 0;
	xfixup(0);
	return TRUE;
}

/*
GOTONODEPOINTEDTO [(A reg)]

GOTONODEPOINTEDTO [(A)]

This operator move the pointer to a node which has a NA whose
value is the current position if no register is given or
the node pointed to by the register.
*/


int GotonodepointedtoOper(){
	int soptr=CSR(opptr);
	int attnam = CAR(soptr);
	soptr = CDR(soptr);
	int target, rlist;
	if(soptr==0 || (soptr && CAR(soptr))==0) {
		if(list) return FALSE;
		target =xr7;
		}
	else {
		getreg(CAR(soptr),&target,&rlist);
		if(rlist) return FALSE;
		if(target==0) return FALSE;
		}
int gotopointedto(int, int);
int retv= gotopointedto(target, attnam);
if(retv==0)return FALSE;
if(retv != 1){
if(tr)fill("Two values");
}
return TRUE;
}

/*
This routine adjusts the various stacks and arrays which are part if this INTERP
file. It is called by the XFIXUP function to remove the entries of which contain
deleted nodes.
*/

void fixupStacks(void){
int i,j, unreg, stkCount, rcs, *stptr;

// remove deleted nodes from the array of nodes which have been requested
// by the currently executing routine. If there is no currently executing 
// routine the this array will be empty.

	for(i=0, j=0;i<stackingCount;i++){
		if(NDSPFB(stkstk[i]) != 0) stkstk[j++] = stkstk[i];
		else if((stkstk[j]=NDGCPS(stkstk[i])) != 0)j++;
		}//for
	stackingCount =j;
// fix recursive stack
	for(i=0; i<is; i++){
		if(stack[i].list !=0)continue;
		unreg=stack[i].xr7;
		if(NDSPFB(unreg) != 0) continue;
		stack[i].xr7 = NDGCPS(unreg);
		}//for on i

// modify the entries in the environment save areas 

	int nofn;
	for(int uns=0; uns<environSavIdx; uns++){
		if((nofn=unstackInfo[uns].numOfNodes) == 0) continue;

		stkCount = unstackInfo[uns].stackCnt;
		stptr = unstackInfo[uns].stackSav;
		for(i=0; i<stkCount; i++, stptr++) {
			if(NDSPFB(*stptr) != 0) continue;
			*stptr = NDGCPS(*stptr);
			}//for

// fix saved recursive stack
		rcs = unstackInfo[uns].recurLenth;
		stackstr *stdP = unstackInfo[uns].recurSav;
		for(i=0; i<rcs; i++, stdP++) {
			unreg= stdP->xr7;
			if(NDSPFB(unreg) != 0) continue;
			stdP->xr7 = NDGCPS(unreg);
		 	}//for

// fix node in requested unstacking array
		int *ndip, *ndop;
		ndop = ndip = unstackInfo[uns].nodeListPtr;
		for(i=0; i<nofn; i++, ndip++){
			//if(NDSPFB(*ndip++) != 0){
			if(NDSPFB(*ndip) == 0){
				//*(ndop++) =*(ndip-1);
				//j++;
				//}
			//else {
				*ndip = 0;
				if(NDGCPS(*ndip) != 0){
					*ndip = NDGCPS(*ndip);
					//j++;
					}//if
				}//else
			}//for
		//unstackInfo[uns].numOfNodes = j;
		//if(j == 0){
			//deleteStackingSaves(uns);
			//chgflg=1;
			//}
		} //for
	//if(!chgflg) return;

	//int ons;
	//for(uns=0, ons=0; uns<environSavIdx; uns++){
		//if(unstackInfo[uns].numOfNodes == 0) continue;
		//unstackInfo[ons++] = unstackInfo[uns];
		//}//for
	//environSavIdx = ons;
	return;
}

//------------------------------------------------------------------

void interpRestart(){
	ngensym=0;
	return;
}
      
#if 0

// *                E R R O R   E X I T

 9000 prntif();
      skipln();
      cout<<"*** Stack overflow occured executing restriction "<<
 9005 fill(resnamP);
      prnt();
 const char * msgRestTerm="Execution of transformation terminated, success indication returned";
      pass=TRUE;
      GO TO 150

 9050 prntif();
       cout<< "\n*** Conjunction stack overflow\n"<<resnamP<<"\n"
	<<msgRestTerm<<endl;
      pass=TRUE;
      GO TO 150

 9100 prntif();
      skipln();
      fill(msgRanOutSpace);
      cout<<resnamP<<);
 9150 prnt();
cout<<msgTranTermF<<endl;
      pass=FALSE;
      GO TO 150

// 9999 parstat = -3
      return 1
#endif
