/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <fstream.h>
#include "symtab.h"
#include "common.fcm"
#include "lispdefs.fcm"

inline int MIN(int x,int y){ if(x<=y)return x;else return y;}
inline int MAX(int x,int y){ if(x<=y)return y;else return x;}
extern SymbTable sytab;
extern char * nodnam(int, char*);
extern fstream *getstptr(int);
extern void prntif(void);
extern int printSent(int,int,int,int);
extern char* subsum(int, char*);

void errmgp(int mgtp,int int1, int int2,int int3){
	const char *fatLexErr= " ***Fatal lexical error--No parse attempted";
	char nambuf[50];
	char subf[200];
	char * subsP;
	fstream *erfilP=0, *prfilP;

	prfilP = getstptr(PRUNIT);
	if(errmgf) erfilP=getstptr(errmgf);
	switch(mgtp){

	case 1:
	*coutP<<"SID="<<sentid<<" - No parses possible ."<<endl;
	printSent(1,nwordSent,0,2);

	if(errmgf) {
	*erfilP<<"SID="<<sentid<<" - No parses possible ."<<endl;
	printSent(1,nwordSent,0,errmgf);
      	}
	return;

	case 2:
	*coutP<<"SID="<<sentid<<fatLexErr<<endl;
	if(errmgf) *erfilP<<"SID="<<sentid<<fatLexErr<<endl;
	return ;
	break;

case 3:
{
        int j1=MAX(1, int1-2);
        int j4=MIN(int1+3,int2-1);
	if(errmgf) {
	*erfilP<<"SID="<<sentid<<"\nFurthest word analyzed was No. "<<int3
		<< " = "<<SENTWD(int3)<<endl;
        *erfilP<<"  Last words analyzed:";
	for(int j=j1; j<=int1; j++) *erfilP<<' '<<SENTWD(j);
	*erfilP<<endl;
	*erfilP<< "Next words to be analyzed:";
	for(int j=int1+1; j<=j4; j++) *erfilP<<' '<<SENTWD(j);
	*erfilP<<endl;
	}
	*coutP<<"SID="<<sentid<<"\nFurthest word analyzed was No. "<<int3
      		<<" = "<<SENTWD(int3)<<endl;
	*coutP<<"Last words analyzed:";
	for(int j=j1; j<=int1; j++) *coutP<<' '<<SENTWD(j);
	*coutP<<endl;
	*coutP<<"Next words to be analyzed:";
	for(int j=int1+1;j<=j4;j++) *coutP<<' '<<SENTWD(j);
	*coutP<<endl;
	return;
}

case 4:
      prntif();
	subsP=subsum(int2,subf);
	*coutP<<"SID="<<sentid<<" transf "<<STNAME(int1)<<" in "
		<<nodnam(int2, nambuf)<<" failed subsuming "
		<<subsP<<endl;
      if(errmgf)
	*erfilP<<"SID="<<sentid<<" transf "<<STNAME(int1)<<" in "
		<<nodnam(int2, nambuf)<<" failed subsuming "
		<<subsP<<endl;
      return;

case 5:
*coutP<<"SID="<<sentid<<"---Line limit exceeded/parse terminated---"<<endl;
      if(errmgf) {
*erfilP<<"SID="<<sentid<<"---Line limit exceeded/parse terminated---"<<endl;
      }
      return;

case 6:
*coutP<<"SID="<<sentid<<"---Node limit exceeded/parse terminated---"<<endl;
      if(errmgf) {
*erfilP<<"SID="<<sentid<<"---Node limit exceeded/parse terminated---"<<endl;
      }
      return;

case 7:
*coutP<<"\nSID="<<sentid
     <<"---Line limit exceeded/Transformation terminated---"<<endl;
      if(errmgf) {
	*erfilP<<"\nSID	="<<sentid
     <<"---Line limit exceeded/Transformation terminated---"<<endl;
      }
      return;

case 8:
*coutP<<"\nSID="<<sentid<<" Out of grammar list space---\n"<<endl;
      if(errmgf) {
*erfilP<<"\nSID="<<sentid<<" Out of grammar list space---\n"<<endl;
      }
      return;

case 9:
*coutP<<"\nSID="<<sentid<<" Parsing Segment --\n"<<endl;
//      DO i=1,srclen PRINT *, SOURCE(i) ENDDO 
      if(errmgf) {
*erfilP<<"\nSID="<<sentid<<" Parsing Segment --\n"<<endl;
      }
      return;

case 10:
*coutP<<"\nSID="<<sentid<<" Undefined Word: "<<SENTE1(int1)<<endl;
      if(errmgf)  *erfilP<<
"\nSID="<<sentid<<" Undefined Word: "<<SENTE1(int1)<<endl;
      return;

case 11:
if(int1>0){
*coutP<<"SID="<<sentid<<" Undefined word(s). Parse attempted to word : "<<int1
   <<": "<<SENTWD(int1)<<endl;
      if(errmgf) {
*erfilP<<"SID="<<sentid<<" Undefined word(s). Parse attempted to word : "<<int1
   <<": "<<SENTWD(int1)<<endl;
	}	
      }
else {
*coutP<<"SID="<<sentid<<" Undefined first word. No Parse attempted"<<endl;
if(errmgf) *erfilP<<"SID="<<sentid<<" Undefined first word. No Parse attempted"<<endl;
	}
      return ;

case 12: // maxtime message
*coutP<<"SID="<<sentid<<" Maximum Time="<<maxtime<<" Exceeded"<<endl;
      if(errmgf) {
*erfilP<<"SID="<<sentid<<" Maximum Time ="<<maxtime<<"Exceeded"<<endl;
}
      }//switch
}
