*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      FUNCTION LOOKST (NM)
*
************************************************************************
*
*     LOOKST searches the symbol table for -NM-, returning the
*     index of the symbol table entry if it appears, else 0.
*
************************************************************************
*
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*(*) NM
      INCLUDE 'asf.fcm'
*
      LOOKST=0
*                  GET HASH TABLE POINTER
      LINK=HASHLK(IHASH(NM))
*                  IF 0 (NO LIST/END OF LIST), RETURN 0
   10 IF(LINK.EQ.0) RETURN
*                  COMPARE SYMBOL TABLE ENTRY WITH NM
      IF(STNAME(LINK).EQ.NM) GO TO 20
*                  NO MATCH -- GET NEXT SYMBOL TABLE ENTRY
      LINK=STLINK(LINK)
      GO TO 10
*                  MATCH -- RETURN INDEX OF SYMBOL TABLE ENTRY
   20 LOOKST=LINK
      RETURN
      END
      FUNCTION PUTST (NM)
*
************************************************************************
*
*     PUTST CREATES A NEW SYMBOL TABLE ENTRY CONTAINING -NM-, AND
*     RETURNS THE INDEX OF THIS ENTRY.
*
************************************************************************
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*(*) NM
      INCLUDE 'asf.fcm'
*
*                  GET FREE SYMBOL TABLE ENTRY
      IF(FREELK.NE.0) GO TO 20
      CALL EXITR(' ***** Symbol table full, run terminated')
   20 LINK=FREELK
      FREELK=STLINK(FREELK)
*                  STORE -NM- IN TABLE
      STNAME(LINK)=NM
*                  LINK ENTRY INTO SYMBOL TABLE
      NHASH=IHASH(NM)
      STLINK(LINK)=HASHLK(NHASH)
      HASHLK(NHASH)=LINK
      PUTST=LINK
      RETURN
      END
      SUBROUTINE RMVST (INDEX)
*
************************************************************************
*
*     RMVST REMOVES SYMBOL TABLE ENTRY  INDEX  FROM SYMBOL TABLE
*
************************************************************************
*
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'asf.fcm'
*                            I. DETERMINE ON WHICH LINKED LIST OF SYMBOL
*                               TABLE THIS ENTRY APPEARS
      K=IHASH(STNAME(INDEX))
      LINK=HASHLK(K)
*                            II. CHECK IF ENTRY SOUGHT IS FIRST ONE ON
*                                LIST
      IF(LINK.NE.INDEX) GO TO 25
*                               A. YES--RESET HASHLK TO NEXT LIST MEMBER
      HASHLK(K)=STLINK(INDEX)
*                            III. PLACE ENTRY ON FREE LIST
   10 STLINK(INDEX)=FREELK
      FREELK=INDEX
*                               A. CLEAR OUT NAME, TYPE
      STNAME(INDEX)=' '
      STTYPE(INDEX)=0
      RETURN
*                            IV. SEARCH LIST FOR ENTRY
   20 LINK=STLINK(LINK)
*                               A. IF END OF LIST HIT FIRST, ERROR
   25 IF(LINK.EQ.0) GO TO 90
      IF(STLINK(LINK).NE.INDEX) GO TO 20
*                               B. SPLICE ENTRY OUT OF LIST
      STLINK(LINK)=STLINK(INDEX)
*                               C. GO PUT ENTRY ON FREE LIST
      GO TO 10
   90 PRINT 91
   91 FORMAT(/'**** RMVST has found error in symbol table linkage')
      RETURN
      END
      FUNCTION GETST (NME,JYTYP)
      IMPLICIT INTEGER(A-Z)
      CHARACTER*(*) NME
      SYTYP=JYTYP
      INDEX=LOOKST(NME)
      IF(INDEX.EQ.0)INDEX=PUTST(NME)
      IF(SYTYP.NE.0)CALL SETTYP (INDEX,SYTYP)
      GETST=INDEX
      RETURN
      END
      SUBROUTINE SSTRFC(P,V)
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'asf.fcm'
      STREFC(P)=V
      RETURN
      ENTRY SSTTYP(P,V)
      STTYPE(P)=V
      RETURN
      ENTRY SSTADR(P,V)
      STADDR(P)=V
      RETURN
      ENTRY SSTLNK(P,V)
      STLINK(P)=V
      RETURN
      END
      SUBROUTINE SETTYP (INDEX,SYTYP)

************************************************************************
*
*     SETTYP or's SYTYP into STTYPE(INDEX).  If the type field (bits 0
*     to 3) of STTYPE(INDEX) are nonzero and different from the type
*     field of SYTYP, an error message is printed.
*
************************************************************************

      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'asf.fcm'
*
      IF(AND(STTYPE(INDEX),15).EQ.0) GO TO 10
      IF(AND(SYTYP,15).EQ.0) GO TO 10
      IF(AND(STTYPE(INDEX),15).NE.AND(SYTYP,15)) GO TO 20
   10 STTYPE(INDEX)=OR(STTYPE(INDEX),SYTYP)
      RETURN
   20 PRINT 25, STNAME(INDEX)
   25 FORMAT(' *** Type of symbol ',A20,'conflicts with prior usage')
      RETURN
      END
