*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE RIGHT
***********************************************************************
*
*     This program contains the basic routines for moving about
*     the parse tree.  Its entry points are:
*          RIGHT -- go to node right of current node
*          LEFT1 -- go to node left of current node
*          UPONE -- go to node above current node
*          DOWN  -- go to leftmost node on level below current node
*          DNRIT -- go to rightmost node on level below current node
*     On entry, XR7 points to the current node.
*     ON exit, PASS=.TRUE. If the operation could be performed,
*     XR7 then points to the new current node.
*     PASS=.FALSE. If the operation could not be performed,
*     XR7 is unchanged
*
************************************************************************
*
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*
      IF(NDRTPT(XR7).EQ.0) GO TO 2
      XR7=NDRTPT(XR7)
 1    PASS = .TRUE.
      RETURN
 2    PASS = .FALSE.
      RETURN
*
      ENTRY LEFT1
*
      IF (NDFILT(XR7)) GO TO 2
      XR7=NDUPLF(XR7)
      GO TO 1
*
      ENTRY UPONE
*
      NXR7=XR7
 3    IF (NDFILT(XR7)) GO TO 4
      XR7=NDUPLF(XR7)
      GO TO 3
 4    XR7=NDUPLF(XR7)
      IF (XR7.NE.0) GO TO 1
      XR7=NXR7
      GO TO 2
*
      ENTRY DOWN
*
      IF (NDATMT(XR7)) GO TO 2
      IF (NDBALP(XR7).EQ.0) GO TO 2
      XR7=NDBALP(XR7)
      GO TO 1
*
      ENTRY DNRIT
*
      IF (NDATMT(XR7)) GO TO 2
      IF(NDBALP(XR7).EQ.0) GO TO 2
      XR7=NDBALP(XR7)
 5    IF (NDRTPT(XR7).EQ.0) GO TO 1
      XR7=NDRTPT(XR7)
      GO TO 5
      END
