*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE RECURS (I,*)

************************************************************************
*
*     A left-recursive construction in the grammar would cause a top-
*     down parser such as our routine PARSER to enter an infinite loop.
*     To avoid this, parser calls recurs to keep track of those nodes
*     which can appear in left-recursive loops.  (Such nodes must be
*     flagged explicitly by the grammar writer by placing them on the
*     RECURSIVE list.)  The routine recurs enforces the requirement that
*     a subtree containing n-1 occurrances of a recursive node named T
*     at a word W be completed successfully before it will permit a
*     tree with N occurrances of that recursive node at word W to be
*     built.  Note that this requires that the option of a definition
*     which leads to a left recursive loop must be the last option in a
*     BNF definition.
*          For each word in the sentence, for each recursive definition,
*     the PARSER maintains (through calls on RECURS) the following three
*     counters:
*        APPEARANCE-COUNT:   the number of nodes corresponding to this
*                            definition which appear in the current tree
*                            beginning at this word
*        COMPLETION-COUNT:   the number of nodes corresponding to this
*                            definition which appear in the current tree
*                            beginning at this word and have been
*                            completed
*        SUCCESS-COUNT:      the maximum number of occurrances of a node
*                            corresponding to this definition beginning
*                            at this word which have all been success-
*                            fully completed (at any time during the
*                            parsing of this sentence)
*
*     These counters are maintained on lists pointed to by elements of
*     the fifth column of SENTE.  SENTE5(WORD) points to a list of
*     elements, each of which holds the three counters for a
*     particular recursive definition in the following LITHP format:
*          DEFINITION-NAME
*             [ ( SUCCESS-COUNT [ APPEARANCE-COUNT ] COMPLETION-COUNT )]
*          RECURS IS INVOKED AT FIVE POINTS IN THE ROUTINE PARSER;
*     It is passed a single argument, whose value is 0, 1, 2, 3, or 4.
*     the value of the argument, the point in the parse where RECURS is
*     called with this argument, and the operation performed by RECURS
*     are tabulated below.
*
*      0    INITIALIZATION      clear RECUR array
*
*      1    WHEN A RECURSIVE    if there is an element corresponding
*           NODE IS ABOUT TO       to this definition at this word
*           BE ATTACHED         then if APPEARANCE-COUNT/=SUCCESS-COUNT
*                                    then return with PASS=.F.
*                                    ELSE APPEARANCE-COUNT =
*                                                APPEARANCE-COUNT + 1
*                                         return with PASS=TRUE
*                               else set up an element for this
*                                    definition at this word with
*                                        APPEARANCE-COUNT = 1
*                                        COMPLETION-COUNT = 0
*                                        SUCCESS-COUNT = 0
*                                    and return with PASS=TRUE
*
*      2    WHEN A RECURSIVE    COMPLETION-COUNT = COMPLETION-COUNT+1
*           NODE IS COMPLETED,  if COMPLETION-COUNT .EQ. APPEARANCE-
*           BEFORE ANY WELLF.                                 COUNT
*           RESTRICTIONS ON     then SUCCESS-COUNT = APPEARANCE-
*           IT ARE EXECUTED                                   COUNT
*
*      3    WHEN DESCENDING     COMPLETION-COUNT = COMPLETION-COUNT-1
*           THROUGH A
*           RECURSIVE NODE
*
*      4    WHEN A RECURSIVE    APPEARANCE-COUNT = APPEARANCE-COUNT-1
*           NODE IS DETACHED
*
************************************************************************

      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      EQUIVALENCE (W,WORD)
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*
      IF(I .EQ. 0) THEN
*                            I. I=0:  CLEAR RECUR
      DO 10 M=1,SENLIM
 10   SENTE5(M)=0
      RETURN
      ENDIF
*                            II. GET CURRENT NODE NAME AND WORD
      IF(I .EQ. 1) THEN
        NODNDX=CAR(ELEMT)
        IW=WORD
      ELSE
        NODNDX=CAR(NDHDBA(XR7))
        IW=NDWPNC(XR7)
      ENDIF
      IF(RECTRC) PRINT 41, I, STNAME(NODNDX), IW
   41 FORMAT(' CALL TO RECURS (',I1,') FOR NODE ',A10,
     =   ' STARTING AT WORD',I4)
*                            III. LOOK FOR ELEMENT IN RECURSIVES LIST
*                                 CORRESPONDING TO CURRENT DEF + WORD
      IF(SENTE5(IW) .EQ. 0) GO TO 60
      L=SENTE5(IW)
   50 IF(CAR(L) .EQ. NODNDX) GO TO 80
      L=CDR(L)
      IF(L .NE. 0) GO TO 50
*                               A. NOT THERE
*                                  1. IF I=1 CREATE ELEMENT AND
*                                     RETURN WITH PASS=TRUE
   60 IF(I .NE. 1) GO TO 70
      POINTR=GCONS(0,1,0)
      if(pointr.le.0)return1
      SENTE5(IW)=GCONS(SENTE5(IW),POINTR,NODNDX)
      if(sente5(iw).le.0)return1
      PASS=.TRUE.
      GO TO 500
*                                  2. IF I/=1 ERROR
   70 PRINT 71, STNAME(NODNDX),IW
   71 FORMAT(' ***** No recursive element FOR ',A10,
     =   ' starting at word',I4)
      RETURN
*                               B. FOUND IT
   80 POINTR=CSR(L)
      GO TO (100,200,300,400), I
*                            IV. I=1:  ATTACHING NEW ELEMENT
  100 IF(CSR(POINTR).GT.CAR(POINTR)) GO TO 110
*                               A. APPEARANCE-COUNT?=SUCCESS-COUNT
*                                  1. INCREMENT APPEARANCE-COUNT BY 1
*
      CSR(POINTR)=CSR(POINTR)+1
*                                  2. RETURN WITH PASS=TRUE
      PASS=.TRUE.
      GO TO 500
*                               B. APPEARANCE COUNT^SUCCESS-COUNT
*                                  1. IF TRACE IS ON, PRINT MESSAGE
  110 IF(TRACE) THEN
        CALL PRNT
        PRINT 112
  112 FORMAT(' >>>>> Recursion')
      ENDIF
*                                  2. RETURN WITH PASS=FALSE
      PASS=.FALSE.
      GO TO 500
*                            V. I=2:  NODE COMPLETED
*                               A. INCREMENT COMPLETION-COUNT BY 1
  200 CDR(POINTR)=CDR(POINTR)+1
*                               B. IF COMPLETION-COUNT=APPEARANCE-COUNT,
*                                  SET SUCCESS-COUNT=COMPLETION-COUNT
      IF(CDR(POINTR) .EQ. CSR(POINTR)) CAR(POINTR)=CSR(POINTR)
      GO TO 500
*                            VI. I=3:  DESCENDING THROUGH NODE,
*                                DECREMENT COMPLETION-COUNT BY 1
  300 CDR(POINTR)=CDR(POINTR)-1
      GO TO 500
*                            VII. I=4:  DETACHING NODE,
*                                 DECREMENT APPEARANCE-COUNT BY 1
  400 CSR(POINTR)=CSR(POINTR)-1
*                            VIII. IF RECURSION TRACE IS ON, PRINT OUT
*                                  COUNTER VALUES AFTER CALL
  500 IF(RECTRC) THEN
        N1=CSR(POINTR)
        N2=CDR(POINTR)
        N3=CAR(POINTR)
        PRINT 501, N1, N2, N3
  501 FORMAT(6X,'After call appearance count=',I3,
     ='    Completion count=',I3,' Success count=',I3)
      ENDIF
      RETURN
      END
