*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE FILL (ITEM)
*
************************************************************************
*
*     FILL writes 'ITEM', a character string of 'LENGTH' characters,
*     into the currently active output buffer 
*
************************************************************************
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'printr.fcm'
      CHARACTER*(*) ITEM
      LENGTH=LEN(ITEM)
      OTU=WUTIX(OTUNIT)
      CALL FILLIN (LINE(OTU),COL(OTU),ITEM,LENGTH,RM(OTU))
      RETURN
      END
*
      SUBROUTINE FILLTR(ITEM)
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'printr.fcm'
      CHARACTER*(*) ITEM
      LENGTH=TRMLEN(ITEM)
      IF(LENGTH.EQ.0) RETURN
      OTU=WUTIX(OTUNIT)
      CALL FILLIN (LINE(OTU),COL(OTU),ITEM,LENGTH,RM(OTU))
      RETURN
      END
      SUBROUTINE FILLIN (BUFFER,POS,ITEM,ACTLEN,LIMIT)
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'printr.fcm'
      CHARACTER*(*) BUFFER,ITEM
      if(actlen .eq.0) then
        print *,'in fillin: attempting to print a blank item'
        return
      end if
*                  if ITEM will not fit on line, print current line
      BUFSIZ=ABS(LIMIT)
      IF((POS+ACTLEN-1.LE.BUFSIZ).OR.(LIMIT.LT.0)) GO TO 20
      CALL PRNT
      IF(OTUNIT.EQ.PRUNIT) POS=INDENT
*                    MOVE ITEM TO BUFFER
   20 DO 40 J=1,ACTLEN
      IF(POS.GT.BUFSIZ) GO TO 50
      IF(ITEM(J:J).EQ.'!') THEN
      BUFFER(POS:POS)=' '
      ELSE
      BUFFER(POS:POS)=ITEM(J:J)
      END IF
      POS=POS+1
   40 CONTINUE
   50 RETURN
      END
      SUBROUTINE PRNT
*
************************************************************************
*
*     PRNT flushes the currently active output line buffer onto unit
*     OTUNIT.  If PPARSW=.TRUE. (we are printing a parse tree), LINEP
*     are flushed onto the print file.
*
************************************************************************
*
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'printr.fcm'
*
      IF(PPARSW) GO TO 50
*                  write output line buffer onto output unit
      OTU=WUTIX(OTUNIT)
   10 TRL=TRMLEN(LINE(OTU))
      IF(OTUNIT.EQ.PRUNIT) THEN
        IF(TRL.GT.0)THEN
          PRINT 20, LINE(OTU)(1:TRL)
        ELSE
          PRINT 21
   21 FORMAT(' ')
        END IF
      ELSE
        IF(TRL.GT.0) THEN
          WRITE(UNIT=OTUNIT,FMT=20) LINE(OTU)(1:TRL)
        ELSE
          WRITE(UNIT=OTUNIT,FMT=21)
        END IF
      END IF
   20 FORMAT(A)
*                       reset column pointer to left margin
      COL(OTU)=1
      IF(OTUNIT.EQ.PRUNIT) COL(OTU)=2
*             fill buffer with spaces
      LINE(OTU)=' '
*          if writing to the print file, decrement the line limit
      IF(OTUNIT.EQ.PRUNIT) LINZ=LINZ-1
      RETURN
*
*               PRINTING PARSE TREE -- FLUSH LINE1 AND LINE2
*
   50 TRL=TRMLEN(LINEP(1))
      IF(TRL.GT.0)THEN
        WRITE(UNIT=OTUNIT,FMT=20) LINEP(1)(1:TRL)
      END IF
      TRL=TRMLEN(LINEP(2))
      IF(TRL.GT.0) THEN
        WRITE(UNIT=OTUNIT,FMT=20) LINEP(2)(1:TRL)
      END IF
      LINEP(1)=' '
      LINEP(2)=' '
      LINEZ=LINEZ-2
      NEND=INDENT
      RETURN
      END
*
      SUBROUTINE PRNTIF
*
************************************************************************
*
*     PRNTIF flushes the currently active output line buffer if it is
*     not empty (all blank).
*
************************************************************************
*
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'printr.fcm'
      IF(.NOT.PPARSW) THEN
      OTU=WUTIX(OTUNIT)
      IF(LINE(OTU).NE.' ') call prnt
      ELSE
      IF(LINEP(1).NE.' ' .OR. LINEP(2).NE.' ') call prnt
      ENDIF
      RETURN
      END
      SUBROUTINE SKIPLN
*
***********************************************************************
*
*     Skip a line in the print file
*
***********************************************************************
*
      WRITE(OTUNIT,FMT='('' '')')
      RETURN
      END
*
      SUBROUTINE OTUSEL(NUNIT)
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'printr.fcm'
      IF(NUNIT.LT.6)CALL EXITR('Out Unit must be 6 or larger')
      IF(WUTIX(NUNIT).EQ.0) THEN
      DO  I=2,NPLBFS
      IF(WUFBFL(I).EQ.0) GO TO 11
      ENDDO
   11 WUTIX(NUNIT)=I
      WUFBFL(I)=NUNIT
      END IF
      OTUNIT=NUNIT
      RETURN
      ENTRY OTSIN
      WUTIX(PRUNIT)=1
      WUFBFL(1)=PRUNIT
      RETURN
      END
