*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE PLIST (LSTPTR,PRETTY)
*
************************************************************************
*     PLIST prints the list pointed to by LSTPTR in LITHP format.  The
*     list structure is output as a continuous stream of characters.
*
*    PLIST with PRETTY=.TRUE. ('PRETTY-PRINT LIST") also prints the list 
*    pointed to by LSTPTR,  but with appropriate indentation to facilitate 
*    reading the list.
************************************************************************
      IMPLICIT INTEGER (A-Z)
      LOGICAL PRETTY
      call plistg(lstptr,pretty,0)
      return
      end
      subroutine plistnn(lstptr,pretty)
      IMPLICIT INTEGER (A-Z)
      LOGICAL PRETTY
      call plistg(lstptr,pretty,1)
      return
      end

      SUBROUTINE PLISTG(lstptr,pretty,type)
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'printr.fcm'
      LOGICAL PRETTY,FRSTEL
      CHARACTER*(WORDLEN) TNAME
      CHARACTER*8 DEC
      CHARACTER*60 LITNAM
      PARAMETER (KPLIM=500)
      INTEGER POSSTK(KPLIM),SKTSTK(KPLIM)
      INCLUDE 'asf.fcm'
*
      IF(LSTPTR.EQ.0) THEN
        CALL FILL(' NIL')
        CALL PRNT
        RETURN
	ENDIF
*
      IF(.NOT.ATOMP(LSTPTR)) GO TO 40
      IFLD=LSTPTR

      ASSIGN 20 TO IRET
      GO TO 400
*
   20 RETURN
   40 POS=LSTPTR
      KP=0
*                        A. save current print column
*                           (for pretty printing)
   50 SKOUNT=COL(WUTIX(OTUNIT))
      FRSTEL=.TRUE.
*                       B. output (
      CALL FILL('(')
*                            II. analyze address field
*                               A. extract it
  100 IFLD=CAR(POS)
*       if(debuga.ne.0) then
*       print *,'pos ifld',pos,ifld
*       if(ifld.gt.50000) then
*       lll=9
*       endif
*       endif
      IF(IFLD.EQ.0) GO TO 180
      IF(.NOT.ATOMP(IFLD)) GO TO 120
*                               B. if field points to symbol, go to
*                                   to print it
      ASSIGN 160 TO IRET
      GO TO 400
*                               C. otherwise stack current position and
*                                  pursue lower level list
  110 POS=-POS
  120 KP=KP+1
      IF(KP.GT.KPLIM)  THEN
      CALL PRNT
      PRINT 131
  131 FORMAT(' *** List circular or too deeply nested, cannot be printed
     =')
      RETURN
      END IF
      POSSTK(KP)=pos
      SKTSTK(KP)=SKOUNT
      POS=IFLD
      GO TO 50
*                               D. for atomic address field, save print
*                               column after printing atom (FOR PRETTY-PRINT)
  160 IF(FRSTEL) SKOUNT=COL(WUTIX(OTUNIT))
      GO TO 200
*                               E. FOR 0 ADDRESS FIELD, PRINT  NIL
  180 CALL FILL('NIL')
*                            III. analyze special field
*                               A. extract field
  200 IFLD=CSR(POS)
*                               B. if null print nothing
      IF(IFLD.EQ.0) GO TO 300
*                               C. OUTPUT [
      CALL FILL(' [')
*                               D. IF FIELD DOES NOT POINT TO HEAD, GO
*                                  STACK CURRENT POSITION AND PURSUE
*                                  LOWER LEVEL LIST
      IF(.NOT.ATOMP(IFLD)) GO TO 110
*                               E. ELSE GO TO V. TO PRINT FIELD
      ASSIGN 280 TO IRET
      GO TO 400
*                               F. output ]
  280 CALL FILL(']')
*                            IV. get next word
  300 POS=CDR(POS)
      IF(POS.EQ.0) GO TO 320
      IF(ATOMP(POS)) GO TO 310
*                               A. not at end of list
      FRSTEL=.FALSE.
*                                  1. IF PRETTY-PRINTING, FLUSH THE LINE
*                                      BUFFER AND RESET THE COLUMN CNTR
      IF(PRETTY .AND. COL(WUTIX(PRUNIT)).NE.SKOUNT) THEN
        CALL PRNT
        COL(WUTIX(PRUNIT))=SKOUNT
      END IF
*                                  2. OUTPUT SPACE
      CALL FILL(' ')
*                                  3. GO BACK FOR NEXT WORD
      GO TO 100
*                               B. SYMBOL IN CDR FIELD
*                                  1. OUTPUT .
  310 CALL FILL(' . ')
*                                  2. GO TO V. TO PRINT SYMBOL
      IFLD=POS
      ASSIGN 320 TO IRET
      GO TO 400
*                               C. AT END OF LIST
*                                  1. OUTPUT )
  320 CALL FILL(')')
*                                  2. IF THIS IS TOP LEVEL LIST, FLUSH
*                                     BUFFER AND RETURN
      IF(KP.LE.0) THEN
      IF(TYPE.EQ.0) CALL PRNT
      RETURN
      ENDIF
*                                  3. ELSE GET PREVIOUS POSITON FROM
*                                     STACK
      POS=POSSTK(KP)
      SKOUNT=SKTSTK(KP)
      KP=KP-1
      IF(POS.GE.0) GO TO 200
      POS=-POS
      GO TO 280
* ------------------------------------------------------------
*                            V. PRINT FIELD
  400 if(AND(CSR(ifld),NONAM).NE.0) THEN
*                               A. PRINT NUMBER OF UNNAMED HEAD
        CALL FILL('*')
        NAME=DEC(CAR(ifld),1)
        CALL FILL(NAME(1:1))
      ELSE IF(AND(CSR(IFLD),CNSTBT).EQ.0) THEN
*                               B. print symbol name or literal
        NAME=STNAME(CAR(IFLD))
        IF(AND(CSR(ifld),LTOMIC).NE.0) THEN
          KK=1
          KFLD=IFLD
  405   NAME=STNAME(CAR(KFLD))
        LITNAM(KK:KK)='_'
        KK=KK+1
        DO 406 J=1,TRMLEN(NAME)
*                             if an embedded apostrophe in literal make
*                             two apostrophes
        IF(NAME(J:J).EQ.'''')THEN
          LITNAM(KK:KK)=''''
          KK=KK+1
        END IF
        LITNAM(KK:KK)=NAME(J:J)
        KK=KK+1
  406   CONTINUE
        KFLD=CDR(KFLD)
*       if(kfld) GO TO 405 -- original
        if(kfld.ne.0) GO TO 405
        LITNAM(1:1)=''''
        LITNAM(KK:KK)=''''
        CALL FILL(LITNAM(1:KK))
      ELSE
        NAME=STNAME(CAR(ifld))
        CALL FILLTR(NAME)
      ENDIF
      ELSE
*                                C. print numeric symbol
      NAME=DEC(CDR(ifld),0)
      CALL FILL(NAME(1:4))
      ENDIF
      GO TO IRET, (20,160,280,320)
      END
