*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE PARSER(WORDSTRT,NUMTOKEN,*)
************************************************************************
*     PARSER is the top level routine controlling the parsing of sent-
*     ences.  PARSER interprets the context-free component of the gram-
*     mar and tries to build, in NODE, a parse tree for the sentence.
*     the basic algorithm is a top-down sequential parser for
*     context-free grammars, augmented by a mechanism for checking for
*     left recursion.
*          To obtain the first analysis of a sentence, PARSER should be
*     called with PAR=.FALSE. and the appropriate information about the
*     sentence in the array SENTE.  If a parse is obtained, PARSER
*     will return with PAR=.TRUE., if not, with PAR=.FALSE. .  To find
*     out whether there are any additional parses, PARSER can be
*     called again with PAR=.TRUE.
************************************************************************
       
*-----------------------------------------------------------------------
*      
*                       THE PARSE TREE (NODE ARRAY)
*      
*     The parse tree is an interconnected set of nodes.  Each node
*     corresponds either to a definition which appears in the derivation
*     of the sentence or to an atomic category.  Each node in the tree
*     is represented by a set of fields in the NODE array.
*     In our tree representation, only the first (leftmost) daughter
*     node points to its parent;  second and subsequent daughter nodes
*     point instead to the node immediately to their left. In describing
*     the structure of the nodes, we therefore must differentiate
*     between first-in-level nodes and other nodes.  Whether
*     or not a node is a first-in-level is determined by bit FIL in
*     word 4 of the node.
*          The structure of the node also depends on whether the node
*     was attached as a normal consequence of appearing in the
*     definition of its parent, or was attached by the special process
*     mechanism.  Nodes attached by the special process mechanism are
*     indicated by bit SPNODE in the field NDABTS of the node being on.
*          Throughout the program, the statement that a variable points
*     to a node means that the variable contains the index in array NODE
*     of the first word of the node.
*          The actual allocation of the fields to bits bytes and words
*     in the node array is described in the INCLUDE file.
*      
*        -NDUPLF- if first-in-level, a pointer to the node above this no
*                 if not first-in-level, a pointer to the node to the le
*                                  of this node
*      
*        -NDOPES-
*              if a first-in-level node, a pointer to the option in the
*                 definition of the parent of this node of whi*h this
*                 node is the first element
*              if not a first-in-level node, a pointer to the element
*                 in the definition of the parent of this node which
*                 corresponds to this node
*           = 0 only for the root node
*      
*        -NDBALP- if this node corresponds to a BNF definition (the atom
*              bit in -NDSPFB- of this node is 0) a pointer to the node
*              this node
*           if this node corresponds to an atomic category of a word
*              (the atomic bit in -NDSPFB- = 1 and the LTOMIC and OTOMIC
*              bits in NDSPFB = 0), a pointer to the beginning of the
*              attribute list of that category
*           = 0 if this node corresponds to a literal or null (the
*               ATOMIC bit and either the LTOMIC or OTOMIC bit in NDSPFB
*               = 1)
*      
*        -NDRTPT-   a pointer to the node to the right of this node
*                 = 0 if this is the rightmost daughter of its parent
*      
*        -NDWPNC-  contains the number of the sentence word which was
*                  pending when the node was created;  for non-empty
*                  nodes, this is the number of the first word subsumed
*                  by the node
*      
*        -NDABTS-  contains individual bit flags;  we refer to these by
*                  the names of the variables which contain the corres-
*                  ponding bit masks (for the values of these masks,
*                  see parameters in INCLUDE file.  these bits are:
*                  FIL   = 1 if the node is a first-in-level
*                  INDUM = 1 if the parent of this node is a dummy
*                           (unnamed) node [this bit is used by the
*                           routines ORIGHT, OLEFT, OUPONE, an ODOWN]
*        -NDSPFB-  a copy of the special field of the head of the BNF
*                    definition or atomic symbol corresponding to this n
*      
*        -NDWPCP-  contains the number of the sentence word which was
*                  pending immediately after this node was completed;
*                  for non-empty nodes, this is the number of the last
*                  word subsumed by this node + 1.
*      
*        -NDORDC-
*                  if this node corresponds to an atomic category (the
*                   atomic bit in -NDSPFB- = 1 and the LTOMIC and OTOMIC
*                   bits in -NDSPFB- = 0), the ordinal of the category
*                   corresponding to this node in the category list
*                   the word pending when this node was attached
*              else 0
*      
*        -NDHDBA- a pointer to the head of the BNF definition or atomic
*                 symbol corresponding to this node
*      
*        -NDGCPS- when compiling , this field is used by subroutine GEN
*                  (the code generator) to point to the code generated
*                  for this node
*          the size of the node array is stored in NDLIM.
*      
*-----------------------------------------------------------------------
*      
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'parblk.fcm'
      INCLUDE 'printr.fcm'
      EQUIVALENCE (W,WORD)
      LOGICAL FILSW
      CHARACTER*(WORDLEN) SENTWD
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
      SENTWD(X)=STNAME(SENTE1(X))
*      
      NWORD=WORDSTRT+NUMTOKEN
      MINWD=NWORD
      INDENT=7
*                            I. INITIALIZATION
*                               B. SET COUNTERS AND SWITCHES
*                                  1. word in sentence
      WORD=WORDSTRT
      FURWORD=WORD
*                                  2. PARSE COUNT
      PARSNO=0
*                                  3. DIVISION LIST POINTER
      DLP=GRROOT
*                                  4. initialize GETNOD which will

*                                     set pointer to next available node
      CALL GETNODINIT
*                                     pointer to list of free nodes (list
*                                     grows as nodes are detached)
*                                  6. count of nodes in parse tree
      NINTRE=0
      FILSW=.FALSE.
      do i=worsstart,nword-1
        sente3(i)=0
      enddo
*                               C. set up root node
      CALL GETNOD(NS)
*     NDABTS(NS)=FIL
      NODEX(2*(NS)+8)=FIL                                                           
*     NDWPNC(NS)=WORDSTRT
      NODEX(2*(NS)+7)=WORDSTRT                                                      
*     NDSPFB(NS)=CSR(GRROOT)
      NODE(NS+5)=CSR(GRROOT)                                                        
*     NDHDBA(NS)=GRROOT
      NODE(NS+7)=GRROOT                                                             
      XR7=NS
*      
*                               D. initialize trace
      ELEMT=GRROOT
      IF(TRACE) CALL NODTRC(0)
*                               E. initialize RECUR
      CALL RECURS(0,*9999)
*                            II. GET NEXT DIVISION LIST
  100 DLP=CDR(DLP)
*                               A. IF NO MORE DIVISION LISTS FOR THIS
*                                  SPAN, GO TO VI. TO TEAR UP TREE
      IF(DLP .EQ. 0) GO TO 600
      FILSW=.TRUE.
      NDBITS=0
      ELEMT=CAR(CAR(DLP))
      IF(ELEMT .EQ. 0) GO TO 700
*                               B. if trace is on, print first element
      IF(TRACE) THEN
        CALL NODTRC(1)
        IF(LINZ.LT.0) THEN
          PARSTAT=-1
          RETURN1
        END IF
      END IF
*                            III. ATTACH NODE
*                               A. IF NODE TO BE ATTACHED IS RECURSIVE,
*                                  CHECK RECURSIVES LIST
  200 IF(AND(CSR(ELEMT),RECBT) .EQ. 0) GO TO 210
      CALL RECURS (1,*9999)
*                                  1. IF DISQUALIFIED FOR RECURSION, GO
*                                     TO B.1--BACK UP OR GET NEXT OPTION
      IF(PASS) GO TO 220
      IF(TRACE) CALL NODTRC (2)
      GO TO 219
*                               B. IF ELEMENT IS ATOMIC AND NOT NULL,
*                                  CHECK AGAINST CURRENT WORD
  210 IF(AND(CSR(ELEMT),(ATOMIC+OTOMIC)) .NE. ATOMIC) GO TO 220
      KATEG=0
      CALL LAW (KATEG,NEWW,IATTRB)
      IF(KATEG .NE. 0) GO TO 220
*                                  1. IF NO MATCH
*                                     (A). PRINT -(...) IF TRACE IS ON
      IF(TRACE) CALL NODTRC (2)
*                                     (C) IF LOOKING AT FIRST ELEMENT
*                                         TRY NEXT OPTION
  219 IF(FILSW) GO TO 100
*                                     (D) ELSE BACK UP
      IF(TRACE) CALL NODTRC (4)
      GO TO 500
*                               C. GET FREE SPACE IN NODE ARRAY
  220 CALL GETNOD (NS)
*                                  1. IF NODE LIMIT EXCEEDED, RETURN
      IF(NODZ.LT.0) THEN
        PARSTAT=-2
      IF(TRACE) THEN
      ENDIF
        RETURN1
      ENDIF
      IF(NS .EQ. 0) GO TO 703
*                               D. BUILD NEW NODE
      IF(.NOT. FILSW) THEN
*                                  1. NOT FIRST IN LEVEL:  SET RIGHT PTR
*                                     IN CURRENT NODE TO NEW NODE
*       NDRTPT(XR7)=NS
        NODE(XR7+3)=NS                                                              
*                                     (A) IF CURRENT NODE HAS IN DUMMY
*                                         FLAG SET, FLAG NEW NODE TOO
        IF(NDIDMT(XR7)) NDBITS=NDBITS+INDUM
      ELSE
*                                  2. FIRST IN LEVEL: SET DOWN POINTER
*                                     IN CURRENT NODE TO NEW NODE
*       NDBALP(XR7)=NS
        NODE(XR7+2)=NS                                                              
*                                     (A) SET FIRST-IN-LEVEL FLAG
        NDBITS=NDBITS+FIL
*                                     (B) IF CURRENT NODE IS UNNAMED,
*                                         SET IN DUMMY FLAG
        IF(NDNONT(XR7)) NDBITS=NDBITS+INDUM
      END IF
*     NDWPNC(NS)=WORD
      NODEX(2*(NS)+7)=WORD                                                          
*     NDABTS(NS)=NDBITS
      NODEX(2*(NS)+8)=NDBITS                                                        
*                                  3. SET UP/LEFT POINTER OF NEW NODE
*                                     TO CURRENT NODE
*     NDUPLF(NS)=XR7
      NODE(NS+0)=XR7                                                                
*                                  4. STORE DIVISION LIST POINTER
*     NDOPES(NS)=DLP
      NODE(NS+1)=DLP                                                                
*                                  5. STORE COPY OF GRAMMER DEF HEAD
*     NDSPFB(NS)=CSR(ELEMT)
      NODE(NS+5)=CSR(ELEMT)                                                         
*     NDHDBA(NS)=ELEMT
      NODE(NS+7)=ELEMT                                                              
*                               E. MAKE NEW NODE CURRENT
      XR7=NS
      IF(NDATMT(XR7)) GO TO 250
*                                  FIRST DIVISION LIST
      DLP=ELEMT
      GO TO 100
*                               G. FOR NON-NULL ATOMIC NODES
  250 IF(NDOTMT(XR7)) GO TO 290
*                                  1. ADVANCE WORD POINTER
  260 WORD=NEWW
      FURWORD=MAX(FURWORD,WORD)
      MAXWD=MAX(MAXWD,WORD-1)
*                                  2. SAVE POINTER TO CATEGORY AND NEWW
*     NDWPCP(XR7)=NEWW
      NODEX(2*(XR7)+11)=NEWW                                                        
*     NDORDC(XR7)=KATEG
      NODEX(2*(XR7)+12)=KATEG                                                       
*                                  3. STORE ATTRIBUTE LIST INTO DOWN PTR
*     NDBALP(XR7)=IATTRB
      NODE(XR7+2)=IATTRB                                                            
      GO TO 300
*      
* 290 NDWPCP(XR7)=WORD
  290 NODEX(2*(XR7)+11)=WORD                                                        
*     NDORDC(XR7)=0
      NODEX(2*(XR7)+12)=0                                                           
*                            IV. TEST FOR COMPLETENESS OF LEVEL
  300 CONTINUE
*                               B. IF AT ROOT NODE, GO TO E.
  305 IF(NDUPLF(XR7) .EQ. 0) GO TO 370
*                               C. PUT POINTER TO completed ELEMENT
*                                  IN DLP
      DLP=NDOPES(XR7)
      IF(NDFILT(XR7)) DLP=CAR(DLP)
*                               B. IF TRACE IS ON, PRINT +(NODE) **
  340 IF(TRACE) CALL NODTRC (3)
      IF(LINZ.LT.0) THEN
       PARSTAT=-1
       RETURN1
      ENDIF
      DLP=CDR(DLP)
*                               C. IF MORE ELEMENTS IN CURRENT DEFN,
*                                  GO TO V.
      IF(DLP .NE. 0) GO TO 400
*                               D. ELSE GO UP ONE LEVEL AND REPEAT IV.
      CALL UPONE
*                                  1. IF NODE JUST COMPLETED IS RECURSIV
*                                     RECORD COMPLETION ON RECURS LIST
      IF(NDRECT(XR7)) CALL RECURS (2,*9999)
*                                  2. RECORD PENDING WORD IN NODE
*     NDWPCP(XR7)=WORD
      NODEX(2*(XR7)+11)=WORD                                                        
*     NDORDC(XR7)=0
      NODEX(2*(XR7)+12)=0                                                           
      GO TO 300
*                               E. HAVE COMPLETED TOP LEVEL, CHECK IF
*                                  ALL SENTENCE WORDS HAVE BEEN MATCHED
*                                  1. NO, GO TO VI. TO DETACH LAST
*                                     ATOMIC ATTACHED
  370 IF(WORD.LT.NWORD) GO TO 500
*                                  2. yes, print message if parsing
*                                     and return
      PARSNO=PARSNO+1
      PAR=.TRUE.
      RETURN
*                            V. get next element of division list
  400 ELEMT=CAR(DLP)
      IF(ELEMT .EQ. 0) GO TO 700
      FILSW=.FALSE.
      NDBITS=0
*                               A. IF TRACE IS ON, PRINT ELEMENT
  410 IF(TRACE) CALL NODTRC (1)
*                               B. GO TO III. ATTACH NODE
      GO TO 200
*                            VI. FIND LAST NODE ATTACHED
*                               A. GO DOWN ONE LEVEL TO RIGHTMOST NODE
*                                  1. IF WE ARE ABOUT TO DESCEND THROUGH
*                                     A RECURSIVE NODE, RECORD THIS ON
*                                     THE RECURSIVES LIST
  500 IF(NDRECT(XR7)) CALL RECURS (3,*9999)
*                                  2. CLEAR  LAST WORD+1 FIELD IN NODE
*     NDWPCP(XR7)=0
      NODEX(2*(XR7)+11)=0                                                           
*                                  4. TRY TO DESCEND
      CALL DNRIT
*                                  5. IF WE CAN'T, ARE AT LAST NODE
*                                     ATTACHED
      IF(.NOT. PASS) GO TO 600
*                               B. IF TRACE IS ON, PRINT  :NODE
      IF(TRACE) CALL NODTRC (4)
      IF(LINZ.LT.0) THEN
        PARSTAT=-1
        RETURN1
      ENDIF
*                               C. GO BACK TO A--TRY TO DESCEND FURTHER
      GO TO 500
*                            VII. DETACH NODE
*                               A. IF AT ROOT NODE, ARE FINISHED
*                                  ENUMERATING PARSES
  600 IF(NDUPLF(XR7) .EQ. 0) GO TO 680
  605 CONTINUE
*                               B. IF TRACE IS ON, PRINT - (NODE)
  610 IF(TRACE) CALL NODTRC (5)
      IF(LINZ.LT.0) THEN
        PARSTAT=-1
        RETURN1
      ENDIF
*                               C. IF NODE IS ATOMIC, SEEK ALTERNATE
*                                  CATEGORY
      IF (.NOT. NDATMT(XR7).OR.NDOTMT(XR7)) GO TO 620
      ELEMT=CAR(NDOPES(XR7))
      IF(NDFILT(XR7)) ELEMT=CAR(ELEMT)
      KATEG=NDORDC(XR7)
      IATTRB=NDBALP(XR7)
      NEWW=WORD
      WORD=NDWPNC(XR7)
*      
      IF(PAR) MINWD=MIN(MINWD,WORD)
*                                  1. IF IN A FROZEN SUBSTRUCTURE,
*                                     IGNORE ALTERNATE CATEGORIES
      CALL LAW (KATEG,NEWW,IATTRB)
      IF(KATEG .EQ. 0) GO TO 620
*d    print *,' ********* we find an alternate *********'
*                                  2. ALTERNATE CATEGORY FOUND,
*                                     (A) IF TRACE ON PRINT  = NODE
      IF(TRACE) CALL NODTRC (1)
*                                     (B) GO PUT NEW KATEG AND NEWW IN
*                                         NODE
      GO TO 260
*                               D. DETACH NODE FROM TREE
*                                  1. IF DETACHED NODE IS RECURSIVE,
*                                     RECORD ON RECURSIVES LIST
  620 IF(NDRECT(XR7)) CALL RECURS (4,*9999)
      SXR7=XR7
      XR7=NDUPLF(XR7)
      IF(NDFILT(SXR7)) THEN
*                                  2. FIL NODE--CLEAR DOWN PTR OF NODE
*                                     ABOVE
*       NDBALP(XR7)=0
        NODE(XR7+2)=0                                                               
      ELSE
*                                  3. NOT FIL NODE--CLEAR RIGHT PTR
*                                     OF NODE TO LEFT
*       NDRTPT(XR7)=0
        NODE(XR7+3)=0                                                               
      END IF
*                               E. FREE SPACE USED BY NODE
      FILSW=NDFILT(SXR7)
      NDOP=NDOPES(SXR7)
      CALL FRENOD (SXR7)
      DLP=NDOP
*                               F. IF FIL WAS DETACHED, TRY ITS NEXT
*                                  DIVISION LIST
  658 IF(FILSW) GO TO 100
*                               G. NON FIL DETACHED
*                                  1. IF TRACE IS ON PRINT NEW CURRENT
*                                     NODE
      IF(TRACE) CALL NODTRC (4)
*                                  2. GO TO VI. TO FIND NEXT NODE TO
*                                     DETACH
      GO TO 500
*      
*                               H. HAVE REACHED ROOT NODE QUIT
  680 PAR=.FALSE.
      RETURN
       
  700 PRINT 701
  701 FORMAT(' *** Attempt to reference undefined BNF definition' /
     =   5X,'Parsing terminated')
      GO TO 704
       
  703 PRINT *,'No more space for nodes--unable to continue parse'
  704 PAR=.FALSE.
      RETURN
*      
 9998 parstat = -3
 9999 continue
      RETURN 1
      END
      SUBROUTINE LAW (KATEG,NEWW,IATTRB)
*      
************************************************************************
*      
*     SUBROUTINE LAW ('LOOK AT WORD') IS CALLED BY THE PARSER WHEN IT
*     REACHES AN ATOMIC NODE, TO CHECK FOR A MATCH WITH THE PENDING
*     SENTENCE WORD.  IT IS ALSO CALLED BY THE PARSER WHEN IT IS ABOUT
*     TO DETACH AN ATOMIC NODE, TO CHECK WHETHER THE MATCHED CATEGORY
*     APPEARS A SECOND TIME ON THE CATEGORY LIST (AS WOULD OCCUR IF THE
*     CURRENT WORD WERE A HOMONYM OR THE FIRST WORD OF AN IDIOM) OR
*     WHETHER THE FOLLOWING SENTENCE WORD HAS THE NULL CATEGORY.  THE
*     NULL CATEGORY IS ASSIGNED TO WORDS SUCH AS THE COMMA WHICH MAY
*     BE ENTIRELY IGNORED IN THE CONTEXT FREE ANALYSIS OF THE SENTENCE.
*     WHEN THE ATOMIC NODE IS ABOUT TO BE DETACHED, IF THE FOLLOWING
*     WORD HAS THE NULL CATEGORY, LAW RETURNS TO PARSER THE SIGNAL THAT
*     AN ALTERNATIVE MATCH HAS BEEN MADE, THIS TIME WITH THE NODE SPAN-
*     NING BOTH THE CURRENT AND FOLOWING WORDS.
*          ON THE CALL TO SEEK AN INITIAL MATCH WITH THE SENTENCE WORD,
*     KATEG=0, THE VALUES OF NEWW AND IATTRB ARE IGNORED.  IF NO MATCH
*     CAN BE MADE TO THE PENDING WORD, LAW RETURNS WITH KATEG STILL
*     EQUAL TO 0.  IF THE ATOMIC NODE IS NOT A LITERAL AND IT MATCHES A
*     CATEGORY OF THE PENDING WORD, LAW RETURNS WITH KATEG = THE POSI-
*     TION OF THE MATCHED CATEGORY ON THE CATEGORY LIST (E.G., 3 IF IT'S
*     THE THIRD CATEGORY ON THE LIST) AND IATTRB POINTING TO THE
*     BEGINNING OF THE ATTRIBUTE LIST FOR THAT CATEGORY.  IF THE ATOMIC
*     NODE IS A LITERAL, AND MATCHES THE PENDING WORD, LAW RETURNS WITH
*     KATEG=1, IATTRB=0.  IN EITHER CASE, IF A MATCH IS MADE, NEWW CON-
*     TAINS THE NUMBER OF THE WORD FOLLOWING THE LAST WORD MATCHED BY TH
*     NODE (I.E., THE PENDING WORD AFTER THE ATOMIC NODE IS COMPLETED).
*          ON SUBSEQUENT CALLS TO LAW, WHEN THE CURRENT ATOMIC NODE IS
*     ABOUT TO BE DETACHED, KATEG, IATTRB, AND NEWW SHOULD CONTAIN ON
*     ENTRY THE VALUES RETURNED BY LAW ON THE PRECEDING CALL.  LAW FIRST
*     CHECKS IF THE WORD FOLLOWING THE LAST ONE MATCHED BY THE NODE HAS
*     THE NULL CATEGORY;  IF SO, IT RETURNS WITH THE SAME VALUES OF
*     KATEG AND IATTRB, WITH NEWW INCREMENTED BY 1.  IF NOT, AND THE
*     NODE TO BE MATCHED IS A LITERAL, LAW RETURNS FAILURE (KATEG=0).
*     IF THE NODE IS NOT A LITERAL, LAW CONTINUES SEARCHING THE
*     CATEGORY LIST,  STARTING FROM THE POSITION WHERE THE PREVIOUS
*     MATCHING CATEGORY APPEARED.  IF A SECOND OCCURRANCE OF THIS
*     CATEGORY IS FOUND, LAW RETURNS KATEG, IATTRB, AND NEWW JUST AS FOR
*     THE INITIAL MATCH.  IF THE CATEGORY DOES NOT APPEAR AGAIN, LAW
*     RETURNS WITH KATEG=0.
*      
************************************************************************
*      
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      PARAMETER (LXLEN=15)
      CHARACTER*10 LXSYM(LXLEN)
      COMMON /LEXSYM/LXSYM
      COMMON/LEXLST/LXADR(LXLEN)
      EQUIVALENCE (LXTEXT,LXADR(6))
      EQUIVALENCE (W,WORD)
      CHARACTER*(WORDLEN) SENTWD
      CHARACTER*(WORDLEN) NODSYM
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
      SENTWD(X)=STNAME(SENTE1(X))
*      
      LFORM=0
*                               IF WE ARE LOOKING FOR AN ALTERNATE SPAN,
*                                  GO TO III.
      IF(KATEG .NE. 0) GO TO 40
      xxp1=0
*                               IF ELEMENT TO BE MATCHED IS A LITERAL,
*                                  GO TO II.
      NEWW=WORD+1
      IF(AND(CSR(ELEMT),LTOMIC) .NE. 0) GO TO 50
*                            I. SEARCH FOR MATCHING CATEGORY ON
*                               CATEGORY LIST
*                               A. IF WE ARE LOOKING FOR FIRST SPAN,
*                                  START AT BEGINNING OF LIST
      K=1
      L=SENTE2(WORD)
*                               B. SEARCH CATEGORY LIST
   10 DO 20 KATEG=K,255
*                                  1. IF AT END OF LIST, RETURN FAILURE
      IF(L .EQ. 0) GO TO 40
      KAR=CAR(L)
      IF(.NOT. ATOMP(KAR)) THEN
        LFORM=L
        GO TO 20
      END IF
*                                  3. IF ELEMENT MATCHES CATEGORY
*                                     SOUGHT, RETURN SUCCESS
      IF(KAR .EQ. ELEMT) GO TO 30
*                                  4. GET NEXT LIST ELEMENT
   20 L=CDR(L)
*                               C. IF TOO MANY CATEGORIES, PRINT MESSAGE
      PRINT 25, WORD
   25 FORMAT(' *** More than 255 elements in category list of word ',
     * I4)
      GO TO 40
*                               D. HIT -- RETURN POINTER TO ATTRIBUTE
*                                  LIST IN IATTRB
   30 IATTRB=CSR(L)
      IF(LFORM .NE. 0) THEN
        SENTE3(WORD)=CSR(LFORM)
      ELSE
        SENTE3(WORD)=0
      END IF
      RETURN
*                               E. NO MORE SPANS
   40 KATEG=0
      RETURN
*                            II. CHECK FOR LITERAL MATCH
*                               A. IN PARSERS (I) AND (II), IF WORD HAS
*                                  LEXICAL TYPE <*TEXT> FAIL
   50 IF(SENTE2(WORD).EQ.0) GO TO 60
      IF(CAR(SENTE2(WORD)) .EQ. LXTEXT) GO TO 40
*                               B. IF LITERAL DOES NOT MATCH, GO TO I.E
   60 LITPTR=CAR(ELEMT)
      NAME=SENTWD(WORD)
      IF(NAME.NE.STNAME(LITPTR)) GO TO 40

  400 continue
*                               C. RETURN KATEG=1 AS SUCCESS SIGNAL
      KATEG=1
      IATTRB=0
      SENTE3(WORD)=0
      RETURN
*                            III. CHECK FOR ALTERNATE SPAN OR CATEGORY
*                               A. ONLY FOR PARSER (III)
      go to 40
*                               C. IF ELEMENT IS A LITERAL, RETURN
*                                  FAILURE
  120 IF(AND(CSR(ELEMT),LTOMIC) .NE. 0) GO TO 40
*                               D. SET L TO POINT TO ELEMENT OF
*                                  CATEGORY LIST FOLLOWING ONE JUST USED
      L=SENTE2(WORD)
      DO 140 K=1,KATEG
      IF(L .EQ. 0) GO TO 150
      IF(.NOT. ATOMP(CAR(L))) LFORM=L
  140 L=CDR(L)
*                               E. GO TO I.B TO SEARCH FOR AN
*                                  ALTERNATE CATEGORY
      K=KATEG+1
      GO TO 10
  150 PRINT *,' ***** Invalid KATEG passed to LAW'
      GO TO 40
      END
