*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE PACKEM (CHR)

***********************************************************************
*
*     Subroutine PACKEM packs the character CHR into NAME.
*     if more than WORDLEN characters have been packed, a warning
*     message is issued and the character is ignored.
*
***********************************************************************

      IMPLICIT INTEGER(A-Z)
      SAVE JPLC
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*1 CHR
*
      JPLC=JPLC+1
      IF(JPLC.GE.(WORDLEN+1))THEN
      PRINT 9, CHR
    9 FORMAT(' WARNING--symbol more than WORDLEN char., ',A1,' IGNORED')
      RETURN
      END IF
      IF(CHR.EQ.' ') THEN
        NAME(JPLC:JPLC)='!'
      ELSE
        NAME(JPLC:JPLC)=CHR
      END IF
      RETURN

***********************************************************************
*
*     Entry PAKSET resets PACKEM to pack a new NAME.
*
***********************************************************************

      ENTRY PAKSET
      JPLC=0
      NAME=' '
      RETURN
      END
