*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE ORIGHT

***********************************************************************
*
*     This subprogram contains the code for the restriction operators
*     RIGHT, LEFT, UPONE, and DOWN.  In contrast with the entry
*     points RIGHT, LEFT1, UPONE, and DOWN appearing elsewhere
*     in this program, these operators automatically pass
*     through dummy nodes, in other words, the operators appear to
*     move RIGHT, LEFT, UP, and DOWN in a tree in which elements
*     inside parentheses in a BNF definition are on the same
*     level as the elements outside the parentheses.  The operators
*     can handle an arbitrary depth of DUMMY nodes, i.e., an arbitrarily
*     deep nesting of parentheses in a BNF definition.
*          The entry points are
*          ORIGHT -- operator RIGHT
*          OLEFT -- operator LEFT
*          OUPONE -- operator UPONE
*          ODOWN -- operator DOWN
*     On entry, (XR7,LIST) point to the current position
*     On exit, PASS=.TRUE. If operation was successful,
*     XR7 points to the new current node, LIST=0.
*     PASS=.FALSE. If LIST/=0 on entry (not looking at
*     NODE) or operation could not be performed,
*     XR7 and LIST are unchanged.
*
***********************************************************************

      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*
      IF (LIST.NE.0) GO TO 81
      NXR7=XR7
*S    IF(NDSAVT(XR7)) CALL SAVENA
 10   CALL RIGHT
      IF (.NOT.PASS) GO TO 12
*             IF NODE TO RIGHT IS A DUMMY, DESCEND TO A NAMED NODE
      IF (NDNONT(XR7)) GO TO 30
      RETURN
*             IF CANNOT GO RIGHT AND ARE BELOW DUMMY,TRY TO GO RIGHT
*             ON LEVEL ABOVE
 12   IF (.NOT.(NDIDMT(XR7))) GO TO 80
      CALL UPONE
      IF (.NOT.PASS) GO TO 90
      GO TO 10
*
      ENTRY OLEFT
*
      IF (LIST.NE.0) GO TO 81
      NXR7=XR7
*S    IF(NDSAVT(XR7)) CALL SAVENA
 20   CALL LEFT1
      IF (.NOT.PASS) GO TO 22
*             IF NODE TO LEFT IS DUMMY, DESCEND TO NAMED NODE
 21   IF (.NOT.(NDNONT(XR7))) RETURN
      CALL DNRIT
      IF(.NOT.PASS) GO TO 80
      GO TO 21
*             IF CANNOT GO LEFT AND ARE BELOW DUMMY, TRY TO GO LEFT
*             ON LEVEL ABOVE
 22   IF (.NOT.(NDIDMT(XR7))) GO TO 80
      CALL UPONE
      IF (.NOT.PASS) GO TO 90
      GO TO 20
*
      ENTRY ODOWN
*
      IF (LIST.NE.0) GO TO 81
      NXR7=XR7
 30   CALL DOWN
      IF (.NOT.PASS) GO TO 80
      IF (NDNONT(XR7)) GO TO 30
      RETURN
*
      ENTRY OUPONE
*
      IF (LIST.NE.0) GO TO 81
      NXR7=XR7
*S    IF(NDSAVT(XR7)) CALL SAVENA
 40   CONTINUE
      CALL UPONE
      IF (.NOT.PASS) GO TO 80
      IF (NDNONT(XR7)) GO TO 40
      RETURN
*             FAILURE EXIT
   80 XR7=NXR7
   81 PASS=.FALSE.
      RETURN
*             SYSTEM ERROR EXIT
   90 PRINT *,'***** Node flagged in DUMMY has no parent'
      GO TO 80
      END
