*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE MATBLD

************************************************************************
*
*     MATBLD adds the MINWORD attribute to word definition category
*     lists and builds the sublists for the minword attribute.  It is
*     invoked by SCANTR once for each node in the parse tree after each
*     successful parse.
*
************************************************************************

      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*(WORDLEN) MATN
      CHARACTER*10 DEC
      CHARACTER*(WORDLEN) SENTWD
*      already in common.fcm, Nhan
*     LOGICAL RDLINT
*     COMMON /INITAL/LARGWD,ANYTHP,MAT,RDLINT
      COMMON /INITAL/LARGWD,ANYTHP,MAT
      INCLUDE 'nddfty.fcm'
      DATA MATN/'MAT'/
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
      SENTWD(X)=STNAME(SENTE1(X))
*
*                            I. IF CURRENT NODE NOT OF TYPE MINWD, RETRN
      IF(.NOT.(NDMINT(XR7))) RETURN
*                               A. FIRST TIME THROUGH, GET VALUE OF MAT
      IF(MAT.EQ.0) THEN
        MAT=LOOKST(MATN)
        IF(MAT.EQ.0) THEN
          CALL EXITR('***** No MINWORD attribute')
        END IF
        MAT=STADDR(MAT)
      END IF
*                            II. FIND PARENT NODE
      NXR7= XR7
   11 CALL UPONE
      IF(.NOT.PASS) GO TO 95
      IF(NDNONT(XR7)) GO TO 11
*                               A. PUT ST POINTERS FOR NODE,PARENT
*                                  IN SNXR7, SXR7 RESPECTIVELY
      SNXR7=NDHDBA(NXR7)
      SXR7=NDHDBA(XR7)
*                            III. SEARCH CATEGORY LIST OF CURRENT WORD
*                                 FOR MAT
      NW=NDWPNC(NXR7)
      L=SEARCH(SENTE2(NW),MAT)
      IF(L.EQ.0) THEN
*                               A. NOT ON LIST--PUT MAT:CURRENT NODE>
*                                  PARENT NODE ON CATEGORY LIST
        M=GCONS(0,GCONS(0,GCONS(0,0,SXR7),SNXR7),MAT)
        L=SENTE2(NW)
        IF(L.EQ.0) THEN
          SENTE2(NW)=M
        ELSE
   15     IF(CDR(L).EQ.0) GO TO 16
          L=CDR(L)
          GO TO 15
   16     CDR(L)=M
        END IF
      ELSE
*                            IV. SEARCH FOR CURRENT NODE ON SUBLIST
*                                OF MAT
        IF(CSR(L).EQ.0) GO TO 90
        M=SEARCH(CSR(L),NDHDBA(NXR7))
        IF(M.EQ.0) THEN
*                               A. NOT ON SUBLIST--PUT CURRENT NODE:
*                                  PARENT NODE ON SUBLIST
          CSR(L)=GCONS(CSR(L),GCONS(0,0,SXR7),SNXR7)
        ELSE
*                            V. ADD PARENT NODE TO SUBSUBLIST
          CSR(M)=GCONS(CSR(M),0,SXR7)
        END IF
      ENDIF
*                            V. PRINT NODE AND PARENT NODE IF REQUESTED
   40 IF(MATPRT) THEN
        CALL FILL ('node ')
        CALL FILLTR (NODNAM(NXR7))
        CALL FILL (' in ')
        CALL FILLTR (NODNAM(XR7))
        CALL FILL (' added to MINWD attribute list of word ')
        NAME=DEC(NW,3)
        CALL FILL (NAME(1:3))
        CALL FILL (' = ')
        NAME=SENTWD(NW)
        CALL FILLTR (NAME)
        CALL PRNT
      ENDIF
   50 XR7=NXR7
      RETURN
*
   90 PRINT *,'***** error in MAT list'
      GO TO 50
   95 PRINT *,'*** MINWD attribute on root node'
      GO TO 50
      END
