*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      FUNCTION LOAD (GOTONE)
*
************************************************************************
*
*     Unpacks one OBJECT RECORD into GRAMAR.  The OBJECT RECORD must be
*     selected by presetting OBJPTR before calling LOAD.  On EXIT
*          LOAD > 0 :  no errors encountered, LOAD=INDEX in GRAMAR of
*                      last HEAD encountered
*          LOAD = 0 :  no errors encountered, no HEAD encountered
*          LOAD < 0 :  invalid INTERPRET FIELD encountered
*     If GOTONE=.TRUE., a sign field of 0 was extracted before LOAD was
*     called.  In this case LOCREC (the position in GRAMAR of WORD 0 of
*     the record) must be set before LOAD is called.
*
************************************************************************
*
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      LOGICAL GOTONE,HEADF
      INTEGER G(2)
      COMMON/LOADCM/SOL,SOS,LOCREC
      INCLUDE 'gencom.fcm'
      INCLUDE 'grio.fcm'
      PARAMETER (ISGWTH=1,INTWTH=3,IFDWTH=15)
      INCLUDE 'asf.fcm'
*     PRINT 5555,OBJLEN,RCDNAM
*5555 FORMAT(1X, 'OBJLEN ',I4,1X,A10)
      IF(.NOT.GOTONE) LOCREC=IG
      LOAD=0
      ISIGN=0
*                            I. GET SIGN BIT
      IF(GOTONE) GO TO 6
    5 CALL GETFLD (ISIGN,ISGWTH)
    6 HEADF=.FALSE.
      DO 100 IK=1,2
*                            II. GET INTERPRETATION BITS
      CALL GETFLD (INT,INTWTH)
*                               A. FOR NULL FIELD, STORE 0
      IF(INT.NE.0) GO TO 8
      IFLD=0
      GO TO 100
*                            III. GET AND PROCESS DATA FIELD
   8  IF(INT.EQ.7) GO TO 70
      CALL GETFLD (IFLD,IFDWTH)
      GO TO (10,20,30,40,40,60), INT
*                               A. ABSOLUTE FIELD:  IF HEAD, SET  LOAD
   10 IF(IK.EQ.2) GO TO 100
      IF(AND(IFLD,HDINOG).EQ.0) GO TO 100
      HEADF=.TRUE.
*                                  1. CHANGE BIT USED TO INDICATE HEAD
*                                     IN OBJECT GRAMMAR (HDINOG) TO BIT
*                                     USED TO INDICATE HEAD IN GRAMMAR
*                                     STORED IN CORE (HEAD)

      IFLD=IFLD+HEAD-HDINOG
      GO TO 100
*                               B. RELATIVE FIELD
   20 IFLD=IFLD+LOCREC
      GO TO 100
*                               C. SYMBOL:  STORE SYMBOL TABLE INDEX +
*                                  SOS (START OF SYMBOLS)
   30 IFLD=IFLD+SOS
      GO TO 100
*                               D. INVALID INTERPRETER FIELD
   40 LOAD=-1
*                               E. TERMINATOR FIELD
   70 RETURN
*                               E. LITERAL:  STORE SYMBOL TABLE INDEX +
*                                  SOL (START OF LITERALS)
   60 IFLD=IFLD+SOL
  100 G(IK)=IFLD
      KURENT=GCONS(0,G(1),G(2))
      IF(HEADF) LOAD=KURENT
      IF(ISIGN.NE.0) CDR(LAST)=KURENT
      LAST=KURENT
      GO TO 5
      END
