*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE LEX

      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'chartrn.fcm'
      INCLUDE 'gencom.fcm'
      INCLUDE 'nodray.fcm'
      PARAMETER (LXLEN=15)
      CHARACTER*10 LXSYM(LXLEN)
      COMMON/LEXLST/LXADR(LXLEN)
      COMMON/LEXSYM/LXSYM
      character*40 dictwords(20)
      common/dicblk/dictwords
      LOGICAL REG
      CHARACTER*1 CHR,JCHAR,KCHAR
      CHARACTER*2 NSUFIX(4),NSUF

***********************************************************************
*     LEX processes the characters in the input stream up to the next
*     sentence endmark according to the lexical rules for grammars.
*     0UTPUT IS IN THE ARRAYS SENTE, AS FOLLOWS:
*        SENTE1(I) POINTS TO THE SYMBOL TABLE ENTRY FOR THE I-TH WORD
*        SENTE2(I) POINTS TO THE BEGINNING OF THE LIST IN GRAMAR OF
*                   THE LEXICAL TYPES OF THE I-TH WORD
*
*             LEXICAL TYPES IN PARSER(I)  [BNF]
*
*        FOR THE STATEMENT ENDMARK (A . FOLLOWED BY A BLANK)
      PARAMETER (LXEDMP=1)
      CHARACTER*10 LXENDM
      EQUIVALENCE (LXENDM,LXSYM(LXEDMP))
*        FOR GENERATOR NAMES
      PARAMETER (LXGENP=2)
      CHARACTER*10 LXGEN
      EQUIVALENCE (LXGEN,LXSYM(LXGENP))
*        FOR INTEGERS
      PARAMETER (LXINTP=3)
      CHARACTER*10 LXINT
      EQUIVALENCE (LXINT,LXSYM(LXINTP))
*        FOR NAMES (ALPHAMERIC STRINGS BEGINNING WITH A LETTER)
      PARAMETER (LXNMEP=4)
      CHARACTER*10 LXNAME
      EQUIVALENCE (LXNAME,LXSYM(LXNMEP))
*        FOR SPECIAL CHARACTERS (INCLUDING :: AND .(  AS ONE CHAR)
      PARAMETER (LXSPCP=5)
      CHARACTER*10 LXSPEC
      EQUIVALENCE (LXSPEC,LXSYM(LXSPCP))
*        FOR TEXT ENCOLSED IN QUOTES
      PARAMETER (LXTXTP=6)
      CHARACTER*10 LXTEXT
      EQUIVALENCE (LXTEXT,LXSYM(LXTXTP))
*
*             LEXICAL TYPES IN PARSER(II)  [RESTRICTIONS AND WD]
*
*        FOR ADDRESSES (NAMES PRECEEDED BY A $)
      PARAMETER (LXADDP=7)
      CHARACTER*10 LXADDR
      EQUIVALENCE (LXADDR,LXSYM(LXADDP))
*        FOR MEMBERS OF THE ADJUNCT SET (NODES WITH THE ADJ. SET ATTRB.)
      PARAMETER (LXATMP=8)
      CHARACTER*10 LXATOM
      EQUIVALENCE (LXATOM,LXSYM(LXATMP))
*        FOR ATTRIBUTES (NAMES OF TYPE ATTRIBUTE)
      PARAMETER (LXATTP=9)
      CHARACTER*10 LXATRB
      EQUIVALENCE (LXATRB,LXSYM(LXATTP))
*        FOR DEFS (NAMES OF TYPE DEF)
      PARAMETER (LXDEFP=10)
      CHARACTER*10 LXDEF
      EQUIVALENCE (LXDEF,LXSYM(LXDEFP))
*        FOR NODES (ATOMICS AND DEFS)
      PARAMETER (LXNODP=11)
      CHARACTER*10 LXNODE
      EQUIVALENCE (LXNODE,LXSYM(LXNODP))
*        FOR ORDINAL NUMBERS (INTEGERS WITH A ST, ND, RD, OR TH SUFFIX)
      PARAMETER (LXORDP=12)
      CHARACTER*10 LXORDN
      EQUIVALENCE (LXORDN,LXSYM(LXORDP))
*        FOR REGISTERS (NAMES CONSISTING OF AN 'X' FOLLOWED BY AN INTGR)
      PARAMETER (LXREGP=13)
      CHARACTER*10 LXREG
      EQUIVALENCE (LXREG,LXSYM(LXREGP))
*        FOR SUBPART NUMBERS (INTEGERS PRECEEDED BY .)
      PARAMETER (LXSBPP=14)
      CHARACTER*10 LXSUBP
      EQUIVALENCE (LXSUBP,LXSYM(LXSBPP))
*        FOR TYPES (NAMES OF TYPE TYPE)
      PARAMETER (LXTYPP=15)
      CHARACTER*10 LXTYPE 
      EQUIVALENCE (LXTYPE,LXSYM(LXTYPP))
      CHARACTER*(WORDLEN) PERODC
      DATA PERODC/'.'/
      DATA NSUFIX /'ST', 'ND', 'RD', 'TH' /
      DATA LXGEN /'GENERATOR'/
      DATA LXENDM /'ENDMARK'/
      DATA LXSPEC /'SPECIAL'/
      DATA LXNAME /'NAME'/
      DATA LXINT  /'INTEGER'/
      DATA LXTEXT /'TEXT'/
      DATA LXADDR /'ADDRESS'/
      DATA LXATOM /'ATOM'/
      DATA LXATRB /'ATTRIBUTE'/
      DATA LXDEF  /'DEF'/
      DATA LXNODE /'NODE'/
      DATA LXORDN /'NTH'/
      DATA LXREG  /'REG'/
      DATA LXSUBP /'LINO'/
      DATA LXTYPE /'TYPE'/
*
***********************************************************************

      INCLUDE 'asf.fcm'
      CALL SETIG (NASFW)
      PERIOD=0
      NWORD=0
      LEXERR=.FALSE.
      REG=.FALSE.
      IF(LXTRAC) PRINT 91
   91 FORMAT(/'   N     Word(N)',16X,'SENTE(N)       Lexical types assig
     =ned')
      INDENT=42
* if WD words extract first token and make it text
      if(pmode.eq.4)then
 1507 call getchr(chr,nchr)
      IF(CHR.EQ.' ') GO TO 1507
      if(chr.eq.'.')then
      call getchr(chr,nchr)
      if(nchr.le.9)then
* this is a .nn=
      call pakset
      call packem('.')
	period=1
       go to 300
      endif
      dwcnt=0
      dictwords(1)=' '
     
      dictwords(dwcnt+1)(1:1)='.'
      is=1
      go to 1503
      endif

      dwcnt=0
      dictwords(1)=' '
     
      dictwords(dwcnt+1)(1:1)=chr
      is=1
 1500 call getchr(chr,nchr)
 1503 IF(CHR.EQ.' ')go to 1520

      if(chr.ne.'_')then
      is=is+1
      dictwords(dwcnt+1)(is:is)=chr
      go to 1500
      endif

* end of idiom unit
      dwcnt=dwcnt+1
      CALL STAKEM (dictwords(dwcnt)(1:wordlen),nst)
      CALL LEXTYP (LXADR(LXTXTP))
      dictwords(dwcnt+1)=' '
* stack underscore
      CALL STAKEM ('_',NST)
      CALL LEXTYP (LXADR(LXNMEP))
      is=0
      go to 1500

* end of word
 1520 dwcnt=dwcnt+1
      CALL STAKEM (dictwords(dwcnt)(1:wordlen),nst)
      CALL LEXTYP (LXADR(LXTXTP))
      if(lxtrac)call prnt
*end of statement
      CALL PAKSET
      if(chr.eq.'.') go to 400

*end of word skip to next non blank
 1509 call getchr(chr,nchr)
      IF(CHR.EQ.' ') GO TO 1509
      if(chr.eq.'(') go to 180
      if(chr.eq.'[')go to 800
      reg=.false.
      go to 101
      endif
*                               B. IF NOT A QUOTE, PACK CHARACTER
*                                  1. IF 20 CHAR ALREADY PACKED, SKIP
* 515 IF(N.LT.WORDLEN) THEN

   99 CALL PAKSET
*                            I. BRANCH ON FIRST CHAR OF LEXICAL UNIT
*                               A. GET NEXT CHARACTER
  100 CALL GETCHR (CHR,NCHR)
*                               B. IS IT END OF TEXT -- ERROR
  101 IF(NCHR.EQ.SEOR) GO TO 900
*                               C. IS IT A BLANK -- GET NEXT CHAR
      IF(CHR.EQ.' ') GO TO 100
*                               D. IS IT A LETTER -- GO PROCESS NAME
      IF(NCHR.EQ.IALPHA) GO TO 200
*                               E. IS IT A DIGIT -- GO PROCESS INTEGER
      IF(NCHR.LE.9) GO TO 300
*                               F. IS IT A PERIOD
      IF(NCHR.EQ.IPER) GO TO 400
*                               G. IS IT A QUOTE MARK
      IF(NCHR.EQ.IAPOS) GO TO 500
*                               I. IS IT A $ -- GO PROCESS ADDRESS
      IF(NCHR.EQ.SDOLR) GO TO 700
*                               J. IS IT A [ IN PARSER(II)
*                                  -- GO SKIP COMMENTS
* jump if definitions BNF
      IF(PMODE.EQ.1) GO TO 180
      IF(CHR.EQ.'[') GO TO 800
*                            II. PROCESS SPECIAL CHAR (OTHER THAN ABOVE
*                               A. PLACE ON SENTE
  180 CALL PACKEM (CHR)
      CALL STAKEM (NAME,NST)
      CALL LEXTYP (LXADR(LXSPCP))
      IF(LXTRAC)CALL PRNT
      GO TO 99
*                            III. PROCESS NAME
  200 REG=PMODE.EQ.2.AND.CHR.EQ.'X'
*                               A. PACK CHARACTER INTO 'NAME'
  201 CALL PACKEM (CHR)
*                               B. GET NEXT CHARACTER
      CALL GETCHR (CHR,NCHR)
      IF(NCHR.EQ.BLANK.OR.NCHR.EQ.EOL.or.nchr.eq.SEOR) GO TO 203
*                               C. IF ALPHAMERIC OR - , KEEP PACKING
      IF(NCHR.LE.IALPHA.OR.CHR.EQ.'-') GO TO 201
*                               D. PLACE POINTER TO NAME ON SENTE
*                                  1. IN PARSER(II), IGNORE NOISE WORDS
*                                     ('THE', 'A', 'AN')
  203 IF(PMODE.EQ.1.OR.PMODE.GE.3) GO TO 204
      IF(NAME.EQ.'THE'.OR.NAME.EQ.'A'.OR.NAME.EQ.'AN') GO TO 290
  204 CALL STAKEM (NAME,NST)
      IF(PERIOD.eq.1) go to 270
      IF(PERIOD.gt.1) go to 275
      IF(PMODE.EQ.1) GO TO 250
      IF(REG) GO TO 260
*                               E. FOR NAMES, IF PARSER(II), DETERMINE
*                                  LEXICAL TYPE
  206 MTYPE=STTYPE(NST)
      M=AND(MTYPE,15)
      IF(M.EQ.DTYPE) GO TO 210
      IF(M.EQ.INTYPE) GO TO 278
      IF(M.NE.LTYPE) GO TO 240
*                                  1. ATOMIC
      CALL LEXTYP (LXADR(LXATMP))
      GO TO 220
*                                  2. DEF
  210 CALL LEXTYP(LXADR(LXDEFP))
*                                  4. DEF OR ATOMIC:NODE
  220 CALL LEXTYP(LXADR(LXNODP))
      GO TO 280
*                               F. ATTRIBUTES
  240 IF(M.NE.ATTYPE) GO TO 245
      CALL LEXTYP(LXADR(LXATTP))
      GO TO 250
*                               G. TYPES
  245 IF(M.NE.TPTYPE) GO TO 250
      CALL LEXTYP (LXADR(LXTYPP))
*                               H. NAMES IN PARSER(I), AND OTHER NAMES
*                                  IN PARSER(II) : NAME
  250 CALL LEXTYP(LXADR(LXNMEP))
      GO TO 280
*                               I. REGISTERS
  260 CALL LEXTYP (LXADR(13))
      CALL SETTYP (NST,RGTYPE)
      GO TO 280
*                               J. PERIOD=1 : GENERATOR
  270 CALL LEXTYP(LXADR(LXGENP))
      CALL SETTYP (NST,GTYPE)
      GO TO 280
*                               K. PERIOD=2 : ADDRESS
  275 CALL LEXTYP (LXADR(7))
      CALL SETTYP (NST,ADTYPE)
      GO TO 280
*                               L. NAMED ORDINALS
  278 CALL LEXTYP (LXADR(12))
*                               M. RESET NAME-PACKING SUBROUTINE
  280 IF(LXTRAC)CALL PRNT
  290 CALL PAKSET
      PERIOD=0
      GO TO 101
*                            III. PROCESS INTEGER
*                               A. PACK DIGIT INTO 'NAME'
  300 NUM=0
  301 CALL PACKEM (CHR)
*                               B. COMPUTE VALUE OF INTEGER
      NUM=NUM*10+NCHR
*                               C. GET NEXT CHARACTER
  310 CALL GETCHR (CHR,NCHR)
*                               D. LETTER -- POSSIBLE SUFFIX
  311 IF(NCHR.EQ.IALPHA) GO TO 350
*                               E. DIGIT -- KEEP PACKING
  312 IF(NCHR.LE.9) GO TO 301
*                               F. PLACE POINTER TO PACKED INT ON SENTE
      CALL STAKEM (NAME,NST)
      IF(PERIOD.EQ.0) THEN
*                                  1. PERIOD=0 : INTEGER
       CALL LEXTYP (LXADR(3))
       IT=INTYPE
      ELSE
*                                  2. PERIOD=1 : SUBPART NUMBER
       CALL LEXTYP (LXADR(14))
       IT=SPTYPE
      END IF
*                               G. STORE VALUE OF INTEGER IN SYMB TABLE
      CALL SETTYP (NST,NUM*16+IT)
      GO TO 280
*                               H. TEST FOR SUFFIX
  350 CALL GETCHR (JCHAR,NJCHR)
*                                  1. NOT IF THIS IS A SUBPART NUMBER
      IF(PERIOD.NE.0) GO TO 352
*                                  2. IF ONLY ONE LETTER, ERROR
      IF(NJCHR.EQ.IALPHA) GO TO 355
  352 PRINT 353, CHR
  353 FORMAT(' ***EMBEDDED LETTER ',A1,' IN INTEGER')
      LEXERR=.TRUE.
      CHR=JCHAR
      NCHR=NJCHR
      GO TO 312
*
  355 CALL GETCHR (KCHAR,NKCHR)
*                                  3. IF THE TWO LETTERS ARE FOLLOWED BY
*                                     A DIGIT OR ANOTHER LETTER, ERROR
      IF(NKCHR.GT.IALPHA)THEN
*                                  4. COMPARE SUFFIX WITH LIST
      NSUF=CHR//JCHAR
      DO 365 I=1,4
      IF(NSUF.EQ.NSUFIX(I)) GO TO 370
  365 CONTINUE
      END IF
*                                     (A) NOT ON LIST, PRINT ERROR MSG
      PRINT 353, CHR, JCHAR
      LEXERR=.TRUE.
      CHR=KCHAR
      NCHR=NKCHR
      GO TO 311
*                                  5. ADD SUFFIX TO PACKED NAME
  370 CALL PACKEM (CHR)
      CALL PACKEM (JCHAR)
*                                  6. NOW CHECK THAT THIS IS THE CORRECT
*                                     SUFFIX FOR THIS NUMBER
*                                     (A) IF TENS DIGIT=1, IT'S  'TH'
      II=MOD(NUM,100)
      IF(II.GT.3.AND.II.LT.21) GO TO 379
*                                     (B) SET I = ONES DIGIT
      I=MOD(NUM,10)
*                                     (C) IF I=0 OR I/=3, IT 'S   'TH ';
*                                        ELSE IT'S  'ST','ND', OR 'RD'
*                                        FOR 1, 2 OR 3 RESPECTIVELY
      IF(I.EQ.0) GO TO 379
      IF(I.LE.3) GO TO 380
  379 I=4
*                                     (D) IF WRONG SUFFIX, PRINT WARNING
  380 IF(NSUF.NE.NSUFIX(I)) PRINT 383
  383 FORMAT(' ***Warning--Improper suffix for ordinal')
*                                  7. PUT ORDINAL ON SENTE
      CALL STAKEM (NAME,NST)
      CALL LEXTYP (LXADR(12))
      CALL SETTYP (NST,NUM*16+INTYPE)
      CHR=KCHAR
      NCHR=NKCHR
      GO TO 280
*                            IV. PROCESS PERIOD
*                               A. GET NEXT CHARACTER
  400 CALL GETCHR (CHR,NCHR)
*                               B. SENSE ENDMARK (FOLLOWING BLANK OR
*                                  OR END OF TEXT)
  403 IF(NCHR.EQ.BLANK.or.nchr.eq.EOL.OR.NCHR.EQ.SEOR) THEN
*                                  1. STORE POINTER TO ENDMARK IN SENTE
      CALL STAKEM(PERODC,NST)
      CALL LEXTYP(LXADR(LXEDMP))
      IF(LXTRAC)CALL PRNT
*                                  2. RETURN TO CONTROL PROGRAM
      CALL ADDCNT (NWORD,SENLIM,'SENTE',1)
      SENTE1(NWORD)=0
      SENTE2(NWORD)=0
      RETURN
      END IF
*                               C. IF LETTER FOLLOWS, GO PACK GENERATOR
  420 PERIOD =1
      IF(NCHR.EQ.IALPHA) GO TO 200
*                               D.IF FOLLOWING DIGIT, GO PACK SUBPART N
      IF(NCHR.GT.9) GO TO 430
  422 CALL PACKEM ('.')
      GO TO 300
*                               E. ELSE STACK PERIOD BY ITSELF
  430 CALL STAKEM (PERODC,NST)
      CALL LEXTYP (LXADR(LXSPCP))
      PERIOD=0
      IF(LXTRAC)CALL PRNT
      GO TO 101
*                            V. PROCESS TEXT ENCLOSED IN QUOTES
  500 N=0
*                               A. GET NEXT CHARACTER
  510 CALL GETCHR (CHR,NCHR)
*                                  1. IF END-OF-TEXT, ERROR
      IF(NCHR.EQ.SEOR) GO TO 900
*                               B. IF NOT A QUOTE, PACK CHARACTER
      IF(NCHR.NE.IAPOS) GO TO 515
      CALL GETCHR (CHR,NCHR)
      IF(NCHR.EQ.SEOR) GO TO 900
      IF(NCHR.NE.IAPOS) GO TO 520
*                                  1. IF 40 CHAR ALREADY PACKED, SKIP
  515 IF(N.LT.WORDLEN) THEN
      N=N+1
      CALL PACKEM (CHR)
      ELSEIF (N.LT.40)THEN
*                               C. MORE THAN 40 CHAR, PRINT MESSAGE
      PRINT *,' ***More than WORDLEN characters in quoted literal'
      trl=trmlen(name)
      PRINT 8888,CHR,NCHR,NAME(1:trl)
 8888 FORMAT(1X,A1,I3,2X,A)
      ELSE
  583 CALL GETCHR(CHR,NCHR)
      IF(NCHR.EQ.SEOR.OR.NCHR.EQ.IPER) GO TO 903
       GO TO 583
      END IF
      GO TO 510
*                                  2. IF TWO ' IN A ROW, PACK ONE
*                               D. CLOSE QUOTE FOUND, ENTER POINTER TO
*                                  STRING ON SENTE. Mark as text or node
  520 CALL STAKEM (NAME,NST)
      CALL LEXTYP (LXADR(LXTXTP))
      IF(PMODE.NE.1) CALL LEXTYP (LXADR(LXNODP))
      GO TO 280
*                            VII. process dollar sign (address)
*                               A. GET NEXT CHARACTER
  700 CALL GETCHR (CHR,NCHR)
      IF(NCHR.EQ.SEOR) GO TO 900
*                               B. IF ALPHAMERIC, GO PACK ADDRESS NAME
      IF(NCHR.GT.IALPHA) GO TO 710
      CALL PACKEM ('$')
      PERIOD=2
      REG=.FALSE.
      GO TO 201
*                               C. ELSE ERROR
  710 PRINT *,' ***$ Followed by special character'
*                                  1. UNLESS EOT REACHED, GET NEXT CHAR.
      IF(NCHR.NE.SEOR) GO TO 100
*     GO TO 900
*                            VIII. [ IN PARSER(II) -- IGNORE TEXT TO
*                                  NEXT ]
  800 LBCOUNT=1
  801 LBCOUNT=LBCOUNT+1
      IF(LBCOUNT.GT.50)THEN
        Print*, "Right hand bracket seems to be missing"
        GO TO 100
      ENDIF
  803 CALL GETCHR (CHR,NCHR)
      IF(NCHR.EQ.SEOR) GO TO 810
      IF(NCHR.EQ.EOL) GO TO 801
      IF(CHR.EQ.'[')THEN
        Print*, "Right hand bracket seems to be missing"
        GO TO 101
      ENDIF
      IF(CHR.NE.']') GO TO 803
      GO TO 100
*                               A. If EOT encountered, print error msg
  810 PRINT *,' ***Unpaired ]'
      GO TO 904
  903 PRINT 906
  906 FORMAT(' ***Closing QUOTE probably missing - scan terminated'/)
      GO TO 904
*                            IX. EOT HIT -- PRINT ERROR MESSAGE
  900 PRINT *,' ** No statement ENDMARK'
  904 LEXERR=.TRUE.
      RETURN
      END
      SUBROUTINE STAKEM (NM,JST)

***********************************************************************
*
*     STAKEM is called by the lexical processor to add a word to SENTE.
*     STAKEM searches the symbol table for NM, and puts it on if it is
*     not already there.  It then stores a pointer to the symbol table
*     entry in SENTE1() and a pointer to the beginning of the list in
*     grammar of lexical types in SENTE2().  (The list of lexical
*     types is created after the call to STAKEM, so SENTE2() is set to
*     point to the next available word in the grammar.)
*
***********************************************************************

      IMPLICIT INTEGER(A-Z)
      SAVE NEWLST
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*(*) NM
      CHARACTER*10 DEC
      CHARACTER*5 TEMP
      INCLUDE 'asf.fcm'
*                               A. INCREMENT WORD COUNT
      CALL ADDCNT (NWORD,SENLIM,'SENTE',1)
*                               B. FIND NAME ON SYMBOL TABLE
      JST=GETST(NM,0)
*                               C. STORE ENTRY IN SENTE
      SENTE1(NWORD)=JST
      SENTE2(NWORD)=0
*                               D. SET FLAG FOR LEXTYP
      NEWLST=0
*                               E. IF TRACE IS ON, ENCODE NAME AND SENTE
*                                  ENTRY ON LINE
      IF(LXTRAC) THEN
        TEMP=DEC(NWORD,3)
        CALL FILL ('  ')
        CALL FILL (TEMP(1:3))
        CALL FILL ('   ')
        CALL FILL (NM)
        CALL FILL ('   (')
        TEMP=DEC(JST,5)
        CALL FILL (TEMP)
        CALL FILL (',')
        TEMP=DEC(IG+1,5)
        CALL FILL (TEMP)
        CALL FILL (')    ')
      END IF
      RETURN
*
      ENTRY LEXTYP(IT)
*
************************************************************************
*
*     LEXTYP IS CALLED BY LEX ONCE FOR EACH LEXICAL TYPE TO BE
*     ASSIGNED TO THE CURRENT WORD (THE LAST WORD ADDED TO SENTE BY
*     STAKEM).  IF THE LEXICAL TYPE IS REFERENCED IN THE GRAMMAR, AND
*     HENCE HAS BEEN ASSIGNED A NUMBER, THIS NUMBER IS PASSED IN IT.
*     OTHERWISE ZERO IS PASSED AND THE CALL IS IGNORED .
*
************************************************************************
*
*                             A. IF IT=0, TYPE IS NOT REFERENCE IN
*                                IN GRAMMAR, IGNORE CALL
      IF(IT.EQ.0) RETURN
*                             B. ADD LEX TYPE TO LIST
      K=GCONS(0,0,IT)
      IF(NEWLST.EQ.0) THEN
        SENTE2(NWORD)=K
      ELSE
        CDR(NEWLST)=K
      END IF
      NEWLST=K
*                               C. IF TRACE IS ON, ENCODE LEX TYPE
      IF(LXTRAC) THEN
        CALL FILLTR (STNAME(CAR(IT))(1:20))
        CALL FILL (', ')
      END IF
      RETURN
      END
