*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE GETNOD (NS)
*
************************************************************************
*
*     GETNOD allocates space for a node of the parse tree.  NS is set to
*     the index of the first word of the allocated block.  All words in
*     the block are set to 0.  If no space is available, NS is set to 0.
*     GETNOD also returns, without setting NS, if the node limit is
*     exceeded (if NODZ is negative after being decremented).
*
*          INITIALLY SPACE IN NODE IS ALLOCATED SEQUENTIALLY;  I.E., THE
*     ROOT NODE IS STORED IN THE NODE WITH THE LOWEST INDEX, THE NEXT NO
*     CONSTRUCTED IS STORED IN THE NODE WITH THE NEXT INDEX , ETC.
*     VARIABLE XN POINTS TO THE NEXT AVAILABLE WORD IN NODE.  WHEN ALL
*     OF NODE HAS BEEN USED ONCE IN THIS FASHION, THE PARSER BEGINS
*     TO USE SPACE WHICH HAS BEEN FREED BY DETACHING NODES FROM THE
*     PARSE TREE.  The variable PREV points to the most recently freed
*     NODE;  NDHDBA(.) OF THAT NODE (I.E., NDHDBA(PREV) ) POINTS
*     TO THE NEXT AVAILABLE BLOCK , AND SO FORTH, FORMING A LINKED
*     LIST, UNTIL NDHDBA(.) OF THE LAST BLOCK CONTAINS 0.
*
************************************************************************

      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'parblk.fcm'
      INCLUDE 'nddfty.fcm'
      SAVE PREVRETBLK,XNODPTR
      DATA PREVRETBLK/0/,XNODPTR/1/
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
      NODZ=NODZ-1
      IF(NODZ.LT.0) THEN
        NS=0
        RETURN
      END IF
      NINTRE=NINTRE+1
      IF(XNODPTR+(NDSIZE-1).LE.NDLIM) THEN
        NS=XNODPTR
        XNODPTR=XNODPTR+NDSIZE
      ELSE
      NBB=NDSIZE
        NS=PREVRETBLK
        IF(NS.EQ.0) RETURN
        PREVRETBLK=NDHDBA(PREVRETBLK)
      ENDIF
*   set all the items in the node to zero
      INCLUDE 'clrnod.fcm'
      RETURN
*
      ENTRY FRENOD (NS)
*
************************************************************************
*
*     FRENOD adds to the available space list the node whose first word
*     is pointed TO BY NS.
*
************************************************************************

*     NDHDBA(NS)=PREV
      NODE(NS+7)=PREVRETBLK
      PREVRETBLK=NS
*     NDSPFB(NS)=0
      NODE(NS+5)=0
      NINTRE=NINTRE-1
      RETURN
*
      ENTRY GETNODINIT
      PREVRETBLK=0
      XNODPTR=1
      RETURN
      END
