*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE GEN
************************************************************************
*     GEN interprets the lists of generator calls and generates the code
*     After parsing, if a parse has been obtained, the main program calls
*     SCANTR.  SCANTR scans the parse tree and calls GEN once for each
*     node in the tree, in a bottom-up, left-to-right sequence.

*     GEN generates a list structure for the node from the list structures
*     assigned to nodes on the level below and assigns it to the node.
*     (a pointer to the generated list structure is placed in word 8 of the
*     node.)  The list structure assigned to the root node of the tree is
*     subsequently written out as the generated code of the parsed statement.
*
*          When GEN is called, it first checks the type of the current
*     node.  If the node is a literal or NULL atomic, GEN assigns it
*     a LIST structure of NIL.  If the node is a NON-LITERAL, NON-NULL
*     ATOMIC, IT IS ASSIGNED AS LIST STRUCTURE THE SYMBOL WHOSE NAME IS
*     THE NAME OF THE WORD MATCHED IN THE SENTENCE.  However, if the
*     ATOMIC NODE IS NAMED TEXT, IT IS ASSIGNED INSTEAD THE LITERAL
*     WHOSE NAME IS THE NAME OF THE WORD MATCHED IN THE SENTENCE.  IF
*     THE CURRENT NODE IS NOT ATOMIC, GEN CHECKS ITS LIST OF GENERATOR
*     CALLS.  POINTERS TO THE LISTS OF GENERATORS ARE STORED IN THE
*     SPECIAL FIELDS OF THE OPTION LISTS OF THE DEFINITIONS.  GEN
*     DETERMINES WHICH OPTION WAS USED TO EXPAND THE CURRENT NODE, AND
*     LOOKS IN THE DECREMENT FIELD OF THE ELEMENT CONTAINING THE OPTION
*     POINTER.  IF THE SPECIAL FIELD IS 0 (THERE IS NO SEQUENCE OF
*     GENERATOR CALLS ASSOCIATED WITH THIS OPTION) GEN COMPUTES AS THE
*     GENERATED CODE FOR THE CURRENT NODE THE CONCATENATION OF THE CODE
*     ASSIGNED TO ALL THE DAUGHTER NODES OF THIS NODE.
*      
*          IF THE SPECIAL FIELD DOES CONTAIN A POINTER TO A LIST OF
*     GENERATOR CALLS, GEN INTERPRETS THESE CALLS IN SEQUENCE.  THE
*     OPERATIONS PERFORMED BY THE INDIVIDUAL GENERATORS ARE DESCRIBED
*     BELOW JUST BEFORE THE ASSOCIATED CODE.  ALL INFORMATION IS PASSED
*     FROM GENERATOR TO GENERATOR THROUGH A SINGLE PUSH DOWN STACK,
*     GPDS.  THE ITEM ON TOP OF THE STACK WHEN ALL OF THE GENERATORS
*     HAVE BEEN EXECUTED IS ASSIGNED AS THE CODE GENERATED FOR THE
*     CURRENT NODE.
************************************************************************
       
      IMPLICIT INTEGER(A-Z)
      SAVE LSTWDS,ELIST
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'gencom.fcm'
      INCLUDE 'grio.fcm'
      PARAMETER (NUMGEN=13)
      PARAMETER (NMBITS=15)
      PARAMETER (GPDSLM=25)
      INTEGER GPDS(GPDSLM),PTR(9)
      CHARACTER*(WORDLEN) NAM,NDNAME
      CHARACTER*8 DEC
      PARAMETER (GLOBAL=BIT4)
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*      
      IF(NDATMT(XR7)) THEN
*                            I. GENERATE CODE FOR ATOMIC NODE
        IF((NDLTMT(XR7)) .OR. (NDOTMT(XR7))) THEN
*                               A. FOR LITERALS AND NULL, CODE=NIL
*         NDGCPS(XR7)=0
          NODE(XR7+8)=0                                                             
        ELSE
*                               B. FOR OTHER ATOMICS, CODE=POINTER TO
*                                  SYMBOL HEAD WHOSE NAME IS WORD
*                                  MATCHED, EXCEPT IF NODE IS *TEXT
*                                  CODE=POINTER TO LITERAL HEAD WHOSE
*                                  NAME IS WORD MATCHED
          IHEAD=HEAD
          IF(NODNAM(XR7).EQ.'TEXT') IHEAD=IHEAD+LTOMIC
          IW=NDWPNC(XR7)
          TEMP=SENTE1(IW)
*         NDGCPS(XR7)=GCONS(0,IHEAD,TEMP)
          NODE(XR7+8)=GCONS(0,IHEAD,TEMP)                                           
        END IF
        RETURN
      END IF
*                            II. Get node name and generator list
*                               A. GET NODE NAME
  100 SXR7=XR7
      NDNAME=NODNAM(XR7)
*                               B. IF TRACE IS ON PRINT NODE NAME
      IF(TSTTRC) THEN
        CALL FILL ('  Code being generated for node ')
        CALL FILLTR (NDNAME)
      END IF
*                               C. FIND GENERATOR LIST
      CALL DOWN
      IF(.NOT.PASS) GO TO 190
      GENLST=CSR(NDOPES(XR7))
      IF(GENLST.EQ.0) GO TO 200
      XR7=SXR7
      GO TO 300
*      
  190 PRINT *,'***** GEN has found error in parse tree'
      GO TO 990
*                            III. IF NODE HAS NO GENERATORS, CONCATENATE
*                                 CODE OF DAUGHTER NODES
*                               A. IF TRACE IS ON, PRINT MESSAGE
  200 IF(TSTTRC) PRINT 201
  201 FORMAT('    option has no generators--code of daughter nodes will
     *be concatenated')
*                               B. PUT CODE OF FIRST-IN-LEVEL IN KODE
  205 KODE=NDGCPS(XR7)
*                               C. GO RIGHT--IF IMPOSSIBLE, ARE FINISHED
  210 CALL RIGHT
      IF(.NOT.PASS) GO TO 250
*                               D. IF THIS ELEMENT HAS NULL CODE,
*                                  KEEP GOING
      IF(NDGCPS(XR7).EQ.0) GO TO 210
*                               E. IF THIS IS THE FIRST ELEMENT WITH A
*                                  NON-NULL CODE, SAVE IT IN KODE
      IF(KODE.EQ.0) GO TO 205
*                               F. OTHERWISE, CONCATENATE TO CODE
*                                  ALREADY IN KODE
      KODE=CAT(KODE,NDGCPS(XR7))
      GO TO 210
*      
  250 XR7=SXR7
      GO TO 840
*                            IV. INTERPRET GENERATOR LIST
*                               A. IF TRACE IS ON, INITIALIZE LINE BUFFE
  300 IF(TSTTRC) THEN
        INDENT=10
        CALL FILL ('    generators called:  ')
      END IF
*                               B. SET STACK EMPTY, CLEAR POINTERS
      IGP=0
      DO 315 I=1,9
  315 PTR(I)=0
*                               C. GET FIRST/NEXT GENERATOR
  320 IGEN=CAR(GENLST)
      IOP=CDR(IGEN)
      ARG=CSR(GENLST)
*                                  1. CHECK FOR VALID GENERATOR
      IF(IOP.LE.0.OR.IOP.GT.NUMGEN) GO TO 900
*                                  2. IF TRACE IS ON, PRINT GENERATOR
*                                     NAME AND ARGUMENT
      IF(TSTTRC) THEN
*     PRINT *,'IGEN ARG IOP ',IGEN,ARG,IOP
        CALL PLIST (IGEN,.FALSE.)
        IF(ARG.NE.0) THEN
          CALL FILL ('(')
          CALL PLIST (ARG,.FALSE.)
          CALL FILL (')  ')
        ELSE
          CALL FILL ('  ')
        END IF
      END IF
*                               D. EXECUTE GENERATOR
      GO TO (420,440,460,480,500,520,540,560,580,600,620,640,660), IOP

*     ELEM(N):  PUT CODE VALUE OF NTH ELEMENT ON TOP OF STACK

  420 IF(ARG.LE.0) GO TO 955
      IF(AND(CSR(ARG),(HEAD+CNSTBT)).NE.(HEAD+CNSTBT)) GO TO 955
      NUM=CDR(ARG)
      CALL ADDCNT (IGP,GPDSLM,'GPDS',1)
      CALL DOWN
      NUM=NUM-1
      DO 425 I=1,NUM
      CALL RIGHT
      IF(.NOT.PASS) GO TO 905
  425 CONTINUE
      GPDS(IGP)=NDGCPS(XR7)
      XR7=SXR7
      GO TO 800
*      
*     SYM(N):  N SHOULD POINT TO A LITERAL OR INTEGER HEAD;  PLACE
*              POINTER TO SYMBOL HEAD WITH SAME NAME AS LITERAL/
*              INTEGER ON TOP OF STACK.  EXCEPTION:  IF N IS NIL OR
*              POINTS TO THE LITERAL  NIL , PLACE A ZERO (I.E., NIL) ON
*              THE STACK.   (IN THE CASE OF LITERALS, WHEN STNAME ENTRY
*              IS GENERATED ON FIRST CALL, A POINTER TO THAT ENTRY IS
*              SAVED IN THE CSR FIELD OF THE LITERAL TO AVOID HAVING
*              TO PERFORM SUBSEQUENT LOOK-UPS;  HOWEVER, WE MUST STILL
*              CHECK EACH TIME WHETHER THE POINTER IS CORRECT TO ALLOW
*              FOR THE POSSIBILITY THAT THE SYMBOL HAS JUST BEEN
*              REMOVED FROM STNAME BY A *DELETE DIRECTIVE)
*      
  440 CALL ADDCNT (IGP,GPDSLM,'GPDS',1)
      IF(ARG.EQ.0) GO TO 457
      IF(ARG.LT.0) GO TO 910
      KAR=ATMTST(ARG)
      KSR=CDR(ARG)
      IF(KAR.EQ.0) GO TO 910
      IF(KAR.LT.0) GO TO 450
      IF(AND(CSR(ARG),CNSTBT).EQ.0) GO TO 910
      NAM=STNAME(KAR)
      KSR=GETST(NAM,KSR*16+INTYPE)
      GO TO 448

  450 NAM=STNAME(-KAR)
      IF(NAM.EQ.'NIL') GO TO 457
      IF(KSR.EQ.0) GO TO 442
      IF(STNAME(KSR).EQ.NAM) GO TO 448
  442 KSR=GETST(NAM,0)
      CDR(ARG)=KSR
  448 GPDS(IGP)=GCONS(0,HEAD,KSR)
      GO TO 800
*      
  457 GPDS(IGP)=0
      GO TO 800

*     SAVEPTR(N):  TOP OF STACK MUST POINT TO AN UNNAMED HEAD WHICH HAS
*                  BEEN ASSIGNED DUMMY NUMBER D.  D IS SAVED AS VALUE OF
*                  PTR(N), 1 N 9.  ERROR IF A HEAD HAS ALREADY BEEN
*                  SAVED IN PTR(N) (IF PTR(N) 0).

  460 IF(ARG.LE.0) GO TO 955
      IF(.NOT.NUMBRP(ARG)) GO TO 955
      NUM=CDR(ARG)
      IF(NUM.LE.0.OR.NUM.GT.9) GO TO 915
      IF(IGP.EQ.0) GO TO 920
      IF(GPDS(IGP).LE.0) GO TO 925
      IF(AND(CSR(GPDS(IGP)),(HEAD+NONAM)).NE.(HEAD+NONAM)) GO TO 925
      IF(PTR(NUM).GT.0) GO TO 930
      IF(PTR(NUM).EQ.0) THEN
        PTR(NUM)=CAR(GPDS(IGP))
      ELSE
        PTR(NUM)=-PTR(NUM)
        I=SEARCH(DUMLST,CAR(GPDS(IGP)))
        IF(I.EQ.0) GO TO 970
        CAR(I)=PTR(NUM)
        CAR(GPDS(IGP))=PTR(NUM)
      END IF
      GO TO 800
*      
*     PTR(N):  IF THERE IS NO DUMMY NUMBER D ASSOCIATED WITH PTR(N),
*              GENERATE A NEW ONE AND ASSIGN IT TO PTR(N).  PUT A
*              POINTER TO A DUMMY HEAD WITH NUMBER D ON TOP OF STACK.
*      
  480 IF(ARG.LE.0) GO TO 955
      IF(.NOT.NUMBRP(ARG)) GO TO 955
      NUM=CDR(ARG)
      IF(NUM.LE.0.OR.NUM.GT.9) GO TO 915
      ID=ABS(PTR(NUM))
      IF(ID.EQ.0) THEN
      NDUMMY=NDUMMY+1
      ID=NDUMMY
      PTR(NUM)=-ID
      END IF
      CALL ADDCNT (IGP,GPDSLM,'GPDS',1)
      GPDS(IGP)=GCONS(0,HEAD+NONAM,ID)
      GO TO 800
*      
*     SAVELIST:  SAVE LIST POINTED TO BY TOP OF STACK FOR SUBSEQUENT
*                USE BY GENERATOR LOOKUP
*      
  500 IF(IGP.EQ.0) GO TO 920
      ELIST=GPDS(IGP)
      GO TO 800
*      
*     LOOKUP(N):  SEARCHES ELIST (SAVED BY SAVELIST) FOR A MATCH WITH
*                 THE ITEM ON TOP OF THE STACK.  IF THE MTH ELEMENT
*                 OF ELIST MATCHES, REPLACES ITEM ON TOP OF STACK WITH
*                 M;  IF NO MATCH PRINTS ERROR MESSAGE
*                IF N=1 MATCHES CAR OF ELIST ELEMENT
*                IF N=2 MATCHES CDR OF ELIST ELEMENT
*      
  520 IF(ARG.LE.0) GO TO 955
      IF(.NOT.NUMBRP(ARG)) GO TO 955
      NUM=CDR(ARG)
      IF(NUM.NE.1 .AND. NUM.NE.2) GO TO 915
      IF(IGP.EQ.0) GO TO 920
      KAR=ATMTST(GPDS(IGP))
      IF(KAR.LE.0) GO TO 945
      IF(ELIST.EQ.0) GO TO 965
      L=ELIST
      M=1
  525 IF(NUM.NE.2) THEN
        LELEM=CAR(L)
      ELSE
        LELEM=CSR(L)
      END IF
      IF(ATMTST(LELEM).EQ.KAR) GO TO 535
      L=CDR(L)
      M=M+1
      IF(L.NE.0) GO TO 525
      GO TO 935
*      
  535 NAM=DEC(M,0)
      I=GETST(NAM,M*16+INTYPE)
      GPDS(IGP)=GCONS(0,(HEAD+CNSTBT),I)
      GO TO 800

*     CONS:  CONSTRUCT A LITHP ELEMENT FROM THE TOP THREE ELEMENTS ON
*            THE STACK;  REPLACE THE THREE ELEMENTS BY A POINTER TO THE
*            NEW ELEMENT.  IF THE NEW ELEMENT IS A DUMMY HEAD, ASSIGN
*            IT A DUMMY NUMBER AND PLACE IT ON THE DUMMY LIST.

  540 IF(IGP.LT.3) GO TO 940
      GPDS(IGP-2)=GCONS(GPDS(IGP),GPDS(IGP-1),GPDS(IGP-2))
      IGP=IGP-2
      I=ATMTST(GPDS(IGP+1))
      IF(I.LE.0) GO TO 800
      IF(STNAME(I).NE.'UNNHEAD') GO TO 800
      NDUMMY=NDUMMY+1
      DUMLST=GCONS(DUMLST,GPDS(IGP),NDUMMY)
      GPDS(IGP)=GCONS(0,HEAD+NONAM,NDUMMY)
      GO TO 800
*      
*     CAT:  CONCATENATES THE LISTS POINTED TO BY THE TOP TWO ELEMENTS ON
*           THE STACK AND REPLACES THESE TWO ELEMENTS WITH A POINTER TO
*           THE CONCATENATED LIST
*      
  560 IF(IGP.LT.2) GO TO 930
      GPDS(IGP-1)=CAT(GPDS(IGP-1),GPDS(IGP))
      IGP=IGP-1
      GO TO 800

*     TXT:  ITEM ON TOP OF STACK SHOULD POINT TO A SYMBOL HEAD.  CHANGE
*           THIS TO A LITERAL HEAD.

  580 IF(IGP.EQ.0) GO TO 920
      IF(ATMTST(GPDS(IGP)).LE.0) GO TO 945
      CSR(GPDS(IGP))=(HEAD+LTOMIC)
      GO TO 800

*     TYPE(N):  ITEM ON TOP OF STACK MUST POINT TO A SYMBOL HEAD.
*               ASSIGN SYMBOL THE TYPE N.

  600 IF(ARG.LE.0) GO TO 955
      IF(.NOT.NUMBRP(ARG)) GO TO 955
      NUM=CDR(ARG)
      IF(IGP.EQ.0) GO TO 920
      I=ATMTST(GPDS(IGP))
      IF(I.LE.0) GO TO 935
      CALL SETTYP (I,NUM)
      GO TO 800

*     IDIOM:  item on top of stack should point to symbol or literal
*             head.  Save name of symbol/literal in object buffer as
*             next word of idiom.

  620 IF(IGP.EQ.0) GO TO 920
      I=ABS(ATMTST(GPDS(IGP)))
      IF(I.EQ.0) GO TO 960
      IDWDCT=IDWDCT+1
      IDWORD(IDWDCT)=STNAME(I)
      IF(SEARCH(LSTWDS,I).EQ.0) LSTWDS=GCONS(LSTWDS,0,I)
      GO TO 800

*    DERIV:  SETS DERIVATIVE FLAG TO 1

  640 DERIV=1
      GO TO 800
*      
*     END(N):  Performs the following functions at the conclusion of
*              code generation
*              1. SETS UP
*                RCDNAM = NAME OF RECORD
*                TOST = TYPE OF STATEMENT (PASSED AS ARGUMENT TO END)
*                STPTR = FOR ALL RECORDS EXCEPT WORD DEFINITIONS,
*                        POINTER TO SYMBOL TABLE ENTRY OF HEAD OF RECORD
*                      = FOR WORD DEFINITIONS, POINTER TO SYMBOL TABLE
*                        ENTRY OF CANONICAL FORM USED TO DEFINE WORD
*                        (=0 IF CATEGORY LIST APPEARS EXPLICITLY)
*      
  660 IF(ARG.LE.0) GO TO 955
      IF(.NOT.NUMBRP(ARG)) GO TO 955
      NUM=CDR(ARG)
      IF(IGP.EQ.0) GO TO 920
      I=CAR(CAR(GPDS(IGP)))
      RCDNAM=STNAME(I)
      IF(NUM.EQ.6 .OR. NUM.EQ.8) THEN
        IF(NUM.EQ.6) THEN
         STPTR=0
        ELSE
          STPTR=CAR(CDR(GPDS(IGP)))
          CDR(GPDS(IGP))=0
        END IF
*      
*              2. FOR WORD DEFINITIONS, ADD WORD TO LIST OF SYMBOLS TO
*              BE REMOVED FROM SYMBOL TABLE AFTER DEFINITION HAS BEEN
*              WRITTEN OUT
*      
        IF(SEARCH(LSTWDS,I).EQ.0)LSTWDS=GCONS(LSTWDS,0,I)
          CAR(GPDS(IGP))=0
        ELSE
          STPTR=I
        END IF
        TOST=NUM
*      
*              3. ASSIGNS TYPE TO HEAD OF RECORD
*                  DTYPE FOR DEFINITIONS (NUM=1)
*                  ADTYPE FOR RESTRICTIONS & ADDRESS SENTENCES (NUM=2,3)
*                  ADTYPE+GLOBAL FOR ROUTINES (NUM=4)
*      
        IF(NUM.LE.4) THEN
          IF(NUM.EQ.1) THEN
            CALL SETTYP (I,DTYPE)
          ELSE
            CALL SETTYP (I,ADTYPE)
            IF(NUM.EQ.4) CALL SETTYP (I,GLOBAL)
          END IF
        END IF
*      
*              4. FOR TYPE LISTS, IF TYPE IS ASSIGNED A BIT IN STTYPE,
*              TURNS ON THAT BIT FOR EACH SYMBOL ON TYPE LIST
*      
        IF(NUM.NE.5) GO TO 800
        IF(RCDNAM.EQ.'ATTRIBUTE'.OR.RCDNAM.EQ.'GLOBAL')GO TO 800
        CALL SETTYP (I,TPTYPE)
      IF(RCDNAM.EQ.'STRING') THEN
        IBIT=STGBIT
      ELSE IF(RCDNAM.EQ.'MINLIST') THEN
        IBIT=MINFLG
      ELSE IF(RCDNAM.EQ.'RECURSIVE') THEN
        IBIT=RECBT
      ELSE
        GO TO 800
      END IF
*      
      NBIT=IBIT*16
*      
*  Since it may be the case that symbols are being removed from
*  a TYPE list if the process is an update.  Therefore it is
*  necesary to remove the bit from all the symbols and have it
*  reestablished for the symbols on the TYPE LIST being processed.
*      
      KBIT=COMPL(NBIT)
      DO 684 II=1,STLNTH
      if(and(sttype(ii),15).eq.TPTYPE)STTYPE(II)=AND(STTYPE(II),KBIT)
  684 if(and(sttype(ii),15).eq.DTYPE)STTYPE(II)=AND(STTYPE(II),KBIT)
      CALL SETTYP (I,NBIT)
      L=CDR(GPDS(IGP))
  685 K=ATMTST(CAR(L))
      IF(K.LE.0) GO TO 950
      CALL SETTYP (K,NBIT)
      L=CDR(L)
      IF(L.NE.0) GO TO 685
*      
*                               E. GET NEXT GENERATOR, IF ANY
  800 GENLST=CDR(GENLST)
      IF(GENLST.NE.0) GO TO 320
      IF(TSTTRC) CALL PRNTIF
*                               F. CHECK FOR UNDEFINED POINTER
      DO 820 I=1,9
  820 IF(PTR(I).LT.0) GO TO 825
*                            V. STORE GENERATED CODE IN NODE
      KODE=0
      IF(IGP.NE.0) KODE=GPDS(IGP)
* 840 NDGCPS(XR7)=KODE
  840 NODE(XR7+8)=KODE                                                              
*                               A. IF TRACE IS ON, PRINT CODE
      IF(TSTTRC) THEN
      CALL FILL ('    Generated code:   ')
      CALL PLIST (KODE,.FALSE.)
      CALL PRNT
      END IF
      RETURN
  825 CALL FILL ('*** Pointer ')
      NAME=DEC(I,2)
      CALL FILL (NAME(1:2))
      CALL FILL (' not defined')
      GO TO 985
*                            VI. ERROR MESSAGES
  900 CALL PRNTIF
      CALL FILL ('*** Invalid generator')
      GO TO 985
  905 PRINT *,'*** Semantics error--argument>number of elements'
      GO TO 980
  910 PRINT *,'*** Semantics error--argument not a literal or integer'
      GO TO 980
  915 PRINT *,'*** Semantics error--invalid argument'
      GO TO 980
  920 PRINT *,'*** Semantics error--stack empty'
      GO TO 980
  925 PRINT *,'*** Semantics error--top of stack not a dummy'
      GO TO 980
  930 PRINT *,'*** Semantics error--duplicate assignment'
      GO TO 980
  935 PRINT *,'*** Semantics error--no matching item in element list'
      GO TO 980
  940 PRINT *,'*** Semantics error--too few items on stack'
      GO TO 980
  945 PRINT *,'*** Semantics error--top of stack not a symbol'
      GO TO 980
  950 PRINT *,'*** Type list element not a symbol'
      GO TO 980
  955 PRINT *,'*** Semantics error--argument to generator not an integer
     R*'
      GO TO 980
  960 PRINT *,'*** Semantics error--top of stack not a symbol or literal
     *'
      GO TO 980
  965 PRINT *,'*** Semantics error--no prior call to SAVELIST'
      GO TO 980
  970 PRINT *,'***** System error--dummy not on dummy list'
*      
  980 IF(TSTTRC) CALL PRNTIF
      CALL FILL ('     error detected by generator ')
      CALL FILLTR (STNAME(CAR(IGEN)))
  985 CALL FILL (' in semantics of ')
      CALL FILLTR (NDNAME)
      CALL PRNT
  990 GENERR=.TRUE.
*     NDGCPS(XR7)=0
      NODE(XR7+8)=0                                                                 
      RETURN
       
      ENTRY GENINI
       
*      
      GENERR=.FALSE.
      DUMLST=0
      NDUMMY=0
      IDWDCT=0
      ELIST=0
      DERIV=0
      LSTWDS=0
      RETURN

      ENTRY GENTRM
*   GENTRM IS INVOKED AFTER THE GENERATED CODE HAS BEEN WRITTEN OUT
*   TO THE GRAMMAR FILE.  IT REMOVES FROM THE SYMBOL TABLE THE
*   ENTRIES CREATED FOR THE WORDS IN A WORD DEFINITION STATEMENT
*   (UNLESS THE ENTRIES ARE REFERENCED AS REAL SYMBOLS ELSEWHERE IN
*   THE GRAMMAR)

 1000 IF(LSTWDS.EQ.0)RETURN
      K=CAR(LSTWDS)
      IF(STREFC(K).EQ.0)CALL RMVST(K)
      LSTWDS=CDR(LSTWDS)
      GO TO 1000
      END

      FUNCTION ATMTST (ATMPTR)

************************************************************************
*     ATMTST RETURNS
*             +CAR(ATMPTR) [=+SYMBOL TABLE POINTER] IF ATMPTR POINTS
*                          TO A NAMED SYMBOL HEAD
*             -CAR(ATMPTR) [=-SYMBOL TABLE/LITTAB POINTER] IF ATMPTR
*                          POINTS TO A LITERAL HEAD
*             0 OTHERWISE
************************************************************************
       
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*      
      IF(ATMPTR.EQ.0) GO TO 8
      KDR=CSR(ATMPTR)
      IF(AND(KDR,HEAD).EQ.0) GO TO 8
      IF(AND(KDR,LTOMIC).NE.0) GO TO 4
      IF(AND(KDR,NONAM).NE.0) GO TO 8
      ATMTST=CAR(ATMPTR)
      RETURN
    4 ATMTST=-CAR(ATMPTR)
      RETURN
    8 ATMTST=0
      RETURN
      END
      SUBROUTINE SCANTR

************************************************************************
*     SCANTR is invoked after each successful sentence parse.  It
*     traverses the parse tree, starting with the root node, and
*     INVOKES THOSE ROUTINES WHICH ARE TO BE EXECUTED AFTER A PARSE
*     HAS BEEN OBTAINED.  IN ADDITION, IF TSTAT IS TRUE, IT WRITES
*     THE PARSE TREE OUT ON FILE UNIT WKFIL.
************************************************************************

      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'grio.fcm'
      COMMON/TSTAT/TSTAT
      LOGICAL TSTAT
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*
      IF(TSTAT) WRITE (WKFIL,1001) (SOURCE(I),I=1,SRCLEN)
 1001 FORMAT('START TREE'/(A80))
      I=PARSNO-1
      IF(TSTAT) WRITE (WKFIL,2001) I
 2001 FORMAT('PARSE'/I5)
      XR7=1
  100 CONTINUE
*     ROUTINES TO BE EXECUTED BEFORE SUBTREE OF CURRENT NODE IS
*        ENTERED GO HERE
      IF(TSTAT) THEN
      NAME=NODNAM(XR7)
      WRITE (WKFIL,1002) NAME,NDSPFB(XR7)
 1002 FORMAT(A10,1X,O5)
      ENDIF
      IF(EXTYP.EQ.PARSSN) CALL MATBLD
*-----
      CALL DOWN
      IF(.NOT.PASS) GO TO 200
      IF(TSTAT) WRITE (WKFIL,1003)
 1003 FORMAT('Go down')
      GO TO 100
*
  200 CONTINUE
*     Routines to be executed after subtree below current node has
*        BEEN TRAVERSED GO HERE
      CALL GEN
      CALL RIGHT
      IF(PASS) GO TO 100
      CALL UPONE
      IF(.NOT.PASS) RETURN
      IF(TSTAT) WRITE (WKFIL,1004)
 1004 FORMAT('Go up')
      GO TO 200
      END
