*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE DUMP
************************************************************************
*
*     DUMP converts the internal list structure (produced by the
*     GENERATORS) into the external list structure which will be
*     written out as part of the object record.
*
************************************************************************
*
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'gencom.fcm'
      INCLUDE 'nodray.fcm'
      PARAMETER (KPLIM=20)
      INTEGER POSSTK(KPLIM),OLSTK(KPLIM),OLESTK(KPLIM),LENSTK(KPLIM)
      CHARACTER*10 DEC
      CHARACTER*3 CHAR3
      EQUIVALENCE (NAME,CHAR3)
      PARAMETER (ISGWTH=1, INTWTH=3, IFDWTH=15)
      LOGICAL WRITE
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*                   BECAUSE THE GENERATED LIST MAY BE CIRCULAR, THE DUMP
*                   MUST BE PERFORMED IN THREE STEPS:
*                            I. SCAN LISTS BELOW DUMMY HEADS TO
*                               DETERMINE THE POSITIONS OF THE DUMMY
*                               HEADS IN THE OUTPUT LIST STRUCTURE
*                               THIS INFORMATION IS SAVED IN THE DUMMY
*                               CORRESPONDENCE LIST, DUMCOR, EACH OF
*                               WHOSE ELEMENTS IS OF THE FORM
*                               DUMMY-NUMBER[POSN IN OUTPUT LIST]
      WRITE=.FALSE.
      OUTCT=0
      DUMCOR=0
      LDUM=DUMLST
   10 IF(LDUM.EQ.0) GO TO 20
      D=CAR(LDUM)
      LSTPTR=CSR(LDUM)
      ASSIGN 15 TO MRET
      GO TO 80
   15 DUMCOR=GCONS(DUMCOR,OUTPTR,D)
      LDUM=CDR(LDUM)
      GO TO 10
*                            II. THE LISTS BELOW THE DUMMY HEADS ARE
*                               SCANNED AGAIN, IN EXACTLY THE SAME ORDER
*                               THIS TIME TO WRITE THEM OUT
   20 WRITE=.TRUE.
      OUTCT=0
      LDUM=DUMLST
      IF(PUTTRC) PRINT 21
   21 FORMAT(/' Object Record:')
   22 IF(LDUM.EQ.0) GO TO 30
      LSTPTR=CSR(LDUM)
      ASSIGN 25 TO MRET
      GO TO 80
   25 LDUM=CDR(LDUM)
      GO TO 22
*                            III. finally we write out the list below
*                                 the named head
   30 LSTPTR=NDGCPS(1)
      ASSIGN 35 TO MRET
      GO TO 80
   35 IF(PUTTRC) CALL PRNT
      CALL PUTFLD (0,ISGWTH)
      CALL PUTFLD (IEOR,INTWTH)
      RETURN

*-----------------------------------------------------------------------
*
*     THE FOLLOWING CODE SCANS A SINGLE INTERNAL LIST AND GENERATES THE
*     CORRESPONDING EXTERNAL LIST STRUCTURE THROUGH CALLS ON PUTFLD.
*     THIS CODE IS USED IN EFFECT AS A CLOSED SUBROUTINE BY THE CODE
*     ABOVE, WITH THE FOLLOWING ARGUMENTS:
*          LSTPTR = POINTER TO LIST TO BE CONVERTED
*          WRITE  = .TRUE. IF EXTERNAL LIST STRUCTURE IS TO BE GENERATED
*                   .FALSE. IF EXTERNAL LIST STRUCTURE IS NOT TO BE
*                           GENERATED (ONLY INTERESTED IN VALUE OF
*                           OUTPTR WHICH IS RETURNED)
*          MRET   = RETURN ADDRESS
*     AND RETURNS
*          OUTPTR = POSITION IN EXTERNAL LIST STRUCTURE OF ELEMENT
*                   CORRESPONDING TO INTERNAL LIST ELEMENT POINTED TO BY
*                   LSTPTR
*
*     THIS CODE ALSO USES THE FOLLOWING VARIABLES:
*          POS:  IABS(POS) = POINTER TO LIST ELEMENT BEING PROCESSED
*                POS>0 IF PROCESSING SPECIAL FIELD
*                POS<0 IF PROCESSING ADDRESS FIELD
*          OUTL   = POINTER TO INTERMEDIATE-FORMAT OUTPUT LIST, EACH OF
*                   WHOSE ELEMENTS IS OF THE FORM
*                            IPTR [ FLAG ]
*                   WHERE, IF FLAG=0 IPTR =0 (INDICATING A NIL FIELD) OR
*                                    POINTS TO A HEAD IN THE INTERNAL
*                                    LIST STRUCTURE
*                          IF FLAG=1, IPTR POINTS TO AN ELEMENT OF THE
*                                    EXTERNAL LIST STRUCTURE WHICH HAS
*                                    ALREADY BEEN GENERATED
*                   NOTE THAT TWO ELEMENTS OF THIS INTERMEDIATE LIST ARE
*                   REQUIRED FOR EACH ELEMENT OF THE ORIGINAL LIST--
*                   FIRST ONE FOR THE SPECIAL FIELD, THEN ONE FOR THE
*                   ADDRESS FIELD.  IN ADDITION, THE FIRST ELEMENT OF
*                   THE LIST IS A DUMMY (CAR=CDR=0) PRESENT ONLY TO
*                   SIMPLIFY THE ADDITION OF ELEMENTS TO THE LIST.
*          OLEND  = POINTER TO LAST ELEMENT OF INTERMEDIATE LIST
*          LENG   = NUMBER OF ELEMENTS OF THE INTERNAL LIST STRUCTURE
*                   ON THIS LEVEL WHICH HAVE ALREADY BEEN PROCESSED
*     WHEN A LOWER LEVEL LIST MUST BE PURSUED, THE CURRENT VALUES OF POS
*     , OUTL, OLEND, AND LENG ARE STACKED ON POSSTK, OLSTK, OLESTK,
*     AND LENSTK RESPECTIVELY.
*
   80 POS=LSTPTR
      KP=0
*                            I. NEW OUTPUT LEVEL, CLEAR OUTL AND LENG
   90 OUTL=GCONS(0,0,0)
      OLEND=OUTL
      LEN=0
*
*                            II. PROCESS SPECIAL FIELD
*                               A. EXTRACT FIELD
  100 IFLD=CSR(POS)
*                               B. NIL FIELD, ADD 0[0] TO OUTL
  110 IF(IFLD.EQ.0) GO TO 150
      IF(ATOMP(IFLD)) GO TO 150
*                               C. FIELD POINTS TO LIST, STACK
*                                  VARIABLES AND PURSUE LOWER LEVEL LIST
      CALL ADDCNT (KP,KPLIM,'POSSTK',1)
      POSSTK(KP)=POS
      OLSTK(KP)=OUTL
      OLESTK(KP)=OLEND
      LENSTK(KP)=LEN
      POS=IFLD
      GO TO 90
*                               D. FIELD POINTS TO HEAD, PUT
*                                  POINTER-TO-HEAD[0] ON OUTL
  150 IFLAG=0
  160 I=GCONS(0,IFLAG,IFLD)
      CDR(OLEND)=I
      OLEND=I
  180 IF(POS.LT.0) GO TO 190
*                            III. REPEAT II. FOR ADDRESS FIELD
      IFLD=CAR(POS)
      POS=-POS
      GO TO 110
  190 POS=-POS
*                            IV. GET NEXT LIST ELEMENT
  200 POS=CDR(POS)
      LEN=LEN+1
      IF(POS.NE.0) GO TO 100
*                            V. LEVEL IS COMPLETE, WRITE EXTERNAL LIST
*                               STRUCTURE (IF WRITE=.TRUE.)
      IF(.NOT.WRITE) GO TO 320
      OUTL=CDR(OUTL)
*                               A. IF TRACE IS ON, PRINT POSITION OF
*                                  FIRST LIST ELEMENT
      IF(PUTTRC) THEN
      CALL FILL('   ')
      CHAR3=DEC(OUTCT+1,3)
      CALL FILL (CHAR3)
      CALL FILL (':  (')
      END IF
      ISIGN=0
*                               B. OUTPUT SIGN FIELD (0 FOR FIRST ELEM.,
*                                  1 FOR SUCCEEDING ELEMENTS)
  225 CALL PUTFLD (ISIGN,ISGWTH)
*                               C. OUTPUT FIRST SPECIAL, THEN
*                                  ADDRESS FIELD
      DO 300 I=1,2
      IF(PUTTRC.AND.I.EQ.1) CALL FILL (' [ ')
      IFLAG=CSR(OUTL)
      IPTR=CAR(OUTL)
      OUTL=CDR(OUTL)
      IF(IFLAG.EQ.1) GO TO 280
      IF(IPTR.NE.0) GO TO 240
*                                  1. NIL FIELD, OUTPUT NIL INTERP.
*                                     FIELD, NO VALUE FIELD
      CALL PUTFLD (INIL,INTWTH)
      IF(PUTTRC) CALL FILL ('NIL')
      GO TO 290

  240 ISTPTR=ATMTST(IPTR)
      IF(ISTPTR.EQ.0) GO TO 270
      IF(ISTPTR.GT.0) THEN
*                                  2. SYMBOL HEAD
      IF(PUTTRC) CALL FILLTR (STNAME(ISTPTR))
*                                     (A) IF A RESERVED NAME (NHEAD OR
*                                         UNNHEAD) OUTPUT CORRESPONDING
*                                         ABSOLUTE FIELD
      IF(STNAME(ISTPTR).EQ.'NHEAD') THEN
        CALL PUTFLD (IABSO,INTWTH)
        CALL PUTFLD (HDINOG,IFDWTH)
*
      ELSEIF(STNAME(ISTPTR).EQ.'UNNHEAD') THEN
        CALL PUTFLD (IABSO,INTWTH)
        CALL PUTFLD ((HDINOG+NONAM),IFDWTH)
*                                     (B) ELSE OUTPUT SYMBOL FIELD
      ELSE
        CALL PUTFLD (ISYM,INTWTH)
        CALL PUTFLD (ISTPTR,IFDWTH)
        STREFC(ISTPTR)=STREFC(ISTPTR)+1
      END IF
      ELSE
*                                  3. literal head, output literal field
      ISTPTR=-ISTPTR
      CALL PUTFLD(ILIT,INTWTH)
      CALL PUTFLD(ISTPTR,IFDWTH)
      STREFC(ISTPTR)=STREFC(ISTPTR)+1
      IF(PUTTRC) THEN
        CALL FILL ('''')
        CALL FILLTR (STNAME(ISTPTR))
        CALL FILL ('''')
      END IF
      END IF
      GO TO 290
*                                  4. DUMMY HEAD
*                                     (A) LOOK UP POSITION IN EXTERNAL
*                                         LIST ON DUMMY CORRESPONDENCE
*                                         LIST
  270 ND=CAR(IPTR)
      IPTR=SEARCH(DUMCOR,ND)
*                                     (B) FOUND, OUTPUT RELATIVE FIELD
      IF(IPTR.NE.0) THEN
        IPTR=CSR(IPTR)
      ELSE
*                                     (C) NOT ON LIST, ERROR
        PRINT 276, ND
  276 FORMAT(' ***** DUMMY ',I2,' Undefined (DUMP)')
      END IF
*                                  5. OUTPUT RELATIVE FIELD
  280 CALL PUTFLD (IREL,INTWTH)
      CALL PUTFLD (IPTR,IFDWTH)
      IF(PUTTRC) THEN
      CHAR3=DEC(IPTR,3)
      CALL FILL (CHAR3)
      CALL FILL ('+')
      END IF
  290 IF(PUTTRC.AND.I.EQ.1) CALL FILL (' ] ')
  300 CONTINUE
*                               D. IF MORE ELEMENTS ON OUTL, LOOP
*                                  BACK TO B
      ISIGN=1
      IF(OUTL.EQ.0) GO TO 310
      IF(PUTTRC) CALL FILL (', ')
      GO TO 225
  310 IF(PUTTRC) THEN
        CALL FILL (' )')
        CALL PRNT
      END IF
*                               E. SAVE POINTER TO START OF EXTERNAL
*                                  LIST IN OUTPTR, ADVANCE OUTCT
*                                  (=NUMBER OF EXTERNAL ELEMENTS WRITTEN)
  320 OUTPTR=OUTCT+1
      OUTCT=OUTCT+LEN
*                               F. IF AT TOP LEVEL LIST, RETURN
      IF(KP.EQ.0) GO TO MRET(15,25,35)
*                               G. ELSE POP STACK
      POS=POSSTK(KP)
      OUTL=OLSTK(KP)
      OLEND=OLESTK(KP)
      LEN=LENSTK(KP)
      KP=KP-1
*                               H. APPEND POINTER-TO-EXT.-LIST[1] TO
*                                  OUTL
      IFLD=OUTPTR
      IFLAG=1
      GO TO 160
      END
