*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
       FUNCTION DEC (NUM,NCHAR)
************************************************************************
*
*     DEC converts the integer NUM to a decimal display code integer
*     of NCHAR characters.  The result is returned right justified,
*     space filled.  A number too large to fit in the field will be
*     flagged by an * as the leftmost character.  If NCHAR=0,
*     DEC will generate a display code integer of the minimal
*     required length (i.e., with no leading blanks)
*
************************************************************************
*
      IMPLICIT INTEGER(A-Z)
      PARAMETER (DLEN=8)
      CHARACTER*(DLEN) DEC,HEX
      CHARACTER*1 CHR
      CHARACTER*(DLEN) DTEMP
      CHARACTER*1 CTR(16)
      DATA CTR/'0','1','2','3','4','5','6','7','8','9','A','B','C','D',
     *'E','F'/
      RADX=10
      GO TO 2
      ENTRY HEX (NUM,NCHAR)
      RADX=16
   2  DTEMP='        '
      NN=NUM
        N=ABS(NN)
        IF(NCHAR.EQ.0) THEN
          NMCHAR=DLEN
        ELSE
          NMCHAR=NCHAR
        END IF
        K=DLEN
        DO 10 I=1,NMCHAR
        DTEMP(K:K)=CTR(MOD(N,RADX)+1)
        N=N/RADX
        IF(N.EQ.0) GO TO 5
        K=K-1
   10   CONTINUE
    9   DTEMP(K:K)='*'
    5   IF(NN.LT.0) THEN
          IF (I.EQ.NMCHAR) GO TO 9
          K=K-1
          DTEMP(K:K)='-'
        END IF
          IF(NCHAR.NE.0) K=(DLEN+1)-NCHAR
          IF(RADX.EQ.10) THEN
            DEC=DTEMP(K:DLEN)
          ELSE
            HEX=DTEMP(K:DLEN)
          END IF
      RETURN
      END
