*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      FUNCTION CAT (A,B)

************************************************************************
*
*     IF A AND B POINT TO LISTS, CAT RETURNS THE CONCATENATION OF A AND
*     B.  LIST A IS MODIFIED BY THIS PROCESS.  IF A AND/OR B POINTS TO
*     A HEAD, THE LISTS (A) AND/OR (B) ARE USED IN THE CONCATENATION
*     OPERATION.
*
************************************************************************

      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'asf.fcm'
      AL=A
      BL=B
      IF(BL.EQ.0) GO TO 20
      IF(.NOT.ATOMP(BL)) GO TO 20
*                            1. IF B POINTS TO A NAMED HEAD, USE (B)
*                               INSTEAD
      BL=GCONS(0,0,BL)
   20 IF(AL.EQ.0) GO TO 30
      IF(.NOT.ATOMP(AL)) GO TO 40
*                            2. IF A POINTS TO A NAMED HEAD,RETURN (A B)
      CAT=GCONS(BL,0,AL)
      RETURN
*                            3. IF A IS NIL, RETURN B
   30 CAT=BL
      RETURN
*                            4. IF B IS NIL, RETURN A
   40 IF(BL.EQ.0) GO TO 56
*                            5. APPEND LIST B TO LIST A AND RETURN A
      L=AL
   51 IF(CDR(L).EQ.0) GO TO 55
      L=CDR(L)
      GO TO 51
   55 CDR(L)=BL
   56 CAT=AL
      RETURN
      END
      FUNCTION LENGTH (L)
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'asf.fcm'
*
      LENGTH=0
      P=L
   1  IF(P.EQ.0)RETURN
      LENGTH=LENGTH+1
      P=CDR(P)
      GO TO 1
      END
*
      FUNCTION APPEND(A,B)
************************************************************************
*
*     RETURNS THE LIST FORMED BY APPENDING LIST B TO THE END OF LIST A.
*     NEITHER A NOR B IS MODIFIED;  IF A IS NON-NULL,THE CDR-CHAIN OF
*     IS COPIED, WITH THE FINAL CDR SET TO POINT TO B.
*
************************************************************************
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'asf.fcm'
      IF(ATOMP(A).OR.A.EQ.0) THEN
        APPEND=B
      ELSE
        L=A
        LAST=GCONS(0,CSR(L),CAR(L))
        APPEND=LAST
*                  A POINTER TO THE HEAD OF THE NEW LIST IS
*                  STACKED SO THAT THE LIST WILL BE SAVED IF A
*                  GARBAGE COLLECTION OCCURS.
  10    L=CDR(L)
        IF(L.EQ.0) GO TO 50
        IF(ATOMP(L)) GO TO 50
        KOPY=GCONS(0,CSR(L),CAR(L))
        CDR(LAST)=KOPY
        LAST=KOPY
        GO TO 10
  50    CDR(LAST)=B
      END IF
      RETURN
      END
