module memory/checkCache [Addr, Data]

open memory/cacheMemory [Addr, Data] as cache
open memory/abstractMemory [Addr, Data] as amemory

fun alpha [c: CacheMemory]: AbsMemory {
	{m: AbsMemory | m.data = c.main ++ c.cache}
}

// This check should not produce a counterexample
ReadOK: check {
	// introduction of m, m' ensures that they exist, and gives witnesses if counterexample
	all c: CacheMemory, a: Addr, d: Data, m: AbsMemory |
		cache/read [c, a, d] and m = alpha [c] 
			=> amemory/read [m, a, d]
}

// This check should not produce a counterexample
WriteOK: check {
	all c, c': CacheMemory, a: Addr, d: Data, m, m': AbsMemory |
		cache/write [c, c', a, d] and m = alpha [c] and m' = alpha [c']
 			=> amemory/write [m, m', a, d]
}

// This check should not produce a counterexample
LoadOK: check {
	all c, c': CacheMemory, m, m': AbsMemory |
		cache/load [c, c'] 
		and m = alpha [c] and m' = alpha [c'] => m = m'
}

// This check should not produce a counterexample
FlushOK: check {
	all c, c': CacheMemory, m, m': AbsMemory |
		cache/flush [c, c'] 
		and m = alpha [c] and m' = alpha [c'] => m = m'
}
