module memory/abstractMemory [Addr, Data]

sig AbsMemory {
	data: Addr -> lone Data
}

pred init [m: AbsMemory] {
	no m.data
}

pred write [m, m': AbsMemory, a: Addr, d: Data] {
	m'.data = m.data ++ a -> d
}

pred read [m: AbsMemory, a: Addr, d: Data] {
	let d' = m.data [a] | some d' implies d = d'
}

fact Canonicalize {
	no m, m': AbsMemory | m != m' and m.data = m'.data
}

// This command should not find any counterexample
ReadAfterWrite: check {
	all m, m': AbsMemory, a: Addr, d1, d2: Data |
		write [m, m', a, d1] and read [m', a, d2] => d1 = d2
}

// This command should not find any counterexample
WriteIdempotent: check {
	all m, m', m": AbsMemory, a: Addr, d: Data |
		write [m, m', a, d] and write [m', m", a, d] => m' = m"
}
