package mergesort

import akka.testkit.TestKit
import akka.actor.ActorSystem
import org.scalatest.WordSpecLike
import scala.concurrent.Future
import java.util.concurrent.Executor
import org.scalatest.BeforeAndAfterAll
import akka.testkit.ImplicitSender
import akka.actor.Props
import akka.actor.Actor
import akka.actor.ActorRef

class StepParent(child: Props, fwd: ActorRef) extends Actor {
  context.actorOf(child, "sorter")
  def receive = {
    case msg => fwd.tell(msg, sender)
  }
}

class SorterTest  extends TestKit(ActorSystem("GetterSpec"))
  with WordSpecLike with BeforeAndAfterAll with ImplicitSender {

  override def afterAll(): Unit = {
    system.shutdown()
  }

  def sortTest(l: List[Int]) {
    val sorter = system.actorOf(Props(new StepParent(Props[Sorter], testActor)))
    l foreach { sorter ! Some(_) }
    sorter ! None
    l sortWith { _ < _ } foreach { (x: Int) => expectMsg(Some(x)) }
    expectMsg(None)
  }

  "A Sorter" must {
    "sort the empty list" in {
      sortTest(Nil)
    }

    "sort a one-element list" in {
      sortTest(List(2))
    }

    "sort a list with duplicate elements" in {
      sortTest(List(1,4,1))
    }

    "sort an already sorted list" in {
      sortTest(List(1,2,3,4))
    }

    "sort a list that is in reverse order" in {
      sortTest(List(5,4,3,2))
    }
  }
}
