library(ggplot2)
# Plotting some of the outputs of the pairs program from NUPACK

args <- commandArgs(TRUE)
filename <- paste(args[1], 'analysis', sep='.')
newdata <- read.csv(filename, header=TRUE)

pdf(paste(args[1], '-temperature-analysis.pdf', sep=''))
energy_plot <- ggplot(newdata, aes(temp, mfe_energy, colour="MFE")) + geom_line()
energy_plot <- energy_plot + geom_line(aes(temp, desired_energy, colour="Desired")) + opts(title="Free energy for structure")
energy_plot

prob_plot <- ggplot(newdata, aes(temp, mfe_prob, colour="MFE")) + geom_line()
prob_plot <- prob_plot + geom_line(aes(temp, desired_prob, colour="Desired")) + opts(title="Probability of attaining structure")
prob_plot
dev.off()
