# -*- coding: utf-8 -*-

from jinja2 import Environment, FileSystemLoader
import codecs;

class HTMLGraphics(object):

  def __init__(self, path = 'compiler/html'):
    self.path = path
    self.env = Environment(loader=FileSystemLoader(self.path))
    self.template = self.env.get_template('dna_canvas.html.tmpl')


  def render(self, program, suffix):
    # Remove the .tmpl extension
    html_filename = ".".join(self.template.filename.split(".")[0:-2]) + '-' + str(suffix) + '.html'
    html_file = codecs.open(html_filename, encoding='utf-8', mode='w')
    html_file.write(self.template.render(program=program, state_num=suffix))
    html_file.close()

