import java.util.Random;

public class Board {
	private static final int size = 10;
	private int board[][];
	
	private int[][] path;
	
	private Hint lastHint = null;
	private boolean expectMove = false;

	
	public Board() {
		board = new int[size][size];
	}
	
	public boolean isTherePath(int player){
		initPath();
		boolean pathFound = false;
		for (int i=0; i<size && !pathFound; i++) {
			switch (player) {
			case 1: pathFound = isTherePath(i, 0, player); break;
			case 2: pathFound = isTherePath(0, i, player); break;
			default:  //bad input
			}
		}
		return pathFound;
	}
	
	public String generateNextHint() {
		Random rand = new Random();
		int h = Math.abs(rand.nextInt()) % 4;
		Hint hint = null;
		switch (h) {
		case 0 : hint = new Hint(Hint.ODD, 0, 0, 0); break;
		case 1 : hint = new Hint(Hint.EVEN, 0, 0, 0); break;
		case 2 : 
			int c = Math.abs(rand.nextInt()) % 10;
			hint = new Hint(Hint.CONTAINS, c, 0, 0);
			break;
		case 3 : 
			int l = Math.abs(rand.nextInt()) % 100 + 1;
			int m = Math.abs(rand.nextInt()) % l + 1;
			hint = new Hint(Hint.MORE_LESS, 0, m, l); 
			break;
		default: System.out.println("h is " + h);
		}
		if (goodHint(hint)) {
			lastHint = hint;
			expectMove = true;
			return hint.toString();
			
		} else {
			return generateNextHint();
		}
	}
	
	public int acceptMove (int i, int j, int player) {
		System.out.println("accept " + i + "  " + j + " from " + 2);
		if (!expectMove || board[i][j] != 0) {
			return Protocol.INVALID_MOVE;
		}
		if (lastHint.satisfy((i+1)*(j+1))) {
			board[i][j] = player;
			return Protocol.SUCCESS;
		} else {
			return Protocol.BAD_GUESS;
		}
	}
	
	public boolean validMove (int i, int j) {
		System.out.println(i+ " " +j + "  " + board[i][j]);
		if (!expectMove || board[i][j] != 0 || !lastHint.satisfy((i+1)*(j+1))) {
			System.out.println("false");
			return false;
		}
		System.out.println("true");
		return true;
	}
	
	private boolean goodHint(Hint hint) {
		for (int i=0; i<size; i++) 
			for (int j=0; j<size; j++) 
				if (board[i][j] == 0 && hint.satisfy ((i+1)*(j+1))) 
					return true;
		return false;
	}

	private void initPath() {
		path = new int[size][size];
		for (int i=0; i<size; i++)
			for (int j=0; j<size; j++)
				path[i][j] = Protocol.UNVISITED;
	}
	
	private boolean isTherePath(int startI, int startJ, int player) {
		if (startI<0 || startI>=size || startJ<0 || startJ>=size || board[startI][startJ] != player)
			return false;
		if (path[startI][startJ] != Protocol.UNVISITED)
			return path[startI][startJ] == Protocol.PATH_EXISTS;
		if ((player == 1 && startJ == size-1) || (player == 2 && startI == size -1)) 
			return true;
		path[startI][startJ] = Protocol.INPROGRESS;
		boolean pathFound = false;
		for (int i=-1; i<2 && !pathFound; i++) {
			for (int j=-1; j<2 && !pathFound; j++) {
				//if (board)
				pathFound |= isTherePath(startI+i, startJ+j, player);
			}
		}
		if (pathFound) {
			path[startI][startJ] = Protocol.PATH_EXISTS;
		} else {
			path[startI][startJ] = Protocol.NO_PATH;
		}
		return pathFound;
	}

	public int getPlayer(int i, int j) {
		if (validMove(i, j))
			return 4;
		return board[i][j];
	}
	
}