package superply.ui;

import superply.SPSystemAnalyzer;
import superply.math.HintChecker;

import heurgame.HuClient;
import heurgame.HuReceptor;
import heurgame.PlayerToken;
import heurgame.event.GameEvent;
import heurgame.event.GameListener;
import heurgame.event.PlayerEvent;
import heurgame.event.PlayerListener;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;

/**
 * Component to draw the game in a pretty window. Pretty much just a grid.
 * Left clicking on a square chooses that square for your turn.
 */
public class SPanel extends java.awt.Panel implements PlayerListener,
        GameListener, HuReceptor {

	int CELL_SIZE;
	int CELL_PAD = 5;
	int HINT_SPACE = 60;
	public boolean debugCellValue = false;

	private Image image = null;
	private Graphics buffer = null;

    private Dimension pref;
    private HintChecker boardState;
    private int dimCells;
    private int highlightedCell = 100;
    private boolean depress = false;
    private int turn = 0;
    private Vector activePlayers;
    private volatile boolean doCapture = false;
    private volatile HuClient capturedClient = null;
    private SPSystemAnalyzer systemContext;
    
    private Color topColor = new Color(153,204,255);
	private Color leftColor = new Color(205,50,50);
	private Color opColor = new Color(154,202,127);
	
    public SPanel(HintChecker hc) {
        super();
		CELL_SIZE = hc.getCellSize();
		dimCells = hc.getBoardSize();
        pref = new Dimension((CELL_SIZE+CELL_PAD)*(dimCells+1)+CELL_PAD
        					,(CELL_SIZE+CELL_PAD)*(dimCells+1)+CELL_PAD+HINT_SPACE );
		boardState = hc;
        SPanelMouse mouseInformant = new SPanelMouse(this);
        this.addMouseListener(mouseInformant);
        this.addMouseMotionListener(mouseInformant);
        activePlayers = new Vector();
    }

    public void paint(Graphics g) {
        update(g);
    }
	public void update(Graphics g) {
		if( image == null){
			image = createImage(pref.width, pref.height);
			buffer = image.getGraphics();
		}
		render(buffer);
		if (image != null)
			g.drawImage(image,0,0,this);
	}
    public void render(Graphics g) {
    	g.setColor(Color.gray);
        g.fillRect(0,0,getWidth(),getHeight());
        int textOffset = CELL_SIZE/4;
        String[] Clabels = boardState.getColumnLabels().split(" ");
		String[] Rlabels = boardState.getRowLabels().split(" ");
		String label = "", moving = "", goal="";
		int x = CELL_PAD; int y = CELL_PAD+HINT_SPACE; //upper left of cells
		for(int c = -1; c < dimCells; c++){
         for(int r = -1; r < dimCells; r++){
         	if(r == -1){ //labels top
         		if(c == -1){ //operation
					g.setColor(opColor);
					g.fill3DRect(x,y,CELL_SIZE,CELL_SIZE,true);
					g.setColor(Color.black);
					g.drawString(boardState.getOperation(),x+textOffset,y+5*textOffset/2);
         		}else{
					g.setColor(topColor);
					g.fill3DRect(x,y,CELL_SIZE,CELL_SIZE,true);
					g.setColor(Color.black);
					g.drawString(Clabels[c],x+textOffset,y+5*textOffset/2);
         		}
         	}else if(c == -1){ //labels left
				g.setColor(leftColor);
				g.fill3DRect(x,y,CELL_SIZE,CELL_SIZE,true);
				g.setColor(Color.black);
				g.drawString(Rlabels[r],x+textOffset,y+5*textOffset/2);
         	}else{ // internal cell
         		label = "??";
         		if( debugCellValue )
         			label = boardState.getLabelAt(r,c);
				if(boardState.getPlayerAt(r,c) == null){
					if(r*dimCells+c == highlightedCell)
						g.setColor(Color.yellow);
					else if((r+c)%2 == 0)
						g.setColor(Color.white);
					else
						g.setColor(Color.lightGray);
         		}else if(boardState.getPlayerAt(r,c).equals(boardState.playOrder.get(0))){
         			g.setColor(Color.cyan);
         			label = boardState.getLabelAt(r,c);
         		}else{
					g.setColor(Color.red);
					label = boardState.getLabelAt(r,c);
         		}
				g.fill3DRect(x,y,CELL_SIZE,CELL_SIZE,(r*dimCells+c!=highlightedCell) || !depress);
				g.setColor(Color.black);
				g.drawString(label,x+textOffset,y+5*textOffset/2);
         	}
         	y += CELL_SIZE+CELL_PAD;
         }
         y = CELL_PAD+HINT_SPACE;
         x += CELL_SIZE+CELL_PAD;
		}
		label = "HINT: "+boardState.getHint();
		if(turn > 1 && boardState.winner > 1){
			goal = turn%2==0?
			"You are trying to make a connection from left to right.":
			"You are trying to make a connection from top to bottom.";
			moving = "TIME TO MOVE "+((PlayerToken)boardState.playOrder.get(turn%2)).getName()+"!";
    	}
		if(boardState.winner == 0){
			label = "GAME OVER!";
			moving = ((PlayerToken)boardState.playOrder.get(0)).getName()+" WINS!";
			goal = "You are the new World Wide Web SuperPly Champ!";
		}
		if(boardState.winner == 1){
			label = "GAME OVER!";
			moving = ((PlayerToken)boardState.playOrder.get(1)).getName()+" WINS!";
			goal = "You are the new World Wide Web SuperPly Champ!";
		}
		g.setColor(Color.white);
		g.fillRect(0,0,getWidth(),HINT_SPACE);
		g.setColor(Color.black);
		g.drawString(label,30,3*HINT_SPACE/10);
		if(boardState.winner == 0)
			g.setColor(Color.blue);
		else if(boardState.winner == 1)
			g.setColor(Color.red);
		else if(turn%2 == 0)
			g.setColor(Color.blue);
		else
			g.setColor(Color.red);
		g.drawString(moving,30,6*HINT_SPACE/10);
		g.drawString(goal,30,9*HINT_SPACE/10);
    }

    public Dimension getPreferredSize() {
        return pref;
    }

    public void setPreferredSize(Dimension d) {
        pref = d;
    }

    /**
     * @see heurgame.event.PlayerListener#playerJoined(heurgame.event.PlayerEvent)
     */
    public void playerJoined(PlayerEvent e){
    }

    /**
     * @see heurgame.event.PlayerListener#playerLeft(heurgame.event.PlayerEvent)
     */
    public void playerLeft(PlayerEvent e){
        if (e.disqualified) {
            if (activePlayers.contains(e.player) == true) {
                activePlayers.remove(e.player);
                repaint();
            }
                        
        }
        
    }

    /**
     * @see heurgame.event.PlayerListener#playerMoved(heurgame.event.PlayerEvent)
     */
    public void playerMoved(PlayerEvent e) {
        if (e.validMove) {
            if (activePlayers.contains(e.player) == false) {
                activePlayers.add(e.player);
            }
            repaint();
        }
        turn++;
    }

    /**
     * @see heurgame.event.PlayerListener#playerStatusChanged(heurgame.event.PlayerEvent)
     */
    public void playerStatusChanged(PlayerEvent e) {
		repaint();
    }

    /**
     * @see heurgame.HuReceptor#captureMove(heurgame.HuClient)
     */
    public void captureMove(HuClient h) {
		capturedClient = h;
		doCapture = true;
    }

    /**
     * @see heurgame.event.GameListener#gameSetup(heurgame.event.GameEvent)
     */
    public void gameSetup(GameEvent e) {
    }

    /**
     * @see heurgame.event.GameListener#gameStarted(heurgame.event.GameEvent)
     */
    public void gameStarted(GameEvent e) {
        systemContext = (SPSystemAnalyzer) e.context.getSystemAnalyzer();
    }

    /**
     * @see heurgame.event.GameListener#gameEnded(heurgame.event.GameEvent)
     */
    public void gameEnded(GameEvent e) {
    	turn = 0;
		repaint();
    }

	/**
	 * @return the hintChecker controlling board data for this visualization
	 */
	public HintChecker getHintChecker() {
		return boardState;
	}
	
	class SPanelMouse extends java.awt.event.MouseAdapter implements
			java.awt.event.MouseMotionListener {
		private SPanel vp;

		public SPanelMouse(SPanel vp) {
			this.vp = vp;
		}

		public void mouseDragged(java.awt.event.MouseEvent e) {
			mouseMoved(e);
		}

		public void mouseMoved(java.awt.event.MouseEvent e) {
			//highlight cells
			Point p = e.getPoint();
			int area = (CELL_SIZE+CELL_PAD);
			if( ((p.y-HINT_SPACE)/area-1) >= 0 && (p.x/area-1) >= 0 )
				highlightedCell = dimCells*((p.y-HINT_SPACE)/area-1) + (p.x/area-1);
			else
				highlightedCell = 100;
			repaint();
		}
		
		public void mouseExited(java.awt.event.MouseEvent e) {
			highlightedCell = 100;
			repaint();
		}

		public void mousePressed(java.awt.event.MouseEvent e){
			depress = true;
			repaint();
		}

		public void mouseReleased(java.awt.event.MouseEvent e) {
			depress = false;
			highlightedCell = 100;
			Point p = e.getPoint();
			int area = (CELL_SIZE+CELL_PAD);
			if (e.isAltDown()) {
				System.out.println("DEBUG---CELL!");
				System.out.println("" + ((p.y-HINT_SPACE)/area-1) + " " + (p.x/area-1));
			} else if (e.isShiftDown()) {
				System.out.println("DEBUG---ACTION!");
			} else {
				if (doCapture && capturedClient != null) {
					doCapture = false;
					if( ((p.y-HINT_SPACE)/area-1) >= 0 && (p.x/area-1) >= 0  )
					capturedClient.fromOutside("" + ((p.y-HINT_SPACE)/area-1) + " " + (p.x/area-1));
					capturedClient = null;
				}
			}
		}
	}
}