/*
 * Created on Dec 13, 2004
 */
package superply.math;

/**
 * @author Chris Quackenbush
 */
public class HintChooser{
	public String[] hints;
	private boolean[] valid;
	boolean random = true;
	int counter = 0;
	HintChecker hc;
	/**
	 * @param hintType "random" or "deterministic"
	 */
	public HintChooser(HintChecker hintC) {
		if(hintC.getHintMethod().equals("deterministic"))
			random = false;
		hc = hintC;
		hints = hc.getHints();
		valid = new boolean[hints.length];
		for(int i=0; i <valid.length;i++)
			valid[i] = true;
	}

	/**
	 * @return the next hint
	 */
	public String next() {
		do{
			do{
				if(random){
					counter = (int)(hints.length*Math.random());
				}else{
					counter++;counter%=hints.length;
				}
			}while(!valid[counter]);
			valid[counter] = false;
			for(int r=0;r<hc.getBoardSize() && !valid[counter];r++)
			for(int c=0;c<hc.getBoardSize() && !valid[counter];c++)
				if( hc.isValidHint(r,c,counter) && hc.getPlayerAt(r,c)==null )
					valid[counter] = true;
		}while(!valid[counter]);
		return hints[counter];
	}

	/**
	 * @return the current hint
	 */
	public String get() {
		return hints[counter];
	}
}
