package superply.math;

/*
 * Created on Nov 21, 2004
 */

/**
 * @author Chris Quackenbush
 */
public class HintCheckerMultiply extends HintChecker{
//game definition
	int BOARD_SIZE = 8;
	int LARGEST_TEXT_ELEMENT = 45;
	String rowLabels = "2 3 4 5 6 7 8 9";
	String colLabels = "2 3 4 5 6 7 8 9";
	String symbol = "X";
	String[] hints = {
		"odd",
		"even",
		"between 0 18",
		"between 18 81",
		"contains 4",
		"odd",
		"even",
		"between 0 16",
		"between 16 36",
		"contains 2",
		"odd",
		"even",
		"between 12 42",
		"between 20 54",
		"contains 5",
		"odd",
		"even",
		"between 8 20",
		"between 18 30",
		"contains 1",
	};
	
	public String getLabelAt(int r, int c) {
		return String.valueOf( (2+r)*(2+c) );
	}
	
	public boolean isValidHint(int r, int c, int h) {
		if( r < 0 || r >= BOARD_SIZE || c < 0 || c >= BOARD_SIZE)
			return false;
		String[] hint = hints[h].split(" ");
		int cellVal = (2+c)*(2+r);
		if(
		 (hint[0].equals("odd") && cellVal%2 == 1) ||
		 (hint[0].equals("even") && cellVal%2 == 0) ||
		 (hint[0].equals("contains") && getLabelAt(r,c).indexOf(hint[1]) >= 0) ||
		 (hint[0].equals("between") && cellVal >= Integer.parseInt(hint[1]) && cellVal <= Integer.parseInt(hint[2]))
		){
			return true;
		}
		return false;
	}	
//end game definition
	
	public HintCheckerMultiply(String hintType) {
		super(hintType);
		clear();
	}
	
	public String[] getHints() {
		return hints;
	}

	public int getBoardSize() {
		return BOARD_SIZE;
	}

	public String getColumnLabels() {
		return colLabels;
	}

	public String getRowLabels() {
		return rowLabels;
	}

	public String getOperation() {
		return symbol;
	}

	public int getCellSize() {
		return LARGEST_TEXT_ELEMENT;
	}
}
