package superply;

import java.awt.Button;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import superply.math.*;

import superply.ui.SPanel;
import heurgame.TurnBasedReferee;
import heurgame.GameServer;
import heurgame.HuClient;
import heurgame.event.GameBroadcaster;
import heurgame.event.PlayerBroadcaster;
import heurgame.event.TimeBroadcaster;
import heurgame.ui.EstimatedTime;
import heurgame.ui.GraphicalLogInterface;
import heurgame.ui.WelcomeScreen;

/*
 * Created on Nov 21, 2004
 */

/**
 * @author David Kaplin and Chris Quackenbush
 *
 */
public class SuperPlyMain {
	//default arguments
	public static String hostname = "127.0.0.1";
    public static int port = 20000;
    public static String hintType = "random"; // random or deterministic
    public static long gameTime = 1000 * 60 * 2; //2 minutes
    //game elements
    public static SuperPlyGame superPly;
    public static SPanel spPanel;
    public static TurnBasedReferee official;
    public static WelcomeScreen welcome;
    public static WindowAdapter onClose;
    public static TimeBroadcaster timeBroadcaster;
	
    public static void main(String[] args) {
        if (args.length == 4){
            hostname = args[0];
            port = Integer.parseInt(args[1]);
			hintType = args[2];
            gameTime = Long.parseLong(args[3]) * 1000;
        }else if (args.length > 0){
            System.out.println("Usage:\n java -jar superPly.jar");
            System.out.println("\tRuns the Server on 127.0.0.1:20000 with random hints and a total time usage of 2 minutes per player.");
            System.out.println("Expert Usage:\n java -jar superPly.jar server_hostname port hint_type game_time");
            System.out.println("Where");
            System.out.println("server_host - is the hostname that the server (this computer)");
            System.out.println("port - valid open port for the server to attach");
            System.out.println("hint_type - either 'random' or 'deterministic'");
            System.out.println("game_time - Maximum number of seconds a player is allowed over the course of the game");
            return;
        }
        superPly = new  SuperPlyGame();
        timeBroadcaster = new TimeBroadcaster();
        superPly.setTimeBroadcaster(timeBroadcaster);
        superPly.setGameBroadcaster(new GameBroadcaster());
        superPly.setPlayerBroadcaster(new PlayerBroadcaster());
        
        official = new TurnBasedReferee();
        superPly.setReferee(official);
        GameServer server = new GameServer(hostname,port,superPly,official);
//fix this
        spPanel = new SPanel(new HintCheckerAlgebra(hintType));
		superPly.addPlayerListener(spPanel);
        superPly.setup(server,spPanel);
        Thread sThread = new Thread(server);
        
        welcome = new WelcomeScreen(server);

        superPly.addPlayerListener(welcome);
        
        final Runnable onExit = new Runnable(){
            public void run(){
                System.out.println("Goodbye cruel world.");
                System.exit(0);
            }
        };
        
        onClose = new WindowAdapter(){
            public void windowClosing(WindowEvent w){
                onExit.run();
            }
          };
        Runnable onStart = new Runnable(){
            public void run(){
                setupWindow();
            }
        };
        
        sThread.start();
        Frame first = welcome.getWelcome(onStart,onExit,null);
        first.pack();
        first.show();
        
    }
    public static void setupWindow(){
        (new heurgame.ui.GraphicalLogInterface()).clearLog();
        EstimatedTime estTime = new EstimatedTime();
        superPly.addGameListener(estTime);
        superPly.addGameListener(spPanel);
        timeBroadcaster.addTimeListener(estTime);
        superPly.newGame(gameTime);
        superPly.addTurnListener(official);//is last
        
		HuClient[] humans = superPly.getHumanClients();
		for(int i=0;i<humans.length;i++){
			humans[i].setReceptor(spPanel);
		}
		
		final Frame mainFrame = new Frame(superPly.getName());
		mainFrame.addWindowListener(onClose);
		mainFrame.setLayout(new java.awt.BorderLayout());
		mainFrame.add(spPanel,java.awt.BorderLayout.CENTER);
		Panel bottom = new Panel();
		bottom.setLayout(new java.awt.BorderLayout());
		Button newGame = new Button("New Game");
		newGame.addActionListener(new java.awt.event.ActionListener(){
		    public void actionPerformed(java.awt.event.ActionEvent e){
		        official.rejectAllPlayers("Game Over");
		        mainFrame.hide();
		        mainFrame.dispose();
		        welcome.getBuiltWelcome().show();
			}
		});
		bottom.add(newGame,java.awt.BorderLayout.WEST);
		Button slog = new Button("Log");
		slog.addActionListener(new java.awt.event.ActionListener(){
		    public void actionPerformed(java.awt.event.ActionEvent e){
		        Frame logWind = GraphicalLogInterface.getLogWindow();
		        logWind.show();
		    }
		});
		bottom.add(slog,java.awt.BorderLayout.EAST);
		bottom.add(estTime.getEstimatedTime());
		mainFrame.add(bottom,java.awt.BorderLayout.SOUTH);
		Thread g = new Thread(){
		    public void run(){
		        superPly.start();				        
		    }
		};
		g.start();
		mainFrame.pack();
		mainFrame.setResizable(false);
		mainFrame.show();
		(welcome.getBuiltWelcome()).hide();
    }
}
