/*
 * Created on Dec 2, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package superply;

import java.net.Socket;
import java.io.*;
/**
 * @author Chris Quackenbush
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class SuperPlyPlayer {
	int boardSize,rounds,players;
	int[] board;
	SuperPlyPlayer(int port) {
		this("localhost",port,"default name "+(int)(100*Math.random()));
	}

	SuperPlyPlayer(String server, int port) {
		this(server,port,"default name"+(int)(100*Math.random()));
	}

	SuperPlyPlayer(int port, String name) {
		this("localhost",port,name);
	}

	SuperPlyPlayer(String server, int port, String name) {
		boardSize=0;
		rounds=0;
		players=0;
		Socket socket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		try {
			socket = new Socket(server,port);
			socket.setTcpNoDelay(true);
			out = new PrintWriter(socket.getOutputStream(), true);
			in = new BufferedReader(new InputStreamReader(socket.getInputStream()));

		} catch (IOException ev) {
			System.err.println(ev.getMessage());
		}
		String command;
		String[] parse;
		try {
			out.println(name);
			while ((command = in.readLine())!= null) {
				System.out.println(command);
				parse = command.split(" ");
				if(parse[0].equals("INIT")){
					//INIT 400 random
					boardSize=Integer.parseInt(parse[1]);
				}
				if (parse[0].equals("STATUS")){
					//STATUS cow 23 44 56 78 99 12 , Pig 56 78 90 110 200 3
					int[] players = new int[boardSize*boardSize];
					for(int i = 0; i < players.length; i++)
						players[i] = 0;
					parse = command.substring(7).split(",");
					for(int i = 0; i < parse.length; i++){
						String[] tmp = parse[i].split(" ");
						for(int j = 1+i; j < tmp.length-1; j+=2)
							players[boardSize*Integer.parseInt(tmp[j])+Integer.parseInt(tmp[j+1])] = i;
					}
					for(int i = 0; i < parse.length; i++)
						System.out.println(players[i]+i%8==0?"\n":"");
					wholeState(players);
				}
				if (parse[0].equals("HINT")){
					//HINT some_hint
					boolean[] players = new boolean[boardSize*boardSize];
					for(int i = 0; i < players.length; i++)
						players[i] = false;
					parse = command.substring(5).split(" ");
					for(int k = 0; k < boardSize; k++)
					for(int j = k; j < boardSize; j++){
						int cellVal = (2+k)*(2+j);
						if(
						 (parse[0].equals("odd") && cellVal%2 == 1) ||
						 (parse[0].equals("even") && cellVal%2 == 0) ||
						 (parse[0].equals("contains") && String.valueOf(cellVal).indexOf(parse[1]) >= 0) ||
						 (parse[0].equals("between") && cellVal >= Integer.parseInt(parse[1]) && cellVal <= Integer.parseInt(parse[2]))
						){
							players[k*boardSize+j] = true;
							if(j != k) players[k*boardSize+j] = true;
						}
					}
					out.println(process(players));
				}
				if (parse[0].equals("TIMEOUT")) {
					System.out.println("I was disqualified");
					break;
				}
				if (parse[0].equals("FINAL")) {
					System.out.println("I "+parse[1]);
					break;
				}
			}
		}
		catch (IOException io) {
			System.err.println(io.getMessage());
		}
		out.close();
		try {
			in.close();
			socket.close();
		} catch (IOException io) {
			System.err.println(io.getMessage());
		}
	}

	//These functions can be overridden

	protected void updateState(String[] move){} //called when an opponent moves

	protected void wholeState(int[] state){
		board = state;
	} //called every time the board state is released

	protected String moveAgain(String reason){	//called when we make an illegal move
		return "" + (int)(Math.random()*boardSize) + " " + (int)(Math.random()*boardSize);
	}

	protected abstract String process(boolean[] command); //called on our turn

}
