package superply;

import java.io.IOException;

import heurgame.HuClient;
/*
 * Created on Nov 21, 2004
 */

/**
 * @author David Kaplin and Chris Quackenbush
 */
public class SuperPlyHuClient extends HuClient {

    private volatile boolean needRun = true;
    private volatile String lastMove;

    /** 
     * @see heurgame.HuClient#waitForMessage()
     */
    public String waitForMessage() {
        try {
            String msg = this.fromServer.readLine();
            String cmd = msg.substring(0,msg.indexOf(" "));
            msg = msg.substring(msg.indexOf(" ")+1,msg.length());
            if (cmd.equals("HINT")){
                lastMove = handleMove(msg);
                toServer.println(lastMove);
                toServer.flush();
            }else if (cmd.equals("STATUS")){
                handleStatus(msg);
            }else if (cmd.equals("INIT")){
                handleInitialStatus(msg);
            }else if (cmd.equals("FINAL")){
                handleFinalStatus(msg);
            }else if (cmd.equals("TIMEOUT")){
                handleDisqualification(msg);
            }
        } catch (IOException e) {
            debugging.addUrgentEntry("Protocol Cracker",e.getLocalizedMessage(), 1);
            needRun = false;
        }
        return null;
    }

    /** 
     * @see heurgame.HuClient#handleMove(java.lang.String)
     */
    public String handleMove(String arg0) {
        guiReceptor.captureMove(this);
        while(this.move.length()==0){
            try {
                Thread.sleep(50);
            }catch (InterruptedException e){
                e.printStackTrace();
            }
        }
        String response = new String(this.move);
        this.move = "";
        debugging.addEntry("Move","Sent "+response);
        return response;
    }

    /** 
     * @see heurgame.HuClient#handleInvalidMove(java.lang.String)
     */
    public String handleInvalidMove(String arg0) {
    	//never called
        return "0 0";
    }

    /** 
     * @see heurgame.HuClient#handleInitialStatus(java.lang.String)
     */
    public void handleInitialStatus(String arg0) {
        //System.out.println("INITIAL "+arg0);    
    }

    /** 
     * @see heurgame.HuClient#handleStatus(java.lang.String)
     */
    public void handleStatus(String arg0) { 
        //not really needed    
    }

    /** 
     * @see heurgame.HuClient#handleFinalStatus(java.lang.String)
     */
    public void handleFinalStatus(String arg0) {
        debugging.addEntry("Final status ",arg0);
        toServer.close();
        try {
            fromServer.close();
        } catch (IOException e) {
            debugging.addUrgentEntry("Final Status",e.getLocalizedMessage(), 1);
        }
        needRun = false;
    }

    /** 
     * @see heurgame.HuClient#handleDisqualification(java.lang.String)
     */
    public void handleDisqualification(String arg0) {
        debugging.addEntry("Disqualified","Reason "+arg0);
        try {
            fromServer.close();
        } catch (IOException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }
        toServer.close();
        try {
            fromServer.close();
        } catch (IOException e) {
            debugging.addUrgentEntry("Disqualified",e.getLocalizedMessage(), 1);
        }
        needRun = false;
    }

    /** 
     * @see java.lang.Runnable#run()
     */
    public void run() {
        while(needRun == true){
            try {
                Thread.sleep(50);
                if (fromServer != null && toServer != null){
                	waitForMessage();
                }
            }catch (InterruptedException e){
                e.printStackTrace();
            }
        }
    }

    /** 
     * @see heurgame.HuClient#handleIncrementalStatus(java.lang.String)
     */
    public void handleIncrementalStatus(String status) {
        //neither is this
    }

}
