package superply;

import java.awt.Point;
import java.util.HashMap;
import java.util.Vector;

import superply.math.HintChecker;

import heurgame.event.PlayerEvent;
import heurgame.event.turn.AbstractTurnIterator;
import heurgame.logging.LogBox;
import heurgame.ui.GraphicalLogInterface;
import heurgame.PlayerToken;
import heurgame.analysis.MoveAnalyzer;
import heurgame.analysis.SystemAnalyzer;
/*
 * Created on Oct 12, 2004
 */

/**
 * @author David Kaplin and Chris Quackenbush
 *
 */
public class SPSystemAnalyzer extends SystemAnalyzer {
    private Vector players = new Vector();
    private HintChecker hintChecker;
    private SuperPlyGame game;
    private SPMoveAnalyzer moveChecker;
    private int playersSeen = 0;
    private HashMap timeTable;
    private AbstractTurnIterator turnInfo;
    private Vector bestPlayers;
    private LogBox debugging = new LogBox("System Analyzer",new GraphicalLogInterface());
    
    public void setTimeRemaining(PlayerToken p,long amount){
        if (timeTable.get(p)==null){
            getTimeRemaining(p);
        }
        timeTable.put(p,new Long(amount));
    }
    public long getTimeRemaining(PlayerToken p){
        if (timeTable.get(p)==null){
            timeTable.put(p,new Long(game.getMaximumNormalTime()));
        }
        return ((Long)timeTable.get(p)).longValue();
    }
    public SPSystemAnalyzer(SuperPlyGame g, HintChecker hc,AbstractTurnIterator turns){
        game = g;
		hintChecker = hc;
		hintChecker.playOrder = players;
        moveChecker = new SPMoveAnalyzer(this);
        turnInfo = turns;
        clear();
    }
    public void clear(){
		hintChecker.clear();
        playersSeen = 0;
        players.clear();
        bestPlayers = new Vector();
        timeTable = new HashMap();
    }
    /** 
     * @see heurgame.analysis.SystemAnalyzer#isGameOver()
     */
    public boolean isGameOver() {
        boolean singlePlayer = (players.size()==1) && (playersSeen > 1);
        if (singlePlayer){
            debugging.addEntry("GAME OVER?","Single Player");
            return true;
        }
        debugging.addEntry("GAME OVER?",(hintChecker.winner()!=null)?"yup":"Game not over");
        return (hintChecker.winner()!=null);
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#isDecisive()
     */
    public boolean isDecisive() {
		bestPlayers.clear();
		if(hintChecker.winner > 1)
			hintChecker.winner = 0;
		bestPlayers.add(hintChecker.playOrder.get(hintChecker.winner));
        return true;
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#newGame()
     */
    public void newGame() {
        clear();
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getMoveAnalyzer()
     */
    public MoveAnalyzer getMoveAnalyzer() {
        return moveChecker;
    }
    public synchronized PlayerEvent[] computeScores(PlayerToken[] pTokens){
        synchronized (pTokens){
        int NumPlayers = pTokens.length;
        PlayerEvent[] scores = new PlayerEvent[NumPlayers];
        for(int i=0;i<NumPlayers;i++){
            scores[i] = new PlayerEvent();
            scores[i].player = pTokens[i];
			scores[i].leader = false;
            scores[i].score = scores[i].leader?1:0;
            scores[i].disqualified = false;
            scores[i].timeLeft = getTimeRemaining(scores[i].player);
        }
        return scores;
        }
    }
    
    public void addPlayer(PlayerToken player){
        if (players.contains(player)==false){
            players.add(player);
            playersSeen++;
        }
    }
    /**
     * 
     * @return single line string
     * The history of each connected player is listed in a comma delimited
     * list.  Inside that list you will find this format
     * Name [space] {[row] [column]}
     */
    public String getState(){
    	String result="";
    	PlayerToken pt;
    	Vector moves;
		for(int i = 0;i < players.size(); i++){
			pt = (PlayerToken)players.get(i);
			result += pt.getWhitespaceSafeName()+" ";
			moves = hintChecker.getMoves(pt);
			for(int j = 0;j < moves.size(); j++){
				result += ((Point)moves.get(j)).x+" ";
				result += ((Point)moves.get(j)).y+" ";
			}
			result += ", ";
		}
		return result;
    }
    public void removePlayer(PlayerToken p){
        if (players.contains(p)){
            System.out.println("***REMOVING PLAYER");
            debugging.addEntry("Removing Player ",p.getName());
            players.remove(p);
        }else{
            debugging.addEntry("Could not find player to remove",p.getName());
        }        
    }
    public boolean makeMove(Point p,PlayerToken who){
        return hintChecker.add(who,p);
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getWinningPlayer()
     */
    public PlayerToken getWinningPlayer() {
        return (PlayerToken)bestPlayers.get(0);
    }
    /** 
     * @see heurgame.analysis.SystemAnalyzer#getWinningPlayers()
     */
    public PlayerToken[] getWinningPlayers() {
    	PlayerToken[] out = new PlayerToken[bestPlayers.size()];
    	for(int i=0;i<out.length;i++){
    		out[i] = (PlayerToken)bestPlayers.get(i);
    	}
        return out;
    }
    public void goodMove(PlayerToken who,String move){
        game.announcePlayerMoved(who);
    }
    public PlayerToken getOwner(Point p){
    	PlayerToken pt = null;
    	for(int i = 0;i < players.size(); i++){
			if(hintChecker.getMoves((PlayerToken)players.get(i)).contains(p))
				pt = (PlayerToken)players.get(i);
    	}
    	return pt;
    }
    public String getIncrementalState(){
        return getState();
    }
}	
