/
  Base library for aquery code, version 1.0
  Please report any bugs to jpc485@nyu.edu
\

// Translation utilities
// initialize state
.aq.initQueryState:{.aq.cd:s!s:`$(); .aq.pc:s;};

// Generate column dictionary
.aq.gencd:{[t;sn;rename]
  prefix:$[rename;sn,"__";""];
  $[0=count sn;
    c!c:cols t;
    ((`$(sn,"."),/:sc),c)!(2*count c)#`$prefix,/:sc:string c:cols t
    ]
   };

// rename columns using a dictionary
.aq.drcols:{[t;d](c^d c:cols t) xcol t};
// rename columns using a prefix
.aq.rcols:{[t;p] $[0=count p; t; .aq.drcols[t;c!`$(p,"__"),/:string c:cols t]]};

// initialize table and add to relevant global info
.aq.initTable:{[t;nm;rename]
   // given tables column dictionary
   tc:.aq.gencd[t;nm;rename];
   //drop ambiguous cols from map
   .aq.cd:{(key[y] inter .aq.pc) _ x,y}[.aq.cd;tc];
   // add original columns to .aq.pc
   .aq.pc:.aq.pc union cols t;
   // return table w/ renamed columns
   $[rename;.aq.rcols[t;nm];t]
 };

.aq.initState:{.aq.gencd:{x!x}`$(); .aq.pc:`$();};

// sort column names by attribute
.aq.scbix:{[m] iasc `s`p`g`u?exec c!a from m};
.aq.swix0:{[c;w]
  w iasc min each c?fw@'where each type[`]=(type each) each fw:(raze/) each w
 };
// reorder where clauses based on indices
.aq.reorderFilter:{[v;w]
 // no point in reording if we don't have attributes
 // otherwise reorder locally between aggregates according to safe principle
 $[exec all null a from m:meta v; w; .aq.swix0[.aq.scbix m;w]]
 };

// sort a table by direction-column tuples d and sort only columns c
.aq.sort:{[t;d;c]
 if[0h<>type first d;'"must be list of tuples of direction and column"];
 ix:{[t;ix;dc] ix dc[0] (t dc[1]) ix}[t;;]/[::;reverse d];
 cl:(),c;
 @[t;cl inter $[99h=type t;key t;cl];@[;ix]]
 }

// sort a table when it is grouped (handles group columns appropriately)
.aq.sortGrouped:{[tg;d;c]
  k:keys tg;
  // remove tuples involving grouping direction. semantics indicate grouping is after sort
  // so new order can be imposed via grouping e.g. select * by c1, c3 from `c1 xasc `c3 xdesc t
  dc:d where not (last each d) in k;
  $[(0=count tg)|0=count dc;tg;.aq.sort[ ;dc;c] each tg]
 }


// join using preparation
.aq.joinUsingPrep:{[cs;j]
  $[2<>count m:cs where cs like "*__",s:string j;
    '"ambig-join:",s;
    `rename`remap!(m!2#n;((.aq.cd?m),j)!(1+count m)#n:`$"_"sv string m)
    ]
  };

.aq.joinUsing:{[jf;l;r;cs]
  // join using information
  jui:raze each flip .aq.joinUsingPrep[cols[l],cols r;] each (),cs;
  // remap column references
  .aq.cd,:jui`remap;
  l:.aq.drcols[l;jui`rename];
  r:.aq.drcols[r;jui`rename];
  jf[.aq.cd cs;l;r]
 }

//full outer join using (definition compliant with traditional sql semantics
// from ej
k).aq.ejix:{(=x#z:0!z)x#y:0!y};
.aq.foju:{
  nix:.aq.ejix[x:(),x;y:0!y;z:0!z];
  iz:raze nix; //indices in z for equijoin
  iy:where count each nix; // indices in y for equijoin
  ejr:y[iy],'(x _ z) iz; // perform equi join
  my:select from y where not i in iy; // records in y not in equi join
  mz:select from z where not i in iz; // records z not in equi join
  ejr upsert/(my;mz) // add missing records
  };
// nested join
.aq.nj:{[t1;t2;p] raze {?[x,'count[x]#enlist y;z;0b;()]}[t1; ;p] each t2};

// hash join
.aq.hj:{[t1;t2;a1;a2;p]
  // argument preparation
  a1,:();a2,:();p:$[0<>type first p;enlist p;p];hasneq:any not (=)~/:first each p;
  targs:$[count[t2]>count t1;(t1;t2;a1;a2);(t2;t1;a2;a1)];
  s:targs 0;b:targs 1;sa:targs 2;ba:targs 3;
  // here the "hash function" is identity of join attributes, extract index
  bti:?[s;();sa!sa;`i];
  // hash larger and drop no matches
  bw:?[b;();ba!ba;`i];
  matches:((sa xcol key bw) inter key bti)#bti;
  // perform nj for all matches using complete join predicate
  // if has any predicate that is not equality based otherwise just cross (guaranteed matches)
  inner:b bw ba xcol key matches;
  outer:s value matches;
  $[hasneq;raze .aq.nj'[inner;outer;(count matches)#enlist p];raze {x cross y}'[inner;outer]]
 };

// check if tables are keyed on join keys
// if so use ij instead of ej, much more performant, same semantics in such a case
.aq.iskey:{(count[k]>0)&min (k:keys x) in y};

// faster equi join based on keyed or not
.aq.ej:{[k;t1;t2] $[(kt2:.aq.iskey[t1;k])|kt1:.aq.iskey[t2;k]; $[kt1;t1 ij t2;t2 ij t1]; ej[k;t1;t2]]};

// check attributes
.aq.chkattr:{[x;t] any (.aq.cd where any each flip .aq.cd like/: "*",/:string (),x) in exec c from meta t where not null a};

// enlist for variables inside functions
.aq.funEnlist:{$[0>type x;x;enlist x]};

.aq.wildCard:{{x!x} cols x};

// load
.aq.load:{[fileh;sep;destnm]
  data:(upper exec t from meta destnm;enlist sep) 0:hsym fileh;
  destnm upsert data
  }
.aq.save:{[fileh;sep;t] fileh 0:sep 0:t};

.aq.insert:{[tnm;sorted;modifier;src]
  ctnm:cols tnm;
  if[(0 < count modifier) & count[modifier]<>count ctnm;'"explicitly state all cols"];
  l:$[0 < count modifier; modifier; ctnm];
  d:$[98<=type src;l xcol src;l!src];
  tnm set sorted upsert d
  };

// case expression
.aq.else:{$[0=count x;first 0#y;x]};
// explicit conditions
.aq.eCond:{[ct;e] ?[ct[0;0]; ct[0;1]; $[1=count ct; .aq.else[e; ct[0;1]]; .z.s[1_ct;e]]]};
// implicit conditions
.aq.searchedCond:{[v;ct;e] .aq.eCond[flip (eval each (=;v; ) each first fct; last fct:flip ct); e]};
// wrapper
.aq.cond:{[v;ct;e] $[0=count v; .aq.eCond[ct;e]; .aq.searchedCond[v;ct;e]]}


// Builtins
// Overloaded built-ins are disambiguated by appending the number of arguments
// This precludes overloads with same number of args but different argument types If this is desired
// then it has to be handled at runtime.
.aq.abs:abs;
.aq.and:min;
.aq.avg:avg;
.aq.avgs1:avgs;
.aq.avgs2:mavg;
.aq.between:{x within (y;z)};
.aq.concatenate:(upsert/);
.aq.count:count;
.aq.deltas:deltas;
.aq.distinct:distinct;
.aq.drop:_;
.aq.list:{$[0<=type x;x;enlist x]};
.aq.exec_arrays:{show {key[x] set'value x}flip 0!x;x};
.aq.flatten:ungroup;
.aq.fill:^;
.aq.first1:first;
.aq.first2:sublist;
.aq.is:(::);
.aq.in:in;
.aq.indexEven:{x where (count x)#10b};
.aq.indexOdd:{x where (count x)#01b};
.aq.indexEveryN:{y where $[0>=x;();(count y)#((x-1)#0b),1b]};
.aq.last1:last;
.aq.last2:{[x;y] neg[x] sublist y};
.aq.like:{[x;y] x like string y};
.aq.makeNull:first 0#;
.aq.max:max;
.aq.maxs1:maxs;
.aq.maxs2:mmax;
.aq.min:min;
.aq.mins1:mins;
.aq.mins2:mmin;
.aq.mod:mod;
.aq.moving:{[f;w;a] f each {(x sublist y),z}[1-w;;]\[a]};
.aq.neg:neg;
.aq.next1:next;
.aq.next2:{(neg x) xprev y};
.aq.not:not;
.aq.null:null;
.aq.or:max;
.aq.overlaps:{[x;y] not (x[1]<y[0])|y[1]<x[0]};
.aq.pow:xexp;
.aq.prev1:prev;
.aq.prev2:xprev;
.aq.prd:prd;
.aq.prds:prds;
.aq.ratios:{[x;y] y%x xprev y};
.aq.reverse:reverse;
.aq.show:show;
.aq.sum:sum;
.aq.sums1:sums;
.aq.sums2:msum;
.aq.sqrt:sqrt;
.aq.stddev:dev;
.aq.toSym:`$;
.aq.vars:{mavg[x;y*y]-m*m:mavg[x;y:"f"$y]};
// Translation begins here
// verbatim code

nodefixed:get `:tables/nodefixed;
nodetime:get `:tables/nodetime;
plantfixed:get `:tables/plantfixed;
planttime:get `:tables/planttime;
anctable: get `:anctable;
desctable: get `:desctable


.aq.q0:{
 .aq.initQueryState[];
 aq__t0:.aq.initTable[nodefixed;"nodefixed";1b];
 aq__t1:.aq.initTable[nodetime;"nodetime";1b];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Nodeid)];
 aq__t2:?[aq__t2;();(enlist[{x^.aq.cd x} `Nodeid]!enlist {x^.aq.cd x} `Nodeid);({x^.aq.cd x} `Nodeid) _ (.aq.wildCard aq__t2)];
 aq__t2:?[aq__t2;();0b;((`Nodeid);(`sumsize))!({x^.aq.cd x} `Nodeid;(.aq.sum';{x^.aq.cd x} `Size))];
 aq__t2
 };
.aq.q0[]

.aq.q1:{
 .aq.initQueryState[];
 aq__t0:.aq.initTable[nodefixed;"nodefixed";1b];
 aq__t1:.aq.initTable[nodetime;"nodetime";1b];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Nodeid)];
 aq__t2:?[aq__t2;();(enlist[{x^.aq.cd x} `t.Nodeid]!enlist {x^.aq.cd x} `nodefixed.Nodeid);({x^.aq.cd x} `t.Nodeid) _ (.aq.wildCard aq__t2)];
 aq__t2:.aq.sortGrouped[aq__t2;enlist ((iasc;{x^.aq.cd x} `nodetime.Time));({x^.aq.cd x} `nodefixed.Nodeid;{x^.aq.cd x} `nodetime.Time;{x^.aq.cd x} `nodetime.Size)];
 aq__t2:?[aq__t2;();0b;((`t.Nodeid);(`t.Time);(`sumsize))!({x^.aq.cd x} `nodefixed.Nodeid;{x^.aq.cd x} `nodetime.Time;(.aq.sums1';{x^.aq.cd x} `nodetime.Size))];
 aq__t2
 };
.aq.q1[]

.aq.q2:{
 .aq.initQueryState[];
 aq__t0:.aq.initTable[nodefixed;"nodefixed";1b];
 aq__t1:.aq.initTable[nodetime;"nodetime";1b];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Nodeid)];
 aq__t2:?[aq__t2;();(enlist[{x^.aq.cd x} `t.Nodeid]!enlist {x^.aq.cd x} `nodefixed.Nodeid);({x^.aq.cd x} `t.Nodeid) _ (.aq.wildCard aq__t2)];
 aq__t2:.aq.sortGrouped[aq__t2;enlist ((iasc;{x^.aq.cd x} `nodetime.Time));({x^.aq.cd x} `nodefixed.Nodeid;{x^.aq.cd x} `nodetime.Time;{x^.aq.cd x} `nodetime.Size)];
 aq__t2:?[aq__t2;();0b;((`t.Nodeid);(`t.Time);(`sumsize))!({x^.aq.cd x} `nodefixed.Nodeid;{x^.aq.cd x} `nodetime.Time;(.aq.sums1';{x^.aq.cd x} `nodetime.Size))];
 tmprunningsize:`Nodeid`Time`sumsize xcol aq__t2;
 .aq.initQueryState[];
 aq__t3:.aq.initTable[eval (.aq.flatten;tmprunningsize);"";0b];
 aq__t3:?[aq__t3;();0b;(.aq.wildCard aq__t3)];
 aq__t3
 };
.aq.q2[]

myCorr:{[x;y]
  center_x:eval (-; .aq.funEnlist x; (.aq.avg;.aq.funEnlist x));
  center_y:eval (-; .aq.funEnlist y; (.aq.avg;.aq.funEnlist y));
  num:eval (.aq.sum;(*; .aq.funEnlist center_x; .aq.funEnlist center_y));
  denom:eval (*; (.aq.sqrt;(.aq.sum;(*; .aq.funEnlist center_x; .aq.funEnlist center_x))); (.aq.sqrt;(.aq.sum;(*; .aq.funEnlist center_y; .aq.funEnlist center_y))));
 eval (%; .aq.funEnlist num; .aq.funEnlist denom)
 };

.aq.show .aq.save[hsym `$"tmp.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[nodetime;"nodetime";0b];
 aq__t0:?[aq__t0;();0b;(.aq.wildCard aq__t0)];
 aq__t0
 }[];

.aq.show .aq.save[hsym `$"avgsize.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[nodetime;"nodetime";0b];
 aq__t0:.aq.sort[aq__t0;enlist ((iasc;{x^.aq.cd x} `Time));((.aq.wildCard aq__t0))];
 aq__t0:?[aq__t0;();(enlist[{x^.aq.cd x} `Nodeid]!enlist {x^.aq.cd x} `Nodeid);({x^.aq.cd x} `Nodeid) _ (.aq.wildCard aq__t0)];
 aq__t0:?[aq__t0;();0b;((`Nodeid);(`avgsize))!({x^.aq.cd x} `Nodeid;(.aq.avg';{x^.aq.cd x} `Size))];
 aq__t0
 }[];

.aq.show .aq.save[hsym `$"movingavg.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[nodetime;"nodetime";0b];
 aq__t0:.aq.sort[aq__t0;enlist ((iasc;{x^.aq.cd x} `Time));((.aq.wildCard aq__t0))];
 aq__t0:?[aq__t0;();(enlist[{x^.aq.cd x} `Nodeid]!enlist {x^.aq.cd x} `Nodeid);({x^.aq.cd x} `Nodeid) _ (.aq.wildCard aq__t0)];
 aq__t0:?[aq__t0;();0b;((`Nodeid);(`Time);(`movingClose))!({x^.aq.cd x} `Nodeid;{x^.aq.cd x} `Time;(.aq.avgs2';3;{x^.aq.cd x} `Size))];
 tmpmoving:`Nodeid`Time`movingClose xcol aq__t0;
 .aq.initQueryState[];
 aq__t1:.aq.initTable[eval (.aq.flatten;tmpmoving);"";0b];
 aq__t1:?[aq__t1;();0b;(.aq.wildCard aq__t1)];
 aq__t1
 }[];

.aq.show .aq.save[hsym `$"anctable.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[anctable;"anctable";0b];
 aq__t0:?[aq__t0;();0b;(.aq.wildCard aq__t0)];
 aq__t0
 }[];

.aq.show .aq.save[hsym `$"desctable.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[desctable;"desctable";0b];
 aq__t0:?[aq__t0;();0b;(.aq.wildCard aq__t0)];
 aq__t0
 }[];

.aq.show .aq.save[hsym `$"ancestortime.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[anctable;"anctable";1b];
 aq__t1:.aq.initTable[nodetime;"nodetime";1b];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Nodeid)];
 aq__t2:.aq.sort[aq__t2;enlist ((iasc;{x^.aq.cd x} `nodetime.Time));((.aq.wildCard aq__t2))];
 aq__t2:?[aq__t2;();(enlist[{x^.aq.cd x} `t.Nodeid]!enlist {x^.aq.cd x} `anctable.Nodeid);({x^.aq.cd x} `t.Nodeid) _ (.aq.wildCard aq__t2)];
 aq__t2:?[aq__t2;();0b;((`Nodeid);(`ancestor);(`degree);(`Time);(`sumsize))!({x^.aq.cd x} `anctable.Nodeid;{x^.aq.cd x} `anctable.ancestor;{x^.aq.cd x} `anctable.degree;{x^.aq.cd x} `nodetime.Time;{x^.aq.cd x} `nodetime.Size)];
 tmpancestortime:`Nodeid`ancestor`degree`Time`sumsize xcol aq__t2;
 .aq.initQueryState[];
 aq__t3:.aq.initTable[eval (.aq.flatten;tmpancestortime);"";0b];
 aq__t3:?[aq__t3;();0b;((`Nodeid);(`ancestor);(`degree);(`Time);(`sumsize))!({x^.aq.cd x} `Nodeid;{x^.aq.cd x} `ancestor;{x^.aq.cd x} `degree;{x^.aq.cd x} `Time;{x^.aq.cd x} `sumsize)];
 aq__t3
 }[];

.aq.show `ancestorfixed set {
 .aq.initQueryState[];
 aq__t0:.aq.initTable[anctable;"anctable";1b];
 aq__t1:.aq.initTable[nodefixed;"nodefixed";1b];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Nodeid)];
 aq__t2:?[aq__t2;();0b;((`Nodeid);(`Plantid);(`Birthtime);(`Parent);(`ancestor);(`degree))!({x^.aq.cd x} `anctable.Nodeid;{x^.aq.cd x} `nodefixed.Plantid;{x^.aq.cd x} `nodefixed.Birthtime;{x^.aq.cd x} `nodefixed.Parent;{x^.aq.cd x} `anctable.ancestor;{x^.aq.cd x} `anctable.degree)];
 aq__t2
 }[];

.aq.show `ancestortime2 set {
 .aq.initQueryState[];
 aq__t0:.aq.initTable[ancestorfixed;"ancestorfixed";1b];
 aq__t1:.aq.initTable[nodetime;"nodetime";1b];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Nodeid)];
 aq__t2:?[aq__t2;();(enlist[{x^.aq.cd x} `t.Nodeid]!enlist {x^.aq.cd x} `ancestorfixed.Nodeid);({x^.aq.cd x} `t.Nodeid) _ (.aq.wildCard aq__t2)];
 aq__t2:.aq.sortGrouped[aq__t2;enlist ((iasc;{x^.aq.cd x} `nodetime.Time));({x^.aq.cd x} `ancestorfixed.Parent;{x^.aq.cd x} `ancestorfixed.Birthtime;{x^.aq.cd x} `ancestorfixed.Nodeid;{x^.aq.cd x} `nodetime.Time;{x^.aq.cd x} `ancestorfixed.Plantid;{x^.aq.cd x} `nodetime.Size;{x^.aq.cd x} `ancestorfixed.ancestor;{x^.aq.cd x} `ancestorfixed.degree)];
 aq__t2:?[aq__t2;();0b;((`Nodeid);(`Plantid);(`Birthtime);(`Parent);(`ancestor);(`degree);(`Time);(`sumsize))!({x^.aq.cd x} `ancestorfixed.Nodeid;{x^.aq.cd x} `ancestorfixed.Plantid;{x^.aq.cd x} `ancestorfixed.Birthtime;{x^.aq.cd x} `ancestorfixed.Parent;{x^.aq.cd x} `ancestorfixed.ancestor;{x^.aq.cd x} `ancestorfixed.degree;{x^.aq.cd x} `nodetime.Time;{x^.aq.cd x} `nodetime.Size)];
 aq__t2
 }[];

.aq.show .aq.save[hsym `$"ancestortime2.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[eval (.aq.flatten;ancestortime2);"";0b];
 aq__t0:?[aq__t0;();0b;(.aq.wildCard aq__t0)];
 aq__t0
 }[];

.aq.show `ancestortime3 set {
 .aq.initQueryState[];
 aq__t0:.aq.initTable[ancestorfixed;"ancestorfixed";1b];
 aq__t1:.aq.initTable[nodetime;"nodetime";1b];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Nodeid)];
 aq__t2:?[aq__t2;();(enlist[{x^.aq.cd x} `t.Nodeid]!enlist {x^.aq.cd x} `ancestorfixed.Nodeid);({x^.aq.cd x} `t.Nodeid) _ (.aq.wildCard aq__t2)];
 aq__t2:.aq.sortGrouped[aq__t2;enlist ((iasc;{x^.aq.cd x} `nodetime.Time));({x^.aq.cd x} `ancestorfixed.Parent;{x^.aq.cd x} `ancestorfixed.Birthtime;{x^.aq.cd x} `ancestorfixed.Nodeid;{x^.aq.cd x} `ancestorfixed.Plantid;{x^.aq.cd x} `ancestorfixed.ancestor;{x^.aq.cd x} `ancestorfixed.degree)];
 aq__t2:?[aq__t2;();0b;((`Nodeid);(`Plantid);(`Birthtime);(`Parent);(`ancestor);(`degree);(`sumsize))!({x^.aq.cd x} `ancestorfixed.Nodeid;{x^.aq.cd x} `ancestorfixed.Plantid;{x^.aq.cd x} `ancestorfixed.Birthtime;{x^.aq.cd x} `ancestorfixed.Parent;{x^.aq.cd x} `ancestorfixed.ancestor;{x^.aq.cd x} `ancestorfixed.degree;(.aq.sum';{x^.aq.cd x} `nodetime.Size))];
 aq__t2
 }[];

.aq.show `flatancestortime3 set {
 .aq.initQueryState[];
 aq__t0:.aq.initTable[eval (.aq.flatten;ancestortime3);"";0b];
 aq__t0:?[aq__t0;();0b;(.aq.wildCard aq__t0)];
 aq__t0
 }[];

.aq.show .aq.save[hsym `$"plantaverage.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[flatancestortime3;"flatancestortime3";0b];
 aq__t0:?[aq__t0;();(enlist[{x^.aq.cd x} `Plantid]!enlist {x^.aq.cd x} `Plantid);({x^.aq.cd x} `Plantid) _ (.aq.wildCard aq__t0)];
 aq__t0:?[aq__t0;();0b;((`Plantid);(`avgsize))!({x^.aq.cd x} `Plantid;(.aq.avg';{x^.aq.cd x} `sumsize))];
 plantaverage:`Plantid`avgsize xcol aq__t0;
 .aq.initQueryState[];
 aq__t1:.aq.initTable[plantaverage;"plantaverage";0b];
 aq__t1:?[aq__t1;();0b;(.aq.wildCard aq__t1)];
 aq__t1
 }[];

.aq.show `genericoutgrouped set {
 .aq.initQueryState[];
 aq__t0:.aq.initTable[flatancestortime3;"flatancestortime3";1b];
 aq__t0:?[aq__t0;enlist ((<; {x^.aq.cd x} `flatancestortime3.Birthtime; 3));0b;()];
 aq__t1:.aq.initTable[plantfixed;"plantfixed";1b];
 aq__t1:?[aq__t1;enlist ((=; {x^.aq.cd x} `plantfixed.Type; 1));0b;()];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Plantid)];
 aq__t2:?[aq__t2;();(enlist[{x^.aq.cd x} `t.Plantid]!enlist {x^.aq.cd x} `plantfixed.Plantid);({x^.aq.cd x} `t.Plantid) _ (.aq.wildCard aq__t2)];
 aq__t2:?[aq__t2;();0b;((`Nodeid);(`Plantid);(`Birthtime);(`Parent);(`ancestor);(`degree);(`sumsize);(`Type);(`Fruitsize);(`TimetoHarvest))!({x^.aq.cd x} `flatancestortime3.Nodeid;{x^.aq.cd x} `flatancestortime3.Plantid;{x^.aq.cd x} `flatancestortime3.Birthtime;{x^.aq.cd x} `flatancestortime3.Parent;{x^.aq.cd x} `flatancestortime3.ancestor;{x^.aq.cd x} `flatancestortime3.degree;{x^.aq.cd x} `flatancestortime3.sumsize;{x^.aq.cd x} `plantfixed.Type;{x^.aq.cd x} `plantfixed.Fruitsize;{x^.aq.cd x} `plantfixed.TimetoHarvest)];
 aq__t2
 }[];

.aq.show `genericout set {
 .aq.initQueryState[];
 aq__t0:.aq.initTable[flatancestortime3;"flatancestortime3";1b];
 aq__t0:?[aq__t0;enlist ((<; {x^.aq.cd x} `flatancestortime3.Birthtime; 3));0b;()];
 aq__t1:.aq.initTable[plantfixed;"plantfixed";1b];
 aq__t1:?[aq__t1;enlist ((=; {x^.aq.cd x} `plantfixed.Type; 1));0b;()];
 aq__t2:.aq.joinUsing[.aq.ej;aq__t0;aq__t1;enlist ({x^.aq.cd x} `Plantid)];
 aq__t2:?[aq__t2;();0b;((`Nodeid);(`Plantid);(`Birthtime);(`Parent);(`ancestor);(`degree);(`sumsize);(`Type);(`Fruitsize);(`TimetoHarvest))!({x^.aq.cd x} `flatancestortime3.Nodeid;{x^.aq.cd x} `flatancestortime3.Plantid;{x^.aq.cd x} `flatancestortime3.Birthtime;{x^.aq.cd x} `flatancestortime3.Parent;{x^.aq.cd x} `flatancestortime3.ancestor;{x^.aq.cd x} `flatancestortime3.degree;{x^.aq.cd x} `flatancestortime3.sumsize;{x^.aq.cd x} `plantfixed.Type;{x^.aq.cd x} `plantfixed.Fruitsize;{x^.aq.cd x} `plantfixed.TimetoHarvest)];
 aq__t2
 }[];

.aq.show .aq.save[hsym `$"genericout.csv";","; ] {
  .aq.initQueryState[];
 aq__t0:.aq.initTable[genericout;"genericout";0b];
 aq__t0:?[aq__t0;();0b;(.aq.wildCard aq__t0)];
 aq__t0
 }[];
