package netmatch.wizard;

import cytoscape.data.CyAttributes;
import cytoscape.Cytoscape;
import netmatch.Strings;

import javax.swing.*;

public class WizardPanel4 extends javax.swing.JPanel {
  private WizardPanel3 wp3;
  private JComboBox qEdgeAttrCombo;
  private JComboBox qNodeAttrCombo;

  public WizardPanel4(WizardPanel3 wp3) {
    this.wp3 = wp3;
    initComponents();
    acquireAttr();
  }

  public void acquireAttr() {
    qNodeAttrCombo.removeAllItems();
    qEdgeAttrCombo.removeAllItems();
    if(wp3.getValue() == null || !wp3.getValue().startsWith("QE")) {
      qNodeAttrCombo.removeAllItems();
      qEdgeAttrCombo.removeAllItems();
      CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
      CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
      String[] attrs = edgesAttributes.getAttributeNames();

      for(int i = 0;i < attrs.length;i++)
        qEdgeAttrCombo.addItem(attrs[i]);
      attrs = nodesAttributes.getAttributeNames();
      qNodeAttrCombo.addItem(Strings.DEFAULT_ATTRIBUTES);
      for(int i = 0;i < attrs.length;i++)
        qNodeAttrCombo.addItem(attrs[i]);
    }
    else {
      qEdgeAttrCombo.addItem(wp3.getValue() + " - Edges Attributes");
      qNodeAttrCombo.addItem(wp3.getValue() + " - Nodes Attributes");
    }
  }

  private void initComponents() {
    javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
    javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
    qNodeAttrCombo = new javax.swing.JComboBox();
    javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
    qEdgeAttrCombo = new javax.swing.JComboBox();
    jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11));
    jLabel1.setText("Please select the query attributes from following list: ");
    jLabel2.setText("Node attributes:");
    qNodeAttrCombo.setModel(new javax.swing.DefaultComboBoxModel());
    jLabel3.setText("Edge attributes:");
    qEdgeAttrCombo.setModel(new javax.swing.DefaultComboBoxModel());
    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .add(18, 18, 18)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel3)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(qNodeAttrCombo, 0, 321, Short.MAX_VALUE)
                    .add(jLabel2)
                    .add(jLabel1)
                    .add(qEdgeAttrCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
            .addContainerGap(61, Short.MAX_VALUE)));
    layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
            .addContainerGap()
            .add(jLabel1)
            .add(17, 17, 17)
            .add(jLabel2)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(qNodeAttrCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(21, 21, 21)
            .add(jLabel3)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(qEdgeAttrCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addContainerGap(119, Short.MAX_VALUE)));
  }

  public boolean validateAndSave() {
    return true;
  }

  public String getNodeValue() {
    return (String)qNodeAttrCombo.getSelectedItem();
  }

  public String getEdgeValue() {
    return (String)qEdgeAttrCombo.getSelectedItem();
  }
}
