// IMPORT FROM PICCOLOX

package netmatch.piccolox;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.*;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.*;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public class PHandle extends PPath {

  public static float DEFAULT_HANDLE_SIZE;
  public static Shape DEFAULT_HANDLE_SHAPE;
  public static Color DEFAULT_COLOR;
  //private static PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
  private PLocator locator;
  private PDragSequenceEventHandler handleDragger;

  public PHandle(PLocator plocator) {
    super(DEFAULT_HANDLE_SHAPE);
    locator = plocator;
    setPaint(DEFAULT_COLOR);
    installHandleEventHandlers();
  }

  protected void installHandleEventHandlers() {
    handleDragger = new PDragSequenceEventHandler() {

      protected void startDrag(PInputEvent pinputevent) {
        super.startDrag(pinputevent);
        startHandleDrag(pinputevent.getPositionRelativeTo(PHandle.this), pinputevent);
      }

      protected void drag(PInputEvent pinputevent) {
        super.drag(pinputevent);
        PDimension pdimension = pinputevent.getDeltaRelativeTo(PHandle.this);
        if(pdimension.getWidth() != 0.0D || pdimension.getHeight() != 0.0D)
          dragHandle(pdimension, pinputevent);
      }

      protected void endDrag(PInputEvent pinputevent) {
        super.endDrag(pinputevent);
        endHandleDrag(pinputevent.getPositionRelativeTo(PHandle.this), pinputevent);
      }

    };
    addPropertyChangeListener("transform", new PropertyChangeListener() {

      public void propertyChange(PropertyChangeEvent propertychangeevent) {
        relocateHandle();
      }

    });
    handleDragger.setEventFilter(new PInputEventFilter(16));
    handleDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
    handleDragger.getEventFilter().setAcceptsMouseEntered(false);
    handleDragger.getEventFilter().setAcceptsMouseExited(false);
    handleDragger.getEventFilter().setAcceptsMouseMoved(false);
    addInputEventListener(handleDragger);
  }

  public PDragSequenceEventHandler getHandleDraggerHandler() {
    return handleDragger;
  }

  public PLocator getLocator() {
    return locator;
  }

  public void setLocator(PLocator plocator) {
    locator = plocator;
    invalidatePaint();
    relocateHandle();
  }

  public void startHandleDrag(Point2D point2d, PInputEvent pinputevent) {
  }

  public void dragHandle(PDimension pdimension, PInputEvent pinputevent) {
  }

  public void endHandleDrag(Point2D point2d, PInputEvent pinputevent) {
  }

  public void setParent(PNode pnode) {
    super.setParent(pnode);
    relocateHandle();
  }

  public void parentBoundsChanged() {
    relocateHandle();
  }

  public void relocateHandle() {
    if(locator != null) {
      PBounds pbounds = getBoundsReference();
      Point2D point2d = locator.locatePoint(null);
      if(locator instanceof PNodeLocator) {
        PNode pnode = ((PNodeLocator) locator).getNode();
        PNode pnode1 = getParent();
        pnode.localToGlobal(point2d);
        globalToLocal(point2d);
        if(pnode1 != pnode && (pnode1 instanceof PCamera))
          ((PCamera) pnode1).viewToLocal(point2d);
      }
      double d = point2d.getX();
      double d1 = point2d.getY();
      if(d != pbounds.getCenterX() || d1 != pbounds.getCenterY())
        centerBoundsOnPoint(d, d1);
    }
  }

  private void readObject(ObjectInputStream objectinputstream) throws IOException, ClassNotFoundException {
    objectinputstream.defaultReadObject();
    installHandleEventHandlers();
  }

  static {
    DEFAULT_HANDLE_SIZE = 8F;
    DEFAULT_HANDLE_SHAPE = new java.awt.geom.Ellipse2D.Float(0.0F, 0.0F, DEFAULT_HANDLE_SIZE, DEFAULT_HANDLE_SIZE);
    DEFAULT_COLOR = Color.white;
  }
}