package netmatch.algorithm;

import cytoscape.CyNetwork;
import cytoscape.CyEdge;

import java.util.ArrayList;

public class BfsPath extends ArrayList {
  public BfsPath() {
  }

  public BfsPath(BfsPath path) {
    addAll(path);
  }

  public void add(int index,boolean isOutGoingEdge) {
    super.add(new Pair(index,isOutGoingEdge));
  }

  public boolean contains(int index) {
    for(int i = 0; i<size();i++) {
      Pair p = (Pair)get(i);
      if(p.getEdge() == index)
        return true;
    }
    return false;
  }

  public Pair getLastEdge() {
    return (Pair)get(size()-1);
  }

  public boolean checkCondition(String cond,int number) {
    int level = size();
    if(cond.equals(Common.GT))
      return level > number;
    else if(cond.equals(Common.GE))
      return level >= number;
    else if(cond.equals(Common.EQ))
      return level == number;
    else if(cond.equals(Common.LT))
      return level < number;
    else if(cond.equals(Common.LE))
      return level <= number;
    return false;
  }

  public int[] getApproximatePath(CyNetwork network) {
    int size = size();
    int path[] = new int[size];
    for(int i = 0; i<size;i++) {
      Pair p = (Pair)get(i);
      path[i] = p.getEdge();//((Integer)get(i)).intValue();
    }
    return path;
    /*CyEdge edge = null;
    for(int i = 0; i<size;i++) {
      int val = ((Integer)get(i)).intValue();
      edge = (CyEdge)network.getEdge(val);
      path[i] = edge.getSource().getRootGraphIndex();

    }
    path[size] = edge.getTarget().getRootGraphIndex();
    return path;*/
  }

  public void print(CyNetwork t) {
    if(size() == 0)
      System.out.print("[empty]");
    else
      for(int i = 0; i<size();i++) {
        Pair p = (Pair)get(i);
        //int val = ((Integer)get(i)).intValue();
        CyEdge edge = (CyEdge)t.getEdge(p.getEdge());
        System.out.print("["+edge.getSource().getIdentifier()+","+edge.getTarget().getIdentifier()+"] ");
      }
    System.out.println();
  }
}