package netmatch.help;

import javax.swing.*;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.HyperlinkEvent;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.io.IOException;

public class netMatchQuickHelp extends JFrame implements ActionListener, WindowListener,HyperlinkListener {
  private final int WIDTH = 600;
  private final int HEIGHT = 500;
  private JEditorPane editor;

  public static void main(String args[]) {
    netMatchQuickHelp f = new netMatchQuickHelp("NetMatch Quick Help",null);
    f.setVisible(true);
  }

  public netMatchQuickHelp(String title,ImageIcon img) {
    setTitle(title);
    if(img != null)
      this.setIconImage(img.getImage());
    addWindowListener(this);
    getContentPane().setLayout(new BorderLayout());
    JPanel princ = new JPanel(new BorderLayout());
    princ.setPreferredSize(new Dimension(WIDTH,HEIGHT));
    JScrollPane scroller = new JScrollPane();
    JViewport vp = scroller.getViewport();
    editor = createPage("resources/quick.html");
    vp.add(editor);
    princ.add(createMenuBar(),BorderLayout.NORTH);
    princ.add(scroller, BorderLayout.CENTER);
    getContentPane().add(princ,BorderLayout.CENTER);
    pack();
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation(screenSize.width / 2 - (getWidth() / 2), screenSize.height / 2 - (getHeight() / 2));
  }

  private JMenuBar createMenuBar() {
    JMenuBar menuBar = new JMenuBar();
    JMenuItem i;
    JMenu fileMenu = new JMenu("File");
    i = new JMenuItem("Exit");
    i.addActionListener(this);
    fileMenu.add(i);
    menuBar.add(fileMenu);
    return menuBar;
  }


  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    if(command.equals("Exit")) {
      processEvent(new WindowEvent(this, 201));
    }
  }


  public void windowClosing(WindowEvent e) {
    if(e.getSource() != this)
      return;
    Window window = e.getWindow();
    if(window.equals(this)) {
      setVisible(false);
      dispose();
    }
  }

  public void windowActivated(WindowEvent e) {
  }

  public void windowDeactivated(WindowEvent e) {
  }

  public void windowDeiconified(WindowEvent e) {
  }

  public void windowClosed(WindowEvent e) {
  }

  public void windowIconified(WindowEvent e) {
  }

  public void windowOpened(WindowEvent e) {
  }

  private URL getPage(String page) {
    return getClass().getResource(page);
  }

  private JEditorPane createPage(String path) {
 	  URL url = getPage(path);
    try {
      if(url != null) {
        JEditorPane html = new JEditorPane(url);
        html.setEditable(false);
        html.addHyperlinkListener(this);
        return html;
      }
    }
    catch(IOException e) {
      System.err.println("Failed to laod:"+path);
    }
    return null;
  }

  public void hyperlinkUpdate(HyperlinkEvent e) {
    if(e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
      if(e instanceof HTMLFrameHyperlinkEvent) {
        ((HTMLDocument)editor.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
      }
      else {
        try {
          editor.setPage(e.getURL());
        }
        catch (IOException ioe) {
          System.out.println("IOE: " + ioe);
        }
      }
    }
  }
}
