package netmatch.algorithm;

import java.util.ArrayList;

public class exactNodeComparator implements AttrComparator {
  public exactNodeComparator() {
  }

  public boolean compatible(Object p1, Object p2) throws Exception {
    ArrayList t;
    String q;
    boolean isNumber = false;
    double number = 0;
    String prefix;

    if(p1 instanceof ArrayList) {
      t = (ArrayList)p1;
      q = (String)p2;
    }
    else {
      t = (ArrayList)p2;
      q = (String)p1;
    }
    if(((String)t.get(0)).endsWith(Common.SELF_EDGE) == q.endsWith(Common.SELF_EDGE)) {
      if(q.startsWith(Common.ANY_LABEL))
        return true;
      if(q.endsWith(Common.SELF_EDGE))
        q = q.substring(0,q.length()-Common.SELF_EDGE.length());
      if(!(prefix = Common.isNumber(q)).equals(Common.UNDEFINED)) {
        try {
          number = Double.parseDouble(Common.getNumber(q));
          isNumber = true;
        }
        catch(NumberFormatException e) {
          isNumber = false;
        }
      }
      for(int i = 1; i < t.size();i++) {
        Object obj = t.get(i);
        if(obj.toString().startsWith(Common.ANY_LABEL))
          return true;
        if(isNumber) {
          try {
            double number2 = Double.parseDouble(obj.toString());
            if(prefix.equals(Common.GT))
              return number2 > number;
            else if(prefix.equals(Common.GE))
              return number2 >= number;
            else if(prefix.equals(Common.LT))
              return number2 < number;
            return number2 <= number;
          }
          catch(NumberFormatException e) {
            // Nothing
          }
        }
        if(obj.toString().equals(q))
          return true;
      }
    }
    return false;
    /*String pa = p1.toString();
    String pb = p2.toString();

    if((pa.endsWith(Common.SELF_EDGE) && !pb.endsWith(Common.SELF_EDGE)) || (!pa.endsWith(Common.SELF_EDGE) && pb.endsWith(Common.SELF_EDGE)))
      return false;
    if(pa.startsWith(Common.ANY_LAzBEL) || pb.startsWith(Common.ANY_LABEL) || pa.equals(pb))
      return true;
    return false;*/
  }
}