package netmatch.algorithm;

import java.util.Hashtable;
import java.util.ArrayList;
import java.util.Iterator;

public class Edge {
  int from;
  int to;
  int pos;
  Hashtable attr;
  Edge next;
  boolean isSelfEdge;

  public Edge(int from, int to, Object name, boolean isSelfEdge) {
    this.from = from;
    this.to = to;
    this.pos = -1;
    this.next = null;
    this.attr = new Hashtable();
    update(name);
    //this.attr.put(name, new myInteger(1));
    this.isSelfEdge = isSelfEdge;
  }

  public void update1(String name) {
    if(attr.containsKey(name)) {
      myInteger i = (myInteger)attr.get(name);
      i.setValue(i.intValue() + 1);
    }
    else
      attr.put(name, new myInteger(1));
  }

  public void update(Object t) {
    if(t instanceof ArrayList) {
      Iterator iterator = ((ArrayList)t).iterator();
      while(iterator.hasNext()) {
        update1(iterator.next().toString());
      }
    }
    else
      update1(t.toString());
  }
}
