package nanomunchers.ui;

import heurgame.ui.DisplayUtilities;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;

import nanomunchers.graph.KGraph;
import nanomunchers.graph.KGraphFactory;

/*
 * Created on Oct 29, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class GraphEditor {
    private GraphGeneration generator;
    private GraphEditPanel editPanel;
    private Label fileLabel = new Label("Save to: ");
    private String fileDestination = null;
    private Frame mainFrame;
    private FileDialog saveWindow;
    private Frame parent;
    public GraphEditor(Frame previous){
        parent = previous;
        mainFrame = new Frame("Nanomunchers Graph Editor");
        mainFrame.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent w){
                mainFrame.dispose();
                parent.show();
            }
        });
        editPanel = new GraphEditPanel();
        editPanel.setSize(400,400);
        generator = new GraphGeneration();
        mainFrame.setLayout(new BorderLayout());
        Panel northPanel = new Panel();
        northPanel.setLayout(new BorderLayout());
        Button generate = new Button("Generate Graph");
        northPanel.add(generate,BorderLayout.EAST);
        generate.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                if (generator.generateGraph()==false){
                    return;
                }
                KGraph built = generator.getGraph();
                editPanel.loadGraph(built);
            }
        });
        
        mainFrame.add(northPanel,BorderLayout.NORTH);
        mainFrame.setSize(400,400);
        mainFrame.add(editPanel);
        Button saveButton  = new Button("Save");
        saveButton.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e){
        	    if (editPanel.getGraph()!=null && fileDestination != null){
        	        try {
                        KGraphFactory.saveFile(fileDestination, editPanel.getGraph());
                    } catch (IOException e1) {
                        fileLabel.setText("Save Error" + e1);
                        return;
                    }
        	        fileLabel.setText("Saved");
        	    }else{
        	        fileLabel.setText("No file specified");
        	    }
        	}
    	}
    );
        Button saveAsButton = new Button("Save As...");
        saveAsButton.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e){
        	    saveWindow = new FileDialog(mainFrame, "Save As", FileDialog.SAVE);
        	    saveWindow.show();
        	    if (saveWindow.getDirectory() !=null){
        	        String filename = saveWindow.getDirectory() + saveWindow.getFile();
        	        fileDestination = filename;
        	        if (editPanel.getGraph()!=null && fileDestination != null){
            	        try {
                            KGraphFactory.saveFile(fileDestination, editPanel.getGraph());
                        } catch (IOException e1) {
                            fileLabel.setText("Save Error" + e1);
                            return;
                        }
            	        fileLabel.setText("Saved to: "+ filename);
            	    }else{
            	        fileLabel.setText("No file specified");
            	    }
        	    }
        	    DisplayUtilities.ensureWindowFits(fileLabel);
        	}
    	}
    );
        Panel southPanel = new Panel();
        Panel saveButtons = new Panel();
        saveButtons.setLayout(new GridLayout());
        saveButtons.add(saveAsButton);
        saveButtons.add(saveButton);
        southPanel.setLayout(new BorderLayout());
        southPanel.add(fileLabel);
        southPanel.add(saveButtons,BorderLayout.EAST);
        northPanel.add(generator);
        mainFrame.add(southPanel,BorderLayout.SOUTH);
    }
    public void show(){
        parent.hide();
        generator.setMode(GraphGeneration.GRAPH_COMPLETE);
        mainFrame.pack();
        mainFrame.show();
    }
}
