package heurgame.logging;

import java.io.Serializable;
import java.util.Date;
/**
 * @author David Kaplin
 *
 * Encapsulates an item in a log.
 */
public class LogItem implements Serializable, Cloneable {
    
    public String shortDescription;
    public String longDescription;
    /**
     * Positive numbers, the higher the better <code>priority</code>
     */
    public int priority;
    private String writerName;
    private Date timeWritten;
    
    private void setup(String s, String L, int p){
        timeWritten = new Date();
        shortDescription  = s;
        longDescription  = L;
        this.priority = p;
    }
    /**
     * Creates a normal Log Entry
     * 
     * @param shortDesc One line description of the event.
     * @param longDesc  Detailed description of the event.
     */
    public LogItem(String shortDesc,String longDesc){
        setup(shortDesc,longDesc,0);
    }
    
    /**
     * Creates a new LogItem with a specific priority.
     * 
     * @param shortDesc One line description of the event.
     * @param longDesc  Detailed description of the event.
     * @param priority Positive Integers get a higher priority
     */
    public LogItem(String shortDesc,String longDesc, int priority){
        setup(shortDesc,longDesc,priority);
    }
    
    
    /**
     * This method should only be called by objects of type Log.
     * DO NOT SET THIS WITH A LogWriter.
     * 
     * @param w Name of the responsible component.
     */
    protected void setOwner(String w){
        writerName  = w;
    }
    
    /**
     * Returns the name of the author of the log
     * 
     * @return Name of the responsible component.
     */
    public String getWho(){
        return writerName;
    }
    /**
     * @return Time this item was written by the author
     */
    public Date getTime(){
        return timeWritten;
    }
}
