package nanomunchers;

import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

import nanomunchers.graph.KEdge;
import nanomunchers.graph.KGraph;
import nanomunchers.graph.KGraphFactory;
import nanomunchers.graph.KNode;
import nanomunchers.ui.NanoSimulation;



import heurgame.Game;
import heurgame.HuClient;
import heurgame.PlayerProxy;
import heurgame.PlayerToken;
import heurgame.Referee;
import heurgame.analysis.SystemAnalyzer;
import heurgame.event.GameBroadcaster;
import heurgame.event.GameEvent;
import heurgame.event.PlayerBroadcaster;
import heurgame.event.PlayerEvent;
import heurgame.event.TimeBroadcaster;
import heurgame.logging.LogBox;
/*
 * Created on Oct 21, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class NanoGame implements Game {
    private Vector huClients;
    private int height;
    private int numMunchers;
    private int width;
    private long normalTime;
    private long extraTime;
    private Vector gamelisteners;
    private Referee official;
    private boolean complete_grid;
    private KGraph graph;
    private PlayerBroadcaster playerBroadcaster;
    private GameBroadcaster gameBroadcaster;
    private TimeBroadcaster timeBroadcaster;
    private NanoSystemAnalyzer systemAnalyzer;
    private PlayerToken[] players; 
    private NanoSimulation nanoUI;
    /** 
     * @see heurgame.Game#getName()
     */
    public String getName() {
         return "Nanomunchers 1.6.0";
    }
    public void setupUI(NanoSimulation ns){
        nanoUI = ns;
    }
    public void setupTime(long maximumNormal, long extra){
        this.normalTime = maximumNormal;
        this.extraTime = extra;
    }
    public void newGame(int munchers, String graphtype, int width, int height){
        numMunchers = munchers;
        complete_grid= graphtype.equalsIgnoreCase("complete");
        this.width =width;
        this.height = height;
        graph = KGraphFactory.buildGridGraph(width,height);
        if (complete_grid==false){
            if (graphtype.equalsIgnoreCase("random")){
                graph = KGraphFactory.buildRandomized(graph,.75);
            }else{
                System.out.println("Using file "+graphtype);
                graph = KGraphFactory.loadFile(graphtype);
            }
        }
        systemAnalyzer = new NanoSystemAnalyzer();
    }
    /** 
     * @see heurgame.Game#getMinimumPlayers()
     */
    public int getMinimumPlayers() {
        return 2;
    }

    /** 
     * @see heurgame.Game#getGreeting()
     */
    public String getGreeting() {
        return ""+width+" "+height+" "+numMunchers;
    }

    /** 
     * @see heurgame.Game#getSystemAnalyzer()
     */
    public SystemAnalyzer getSystemAnalyzer() {
        return this.systemAnalyzer;
    }

    /** 
     * @see heurgame.Game#buildPlayerProxy(java.net.Socket)
     */
    public PlayerProxy buildPlayerProxy(Socket connection) {
        PlayerProxy proxy = new NanoPlayerProxy();
        try {
            proxy.setup(proxy,
                    connection.getInetAddress().toString()+":"+
                    connection.getPort(),connection);
            proxy.setupLogging(new LogBox("PlayerProxy-"+proxy.getToken().getName()+"@"+proxy.getToken().getOrigin()
                    , new heurgame.ui.GraphicalLogInterface()));
            playerAdded(proxy.getToken());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return proxy;
    }

    /** 
     * @see heurgame.Game#buildHumanClient(java.lang.String)
     */
    public void buildHumanClient(String name) {
        // TODO For later
    }

    /** 
     * @see heurgame.Game#getHumanClients()
     */
    public HuClient[] getHumanClients() {
        HuClient[] ret = new HuClient[huClients.size()];
        for(int i=0;i<ret.length;i++){
            ret[i] = (HuClient)huClients.get(i);
        }
        return ret;
    }

    /**
     * @see heurgame.Game#getState()
     */
    public String getState() {
        if (this.complete_grid){
            return "WHOLEGRID";
        }
        StringBuffer out = new StringBuffer();
        out.append("PARTIALGRID "+graph.getNodes().length+"\n");
        for(int i=0;i<graph.getNodes().length;i++){
            KNode n = graph.getNodes()[i];
            out.append(""+ i +" "+ n.getX() +" "+ n.getY()+"\n");
        }
        out.append("EDGES "+ graph.getUniqueEdges().length+"\n");
        for(int i=0;i<graph.getUniqueEdges().length;i++){
            KEdge e = graph.getUniqueEdges()[i];
            KNode[] edgeEnds = e.getNodes();
            out.append(""+ edgeEnds[0].getId()+ " "+edgeEnds[1].getId()+"\n");
        }
        return out.toString();
    }

    /** 
     * Not used
     * @see heurgame.Game#getIncrementalState()
     */
    public String getIncrementalState() {
        return "";
    }

    /** 
     * Not used
     * @see heurgame.Game#endTurn()
     */
    public void endTurn() {
    }

  
    /**
     * This is for the player listeners
     * @see heurgame.Game#playerAdded(heurgame.PlayerToken)
     */
    public void playerAdded(PlayerToken token) {
        PlayerEvent e = new PlayerEvent();
        e.disqualified = false;
        e.leader = false;
        e.player = token;
        playerBroadcaster.announcePlayerJoined(e);
    }

    /**
     * @see heurgame.Game#start()
     */
    public void start() {
        //
        nanoUI.setup(graph);
        systemAnalyzer.setup(numMunchers, graph, nanoUI);
        //
        GameEvent setup = new GameEvent();
        setup.context = this;
        setup.currentState = "STARTING UP";
        setup.gameName = this.getName();
        setup.numberOfPlayers = -1;
        gameBroadcaster.announceSetup(setup);
        //
        
        
        GameEvent setup1 = new GameEvent();
        setup1.context = this;
        setup1.currentState = "SETUP";
        setup1.gameName = this.getName();
        setup1.numberOfPlayers = -1;
        gameBroadcaster.announceStart(setup1);
        GameEvent setup2 = new GameEvent();
        setup2.context = this;
        setup2.currentState = "MOVE";
        setup2.gameName = this.getName();
        setup2.numberOfPlayers = -1;
        gameBroadcaster.announceStart(setup2);
        
        Vector validPlayers = new Vector();
        for(int i=0;i<players.length;i++){
            validPlayers.add(players[i]);
        }
        System.out.println("Running Simulation");
        systemAnalyzer.runSimulation(validPlayers);
        System.out.println("Ended Running Simulation");
        //Game is over
        GameEvent end = new GameEvent();
        end.context = this;
        end.currentState = "END";
        end.gameName = this.getName();
        end.numberOfPlayers = -1;
        gameBroadcaster.announceEnd(end);
    }
    /**
     * Not used 
     * @see heurgame.Game#undoLastMove()
     */
    public boolean undoLastMove() {
        return false;
    }

    /**
     * @see heurgame.Game#announceDisqualification(heurgame.PlayerToken)
     */
    public void announceDisqualification(PlayerToken disqualified) {
        PlayerEvent e = new PlayerEvent();
        e.disqualified = true;
        e.leader = false;
        e.player = disqualified;
        playerBroadcaster.announcePlayerLeft(e);
    }

    /**
     * @see heurgame.Game#announcePlayerLeft(heurgame.PlayerToken)
     */
    public void announcePlayerLeft(PlayerToken gone) {
        PlayerEvent e = new PlayerEvent();
        e.disqualified = false;
        e.leader = false;
        e.player = gone;
        playerBroadcaster.announcePlayerLeft(e);
    }

    /**
     * Not used 
     * @see heurgame.Game#announcePlayerStatus()
     */
    public void announcePlayerStatus() {
    }

    /** 
     * @see heurgame.Game#reorderPlayers(heurgame.PlayerToken[])
     */
    public void reorderPlayers(PlayerToken[] tokens) {
        players = tokens;
    }

    /** 
     * @see heurgame.Game#setReferee(heurgame.Referee)
     */
    public void setReferee(Referee ref) {
        official = ref;
        gameBroadcaster.addGameListener(official);
    }

    /** 
     * @see heurgame.Game#getMaximumNormalTime()
     */
    public long getMaximumNormalTime() {
        return this.normalTime;
    }
    /** 
     * @see heurgame.Game#getMaximumWarningTime()
     */
    public long getMaximumWarningTime() {
        return this.extraTime;
    }
    /** 
     * @see heurgame.Game#getTimeBroadcaster()
     */
    public TimeBroadcaster getTimeBroadcaster() {
        return timeBroadcaster;
    }
    /** 
     * @see heurgame.Game#setGameBroadcaster(heurgame.event.GameBroadcaster)
     */
    public void setGameBroadcaster(GameBroadcaster b) {
        gameBroadcaster = b;
    }
    /** 
     * @see heurgame.Game#setTimeBroadcaster(heurgame.event.TimeBroadcaster)
     */
    public void setTimeBroadcaster(TimeBroadcaster t) {
        timeBroadcaster = t;
    }
    /** 
     * @see heurgame.Game#setPlayerBroadcaster(heurgame.event.PlayerBroadcaster)
     */
    public void setPlayerBroadcaster(PlayerBroadcaster p) {
        playerBroadcaster = p;
    }
}
