package nanomunchers;

import heurgame.PlayerToken;

import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import nanomunchers.bot.KNanoBot;
import nanomunchers.bot.KNanoBotWrangler;
import nanomunchers.graph.KGraph;
import nanomunchers.graph.KNode;
import nanomunchers.ui.NanoSimulation;

/*
 * Created on Oct 27, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class NanoSimulator {
    private KGraph graph;
    private KNanoBotWrangler nanoWrangler;
    private Vector playerTokens;
    private NanoSimulation visualization;
    private Hashtable botToID;
    public NanoSimulator(NanoSimulation sim, KGraph board, KNanoBotWrangler wrangler,Vector players ){
        visualization = sim;
        graph = board;
        nanoWrangler= wrangler;
        Hashtable botToID = new Hashtable();
        playerTokens = players;
        
    }
    public synchronized void prepareSimulation(){
        botToID = new Hashtable();
        System.out.println("Preparing Simulation...");
        for(int i=0;i<playerTokens.size();i++){
            PlayerToken owner = (PlayerToken)playerTokens.get(i);
            Vector bots = nanoWrangler.getNanoBots(owner);
            System.out.println(owner.getName()+" has "+ bots.size());
            for(int k=0;k<bots.size();k++){
                KNanoBot bot = (KNanoBot)bots.get(k);
                Integer id = visualization.register(owner,bot);
                System.out.println("bot "+bot +" id "+id + " is Alive= "+ bot.isAlive());
                botToID.put(bot,id);
            }
        }
        
        System.out.println("Preparing Simulation COMPLETE");
    }
    public Vector feedSimulation(){
        System.out.println("BEGIN FEED");
        Set nanos = botToID.keySet();
        int numdead = 0;
        int allbots = nanos.size();
        int dieNow = 0;
        Iterator i = nanos.iterator();
        while(i.hasNext()){
            KNanoBot bot = (KNanoBot)i.next();
            Integer compId = (Integer) botToID.get(bot);
            visualization.nextMove(compId,bot.getCurrentLocation(),0,bot.isAlive());
        }
        visualization.nextFrame();
        while((numdead < allbots) && (dieNow< 40)){
            nanos = botToID.keySet();
            Hashtable potential = new Hashtable();
            i = nanos.iterator();
            numdead = 0;
            while(i.hasNext()){
                KNanoBot bot = (KNanoBot)i.next();
                KNode nextSpot = bot.nextMove();
                if (nextSpot==null){
                    numdead++;
                    nextSpot = bot.getCurrentLocation(); 
                }
                Point nextPlace = nextSpot.getPoint();
                if (potential.contains(nextPlace) == false){
                    potential.put(nextPlace,new Vector());
                }
                Vector botsAtSpot = (Vector) potential.get(nextPlace);
                botsAtSpot.add(bot);
            }
            //kill the weak
            Set conflictedPlaces = potential.keySet();
            Iterator c = conflictedPlaces.iterator();
            while(c.hasNext()){
                
                Vector competators = (Vector)potential.get(c.next());
                if (competators.size()>1){
                    System.out.println("Competition");
                    //Nanobots duke it out
                    int maxDirection =-1;
                    int chosen = -1;
                    for(int j=0;j<competators.size();j++){
                        KNanoBot bot = (KNanoBot)competators.get(j);
                        int tDirection = bot.getDirection();
                        if (tDirection > maxDirection){
                            chosen = j;
                            maxDirection = tDirection;
                        }
                    }
                    for(int j=0;j<competators.size();j++){
                        KNanoBot bot = (KNanoBot)competators.get(j);
                        Integer compId = (Integer) botToID.get(bot);
                        KNode destination = bot.nextMove();
                        if (j!=chosen){
                            bot.kill();
                            //numdead++;
                        }
                        bot.move();
                        visualization.nextMove(compId,destination,bot.getNodesMunched(),bot.isAlive());
                        
                    }
                }else if (competators.size()==1){
                    //No competition
                    KNanoBot bot = (KNanoBot)competators.get(0);
                    Integer compId = (Integer) botToID.get(bot);
                    System.out.println("No Competition "+compId);
                    
                    
                    KNode destination = bot.nextMove();
                    if (destination==null){
                        destination = bot.getCurrentLocation(); 
                    }
                    bot.move();
                    visualization.nextMove(compId,destination,bot.getNodesMunched(),bot.isAlive());
                    if (bot.isAlive()==false){
                        numdead++;
                    }
                }
            }
            System.out.println("dead "+numdead+" living "+allbots);
            visualization.nextFrame();
            dieNow++;
        }
        //Tally results
        Vector results = new Vector();
        for(int r=0;r<playerTokens.size();r++){
            int playerTotal = 0;
            Vector playerBots = nanoWrangler.getNanoBots((PlayerToken) playerTokens.get(r));
            for(int j=0;j<playerBots.size();j++){
                playerTotal += ((KNanoBot)playerBots.get(j)).getNodesMunched();
            }
            results.add(new Integer(playerTotal));
        }
        System.out.println("END FEED");
        return results;
    }
}
